// eslint-disable-next-line import/no-extraneous-dependencies

import { zIndex } from './constants';
export const notDraggingStyle = {
  transform: undefined,
  transition: undefined
};
const baseDraggingStyle = {
  position: 'fixed',
  top: 0,
  left: 0,
  boxSizing: 'border-box',
  transition: 'none',
  zIndex: zIndex.dragging,
  /**
   * This transparency is intended to allow for better visibility of
   * drop indicators.
   */
  opacity: 0.75,
  pointerEvents: 'none'
};

/**
 * Provides the drag preview styles based on the current drag state.
 */
function getDraggingStyle({
  draggableDimensions,
  previewOffset
}) {
  const {
    rect
  } = draggableDimensions;
  const translateX = rect.left + previewOffset.x;
  const translateY = rect.top + previewOffset.y;
  const isAtOrigin = translateX === 0 && translateY === 0;
  return {
    ...baseDraggingStyle,
    transform: isAtOrigin ? undefined : `translate(${translateX}px, ${translateY}px)`,
    width: rect.width,
    height: rect.height
  };
}

/**
 * Returns the styles which should be provided to the draggable via the
 * `draggableProps` API.
 */
export function getDraggableProvidedStyle({
  draggableDimensions,
  draggableState
}) {
  if (draggableState.type !== 'dragging' || !draggableState.previewOffset || !draggableDimensions) {
    return notDraggingStyle;
  }
  return getDraggingStyle({
    draggableDimensions,
    previewOffset: draggableState.previewOffset
  });
}