import { y as ResolvedConfig, x as UserConfig, u as VitestRunMode, F as VitestOptions, V as Vitest, A as ApiConfig, T as TestProject, G as TestSequencer, H as TestSpecification, L as Logger, J as TestModule, M as ModuleDiagnostic } from './chunks/reporters.d.CfRkRKN2.js';
export { B as BaseCoverageOptions, E as BenchmarkUserOptions, ae as BrowserBuiltinProvider, af as BrowserCommand, ag as BrowserCommandContext, p as BrowserConfigOptions, ah as BrowserInstanceOption, ai as BrowserModuleMocker, aj as BrowserOrchestrator, ak as BrowserProvider, al as BrowserProviderInitializationOptions, am as BrowserProviderModule, an as BrowserProviderOptions, o as BrowserScript, ao as BrowserServerState, ap as BrowserServerStateSession, q as BuiltinEnvironment, aq as CDPSession, t as CSSModuleScopeStrategy, l as CoverageIstanbulOptions, k as CoverageOptions, g as CoverageProvider, h as CoverageProviderModule, i as CoverageReporter, c as CoverageV8Options, m as CustomProviderOptions, D as DepsOptimizationOptions, _ as HTMLOptions, I as InlineConfig, a0 as JUnitOptions, $ as JsonOptions, O as OnServerRestartHandler, K as OnTestsRerunHandler, ar as ParentProjectBrowser, P as Pool, s as PoolOptions, Q as ProcessPool, as as ProjectBrowser, z as ProjectConfig, a as ReportContext, ay as ReportedHookContext, n as Reporter, av as ResolveSnapshotPathHandler, aw as ResolveSnapshotPathHandlerContext, at as ResolvedBrowserOptions, R as ResolvedCoverageOptions, au as ResolvedProjectConfig, Z as SerializedTestProject, a1 as TaskOptions, a2 as TestCase, a3 as TestCollection, a4 as TestDiagnostic, a5 as TestModuleState, a6 as TestResult, a7 as TestResultFailed, a8 as TestResultPassed, a9 as TestResultSkipped, az as TestRunEndReason, ax as TestRunResult, ad as TestSequencerConstructor, aa as TestState, ab as TestSuite, ac as TestSuiteState, v as TransformModePatterns, w as TypecheckConfig, U as UserWorkspaceConfig, r as VitestEnvironment, N as VitestPackageInstaller, X as WorkspaceSpec, Y as getFilePoolName } from './chunks/reporters.d.CfRkRKN2.js';
import { InlineConfig, UserConfig as UserConfig$1, Plugin, ResolvedConfig as ResolvedConfig$1, LogLevel, LoggerOptions, Logger as Logger$1, createServer as createServer$1 } from 'vite';
import * as vite from 'vite';
export { vite as Vite };
export { esbuildVersion, isFileServingAllowed, parseAst, parseAstAsync, rollupVersion, version as viteVersion } from 'vite';
import { IncomingMessage } from 'node:http';
import { R as RuntimeRPC } from './chunks/worker.d.C58isfFm.js';
import { Writable } from 'node:stream';
export { V as VitestPluginContext } from './chunks/vite.d.4pkSbgmp.js';
export { W as WorkerContext } from './chunks/worker.d.CSFlSYJg.js';
export { C as TypeCheckCollectLineNumbers, a as TypeCheckCollectLines, c as TypeCheckContext, T as TypeCheckErrorInfo, R as TypeCheckRawErrorsMap, b as TypeCheckRootAndTarget } from './chunks/global.d.Cg2sEPIm.js';
import { Debugger } from 'debug';
export { Task as RunnerTask, TaskResult as RunnerTaskResult, TaskResultPack as RunnerTaskResultPack, Test as RunnerTestCase, File as RunnerTestFile, Suite as RunnerTestSuite, SequenceHooks, SequenceSetupFiles } from '@vitest/runner';
export { f as EnvironmentOptions, H as HappyDOMOptions, J as JSDOMOptions } from './chunks/environment.d.C8UItCbf.js';
export { SerializedError } from '@vitest/utils';
export { b as RuntimeConfig } from './chunks/config.d.DevWltVl.js';
export { generateFileHash } from '@vitest/runner/utils';
import 'node:console';
import '@vitest/mocker';
import '@vitest/utils/source-map';
import '@vitest/pretty-format';
import '@vitest/snapshot';
import '@vitest/utils/diff';
import 'vite-node';
import 'chai';
import './chunks/benchmark.d.BwvBVTda.js';
import 'tinybench';
import './chunks/coverage.d.S9RMNXIe.js';
import 'vite-node/client';
import '@vitest/snapshot/manager';
import 'node:fs';
import 'node:worker_threads';
import '@vitest/expect';
import '@vitest/snapshot/environment';

declare function isValidApiRequest(config: ResolvedConfig, req: IncomingMessage): boolean;

interface CliOptions extends UserConfig {
	/**
	* Override the watch mode
	*/
	run?: boolean;
	/**
	* Removes colors from the console output
	*/
	color?: boolean;
	/**
	* Output collected tests as JSON or to a file
	*/
	json?: string | boolean;
	/**
	* Output collected test files only
	*/
	filesOnly?: boolean;
	/**
	* Override vite config's configLoader from cli.
	* Use `bundle` to bundle the config with esbuild or `runner` (experimental) to process it on the fly (default: `bundle`).
	* This is only available with **vite version 6.1.0** and above.
	* @experimental
	*/
	configLoader?: InlineConfig extends {
		configLoader?: infer T
	} ? T : never;
}
/**
* Start Vitest programmatically
*
* Returns a Vitest instance if initialized successfully.
*/
declare function startVitest(mode: VitestRunMode, cliFilters?: string[], options?: CliOptions, viteOverrides?: UserConfig$1, vitestOptions?: VitestOptions): Promise<Vitest>;

interface CliParseOptions {
	allowUnknownOptions?: boolean;
}
declare function parseCLI(argv: string | string[], config?: CliParseOptions): {
	filter: string[]
	options: CliOptions
};

declare function resolveApiServerConfig<Options extends ApiConfig & UserConfig>(options: Options, defaultPort: number): ApiConfig | undefined;

declare function createVitest(mode: VitestRunMode, options: CliOptions, viteOverrides?: UserConfig$1, vitestOptions?: VitestOptions): Promise<Vitest>;

declare class FilesNotFoundError extends Error {
	code: string;
	constructor(mode: "test" | "benchmark");
}
declare class GitNotFoundError extends Error {
	code: string;
	constructor();
}

/** @deprecated use `TestProject` instead */
type GlobalSetupContext = TestProject;

declare function VitestPlugin(options?: UserConfig, ctx?: Vitest): Promise<Plugin[]>;

declare function resolveConfig(options?: UserConfig, viteOverrides?: UserConfig$1): Promise<{
	vitestConfig: ResolvedConfig
	viteConfig: ResolvedConfig$1
}>;

declare function resolveFsAllow(projectRoot: string, rootConfigFile: string | false | undefined): string[];

interface MethodsOptions {
	cacheFs?: boolean;
	collect?: boolean;
}
declare function createMethodsRPC(project: TestProject, options?: MethodsOptions): RuntimeRPC;

declare class BaseSequencer implements TestSequencer {
	protected ctx: Vitest;
	constructor(ctx: Vitest);
	shard(files: TestSpecification[]): Promise<TestSpecification[]>;
	sort(files: TestSpecification[]): Promise<TestSpecification[]>;
}

declare function registerConsoleShortcuts(ctx: Vitest, stdin: NodeJS.ReadStream | undefined, stdout: NodeJS.WriteStream | Writable): () => void;

declare function createViteLogger(console: Logger, level?: LogLevel, options?: LoggerOptions): Logger$1;

declare const rootDir: string;
declare const distDir: string;

declare function createDebugger(namespace: `vitest:${string}`): Debugger | undefined;

declare const version: string;

/** @deprecated use `createViteServer` instead */
declare const createServer: typeof createServer$1;
declare const createViteServer: typeof createServer$1;

/**
* @deprecated Use `TestModule` instead
*/
declare const TestFile: typeof TestModule;

/**
* @deprecated Use `ModuleDiagnostic` instead
*/
type FileDiagnostic = ModuleDiagnostic;

export { ApiConfig, BaseSequencer, GitNotFoundError, ModuleDiagnostic, ResolvedConfig, TestFile, TestModule, TestProject, TestSequencer, TestSpecification, FilesNotFoundError as TestsNotFoundError, UserConfig, Vitest, VitestOptions, VitestPlugin, VitestRunMode, TestProject as WorkspaceProject, createDebugger, createMethodsRPC, createServer, createViteLogger, createViteServer, createVitest, distDir, isValidApiRequest, parseCLI, registerConsoleShortcuts, resolveApiServerConfig, resolveConfig, resolveFsAllow, rootDir, startVitest, version };
export type { CliParseOptions, FileDiagnostic, GlobalSetupContext };
