/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Functions;
import org.apache.commons.lang3.Streams;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.function.Executable;
import org.xml.sax.SAXException;

public class StreamsTest
extends AbstractLangTest {
    protected <T extends Throwable> Functions.FailableConsumer<String, T> asIntConsumer(T pThrowable) {
        return s -> {
            int i = Integer.parseInt(s);
            if (i == 4) {
                throw pThrowable;
            }
        };
    }

    protected <T extends Throwable> Functions.FailablePredicate<Integer, T> asIntPredicate(T pThrowable) {
        return i -> {
            if (i == 5 && pThrowable != null) {
                throw pThrowable;
            }
            return i % 2 == 0;
        };
    }

    private void assertEvenNumbers(List<Integer> output) {
        Assertions.assertEquals((int)3, (int)output.size());
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)((i + 1) * 2), (int)output.get(i));
        }
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamFilterFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).filter(this.asIntPredicate(null)).collect(Collectors.toList());
        this.assertEvenNumbers(output);
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid argument: 5");
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(iae)).collect(Collectors.toList());
            IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, (Executable)testMethod);
            MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Invalid argument: 5")));
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(oome)).collect(Collectors.toList());
            OutOfMemoryError thrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)testMethod);
            MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).filter(this.asIntPredicate(se)).collect(Collectors.toList());
            UndeclaredThrowableException thrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)testMethod);
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue())), () -> MatcherAssert.assertThat((Object)thrown.getCause(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)se)))});
        }));
    }

    @TestFactory
    public Stream<DynamicTest> simpleStreamForEachFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        return Stream.of(DynamicTest.dynamicTest((String)"IllegalArgumentException", () -> {
            IllegalArgumentException ise = new IllegalArgumentException();
            Executable testMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(ise));
            IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, (Executable)testMethod);
            MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }), DynamicTest.dynamicTest((String)"OutOfMemoryError", () -> {
            OutOfMemoryError oome = new OutOfMemoryError();
            Executable oomeTestMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(oome));
            OutOfMemoryError oomeThrown = (OutOfMemoryError)Assertions.assertThrows(OutOfMemoryError.class, (Executable)oomeTestMethod);
            MatcherAssert.assertThat((Object)oomeThrown.getMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        }), DynamicTest.dynamicTest((String)"SAXException", () -> {
            SAXException se = new SAXException();
            Executable seTestMethod = () -> Functions.stream((Collection)input).forEach(this.asIntConsumer(se));
            UndeclaredThrowableException seThrown = (UndeclaredThrowableException)Assertions.assertThrows(UndeclaredThrowableException.class, (Executable)seTestMethod);
            Assertions.assertAll((Executable[])new Executable[]{() -> MatcherAssert.assertThat((Object)seThrown.getMessage(), (Matcher)Is.is((Matcher)IsNull.nullValue())), () -> MatcherAssert.assertThat((Object)seThrown.getCause(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)se)))});
        }));
    }

    @Test
    public void testSimpleStreamFilter() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).filter(i -> i % 2 == 0).collect(Collectors.toList());
        this.assertEvenNumbers(output);
    }

    @Test
    public void testSimpleStreamForEach() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        ArrayList output = new ArrayList();
        Functions.stream(input).forEach(s -> output.add(Integer.valueOf(s)));
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    public void testSimpleStreamMap() {
        List<String> input = Arrays.asList("1", "2", "3", "4", "5", "6");
        List output = (List)Functions.stream(input).map(Integer::valueOf).collect(Collectors.toList());
        Assertions.assertEquals((int)6, (int)output.size());
        for (int i = 0; i < 6; ++i) {
            Assertions.assertEquals((int)(i + 1), (int)((Integer)output.get(i)));
        }
    }

    @Test
    public void testSimpleStreamMapFailing() {
        List<String> input = Arrays.asList("1", "2", "3", "4 ", "5", "6");
        Executable testMethod = () -> Functions.stream((Collection)input).map(Integer::valueOf).collect(Collectors.toList());
        NumberFormatException thrown = (NumberFormatException)Assertions.assertThrows(NumberFormatException.class, (Executable)testMethod);
        Assertions.assertEquals((Object)"For input string: \"4 \"", (Object)thrown.getMessage());
    }

    @Test
    public void testToArray() {
        String[] array = (String[])Arrays.asList("2", "3", "1").stream().collect(Streams.toArray(String.class));
        Assertions.assertNotNull((Object)array);
        Assertions.assertEquals((int)3, (int)array.length);
        Assertions.assertEquals((Object)"2", (Object)array[0]);
        Assertions.assertEquals((Object)"3", (Object)array[1]);
        Assertions.assertEquals((Object)"1", (Object)array[2]);
    }
}

