/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DiffResultTest
extends AbstractLangTest {
    private static final SimpleClass SIMPLE_FALSE = new SimpleClass(false);
    private static final SimpleClass SIMPLE_TRUE = new SimpleClass(true);
    private static final ToStringStyle SHORT_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;

    @Test
    public void testIterator() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        Iterator expectedIterator = diffs.iterator();
        DiffResult list = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Assertions.assertTrue((boolean)expectedIterator.hasNext());
            Assertions.assertEquals(expectedIterator.next(), iterator.next());
        }
    }

    @Test
    public void testLeftAndRightGetters() {
        SimpleClass left = new SimpleClass(true);
        SimpleClass right = new SimpleClass(false);
        List diffs = left.diff(right).getDiffs();
        DiffResult diffResult = new DiffResult((Object)left, (Object)right, diffs, SHORT_STYLE);
        Assertions.assertEquals((Object)left, (Object)diffResult.getLeft());
        Assertions.assertEquals((Object)right, (Object)diffResult.getRight());
    }

    @Test
    public void testListIsNonModifiable() {
        SimpleClass lhs = new SimpleClass(true);
        SimpleClass rhs = new SimpleClass(false);
        List diffs = lhs.diff(rhs).getDiffs();
        DiffResult list = new DiffResult((Object)lhs, (Object)rhs, diffs, SHORT_STYLE);
        Assertions.assertEquals((Object)diffs, (Object)list.getDiffs());
        Assertions.assertEquals((int)1, (int)list.getNumberOfDiffs());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> list.getDiffs().remove(0));
    }

    @Test
    public void testNoDifferencesString() {
        DiffResult diffResult = new DiffBuilder((Object)SIMPLE_TRUE, (Object)SIMPLE_TRUE, SHORT_STYLE).build();
        Assertions.assertEquals((Object)"", (Object)diffResult.toString());
    }

    @Test
    public void testNullLhs() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffResult(null, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE));
    }

    @Test
    public void testNullList() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, null, SHORT_STYLE));
    }

    @Test
    public void testNullRhs() {
        Assertions.assertThrows(NullPointerException.class, () -> new DiffResult((Object)SIMPLE_TRUE, null, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), SHORT_STYLE));
    }

    @Test
    public void testNullStyle() {
        DiffResult diffResult = new DiffResult((Object)SIMPLE_TRUE, (Object)SIMPLE_FALSE, SIMPLE_TRUE.diff(SIMPLE_FALSE).getDiffs(), null);
        Assertions.assertEquals((Object)ToStringStyle.DEFAULT_STYLE, (Object)diffResult.getToStringStyle());
    }

    @Test
    public void testToStringOutput() {
        DiffResult list = new DiffBuilder((Object)new EmptyClass(), (Object)new EmptyClass(), ToStringStyle.SHORT_PREFIX_STYLE).append("test", false, true).build();
        Assertions.assertEquals((Object)"DiffResultTest.EmptyClass[test=false] differs from DiffResultTest.EmptyClass[test=true]", (Object)list.toString());
    }

    @Test
    public void testToStringSpecifyStyleOutput() {
        DiffResult<SimpleClass> list = SIMPLE_FALSE.diff(SIMPLE_TRUE);
        Assertions.assertEquals((Object)list.getToStringStyle(), (Object)SHORT_STYLE);
        String lhsString = new ToStringBuilder((Object)SIMPLE_FALSE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_FALSE.booleanField).build();
        String rhsString = new ToStringBuilder((Object)SIMPLE_TRUE, ToStringStyle.MULTI_LINE_STYLE).append(SimpleClass.getFieldName(), SIMPLE_TRUE.booleanField).build();
        String expectedOutput = String.format("%s differs from %s", lhsString, rhsString);
        Assertions.assertEquals((Object)expectedOutput, (Object)list.toString(ToStringStyle.MULTI_LINE_STYLE));
    }

    private static final class SimpleClass
    implements Diffable<SimpleClass> {
        private final boolean booleanField;

        static String getFieldName() {
            return "booleanField";
        }

        SimpleClass(boolean booleanField) {
            this.booleanField = booleanField;
        }

        public DiffResult<SimpleClass> diff(SimpleClass obj) {
            return new DiffBuilder((Object)this, (Object)obj, ToStringStyle.SHORT_PREFIX_STYLE).append(SimpleClass.getFieldName(), this.booleanField, obj.booleanField).build();
        }
    }

    private static final class EmptyClass {
        private EmptyClass() {
        }
    }
}

