/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.uml.reveng.idl;

import java.net.MalformedURLException;
import org.apache.log4j.Logger;
import org.argouml.model.Model;
import org.argouml.uml.reveng.ImportClassLoader;
import org.argouml.uml.reveng.idl.ClassifierNotFoundException;
import org.argouml.uml.reveng.idl.Context;

class PackageContext
extends Context {
    private static final Logger LOG = Logger.getLogger(PackageContext.class);
    private Object mPackage;
    private String javaName;
    private static final String GENERATED_TAG_VALUE = "true";

    public PackageContext(Context base, Object thePackage) {
        super(base);
        this.mPackage = thePackage;
        this.javaName = this.getJavaName(thePackage);
    }

    @Override
    public Object getInterface(String name) throws ClassifierNotFoundException {
        return this.get(name, true);
    }

    @Override
    public Object get(String name) throws ClassifierNotFoundException {
        return this.get(name, false);
    }

    @Override
    public Object get(String name, boolean interfacesOnly) throws ClassifierNotFoundException {
        Object mClassifier = Model.getFacade().lookupIn(this.mPackage, name);
        if (mClassifier == null) {
            try {
                Class<?> classifier;
                if (Model.getFacade().isAModel(this.mPackage)) {
                    classifier = Class.forName(name);
                } else {
                    String clazzName = this.javaName + "." + name;
                    classifier = Class.forName(clazzName);
                }
                if (classifier.isInterface()) {
                    mClassifier = Model.getCoreFactory().buildInterface(name, this.mPackage);
                } else if (!interfacesOnly) {
                    mClassifier = Model.getCoreFactory().buildClass(name, this.mPackage);
                }
                if (mClassifier != null) {
                    this.setGeneratedTag(mClassifier);
                }
            }
            catch (ClassNotFoundException e) {
                try {
                    Class classifier;
                    if (Model.getFacade().isAModel(this.mPackage)) {
                        classifier = ImportClassLoader.getInstance().loadClass(name);
                    } else {
                        String clazzName = this.javaName + "." + name;
                        classifier = ImportClassLoader.getInstance().loadClass(clazzName);
                    }
                    if (classifier.isInterface()) {
                        mClassifier = Model.getCoreFactory().buildInterface(name, this.mPackage);
                    } else if (!interfacesOnly) {
                        mClassifier = Model.getCoreFactory().buildClass(name, this.mPackage);
                    }
                    if (mClassifier != null) {
                        this.setGeneratedTag(mClassifier);
                    }
                }
                catch (ClassNotFoundException e1) {
                }
                catch (MalformedURLException e1) {
                    LOG.warn((Object)"Classpath configuration error", (Throwable)e1);
                }
            }
        }
        if (mClassifier == null) {
            if (this.getContext() != null) {
                mClassifier = this.getContext().get(name, interfacesOnly);
            } else if (!interfacesOnly && name.equals("int") || name.equals("long") || name.equals("short") || name.equals("byte") || name.equals("char") || name.equals("float") || name.equals("double") || name.equals("boolean") || name.equals("void") || name.indexOf("[]") != -1) {
                mClassifier = Model.getCoreFactory().buildDataType(name, this.mPackage);
            }
        }
        if (mClassifier == null) {
            throw new ClassifierNotFoundException(name);
        }
        return mClassifier;
    }

    private void setGeneratedTag(Object element) {
        Object tv = Model.getFacade().getTaggedValue(element, "GeneratedFromImport");
        if (tv == null) {
            Model.getExtensionMechanismsHelper().addTaggedValue(element, Model.getExtensionMechanismsFactory().buildTaggedValue("GeneratedFromImport", GENERATED_TAG_VALUE));
        } else {
            Model.getExtensionMechanismsHelper().setValueOfTag(tv, GENERATED_TAG_VALUE);
        }
    }
}

