/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.uml.reveng.idl;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.argouml.model.Model;
import org.argouml.uml.reveng.idl.ClassifierContext;
import org.argouml.uml.reveng.idl.Context;
import org.argouml.uml.reveng.idl.OuterClassifierContext;
import org.argouml.uml.reveng.idl.PackageContext;

class ParseState {
    private static final Logger LOG = Logger.getLogger(ParseState.class);
    private Collection obsoleteFeatures;
    private Collection obsoleteInnerClasses;
    private String classnamePrefix;
    private Context context;
    private Object classifier;
    private int anonymousClassCounter;
    private Object component;

    public ParseState(Object model, Object javaLangPackage) {
        this.obsoleteInnerClasses = new ArrayList();
        this.classifier = null;
        this.context = new PackageContext(new PackageContext(null, model), javaLangPackage);
        this.anonymousClassCounter = 0;
    }

    public ParseState(ParseState previousState, Object mClassifier, Object currentPackage) {
        LOG.info((Object)("Parsing the state of " + mClassifier));
        this.classnamePrefix = previousState.classnamePrefix + Model.getFacade().getName(mClassifier) + "$";
        this.obsoleteFeatures = new ArrayList(Model.getFacade().getFeatures(mClassifier));
        this.obsoleteInnerClasses = new ArrayList(Model.getFacade().getOwnedElements(mClassifier));
        this.context = new OuterClassifierContext(previousState.context, mClassifier, currentPackage, this.classnamePrefix);
        this.classifier = mClassifier;
        this.anonymousClassCounter = previousState.anonymousClassCounter;
    }

    public void addPackageContext(Object mPackage) {
        this.context = new PackageContext(this.context, mPackage);
    }

    public void addClassifierContext(Object mClassifier) {
        this.context = new ClassifierContext(this.context, mClassifier);
    }

    public void addComponent(Object c) {
        this.component = c;
    }

    public Object getComponent() {
        return this.component;
    }

    public Context getContext() {
        return this.context;
    }

    public Object getClassifier() {
        return this.classifier;
    }

    public String anonymousClass() {
        this.classnamePrefix = this.classnamePrefix.substring(0, this.classnamePrefix.indexOf("$") + 1);
        ++this.anonymousClassCounter;
        return Integer.valueOf(this.anonymousClassCounter).toString();
    }

    public void outerClassifier() {
        this.classnamePrefix = "";
        this.anonymousClassCounter = 0;
    }

    public String getClassnamePrefix() {
        return this.classnamePrefix;
    }

    public void innerClassifier(Object mClassifier) {
        this.obsoleteInnerClasses.remove(mClassifier);
    }

    public void removeObsoleteFeatures() {
        if (this.obsoleteFeatures == null) {
            return;
        }
        for (Object feature : this.obsoleteFeatures) {
            Model.getCoreHelper().removeFeature(this.classifier, feature);
            Model.getUmlFactory().delete(feature);
        }
    }

    public void removeObsoleteInnerClasses() {
        if (this.obsoleteInnerClasses == null) {
            return;
        }
        for (Object element : this.obsoleteInnerClasses) {
            if (!Model.getFacade().isAClassifier(element)) continue;
            Model.getUmlFactory().delete(element);
        }
    }

    public void feature(Object feature) {
        this.obsoleteFeatures.remove(feature);
    }

    public Object getFeature(String name) {
        for (Object mFeature : this.obsoleteFeatures) {
            if (!name.equals(Model.getFacade().getName(mFeature))) continue;
            return mFeature;
        }
        return null;
    }

    public Collection getFeatures(String name) {
        ArrayList list = new ArrayList();
        for (Object mFeature : this.obsoleteFeatures) {
            if (!name.equals(Model.getFacade().getName(mFeature))) continue;
            list.add(mFeature);
        }
        return list;
    }

    public Object getMethod(String name) {
        for (Object mFeature : this.obsoleteFeatures) {
            if (!Model.getFacade().isAMethod(mFeature) || !name.equals(Model.getFacade().getName(mFeature))) continue;
            return mFeature;
        }
        return null;
    }

    public Object getOperation(String name) {
        for (Object feature : this.obsoleteFeatures) {
            if (!Model.getFacade().isAOperation(feature) || !name.equals(Model.getFacade().getName(feature))) continue;
            return feature;
        }
        return null;
    }

    public Object getAttribute(String name) {
        for (Object feature : this.obsoleteFeatures) {
            if (!Model.getFacade().isAAttribute(feature) || !name.equals(Model.getFacade().getName(feature))) continue;
            return feature;
        }
        return null;
    }
}

