/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.cpp;

public final class Token {
    private int type;
    private int line;
    private int column;
    private Object value;
    private String text;
    public static final int AND_EQ = 257;
    public static final int ARROW = 258;
    public static final int CHARACTER = 259;
    public static final int COMMENT = 260;
    public static final int DEC = 261;
    public static final int DIV_EQ = 262;
    public static final int ELLIPSIS = 263;
    public static final int EOF = 264;
    public static final int EQ = 265;
    public static final int GE = 266;
    public static final int HASH = 267;
    public static final int HEADER = 268;
    public static final int IDENTIFIER = 269;
    public static final int INC = 270;
    public static final int INTEGER = 271;
    public static final int LAND = 272;
    public static final int LAND_EQ = 273;
    public static final int LE = 274;
    public static final int LITERAL = 275;
    public static final int LOR = 276;
    public static final int LOR_EQ = 277;
    public static final int LSH = 278;
    public static final int LSH_EQ = 279;
    public static final int MOD_EQ = 280;
    public static final int MULT_EQ = 281;
    public static final int NE = 282;
    public static final int NL = 283;
    public static final int OR_EQ = 284;
    public static final int PASTE = 285;
    public static final int PLUS_EQ = 286;
    public static final int RANGE = 287;
    public static final int RSH = 288;
    public static final int RSH_EQ = 289;
    public static final int STRING = 290;
    public static final int SUB_EQ = 291;
    public static final int WHITESPACE = 292;
    public static final int XOR_EQ = 293;
    public static final int M_ARG = 294;
    public static final int M_PASTE = 295;
    public static final int M_STRING = 296;
    public static final int P_LINE = 297;
    public static final int ERROR = 298;
    public static final int _TOKENS = 299;
    static final Token space = new Token(292, -1, -1, " ");
    private static final String[] names = new String[299];
    private static final String[] texts = new String[299];

    public Token(int type, int line, int column, String text, Object value) {
        this.type = type;
        this.line = line;
        this.column = column;
        this.text = text;
        this.value = value;
    }

    public Token(int type, int line, int column, String text) {
        this(type, line, column, text, null);
    }

    Token(int type, String text, Object value) {
        this(type, -1, -1, text, value);
    }

    Token(int type, String text) {
        this(type, text, null);
    }

    Token(int type) {
        this(type, texts[type]);
    }

    public int getType() {
        return this.type;
    }

    void setLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(Token.getTokenName(this.type));
        if (this.line != -1) {
            buf.append('@').append(this.line);
            if (this.column != -1) {
                buf.append(',').append(this.column);
            }
        }
        buf.append("]:");
        if (this.text != null) {
            buf.append('\"').append(this.text).append('\"');
        } else if (this.type > 3 && this.type < 256) {
            buf.append((char)this.type);
        } else {
            buf.append('<').append(this.type).append('>');
        }
        if (this.value != null) {
            buf.append('=').append(this.value);
        }
        return buf.toString();
    }

    public static final String getTokenName(int type) {
        if (type < 0) {
            return "Invalid" + type;
        }
        if (type >= names.length) {
            return "Invalid" + type;
        }
        if (names[type] == null) {
            return "Unknown" + type;
        }
        return names[type];
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Token.texts[i] = String.valueOf(new char[]{(char)i});
            Token.names[i] = texts[i];
        }
        Token.texts[257] = "&=";
        Token.texts[258] = "->";
        Token.texts[261] = "--";
        Token.texts[262] = "/=";
        Token.texts[263] = "...";
        Token.texts[265] = "==";
        Token.texts[266] = ">=";
        Token.texts[267] = "#";
        Token.texts[270] = "++";
        Token.texts[272] = "&&";
        Token.texts[273] = "&&=";
        Token.texts[274] = "<=";
        Token.texts[276] = "||";
        Token.texts[277] = "||=";
        Token.texts[278] = "<<";
        Token.texts[279] = "<<=";
        Token.texts[280] = "%=";
        Token.texts[281] = "*=";
        Token.texts[282] = "!=";
        Token.texts[283] = "\n";
        Token.texts[284] = "|=";
        Token.texts[285] = "##";
        Token.texts[286] = "+=";
        Token.texts[287] = "..";
        Token.texts[288] = ">>";
        Token.texts[289] = ">>=";
        Token.texts[291] = "-=";
        Token.texts[293] = "^=";
        Token.names[257] = "AND_EQ";
        Token.names[258] = "ARROW";
        Token.names[259] = "CHARACTER";
        Token.names[260] = "COMMENT";
        Token.names[261] = "DEC";
        Token.names[262] = "DIV_EQ";
        Token.names[263] = "ELLIPSIS";
        Token.names[264] = "EOF";
        Token.names[265] = "EQ";
        Token.names[266] = "GE";
        Token.names[267] = "HASH";
        Token.names[268] = "HEADER";
        Token.names[269] = "IDENTIFIER";
        Token.names[270] = "INC";
        Token.names[271] = "INTEGER";
        Token.names[272] = "LAND";
        Token.names[273] = "LAND_EQ";
        Token.names[274] = "LE";
        Token.names[275] = "LITERAL";
        Token.names[276] = "LOR";
        Token.names[277] = "LOR_EQ";
        Token.names[278] = "LSH";
        Token.names[279] = "LSH_EQ";
        Token.names[280] = "MOD_EQ";
        Token.names[281] = "MULT_EQ";
        Token.names[282] = "NE";
        Token.names[283] = "NL";
        Token.names[284] = "OR_EQ";
        Token.names[285] = "PASTE";
        Token.names[286] = "PLUS_EQ";
        Token.names[287] = "RANGE";
        Token.names[288] = "RSH";
        Token.names[289] = "RSH_EQ";
        Token.names[290] = "STRING";
        Token.names[291] = "SUB_EQ";
        Token.names[292] = "WHITESPACE";
        Token.names[293] = "XOR_EQ";
        Token.names[294] = "M_ARG";
        Token.names[295] = "M_PASTE";
        Token.names[296] = "M_STRING";
        Token.names[297] = "P_LINE";
        Token.names[298] = "ERROR";
    }
}

