/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.di.GraphElement;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.presentation.Fig;

public abstract class ModeCreate
extends FigModifyingModeImpl {
    protected int _defaultWidth = 32;
    protected int _defaultHeight = 32;
    protected int anchorX;
    protected int anchorY;
    protected Fig _newItem;
    private static Log LOG = LogFactory.getLog(ModeCreate.class);
    private Point snapPt = new Point(0, 0);

    public ModeCreate(Editor par) {
        super(par);
    }

    public ModeCreate() {
    }

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void mousePressed(MouseEvent me) {
        this.createFig(me);
        if (!(this._newItem instanceof GraphElement) && this.editor.getGraphModel() instanceof MutableGraphSupport) {
            ((MutableGraphSupport)this.editor.getGraphModel()).fireGraphChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFig(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        this.start();
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(me.getX(), me.getY());
            this.editor.snap(this.snapPt);
            this.anchorX = this.snapPt.x;
            this.anchorY = this.snapPt.y;
        }
        this._newItem = this.createNewItem(me, this.anchorX, this.anchorY);
        me.consume();
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this.editor.damageAll();
            this.creationDrag(me.getX(), me.getY());
            this.editor.damageAll();
        }
        this.editor.scrollToShow(me.getX(), me.getY());
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this.editor.damageAll();
            this.creationDrag(me.getX(), me.getY());
            this.editor.add(this._newItem);
            this.editor.getSelectionManager().select(this._newItem);
            this._newItem = null;
        }
        this.done();
        me.consume();
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\u001b') {
            LOG.debug((Object)"ESC pressed");
            this.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void creationDrag(int x, int y) {
        int snapY;
        int snapX;
        if (this._newItem == null) {
            return;
        }
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(x, y);
            this.editor.snap(this.snapPt);
            snapX = this.snapPt.x;
            snapY = this.snapPt.y;
        }
        if (this.anchorX == snapX && this.anchorY == snapY) {
            this._newItem.createDrag(this.anchorX, this.anchorY, x + this._defaultWidth, y + this._defaultHeight, snapX + this._defaultWidth, snapY + this._defaultHeight);
        } else {
            this._newItem.createDrag(this.anchorX, this.anchorY, x, y, snapX, snapY);
            this._defaultWidth = snapX - this.anchorX;
            this._defaultHeight = snapY - this.anchorY;
        }
    }

    public void paint(Graphics g) {
        if (null != this._newItem) {
            this._newItem.paint(g);
        }
    }

    public abstract Fig createNewItem(MouseEvent var1, int var2, int var3);
}

