/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public final class GridBagUtils {
    public static final int CENTER = 2;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private static Insets buttonInsets;
    private static Insets captionInsets;
    private static Insets inputFieldInsets;
    private static int rowDistance;

    public static GridBagConstraints buttonConstraints(int x, int y) {
        return GridBagUtils.buttonConstraints(x, y, 1, 1);
    }

    public static GridBagConstraints buttonConstraints(int x, int y, int width, int height) {
        GridBagConstraints gbc = GridBagUtils.createConstraints(x, y, width, height);
        gbc.fill = 1;
        gbc.insets = buttonInsets;
        return gbc;
    }

    public static GridBagConstraints captionConstraints(int x, int y) {
        return GridBagUtils.captionConstraints(x, y, 1, 1, 1);
    }

    public static GridBagConstraints captionConstraints(int x, int y, int alignment) {
        return GridBagUtils.captionConstraints(x, y, 1, 1, alignment);
    }

    public static GridBagConstraints captionConstraints(int x, int y, int width, int height) {
        return GridBagUtils.captionConstraints(x, y, width, height, 1);
    }

    public static GridBagConstraints captionConstraints(int x, int y, int width, int height, int alignment) {
        GridBagConstraints gbc = GridBagUtils.createConstraints(x, y, width, height);
        if (alignment == 0) {
            gbc.anchor = 18;
        } else if (alignment == 1) {
            gbc.anchor = 12;
        } else if (alignment == 2) {
            gbc.anchor = 10;
        }
        gbc.insets = captionInsets;
        return gbc;
    }

    public static GridBagConstraints clientAlignConstraints(int x, int y) {
        return GridBagUtils.clientAlignConstraints(x, y, 1, 1);
    }

    public static GridBagConstraints clientAlignConstraints(int x, int y, int width, int height) {
        GridBagConstraints gbc = GridBagUtils.createConstraints(x, y, width, height);
        gbc.fill = 1;
        return gbc;
    }

    public static GridBagConstraints createConstraints(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        return gbc;
    }

    public static Object textAreaConstraints(int x, int y) {
        return GridBagUtils.textAreaConstraints(x, y, 1, 1);
    }

    public static Object textAreaConstraints(int x, int y, int width, int height) {
        GridBagConstraints gbc = GridBagUtils.createConstraints(x, y, width, height);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.insets = inputFieldInsets;
        return gbc;
    }

    public static GridBagConstraints textFieldConstraints(int x, int y) {
        return GridBagUtils.textFieldConstraints(x, y, 1, 1);
    }

    public static GridBagConstraints textFieldConstraints(int x, int y, int width, int height) {
        GridBagConstraints gbc = GridBagUtils.createConstraints(x, y, width, height);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.insets = inputFieldInsets;
        return gbc;
    }

    private GridBagUtils() {
    }

    static {
        rowDistance = 2;
        buttonInsets = new Insets(rowDistance, 5, rowDistance, 5);
        captionInsets = new Insets(rowDistance + 2, 5, rowDistance, 5);
        inputFieldInsets = new Insets(rowDistance, 0, rowDistance, 0);
    }
}

