/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.argouml.i18n.Translator;
import org.argouml.language.sql.GeneratorSql;
import org.argouml.language.sql.SqlCodeCreator;
import org.argouml.ui.ExceptionDialog;
import org.argouml.ui.GridBagUtils;
import org.argouml.ui.ProjectBrowser;
import org.argouml.ui.TableModelCodeCreators;
import org.argouml.util.ArgoDialog;

public final class SelectCodeCreatorDialog
extends ArgoDialog {
    private JLabel lblSelect;
    private JScrollPane spList;
    private JTable tblCreators;
    private static boolean executed = false;
    private static final Logger LOG = Logger.getLogger(SelectCodeCreatorDialog.class);

    public static boolean execute() {
        if (!executed) {
            SelectCodeCreatorDialog d = new SelectCodeCreatorDialog();
            d.setVisible(true);
        }
        return executed;
    }

    private SelectCodeCreatorDialog() {
        super(Translator.localize((String)"argouml-sql.select-dialog.title"), 5, true);
        this.setPreferredSize(new Dimension(400, 300));
        GridBagLayout l = new GridBagLayout();
        l.rowWeights = new double[]{0.0, 1.0};
        l.columnWeights = new double[]{1.0};
        JPanel content = new JPanel();
        content.setLayout(l);
        this.lblSelect = new JLabel(Translator.localize((String)"argouml-sql.select-dialog.label-select") + ":");
        this.tblCreators = new JTable(new TableModelCodeCreators());
        this.spList = new JScrollPane(this.tblCreators);
        this.getOkButton().setEnabled(false);
        content.add((Component)this.lblSelect, GridBagUtils.captionConstraints(0, 0, 0));
        content.add((Component)this.spList, GridBagUtils.clientAlignConstraints(0, 1));
        this.setContent(content);
        this.tblCreators.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (SelectCodeCreatorDialog.this.tblCreators.getSelectedRowCount() > 0) {
                    SelectCodeCreatorDialog.this.getOkButton().setEnabled(true);
                } else {
                    SelectCodeCreatorDialog.this.getOkButton().setEnabled(false);
                }
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getOkButton()) {
            try {
                int index = this.tblCreators.getSelectedRow();
                if (index >= 0 && index < this.tblCreators.getRowCount()) {
                    SqlCodeCreator scc = (SqlCodeCreator)this.tblCreators.getModel().getValueAt(index, -1);
                    GeneratorSql.getInstance().setSqlCodeCreator(scc);
                    executed = true;
                }
            }
            catch (Exception exc) {
                LOG.error((Object)"Exception", (Throwable)exc);
                String message = Translator.localize((String)"argouml-sql.exceptions.no_sqlcodecreator");
                ExceptionDialog ed = new ExceptionDialog((Frame)ProjectBrowser.getInstance(), message, (Throwable)exc);
                ed.setModal(true);
                ed.setVisible(true);
            }
        }
        this.dispose();
    }
}

