/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.tigris.swidgets.Seperator;

public class LabelledLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -5596655602155151443L;
    private int _hgap;
    private int _vgap;
    private boolean _ignoreSplitters;

    public LabelledLayout() {
        this._ignoreSplitters = false;
        this._hgap = 0;
        this._vgap = 0;
    }

    public LabelledLayout(boolean bl) {
        this._ignoreSplitters = bl;
        this._hgap = 0;
        this._vgap = 0;
    }

    public LabelledLayout(int n, int n2) {
        this._ignoreSplitters = false;
        this._hgap = n;
        this._vgap = n2;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = container.getComponentCount();
            for (int i = 0; i < n4; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible() || component instanceof Seperator) continue;
                int n5 = (int)component.getPreferredSize().getHeight();
                if (component instanceof JLabel) {
                    int n6;
                    JLabel jLabel = (JLabel)component;
                    if ((double)n3 < jLabel.getPreferredSize().getWidth()) {
                        n3 = (int)jLabel.getPreferredSize().getWidth();
                    }
                    if ((n6 = (int)(component = jLabel.getLabelFor()).getPreferredSize().getWidth()) > n) {
                        n = n6;
                    }
                    if ((double)n5 < jLabel.getPreferredSize().getHeight()) {
                        n5 = (int)jLabel.getPreferredSize().getHeight();
                    }
                }
                n2 += n5 + this._vgap;
            }
            return new Dimension(insets.left + n3 + (n += insets.left + n3 + insets.right) + insets.right, n2 += insets.top + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = insets.top + insets.bottom;
            int n2 = container.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!(component instanceof JLabel)) continue;
                JLabel jLabel = (JLabel)component;
                int n3 = (int)(component = jLabel.getLabelFor()).getMinimumSize().getHeight();
                if ((double)n3 < jLabel.getMinimumSize().getHeight()) {
                    n3 = (int)jLabel.getMinimumSize().getHeight();
                }
                n += n3 + this._vgap;
            }
            return new Dimension(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.getInsets().left;
            ArrayList<Component> arrayList = new ArrayList<Component>();
            int n2 = this.getSectionCount(container);
            int n3 = this.getSectionWidth(container, n2);
            int n4 = 0;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component = container.getComponent(i);
                if (component instanceof Seperator) {
                    if (this._ignoreSplitters) continue;
                    this.layoutSection(container, n, n3, arrayList, n4++);
                    n += n3 + this._hgap;
                    arrayList.clear();
                    continue;
                }
                arrayList.add(container.getComponent(i));
            }
            this.layoutSection(container, n, n3, arrayList, n4);
        }
    }

    private int getSectionCount(Container container) {
        int n = 1;
        int n2 = container.getComponentCount();
        if (!this._ignoreSplitters) {
            for (int i = 0; i < n2; ++i) {
                if (!(container.getComponent(i) instanceof Seperator)) continue;
                ++n;
            }
        }
        return n;
    }

    private int getSectionWidth(Container container, int n) {
        return (this.getUsableWidth(container) - (n - 1) * this._hgap) / n;
    }

    private int getUsableWidth(Container container) {
        Insets insets = container.getInsets();
        return container.getWidth() - (insets.left + insets.right);
    }

    private void layoutSection(Container container, int n, int n2, ArrayList arrayList, int n3) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n4; ++i) {
            int n8;
            Component component = (Component)arrayList.get(i);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                component = jLabel.getLabelFor();
                int n9 = (int)jLabel.getPreferredSize().getWidth();
                if (n9 > n5) {
                    n5 = n9;
                }
                n8 = (int)jLabel.getPreferredSize().getHeight();
                if (component != null) {
                    ++i;
                    n8 = this.getChildHeight(component);
                    if (n8 == 0) {
                        ++n6;
                    }
                }
            } else {
                n8 = this.getChildHeight(component);
                if (n8 == 0) {
                    ++n6;
                }
            }
            n7 += n8 + this._vgap;
            arrayList2.add(new Integer(n8));
        }
        n7 -= this._vgap;
        Insets insets = container.getInsets();
        int n10 = container.getHeight() - (insets.top + insets.bottom);
        int n11 = insets.top;
        int n12 = 0;
        for (int i = 0; i < n4; ++i) {
            int n13;
            Component component = (Component)arrayList.get(i);
            if (!component.isVisible()) continue;
            int n14 = n2;
            int n15 = n;
            if (component instanceof JLabel && ((JLabel)component).getLabelFor() != null) {
                ++i;
                JLabel jLabel = (JLabel)component;
                component = jLabel.getLabelFor();
                jLabel.setBounds(n, n11, n5, (int)jLabel.getPreferredSize().getHeight());
                n14 = n2 - (n5 + this._hgap);
                n15 = n + n5 + this._hgap;
            }
            if ((n13 = ((Integer)arrayList2.get(n12)).intValue()) == 0) {
                try {
                    n13 = this.calculateHeight(n10, n7, n6--, component);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new IllegalStateException("Division by zero laying out " + component.getClass().getName() + " on " + container.getClass().getName() + " in section " + n3 + " using " + UIManager.getLookAndFeel().getClass().getName(), arithmeticException);
                }
                n7 += n13;
            }
            if (component.getMaximumSize() != null && component.getMaximumSize().getWidth() < (double)n14) {
                n14 = (int)component.getMaximumSize().getWidth();
            }
            component.setBounds(n15, n11, n14, n13);
            n11 += n13 + this._vgap;
            ++n12;
        }
    }

    private int getChildHeight(Component component) {
        if (this.isResizable(component)) {
            return 0;
        }
        return component.getMinimumSize().height;
    }

    private boolean isResizable(Component component) {
        if (component == null) {
            return false;
        }
        if (component instanceof JComboBox) {
            return false;
        }
        if (component.getPreferredSize() == null) {
            return false;
        }
        if (component.getMinimumSize() == null) {
            return false;
        }
        return component.getMinimumSize().getHeight() < component.getPreferredSize().getHeight();
    }

    private int calculateHeight(int n, int n2, int n3, Component component) {
        int n4 = (n - n2) / n3;
        if ((double)n4 < component.getMinimumSize().getHeight()) {
            n4 = (int)component.getMinimumSize().getHeight();
        }
        return n4;
    }

    public static Seperator getSeperator() {
        return new Seperator();
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int n) {
        this._hgap = n;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int n) {
        this._vgap = n;
    }
}

