/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.swidgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;
import org.tigris.swidgets.ArrowButton;
import org.tigris.swidgets.Horizontal;
import org.tigris.swidgets.Orientation;

public class Vertical
extends Orientation {
    private static final Vertical VERTICAL = new Vertical();

    protected Vertical() {
    }

    public static Orientation getInstance() {
        return VERTICAL;
    }

    public Orientation getPerpendicular() {
        return Horizontal.getInstance();
    }

    public int getLength(Dimension dimension) {
        return (int)dimension.getHeight();
    }

    public int getLength(Component component) {
        return component.getHeight();
    }

    public int getLengthMinusInsets(Container container) {
        Insets insets = container.getInsets();
        return container.getHeight() - (insets.top + insets.bottom);
    }

    public int getBreadth(Dimension dimension) {
        return (int)dimension.getWidth();
    }

    public int getBreadth(Component component) {
        return component.getWidth();
    }

    public int getPosition(Point point) {
        return (int)point.getY();
    }

    public int getOffset(Point point) {
        return (int)point.getX();
    }

    public int getLastUsablePosition(Container container) {
        return container.getHeight() - container.getInsets().bottom;
    }

    public int getFirstUsableOffset(Container container) {
        return container.getInsets().top;
    }

    public Point newPoint(int n, int n2) {
        return new Point(n2, n);
    }

    public int getPosition(Component component) {
        return component.getY();
    }

    public int getPosition(MouseEvent mouseEvent) {
        return mouseEvent.getY();
    }

    public Dimension addLength(Dimension dimension, int n) {
        double d = dimension.getWidth();
        double d2 = dimension.getHeight() + (double)n;
        return new Dimension((int)d, (int)d2);
    }

    public Point addToPosition(Point point, int n) {
        double d = point.getX();
        double d2 = point.getY() + (double)n;
        return new Point((int)d, (int)d2);
    }

    public Dimension setLength(Dimension dimension, int n) {
        return new Dimension((int)dimension.getWidth(), n);
    }

    public Dimension setLength(Dimension dimension, Dimension dimension2) {
        return new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
    }

    public Dimension setBreadth(Dimension dimension, int n) {
        return new Dimension(n, (int)dimension.getHeight());
    }

    public Dimension setBreadth(Dimension dimension, Dimension dimension2) {
        return new Dimension((int)dimension2.getWidth(), (int)dimension.getHeight());
    }

    public Point setPosition(Point point, int n) {
        return new Point((int)point.getX(), n);
    }

    public Cursor getCursor() {
        return new Cursor(8);
    }

    public ArrowButton getStartArrowButton() {
        return new ArrowButton(1, (Border)null);
    }

    public ArrowButton getEndArrowButton() {
        return new ArrowButton(5, (Border)null);
    }
}

