/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import tudresden.ocl.OclTree;
import tudresden.ocl.OnlyNameFinder;
import tudresden.ocl.check.NameBoundQueryable;
import tudresden.ocl.check.NodeEnvironmentMap;
import tudresden.ocl.check.NodeTypeMap;
import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.check.TypeEnvironment;
import tudresden.ocl.check.TypeQueryable;
import tudresden.ocl.check.types.Any;
import tudresden.ocl.check.types.Basic;
import tudresden.ocl.check.types.Collection;
import tudresden.ocl.check.types.OclState;
import tudresden.ocl.check.types.OclType;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.check.types.Type2;
import tudresden.ocl.check.types.TypeFactory;
import tudresden.ocl.parser.OclParserException;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AActualParameterList;
import tudresden.ocl.parser.node.AActualParameterListTail;
import tudresden.ocl.parser.node.AAdditiveExpression;
import tudresden.ocl.parser.node.AAdditiveExpressionTail;
import tudresden.ocl.parser.node.AArrowPostfixExpressionTailBegin;
import tudresden.ocl.parser.node.ABagCollectionKind;
import tudresden.ocl.parser.node.ABooleanLiteral;
import tudresden.ocl.parser.node.AClassifierContext;
import tudresden.ocl.parser.node.AClassifierContextBody;
import tudresden.ocl.parser.node.ACollectionTypeName;
import tudresden.ocl.parser.node.AConstraint;
import tudresden.ocl.parser.node.AConstraintBody;
import tudresden.ocl.parser.node.AContextDeclaration;
import tudresden.ocl.parser.node.ADeclaratorTail;
import tudresden.ocl.parser.node.ADeclaratorTypeDeclaration;
import tudresden.ocl.parser.node.ADotPostfixExpressionTailBegin;
import tudresden.ocl.parser.node.AEnumLiteral;
import tudresden.ocl.parser.node.AEqualRelationalOperator;
import tudresden.ocl.parser.node.AExpression;
import tudresden.ocl.parser.node.AExpressionListOrRange;
import tudresden.ocl.parser.node.AExpressionListTail;
import tudresden.ocl.parser.node.AFeatureCall;
import tudresden.ocl.parser.node.AFeatureCallParameters;
import tudresden.ocl.parser.node.AFeaturePrimaryExpression;
import tudresden.ocl.parser.node.AFormalParameter;
import tudresden.ocl.parser.node.AFormalParameterList;
import tudresden.ocl.parser.node.AFormalParameterListTail;
import tudresden.ocl.parser.node.AGtRelationalOperator;
import tudresden.ocl.parser.node.AGteqRelationalOperator;
import tudresden.ocl.parser.node.AIfExpression;
import tudresden.ocl.parser.node.AIfPrimaryExpression;
import tudresden.ocl.parser.node.AIntegerLiteral;
import tudresden.ocl.parser.node.AIterateDeclarator;
import tudresden.ocl.parser.node.ALetExpression;
import tudresden.ocl.parser.node.ALetExpressionTypeDeclaration;
import tudresden.ocl.parser.node.AListExpressionListOrRangeTail;
import tudresden.ocl.parser.node.ALitColPrimaryExpression;
import tudresden.ocl.parser.node.ALiteralCollection;
import tudresden.ocl.parser.node.ALiteralPrimaryExpression;
import tudresden.ocl.parser.node.ALogicalExpression;
import tudresden.ocl.parser.node.ALogicalExpressionTail;
import tudresden.ocl.parser.node.ALtRelationalOperator;
import tudresden.ocl.parser.node.ALteqRelationalOperator;
import tudresden.ocl.parser.node.AMinusUnaryOperator;
import tudresden.ocl.parser.node.AMultMultiplyOperator;
import tudresden.ocl.parser.node.AMultiplicativeExpression;
import tudresden.ocl.parser.node.AMultiplicativeExpressionTail;
import tudresden.ocl.parser.node.ANEqualRelationalOperator;
import tudresden.ocl.parser.node.ANonCollectionTypeName;
import tudresden.ocl.parser.node.AOperationContext;
import tudresden.ocl.parser.node.AOperationContextBody;
import tudresden.ocl.parser.node.AParenthesesPrimaryExpression;
import tudresden.ocl.parser.node.APathName;
import tudresden.ocl.parser.node.APathNameTail;
import tudresden.ocl.parser.node.APathSimpleTypeSpecifier;
import tudresden.ocl.parser.node.APathTypeName;
import tudresden.ocl.parser.node.APlusAddOperator;
import tudresden.ocl.parser.node.APostfixExpression;
import tudresden.ocl.parser.node.APostfixExpressionTail;
import tudresden.ocl.parser.node.APostfixUnaryExpression;
import tudresden.ocl.parser.node.AQualifiers;
import tudresden.ocl.parser.node.ARangeExpressionListOrRangeTail;
import tudresden.ocl.parser.node.ARealLiteral;
import tudresden.ocl.parser.node.ARelationalExpression;
import tudresden.ocl.parser.node.ARelationalExpressionTail;
import tudresden.ocl.parser.node.AReturnTypeDeclaration;
import tudresden.ocl.parser.node.ASequenceCollectionKind;
import tudresden.ocl.parser.node.ASetCollectionKind;
import tudresden.ocl.parser.node.AStandardDeclarator;
import tudresden.ocl.parser.node.AStringLiteral;
import tudresden.ocl.parser.node.ATypeNamePathNameBegin;
import tudresden.ocl.parser.node.ATypeNamePathNameEnd;
import tudresden.ocl.parser.node.AUnaryUnaryExpression;
import tudresden.ocl.parser.node.Node;
import tudresden.ocl.parser.node.PContextBody;
import tudresden.ocl.parser.node.PExpression;
import tudresden.ocl.parser.node.PExpressionListOrRange;
import tudresden.ocl.parser.node.PExpressionListOrRangeTail;
import tudresden.ocl.parser.node.PFormalParameter;
import tudresden.ocl.parser.node.PPathNameBegin;
import tudresden.ocl.parser.node.PPathNameEnd;
import tudresden.ocl.parser.node.PPostfixExpressionTailBegin;
import tudresden.ocl.parser.node.PPrimaryExpression;
import tudresden.ocl.parser.node.PQualifiers;
import tudresden.ocl.parser.node.PRelationalOperator;
import tudresden.ocl.parser.node.PUnaryOperator;
import tudresden.ocl.parser.node.Start;

public class TypeChecker
extends DepthFirstAdapter
implements NameBoundQueryable,
TypeQueryable {
    NodeTypeMap ntm;
    TypeFactory types;
    NodeEnvironmentMap environs;
    HashMap defaultContexts;
    OclTree tree;
    public static HashSet setOfIteratingMethodNames = new HashSet();

    public TypeChecker(OclTree tree, TypeFactory tf) {
        this.types = tf;
        this.tree = tree;
    }

    public void inStart(Start s) {
        this.ntm = new NodeTypeMap();
        this.defaultContexts = new HashMap();
        this.environs = new NodeEnvironmentMap();
    }

    public void inAConstraint(AConstraint c) {
        Type constrainedType;
        TypeEnvironment env = this.getEnvironmentCopy(c);
        PContextBody cb = ((AContextDeclaration)c.getContextDeclaration()).getContextBody();
        String constrainedName = null;
        if (cb instanceof AClassifierContextBody) {
            AClassifierContext cc = (AClassifierContext)((AClassifierContextBody)cb).getClassifierContext();
            String constrainedTypeName = cc.getPathTypeName().toString().trim();
            constrainedType = this.types.get(constrainedTypeName);
            if (cc.getClassifierHead() != null) {
                constrainedName = cc.getClassifierHead().toString().replace(':', ' ').trim();
            }
        } else {
            Type[] operationParameters;
            AOperationContext oc = (AOperationContext)((AOperationContextBody)cb).getOperationContext();
            String constrainedTypeName = oc.getPathTypeName().toString().trim();
            String constrainedOperationName = oc.getName().toString().trim();
            LinkedList<PFormalParameter> formalParams = new LinkedList<PFormalParameter>();
            if (oc.getFormalParameterList() != null) {
                AFormalParameterList fpl = (AFormalParameterList)oc.getFormalParameterList();
                formalParams.add(fpl.getFormalParameter());
                Iterator iter = fpl.getFormalParameterListTail().iterator();
                int numberOfParameters = 1;
                while (iter.hasNext()) {
                    formalParams.add(((AFormalParameterListTail)iter.next()).getFormalParameter());
                    ++numberOfParameters;
                }
                operationParameters = new Type[numberOfParameters];
                iter = formalParams.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    Type paramType;
                    AFormalParameter nextParam = (AFormalParameter)iter.next();
                    String paramName = nextParam.getName().toString().trim();
                    String paramTypeName = nextParam.getPathTypeName().toString().trim();
                    operationParameters[index] = paramType = this.types.get(paramTypeName);
                    env.put(paramName, paramType);
                    ++index;
                }
            } else {
                operationParameters = new Type[]{};
            }
            constrainedType = this.types.get(constrainedTypeName);
            Type constrainedOperationType = constrainedType.navigateParameterized(constrainedOperationName, operationParameters);
            if (oc.getReturnTypeDeclaration() != null) {
                AReturnTypeDeclaration rtd = (AReturnTypeDeclaration)oc.getReturnTypeDeclaration();
                String returnTypeName = rtd.getPathTypeName().toString().trim();
                Type returnType = this.types.get(returnTypeName);
                this.types.assertTrue(returnType, constrainedOperationType, c);
            }
            env.put("result", constrainedOperationType);
        }
        if (constrainedName == null) {
            constrainedName = "self";
        }
        env.put(constrainedName, constrainedType);
        this.environs.put(c, env);
        this.defaultContexts.put(c, constrainedName);
    }

    public void outAConstraintBody(AConstraintBody cb) {
        this.types.assertTrue(this.ntm.get(cb.getExpression()), this.types.getBoolean(), cb.getExpression());
    }

    public void caseAExpression(AExpression e) {
        LinkedList lets = e.getLetExpression();
        if (!lets.isEmpty()) {
            Iterator iter = lets.iterator();
            Iterator iter2 = lets.iterator();
            iter2.next();
            while (iter.hasNext()) {
                Type formalType;
                ALetExpression nextLet = (ALetExpression)iter.next();
                nextLet.apply(this);
                Node update = iter2.hasNext() ? (ALetExpression)iter2.next() : ((AExpression)nextLet.parent()).getLogicalExpression();
                TypeEnvironment updateEnv = this.getEnvironmentCopy(update);
                nextLet.getExpression().apply(this);
                String name = nextLet.getName().toString().trim();
                Type exprType = this.ntm.get(nextLet.getExpression());
                if (nextLet.getLetExpressionTypeDeclaration() != null) {
                    ALetExpressionTypeDeclaration letd = (ALetExpressionTypeDeclaration)nextLet.getLetExpressionTypeDeclaration();
                    formalType = ((OclType)this.ntm.get(letd.getPathTypeName())).getType();
                    this.types.assertTrue(exprType, formalType, nextLet);
                } else {
                    formalType = exprType;
                }
                updateEnv.put(name, formalType);
                this.environs.put(update, updateEnv);
            }
        }
        e.getLogicalExpression().apply(this);
        this.ntm.put(e, this.ntm.get(e.getLogicalExpression()));
    }

    public void outAIfExpression(AIfExpression ie) {
        Type typeIf = this.ntm.get(ie.getIfBranch());
        Type typeThen = this.ntm.get(ie.getThenBranch());
        Type typeElse = this.ntm.get(ie.getElseBranch());
        this.types.assertTrue(typeIf, this.types.getBoolean(), ie);
        if (this.types.conforms(typeThen, typeElse)) {
            this.ntm.put(ie, typeElse);
        } else if (this.types.conforms(typeElse, typeThen)) {
            this.ntm.put(ie, typeThen);
        } else {
            throw new OclTypeException("non-conformant then- and else-branches in " + ie);
        }
    }

    public void outALogicalExpression(ALogicalExpression le) {
        if (!le.getLogicalExpressionTail().isEmpty()) {
            this.types.assertTrue(this.ntm.get(le.getRelationalExpression()), this.types.getBoolean(), le);
            Iterator iter = le.getLogicalExpressionTail().iterator();
            while (iter.hasNext()) {
                ALogicalExpressionTail logTail = (ALogicalExpressionTail)iter.next();
                this.types.assertTrue(this.ntm.get(logTail.getRelationalExpression()), this.types.getBoolean(), logTail);
            }
            this.ntm.put(le, this.types.getBoolean());
        } else {
            this.ntm.put(le, this.ntm.get(le.getRelationalExpression()));
        }
    }

    public void outARelationalExpression(ARelationalExpression re) {
        if (re.getRelationalExpressionTail() == null) {
            this.ntm.put(re, this.ntm.get(re.getAdditiveExpression()));
        } else {
            AAdditiveExpression leftOperand = (AAdditiveExpression)re.getAdditiveExpression();
            AAdditiveExpression rightOperand = (AAdditiveExpression)((ARelationalExpressionTail)re.getRelationalExpressionTail()).getAdditiveExpression();
            PRelationalOperator operator = ((ARelationalExpressionTail)re.getRelationalExpressionTail()).getRelationalOperator();
            if (operator instanceof AEqualRelationalOperator || operator instanceof ANEqualRelationalOperator) {
                if (this.ntm.get(leftOperand) instanceof Collection != this.ntm.get(rightOperand) instanceof Collection) {
                    throw new OclTypeException("the operators \"=\" and \"<>\" can not be used to compare elements and collections, as in \"" + re.toString() + "\"");
                }
                this.ntm.put(re, this.types.getBoolean());
            } else if (operator instanceof AGtRelationalOperator || operator instanceof ALtRelationalOperator || operator instanceof AGteqRelationalOperator || operator instanceof ALteqRelationalOperator) {
                this.types.assertTrue(this.ntm.get(leftOperand), this.types.getReal(), re);
                this.types.assertTrue(this.ntm.get(rightOperand), this.types.getReal(), re);
                this.ntm.put(re, this.types.getBoolean());
            }
        }
    }

    public void caseAAdditiveExpression(AAdditiveExpression ae) {
        ae.getMultiplicativeExpression().apply(this);
        LinkedList tail = ae.getAdditiveExpressionTail();
        Type firstOperandType = this.ntm.get(ae.getMultiplicativeExpression());
        if (tail.isEmpty()) {
            this.ntm.put(ae, firstOperandType);
        } else {
            boolean firstOperandIsSet = this.types.conforms(firstOperandType, this.types.getSet());
            boolean allOperandsAreInteger = this.types.conforms(firstOperandType, this.types.getInteger());
            if (!firstOperandIsSet && !allOperandsAreInteger) {
                this.types.assertTrue(firstOperandType, this.types.getReal(), ae);
            }
            Iterator iter = tail.iterator();
            while (iter.hasNext()) {
                AAdditiveExpressionTail next = (AAdditiveExpressionTail)iter.next();
                AMultiplicativeExpression nextOperand = (AMultiplicativeExpression)next.getMultiplicativeExpression();
                if (firstOperandIsSet) {
                    if (next.getAddOperator() instanceof APlusAddOperator) {
                        this.types.assertTrue(firstOperandType, this.types.getReal(), ae);
                    }
                    nextOperand.apply(this);
                    this.types.assertTrue(this.ntm.get(nextOperand), firstOperandType, ae);
                    continue;
                }
                nextOperand.apply(this);
                Type nextOperandType = this.ntm.get(nextOperand);
                this.types.assertTrue(nextOperandType, this.types.getReal(), ae);
                if (!allOperandsAreInteger) continue;
                allOperandsAreInteger = this.types.conforms(nextOperandType, this.types.getInteger());
            }
            if (allOperandsAreInteger) {
                this.ntm.put(ae, this.types.getInteger());
            } else if (firstOperandIsSet) {
                this.ntm.put(ae, firstOperandType);
            } else {
                this.ntm.put(ae, this.types.getReal());
            }
        }
    }

    public void outAMultiplicativeExpression(AMultiplicativeExpression me) {
        LinkedList tail = me.getMultiplicativeExpressionTail();
        if (tail.isEmpty()) {
            this.ntm.put(me, this.ntm.get(me.getUnaryExpression()));
        } else {
            this.types.assertTrue(this.ntm.get(me.getUnaryExpression()), this.types.getReal(), me);
            boolean resultIsInteger = this.types.conforms(this.ntm.get(me.getUnaryExpression()), this.types.getInteger());
            Iterator iter = tail.iterator();
            while (iter.hasNext()) {
                AMultiplicativeExpressionTail next = (AMultiplicativeExpressionTail)iter.next();
                this.types.assertTrue(this.ntm.get(next.getUnaryExpression()), this.types.getReal(), next);
                if (!resultIsInteger) continue;
                boolean bl = resultIsInteger = next.getMultiplyOperator() instanceof AMultMultiplyOperator && this.types.conforms(this.ntm.get(next.getUnaryExpression()), this.types.getReal());
            }
            if (resultIsInteger) {
                this.ntm.put(me, this.types.getInteger());
            } else {
                this.ntm.put(me, this.types.getReal());
            }
        }
    }

    public void outAPostfixUnaryExpression(APostfixUnaryExpression ue) {
        this.ntm.put(ue, this.ntm.get(ue.getPostfixExpression()));
    }

    public void outAUnaryUnaryExpression(AUnaryUnaryExpression ue) {
        PUnaryOperator uop = ue.getUnaryOperator();
        Type operandType = this.ntm.get(ue.getPostfixExpression());
        if (uop instanceof AMinusUnaryOperator) {
            this.types.assertTrue(operandType, this.types.getReal(), ue);
        } else {
            this.types.assertTrue(operandType, this.types.getBoolean(), ue);
        }
        this.ntm.put(ue, operandType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void caseAPostfixExpression(APostfixExpression poex) {
        Type prexType;
        PPrimaryExpression prex = poex.getPrimaryExpression();
        prex.apply(this);
        Type navigation = prexType = this.ntm.get(prex);
        Iterator iter = poex.getPostfixExpressionTail().iterator();
        while (iter.hasNext()) {
            boolean isStateMachineAccess;
            APostfixExpressionTail next = (APostfixExpressionTail)iter.next();
            PPostfixExpressionTailBegin begin = next.getPostfixExpressionTailBegin();
            AFeatureCall fcall = (AFeatureCall)next.getFeatureCall();
            String pathName = fcall.getPathName().toString().trim();
            boolean bl = isStateMachineAccess = pathName.equals("oclInState") && begin instanceof ADotPostfixExpressionTailBegin && !(navigation instanceof Collection) && fcall.getFeatureCallParameters() != null && ((AFeatureCallParameters)fcall.getFeatureCallParameters()).getActualParameterList() != null && ((AActualParameterList)((AFeatureCallParameters)fcall.getFeatureCallParameters()).getActualParameterList()).getActualParameterListTail().isEmpty();
            if (!isStateMachineAccess) {
                fcall.apply(this);
            }
            if (fcall.getFeatureCallParameters() == null) {
                if (this.types.conforms(navigation, this.types.getCollection()) && begin instanceof ADotPostfixExpressionTailBegin) {
                    Collection oldColl = (Collection)navigation;
                    this.assertElementType(oldColl, "postfix expression \"" + poex.toString() + "\"");
                    navigation = this.navigateCollect(oldColl, oldColl.getElementType().navigateQualified(pathName, this.getQualifierTypes(fcall.getQualifiers())));
                } else {
                    navigation = !this.types.conforms(navigation, this.types.getCollection()) && begin instanceof AArrowPostfixExpressionTailBegin ? new Collection(47, navigation).navigateQualified(pathName, this.getQualifierTypes(fcall.getQualifiers())) : navigation.navigateQualified(pathName, this.getQualifierTypes(fcall.getQualifiers()));
                }
            } else {
                AFeatureCallParameters fcp = (AFeatureCallParameters)fcall.getFeatureCallParameters();
                if (fcp.getDeclarator() != null) {
                    fcp.getDeclarator().apply(this);
                }
                AActualParameterList apl = (AActualParameterList)fcp.getActualParameterList();
                ArrayList paramTypes = new ArrayList();
                if (apl != null && !isStateMachineAccess) {
                    this.addParamTypesToList(apl, paramTypes, true);
                }
                if (begin instanceof AArrowPostfixExpressionTailBegin) {
                    if (!this.types.conforms(navigation, this.types.getCollection())) {
                        navigation = new Collection(47, navigation);
                    }
                    if (pathName.equals("collect")) {
                        this.types.assertTrue(navigation, this.types.getCollection(), poex);
                        navigation = navigation.navigateParameterized(pathName, paramTypes.toArray(new Type[paramTypes.size()]));
                    } else {
                        navigation = pathName.equals("iterate") ? this.ntm.get(fcall) : (navigation instanceof Type2 ? ((Type2)navigation).navigateParameterizedQuery(pathName, paramTypes.toArray(new Type[paramTypes.size()])) : navigation.navigateParameterized(pathName, paramTypes.toArray(new Type[paramTypes.size()])));
                    }
                } else if (this.types.conforms(navigation, this.types.getCollection())) {
                    Collection oldColl = (Collection)navigation;
                    this.assertElementType(oldColl, "postfix expression \"" + poex.toString() + "\"");
                    navigation = this.navigateCollect(oldColl, oldColl.getElementType().navigateParameterized(pathName, paramTypes.toArray(new Type[paramTypes.size()])));
                } else if (isStateMachineAccess) {
                    OnlyNameFinder onf = new OnlyNameFinder(true);
                    apl.getExpression().apply(onf);
                    String stateName = onf.getPathName().toString().trim();
                    if (!navigation.hasState(stateName)) throw new OclTypeException("" + navigation + " has no state \"" + stateName + "\"");
                    this.ntm.put(apl.getExpression(), new OclState());
                    navigation = Basic.BOOLEAN;
                } else {
                    navigation = navigation instanceof Type2 ? ((Type2)navigation).navigateParameterizedQuery(pathName, paramTypes.toArray(new Type[paramTypes.size()])) : navigation.navigateParameterized(pathName, paramTypes.toArray(new Type[paramTypes.size()]));
                }
            }
            this.ntm.put(next, navigation);
        }
        this.ntm.put(poex, navigation);
    }

    protected Collection navigateCollect(Collection oldCollection, Type paramType) {
        int newColKind = oldCollection.getCollectionKind();
        if (newColKind == 47) {
            newColKind = 97;
        }
        if (paramType instanceof Collection) {
            paramType = ((Collection)paramType).getElementType();
        }
        return new Collection(newColKind, paramType);
    }

    public void inAFeatureCall(AFeatureCall fc) {
        APostfixExpressionTail pet = (APostfixExpressionTail)fc.parent();
        String pathName = fc.getPathName().toString().trim();
        if (pet.getPostfixExpressionTailBegin() instanceof AArrowPostfixExpressionTailBegin && (setOfIteratingMethodNames.contains(pathName) || pathName.equals("iterate"))) {
            this.inIteratingFeatureCall(fc);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void inIteratingFeatureCall(AFeatureCall fc) {
        void var4_10;
        void var4_8;
        ArrayList<String> iteratorNames = new ArrayList<String>();
        TypeEnvironment env = this.getEnvironmentCopy(fc.getFeatureCallParameters());
        Object var4_4 = null;
        if (setOfIteratingMethodNames.contains(fc.getPathName().toString().trim())) {
            String iteratorName;
            AFeatureCallParameters afcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
            if (afcp == null) {
                throw new OclParserException("iterating method without FeatureCallParameters: " + fc.toString());
            }
            if (afcp.getDeclarator() != null) {
                if (!(afcp.getDeclarator() instanceof AStandardDeclarator)) throw new OclParserException("iterating method with wrong Declarator type: " + fc.toString());
                AStandardDeclarator asd = (AStandardDeclarator)afcp.getDeclarator();
                if (asd.getDeclaratorTypeDeclaration() != null) {
                    asd.getDeclaratorTypeDeclaration().apply(this);
                    Type type = ((OclType)this.ntm.get(((ADeclaratorTypeDeclaration)asd.getDeclaratorTypeDeclaration()).getSimpleTypeSpecifier())).getType();
                }
                if (asd.getDeclaratorTail() == null || asd.getDeclaratorTail().isEmpty()) {
                    iteratorName = asd.getName().toString().trim();
                    iteratorNames.add(iteratorName);
                } else {
                    iteratorName = null;
                    this.addIteratorNamesToList(asd, iteratorNames);
                }
            } else {
                iteratorName = this.tree.getNameCreator().getUniqueName("ImplicitIterator");
                iteratorNames.add(iteratorName);
            }
            this.defaultContexts.put(fc.getFeatureCallParameters(), iteratorName);
        } else if (fc.getPathName().toString().trim().equals("iterate")) {
            AFeatureCallParameters afcp = (AFeatureCallParameters)fc.getFeatureCallParameters();
            if (!(afcp.getDeclarator() instanceof AIterateDeclarator)) throw new OclParserException("call to \"iterate\" with wrong Declarator type: " + fc.toString());
            AIterateDeclarator decl = (AIterateDeclarator)afcp.getDeclarator();
            String iterator = decl.getIterator().toString().trim();
            iteratorNames.add(iterator);
            String accumulator = decl.getAccumulator().toString().trim();
            decl.getIterType().apply(this);
            decl.getAccType().apply(this);
            decl.getExpression().apply(this);
            Type type = ((OclType)this.ntm.get(((ADeclaratorTypeDeclaration)decl.getIterType()).getSimpleTypeSpecifier())).getType();
            Type accType = ((OclType)this.ntm.get(((ADeclaratorTypeDeclaration)decl.getAccType()).getSimpleTypeSpecifier())).getType();
            env.put(accumulator, accType);
            this.ntm.put(fc, accType);
        }
        Type toppee = this.computeTypeOfPreviousPostfixExpressionElement(fc);
        this.types.assertTrue(toppee, this.types.getCollection(), fc.parent());
        Collection coll = (Collection)toppee;
        if (var4_8 == null) {
            Any any = coll.getElementType();
        } else if (coll.getElementType() != null && !var4_8.equals(coll.getElementType())) {
            throw new OclTypeException("iterator type (" + var4_8 + ") does not match collection element type (" + coll.getElementType() + ")");
        }
        if (var4_10 == null) {
            throw new OclTypeException("cannot find out iterator type in feature call \"" + fc.toString() + "\"" + "(collection element type not set)");
        }
        Iterator iterators = ((AbstractList)iteratorNames).iterator();
        while (iterators.hasNext()) {
            env.put((String)iterators.next(), (Type)var4_10);
        }
        this.environs.put(fc.getFeatureCallParameters(), env);
    }

    protected Type computeTypeOfPreviousPostfixExpressionElement(AFeatureCall fc) {
        Type typeOfPreviousPEElement;
        APostfixExpressionTail pet = (APostfixExpressionTail)fc.parent();
        APostfixExpression pe = (APostfixExpression)pet.parent();
        if (pe.getPostfixExpressionTail().getFirst() == pet) {
            typeOfPreviousPEElement = this.ntm.get(pe.getPrimaryExpression());
        } else {
            Object next;
            ListIterator lIter = pe.getPostfixExpressionTail().listIterator();
            Object prevTailElem = null;
            while ((next = lIter.next()) != pet) {
                prevTailElem = next;
            }
            APostfixExpressionTail prev = prevTailElem;
            typeOfPreviousPEElement = this.ntm.get(prev);
        }
        return typeOfPreviousPEElement;
    }

    protected Type[] getQualifierTypes(PQualifiers qual) {
        if (qual == null) {
            return null;
        }
        AActualParameterList apl = (AActualParameterList)((AQualifiers)qual).getActualParameterList();
        LinkedList tail = apl.getActualParameterListTail();
        int size = 1 + tail.size();
        Type[] result = new Type[size];
        result[0] = this.ntm.get(apl.getExpression());
        int i = 1;
        Iterator iter = tail.iterator();
        while (iter.hasNext()) {
            AActualParameterListTail next = (AActualParameterListTail)iter.next();
            result[i] = this.ntm.get(next.getExpression());
            ++i;
        }
        return result;
    }

    protected void addIteratorNamesToList(AStandardDeclarator asd, ArrayList names) {
        names.add(asd.getName().toString().trim());
        Iterator iter = asd.getDeclaratorTail().iterator();
        while (iter.hasNext()) {
            ADeclaratorTail dt = (ADeclaratorTail)iter.next();
            names.add(dt.getName().toString().trim());
        }
    }

    public void outALitColPrimaryExpression(ALitColPrimaryExpression lce) {
        this.ntm.put(lce, this.ntm.get(lce.getLiteralCollection()));
    }

    public void outALiteralPrimaryExpression(ALiteralPrimaryExpression lpe) {
        this.ntm.put(lpe, this.ntm.get(lpe.getLiteral()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void caseAFeaturePrimaryExpression(AFeaturePrimaryExpression fpe) {
        Type pnType;
        boolean isStateMachineAccess;
        boolean bl = isStateMachineAccess = fpe.getPathName().toString().trim().equals("oclInState") && fpe.getFeatureCallParameters() != null && ((AFeatureCallParameters)fpe.getFeatureCallParameters()).getActualParameterList() != null && ((AActualParameterList)((AFeatureCallParameters)fpe.getFeatureCallParameters()).getActualParameterList()).getActualParameterListTail().isEmpty();
        if (!isStateMachineAccess) {
            super.caseAFeaturePrimaryExpression(fpe);
        }
        if ((pnType = this.getTypeOfPathName((APathName)fpe.getPathName(), fpe)) != null) {
            this.ntm.put(fpe, pnType);
            return;
        } else {
            String text = fpe.getPathName().toString().trim();
            if (this.isNameBound(text, fpe) && fpe.getFeatureCallParameters() == null) {
                TypeEnvironment tenv = this.getEnvironmentFor(fpe);
                this.ntm.put(fpe, tenv.get(text));
                return;
            } else {
                Type start = this.getEnvironmentFor(fpe).get(this.getDefaultContext(fpe));
                if (fpe.getFeatureCallParameters() == null) {
                    if (start == null) {
                        throw new OclTypeException("names must be qualified explicitly in postfix expression \"" + fpe.parent().toString() + "\", but \"" + text + "\" is no bound name");
                    }
                    this.ntm.put(fpe, start.navigateQualified(text, this.getQualifierTypes(fpe.getQualifiers())));
                    return;
                } else {
                    AFeatureCallParameters params = (AFeatureCallParameters)fpe.getFeatureCallParameters();
                    ArrayList list = new ArrayList();
                    if (params.getActualParameterList() != null && !isStateMachineAccess) {
                        this.addParamTypesToList((AActualParameterList)params.getActualParameterList(), list, false);
                    }
                    if (isStateMachineAccess) {
                        PExpression stateExpr = ((AActualParameterList)params.getActualParameterList()).getExpression();
                        OnlyNameFinder onf = new OnlyNameFinder(true);
                        stateExpr.apply(onf);
                        String stateName = onf.getPathName().toString().trim();
                        if (!start.hasState(stateName)) throw new OclTypeException("" + start + " has no state \"" + stateName + "\"");
                        this.ntm.put(stateExpr, new OclState());
                        this.ntm.put(fpe, Basic.BOOLEAN);
                        return;
                    } else {
                        this.ntm.put(fpe, start instanceof Type2 ? ((Type2)start).navigateParameterizedQuery(text, list.toArray(new Type[list.size()])) : start.navigateParameterized(text, list.toArray(new Type[list.size()])));
                    }
                }
            }
        }
    }

    protected Type getTypeOfPathName(APathName pn, AFeaturePrimaryExpression fpe) {
        Type result;
        LinkedList tail = pn.getPathNameTail();
        PPathNameBegin begin = pn.getPathNameBegin();
        if (tail.isEmpty()) {
            if (begin instanceof ATypeNamePathNameBegin) {
                return this.ntm.get(begin);
            }
            return null;
        }
        PPathNameEnd lastTailElem = ((APathNameTail)tail.getLast()).getPathNameEnd();
        if (lastTailElem instanceof ATypeNamePathNameEnd) {
            APathName pathName = pn;
            return new OclType(this.types.get(this.getFullPath(pn)));
        }
        String complete = pn.toString().trim();
        int divide = complete.lastIndexOf("::");
        String typeName = complete.substring(0, divide).trim();
        String memberName = complete.substring(divide + 2).trim();
        Type type = this.types.get(typeName);
        if (fpe.getFeatureCallParameters() == null) {
            result = type.navigateQualified(memberName, this.getQualifierTypes(fpe.getQualifiers()));
        } else {
            AFeatureCallParameters params = (AFeatureCallParameters)fpe.getFeatureCallParameters();
            ArrayList list = new ArrayList();
            if (params.getActualParameterList() != null) {
                this.addParamTypesToList((AActualParameterList)params.getActualParameterList(), list, false);
            }
            result = type instanceof Type2 ? ((Type2)type).navigateParameterizedQuery(memberName, list.toArray(new Type[list.size()])) : type.navigateParameterized(memberName, list.toArray(new Type[list.size()]));
        }
        return result;
    }

    public void outAParenthesesPrimaryExpression(AParenthesesPrimaryExpression ppe) {
        this.ntm.put(ppe, this.ntm.get(ppe.getExpression()));
    }

    public void outAIfPrimaryExpression(AIfPrimaryExpression ipe) {
        this.ntm.put(ipe, this.ntm.get(ipe.getIfExpression()));
    }

    public void outAStringLiteral(AStringLiteral sl) {
        this.ntm.put(sl, this.types.getString());
    }

    public void outARealLiteral(ARealLiteral rl) {
        this.ntm.put(rl, this.types.getReal());
    }

    public void outAIntegerLiteral(AIntegerLiteral il) {
        this.ntm.put(il, this.types.getInteger());
    }

    public void outABooleanLiteral(ABooleanLiteral bl) {
        this.ntm.put(bl, this.types.getBoolean());
    }

    public void outAEnumLiteral(AEnumLiteral el) {
        this.ntm.put(el, this.types.getEnumerationElement());
    }

    public void outALiteralCollection(ALiteralCollection lc) {
        Type col;
        if (lc.getExpressionListOrRange() == null) {
            col = lc.getCollectionKind() instanceof ASetCollectionKind ? this.types.getSet() : (lc.getCollectionKind() instanceof ABagCollectionKind ? this.types.getBag() : (lc.getCollectionKind() instanceof ASequenceCollectionKind ? this.types.getSequence() : this.types.getCollection()));
        } else {
            PExpressionListOrRange exor = lc.getExpressionListOrRange();
            Type param = this.ntm.get(exor);
            col = lc.getCollectionKind() instanceof ASetCollectionKind ? this.types.getSet(param) : (lc.getCollectionKind() instanceof ABagCollectionKind ? this.types.getBag(param) : (lc.getCollectionKind() instanceof ASequenceCollectionKind ? this.types.getSequence(param) : this.types.getCollection(param)));
        }
        this.ntm.put(lc, col);
    }

    public void outAExpressionListOrRange(AExpressionListOrRange elor) {
        Type firstType = this.ntm.get(elor.getExpression());
        if (elor.getExpressionListOrRangeTail() != null) {
            PExpressionListOrRangeTail tail = elor.getExpressionListOrRangeTail();
            if (tail instanceof AListExpressionListOrRangeTail) {
                AListExpressionListOrRangeTail listTail = (AListExpressionListOrRangeTail)tail;
                Iterator iter = listTail.getExpressionListTail().iterator();
                while (iter.hasNext()) {
                    AExpressionListTail elt = (AExpressionListTail)iter.next();
                    this.types.assertTrue(this.ntm.get(elt.getExpression()), firstType, elt);
                }
            } else {
                ARangeExpressionListOrRangeTail rangeTail = (ARangeExpressionListOrRangeTail)tail;
                this.types.assertTrue(firstType, this.types.getInteger(), rangeTail);
                this.types.assertTrue(this.ntm.get(rangeTail.getExpression()), this.types.getInteger(), rangeTail);
            }
        }
        this.ntm.put(elor, firstType);
    }

    public void outAPathSimpleTypeSpecifier(APathSimpleTypeSpecifier psts) {
        this.ntm.put(psts, this.ntm.get(psts.getPathTypeName()));
    }

    public void outAPathTypeName(APathTypeName ptn) {
        this.ntm.put(ptn, this.ntm.get(ptn.getTypeName()));
    }

    public void inACollectionTypeName(ACollectionTypeName ctn) {
        String colName = ctn.getCollectionType().toString().trim();
        String elemTypeName = ctn.getSimpleTypeName().toString().trim();
        Type elemType = this.types.get(elemTypeName);
        Type colType = colName.equals("Set") ? this.types.getSet(elemType) : (colName.equals("Bag") ? this.types.getBag(elemType) : (colName.equals("Sequence") ? this.types.getSequence(elemType) : this.types.getCollection(elemType)));
        this.ntm.put(ctn, this.types.getOclType(colType));
    }

    public void inANonCollectionTypeName(ANonCollectionTypeName nctn) {
        this.ntm.put(nctn, this.types.getOclType(this.types.get(this.getFullPath(nctn))));
    }

    public void outATypeNamePathNameBegin(ATypeNamePathNameBegin tnpnb) {
        this.ntm.put(tnpnb, this.ntm.get(tnpnb.getTypeName()));
    }

    protected TypeEnvironment getEnvironmentCopy(Node n) {
        Node parent = this.getParentEnvNode(n);
        TypeEnvironment te = this.getEnvironmentFor(parent);
        if (te == null) {
            return new TypeEnvironment();
        }
        return new TypeEnvironment(te);
    }

    protected Node getParentEnvNode(Node n) {
        Node ret = null;
        if (n instanceof ALetExpression) {
            ALetExpression let = (ALetExpression)n;
            AExpression expr = (AExpression)let.parent();
            LinkedList list = expr.getLetExpression();
            Iterator iter = list.iterator();
            if (list.getFirst() == let) {
                ret = expr;
            } else {
                Object nxt;
                while ((nxt = iter.next()) != let) {
                    ret = (ALetExpression)nxt;
                }
            }
        } else {
            ALogicalExpression log;
            LinkedList lets;
            ret = n instanceof ALogicalExpression ? ((lets = ((AExpression)(log = (ALogicalExpression)n).parent()).getLetExpression()).isEmpty() ? n.parent() : (Node)lets.getLast()) : n.parent();
        }
        return ret;
    }

    protected TypeEnvironment getEnvironmentFor(Node n) {
        Node parent = n;
        while (parent != null && !this.environs.containsKey(parent)) {
            parent = this.getParentEnvNode(parent);
        }
        return this.environs.get(parent);
    }

    protected void addParamTypesToList(AActualParameterList apl, List list, boolean recurse) {
        PExpression expr = apl.getExpression();
        expr.apply(this);
        list.add(this.ntm.get(expr));
        Iterator iter = apl.getActualParameterListTail().iterator();
        while (iter.hasNext()) {
            AActualParameterListTail next = (AActualParameterListTail)iter.next();
            expr = next.getExpression();
            expr.apply(this);
            list.add(this.ntm.get(expr));
        }
    }

    protected void assertElementType(Collection coll, String msg) {
        if (coll.getElementType() == null) {
            throw new OclTypeException("cannot find out element type of collection in " + msg);
        }
    }

    public boolean isNameBound(String name, Node node) {
        boolean result = this.getTypeFor(name, node) != null;
        return result;
    }

    public HashSet getBoundNames(Node n) {
        HashSet result = new HashSet();
        TypeEnvironment env = this.getEnvironmentFor(n);
        result.addAll(env.map.keySet());
        return result;
    }

    public String getDefaultContext(Node n) {
        Node parent = n;
        while (parent != null && !this.defaultContexts.containsKey(parent)) {
            parent = parent.parent();
        }
        String ret = (String)this.defaultContexts.get(parent);
        if (!ret.equals(ret.trim())) {
            throw new RuntimeException("untrimmed default context");
        }
        return ret;
    }

    public void changeNotify(Node n) {
        n.apply(this);
    }

    public Type getNodeType(Node n) {
        return this.ntm.get(n);
    }

    public Type getTypeFor(String name, Node node) {
        if (!name.equals(name.trim())) {
            throw new RuntimeException("untrimmed name");
        }
        TypeEnvironment env = this.getEnvironmentFor(node);
        Type ret = env.get(name);
        return ret;
    }

    private String getFullPath(Node n) {
        while (!(n instanceof APathName) && !(n instanceof APathTypeName)) {
            n = n.parent();
        }
        String fullPath = n.toString().trim();
        if (fullPath.indexOf("::") != -1) {
            String cutPath = "";
            StringTokenizer pathTokenizer = new StringTokenizer(fullPath, ":", true);
            while (pathTokenizer.hasMoreElements()) {
                String token = pathTokenizer.nextToken().trim();
                cutPath = cutPath + token;
                if (!token.equals(":") && token.substring(0, 1).toUpperCase().equals(token.substring(0, 1))) break;
            }
            fullPath = cutPath;
        }
        return fullPath;
    }

    static {
        setOfIteratingMethodNames.add("select");
        setOfIteratingMethodNames.add("collect");
        setOfIteratingMethodNames.add("reject");
        setOfIteratingMethodNames.add("forAll");
        setOfIteratingMethodNames.add("exists");
        setOfIteratingMethodNames.add("isUnique");
        setOfIteratingMethodNames.add("sortedBy");
    }
}

