/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.parser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class JEditParserMessageTables
extends JFrame {
    private ParserData m_pdParserData;
    private JToolBar m_jtbToolBar;
    private JButton m_jbSaveButton;
    private JTabbedPane m_jtpTabs;
    private JPanel m_jpErrorMapping;
    private JScrollPane m_jspErrorMap;
    private JTable m_jtErrorMap;
    private JPanel m_jpErrorMessages;
    private JScrollPane m_jspErrorMessages;
    private JTable m_jtErrorMessages;
    private JPanel m_jpErrMsgButtons;
    private JButton m_jbAddMessage;
    private JButton m_jbRemoveMessage;

    public JEditParserMessageTables() {
        this.initComponents();
        this.m_pdParserData = new ParserData();
        this.m_jtErrorMap.setModel(this.m_pdParserData.getErrMapModel());
        this.m_jtErrorMap.getColumnModel().getColumn(1).setCellEditor(this.m_pdParserData.getErrMapEditor());
        this.m_jtErrorMessages.setModel(this.m_pdParserData.getErrMsgModel());
    }

    private void initComponents() {
        this.m_jtbToolBar = new JToolBar();
        this.m_jbSaveButton = new JButton();
        this.m_jtpTabs = new JTabbedPane();
        this.m_jpErrorMapping = new JPanel();
        this.m_jspErrorMap = new JScrollPane();
        this.m_jtErrorMap = new JTable();
        this.m_jpErrorMessages = new JPanel();
        this.m_jspErrorMessages = new JScrollPane();
        this.m_jtErrorMessages = new JTable();
        this.m_jpErrMsgButtons = new JPanel();
        this.m_jbAddMessage = new JButton();
        this.m_jbRemoveMessage = new JButton();
        this.setTitle("Edit Parser Error Messages");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JEditParserMessageTables.this.exitForm(evt);
            }
        });
        this.m_jbSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/save_icon.gif")));
        this.m_jbSaveButton.setHorizontalTextPosition(0);
        this.m_jbSaveButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_jbSaveButton.setAlignmentY(0.5f);
        this.m_jbSaveButton.setAlignmentX(0.5f);
        this.m_jbSaveButton.setDefaultCapable(false);
        this.m_jbSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JEditParserMessageTables.this.onSaveButton(evt);
            }
        });
        this.m_jtbToolBar.add(this.m_jbSaveButton);
        this.getContentPane().add((Component)this.m_jtbToolBar, "North");
        this.m_jpErrorMapping.setLayout(new GridBagLayout());
        this.m_jtErrorMap.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = 4.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 4.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 4.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 4.class$("java.lang.Object")) : class$java$lang$Object};
            static /* synthetic */ Class class$java$lang$Object;

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.m_jtErrorMap.setAutoResizeMode(0);
        this.m_jspErrorMap.setViewportView(this.m_jtErrorMap);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.gridheight = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.m_jpErrorMapping.add((Component)this.m_jspErrorMap, gridBagConstraints1);
        this.m_jtpTabs.addTab("Error mappings", null, this.m_jpErrorMapping, "Maps error numbers to error messages.");
        this.m_jpErrorMessages.setLayout(new GridBagLayout());
        this.m_jtErrorMessages.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = 5.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 5.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 5.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = 5.class$("java.lang.Object")) : class$java$lang$Object};
            static /* synthetic */ Class class$java$lang$Object;

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        this.m_jtErrorMessages.setAutoResizeMode(0);
        this.m_jspErrorMessages.setViewportView(this.m_jtErrorMessages);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        this.m_jpErrorMessages.add((Component)this.m_jspErrorMessages, gridBagConstraints2);
        this.m_jpErrMsgButtons.setLayout(new FlowLayout(2, 5, 5));
        this.m_jbAddMessage.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/RowInsertAfter24.gif")));
        this.m_jbAddMessage.setText("New");
        this.m_jbAddMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JEditParserMessageTables.this.onNewErrorMessage(evt);
            }
        });
        this.m_jpErrMsgButtons.add(this.m_jbAddMessage);
        this.m_jbRemoveMessage.setIcon(new ImageIcon(this.getClass().getResource("/tudresden/ocl/images/RowDelete24.gif")));
        this.m_jbRemoveMessage.setText("Remove");
        this.m_jbRemoveMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JEditParserMessageTables.this.onRemoveErrorMessage(evt);
            }
        });
        this.m_jpErrMsgButtons.add(this.m_jbRemoveMessage);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.gridheight = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 10, 5);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.weightx = 1.0;
        this.m_jpErrorMessages.add((Component)this.m_jpErrMsgButtons, gridBagConstraints2);
        this.m_jtpTabs.addTab("Error Messages", null, this.m_jpErrorMessages, "List of error messages");
        this.getContentPane().add((Component)this.m_jtpTabs, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        ((Component)this).setSize(new Dimension(300, 200));
        ((Component)this).setLocation((screenSize.width - 300) / 2, (screenSize.height - 200) / 2);
    }

    private void onSaveButton(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Saving may corrupt your parser.dat file.\nSave anyway?", "Warning", 0, 2) == 0) {
            this.m_pdParserData.save();
        }
    }

    private void onRemoveErrorMessage(ActionEvent evt) {
        int nIdx = this.m_jtErrorMessages.getSelectedRow();
        if (nIdx != -1) {
            this.m_pdParserData.removeErrorMessage(nIdx);
        }
    }

    private void onNewErrorMessage(ActionEvent evt) {
        this.m_pdParserData.addErrorMessage();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        new JEditParserMessageTables().show();
    }

    private static class ParserData {
        private int[][][] actionTable;
        private int[][][] gotoTable;
        private String[] errorMessages;
        private int[] errors;
        private ErrMapModel m_emmErrMap = new ErrMapModel();
        private ErrMsgModel m_emmErrMsg = new ErrMsgModel();
        private ErrMsgListModel m_emlm = new ErrMsgListModel();

        public ParserData() {
            try {
                DataInputStream s = new DataInputStream(new BufferedInputStream(this.getClass().getResourceAsStream("parser/parser.dat")));
                int length = s.readInt();
                this.actionTable = new int[length][][];
                int i = 0;
                while (i < this.actionTable.length) {
                    length = s.readInt();
                    this.actionTable[i] = new int[length][3];
                    int j = 0;
                    while (j < this.actionTable[i].length) {
                        int k = 0;
                        while (k < 3) {
                            this.actionTable[i][j][k] = s.readInt();
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                length = s.readInt();
                this.gotoTable = new int[length][][];
                int i2 = 0;
                while (i2 < this.gotoTable.length) {
                    length = s.readInt();
                    this.gotoTable[i2] = new int[length][2];
                    int j = 0;
                    while (j < this.gotoTable[i2].length) {
                        int k = 0;
                        while (k < 2) {
                            this.gotoTable[i2][j][k] = s.readInt();
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                length = s.readInt();
                this.errorMessages = new String[length];
                int i3 = 0;
                while (i3 < this.errorMessages.length) {
                    length = s.readInt();
                    StringBuffer buffer = new StringBuffer();
                    int j = 0;
                    while (j < length) {
                        buffer.append(s.readChar());
                        ++j;
                    }
                    this.errorMessages[i3] = buffer.toString();
                    ++i3;
                }
                length = s.readInt();
                this.errors = new int[length];
                int i4 = 0;
                while (i4 < this.errors.length) {
                    this.errors[i4] = s.readInt();
                    ++i4;
                }
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to read parser.dat.");
            }
        }

        public void save() {
            try {
                OutputStream os = null;
                URL urlParserDat = this.getClass().getResource("parser/parser.dat");
                if (urlParserDat.getProtocol().equals("file")) {
                    os = new FileOutputStream(urlParserDat.getFile());
                } else {
                    URLConnection urlcParserDat = urlParserDat.openConnection();
                    urlcParserDat.setDoInput(false);
                    urlcParserDat.setDoOutput(true);
                    urlcParserDat.setUseCaches(false);
                    urlcParserDat.connect();
                    os = urlcParserDat.getOutputStream();
                }
                DataOutputStream s = new DataOutputStream(new BufferedOutputStream(os));
                s.writeInt(this.actionTable.length);
                int i = 0;
                while (i < this.actionTable.length) {
                    s.writeInt(this.actionTable[i].length);
                    int j = 0;
                    while (j < this.actionTable[i].length) {
                        int k = 0;
                        while (k < 3) {
                            s.writeInt(this.actionTable[i][j][k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                s.writeInt(this.gotoTable.length);
                int i2 = 0;
                while (i2 < this.gotoTable.length) {
                    s.writeInt(this.gotoTable[i2].length);
                    int j = 0;
                    while (j < this.gotoTable[i2].length) {
                        int k = 0;
                        while (k < 2) {
                            s.writeInt(this.gotoTable[i2][j][k]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
                s.writeInt(this.errorMessages.length);
                int i3 = 0;
                while (i3 < this.errorMessages.length) {
                    s.writeInt(this.errorMessages[i3].length());
                    int j = 0;
                    while (j < this.errorMessages[i3].length()) {
                        s.writeChar(this.errorMessages[i3].charAt(j));
                        ++j;
                    }
                    ++i3;
                }
                s.writeInt(this.errors.length);
                int i4 = 0;
                while (i4 < this.errors.length) {
                    s.writeInt(this.errors[i4]);
                    ++i4;
                }
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Unable to save parser.dat. File may now be corrupted!");
            }
        }

        public TableModel getErrMapModel() {
            return this.m_emmErrMap;
        }

        public TableModel getErrMsgModel() {
            return this.m_emmErrMsg;
        }

        public TableCellEditor getErrMapEditor() {
            return new DefaultCellEditor(this, new JComboBox(this.m_emlm)){
                private final /* synthetic */ ParserData this$0;
                {
                    this.this$0 = this$0;
                }

                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    JComboBox jcb = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
                    jcb.setSelectedItem(ParserData.access$100(this.this$0)[ParserData.access$000(this.this$0)[row]]);
                    return jcb;
                }
            };
        }

        public void addErrorMessage() {
            String[] newEM = new String[this.errorMessages.length + 1];
            System.arraycopy(this.errorMessages, 0, newEM, 0, this.errorMessages.length);
            newEM[this.errorMessages.length] = "<new message>";
            this.errorMessages = newEM;
            this.m_emlm.fireIntervalAdded(this.errorMessages.length - 1, this.errorMessages.length - 1);
            this.m_emmErrMsg.fireTableDataChanged();
        }

        public void removeErrorMessage(int nIdx) {
            int i = 0;
            while (i < this.errors.length) {
                if (this.errors[i] == nIdx) {
                    JOptionPane.showMessageDialog(null, "This error message is mapped for error number " + i + ".\nPlease change the mapping for that error number first.", "Error", 0);
                    return;
                }
                ++i;
            }
            String[] newEM = new String[this.errorMessages.length - 1];
            System.arraycopy(this.errorMessages, 0, newEM, 0, nIdx);
            System.arraycopy(this.errorMessages, nIdx + 1, newEM, nIdx, this.errorMessages.length - nIdx - 1);
            this.errorMessages = newEM;
            int i2 = 0;
            while (i2 < this.errors.length) {
                if (this.errors[i2] > nIdx) {
                    int n = i2;
                    this.errors[n] = this.errors[n] - 1;
                }
                ++i2;
            }
            this.m_emlm.fireIntervalRemoved(nIdx, nIdx);
            this.m_emmErrMsg.fireTableDataChanged();
        }

        private class ErrMsgListModel
        extends DefaultComboBoxModel {
            private ErrMsgListModel() {
            }

            public int getSize() {
                return ParserData.this.errorMessages.length;
            }

            public Object getElementAt(int row) {
                return ParserData.this.errorMessages[row];
            }

            public void fireContentsChanged(int index0, int index1) {
                super.fireContentsChanged(this, index0, index1);
            }

            public void fireIntervalAdded(int index0, int index1) {
                super.fireIntervalAdded(this, index0, index1);
            }

            public void fireIntervalRemoved(int index0, int index1) {
                super.fireIntervalRemoved(this, index0, index1);
            }
        }

        private class ErrMsgModel
        extends AbstractTableModel {
            static /* synthetic */ Class class$java$lang$String;

            private ErrMsgModel() {
            }

            public int getRowCount() {
                return ParserData.this.errorMessages.length;
            }

            public void setValueAt(Object oValue, int row, int col) {
                ((ParserData)ParserData.this).errorMessages[row] = oValue.toString();
                this.fireTableCellUpdated(row, col);
                ParserData.this.m_emlm.fireContentsChanged(row, row);
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }

            public int getColumnCount() {
                return 1;
            }

            public Object getValueAt(int row, int col) {
                return ParserData.this.errorMessages[row];
            }

            public Class getColumnClass(int col) {
                return class$java$lang$String == null ? (class$java$lang$String = ErrMsgModel.class$("java.lang.String")) : class$java$lang$String;
            }

            public String getColumnName(int col) {
                return "Error message";
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }

        private class ErrMapModel
        extends AbstractTableModel {
            static /* synthetic */ Class class$java$lang$Integer;
            static /* synthetic */ Class class$java$lang$String;

            private ErrMapModel() {
            }

            public int getRowCount() {
                return ParserData.this.errors.length;
            }

            public void setValueAt(Object oValue, int row, int col) {
                int i = 0;
                while (i < ParserData.this.errorMessages.length) {
                    if (ParserData.this.errorMessages[i] == oValue) {
                        ((ParserData)ParserData.this).errors[row] = i;
                        this.fireTableCellUpdated(row, col);
                        return;
                    }
                    ++i;
                }
            }

            public boolean isCellEditable(int row, int col) {
                return col == 1;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int row, int col) {
                switch (col) {
                    case 0: {
                        return new Integer(row);
                    }
                    case 1: {
                        return "(" + ParserData.this.errors[row] + "): \"" + ParserData.this.errorMessages[ParserData.this.errors[row]] + "\"";
                    }
                }
                return null;
            }

            public Class getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return class$java$lang$Integer == null ? (class$java$lang$Integer = ErrMapModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                    }
                    case 1: {
                        return class$java$lang$String == null ? (class$java$lang$String = ErrMapModel.class$("java.lang.String")) : class$java$lang$String;
                    }
                }
                return null;
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Error number";
                    }
                    case 1: {
                        return "Error message";
                    }
                }
                return null;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

