/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.Reference;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import org.apache.log4j.Logger;
import org.argouml.model.AbstractModelEventPump;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.NotImplementedException;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.model.UmlChangeEvent;
import org.argouml.model.UmlChangeListener;
import org.argouml.model.mdr.MDRModelImplementation;
import org.argouml.model.mdr.Registry;
import org.netbeans.api.mdr.MDRManager;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.InstanceEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRPreChangeListener;
import org.netbeans.api.mdr.events.TransactionEvent;
import org.netbeans.api.mdr.events.VetoChangeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelEventPumpMDRImpl
extends AbstractModelEventPump
implements MDRPreChangeListener {
    private static final Logger LOG = Logger.getLogger(ModelEventPumpMDRImpl.class);
    private static final boolean VETO_READONLY_CHANGES = true;
    private MDRModelImplementation modelImpl;
    private Object registrationMutex = new Byte[0];
    private MDRepository repository;
    private Boolean eventCountMutex = new Boolean(false);
    private int pendingEvents = 0;
    private Thread eventThread;
    private Registry<PropertyChangeListener> elements = new Registry();
    private Registry<PropertyChangeListener> listenedClasses = new Registry();
    private Map<String, Collection<String>> subtypeMap;
    private Map<String, Collection<String>> propertyNameMap;

    public ModelEventPumpMDRImpl(MDRModelImplementation implementation) {
        this(implementation, MDRManager.getDefault().getDefaultRepository());
    }

    public ModelEventPumpMDRImpl(MDRModelImplementation implementation, MDRepository repo) {
        this.modelImpl = implementation;
        this.repository = repo;
        this.subtypeMap = this.buildTypeMap(this.modelImpl.getModelPackage());
        this.propertyNameMap = this.buildPropertyNameMap(this.modelImpl.getModelPackage());
    }

    @Override
    public void addModelEventListener(PropertyChangeListener listener, Object modelElement, String[] propertyNames) {
        if (listener == null) {
            throw new IllegalArgumentException("A listener must be supplied");
        }
        if (modelElement == null) {
            throw new IllegalArgumentException("A model element must be supplied");
        }
        this.registerModelEvent(listener, modelElement, propertyNames);
    }

    @Override
    public void addModelEventListener(UmlChangeListener listener, Object modelElement, String[] propertyNames) {
        throw new NotImplementedException();
    }

    @Override
    public void addModelEventListener(PropertyChangeListener listener, Object modelElement) {
        if (listener == null) {
            throw new IllegalArgumentException("A listener must be supplied");
        }
        if (modelElement == null) {
            throw new IllegalArgumentException("A model element must be supplied");
        }
        this.registerModelEvent(listener, modelElement, null);
    }

    @Override
    public void removeModelEventListener(PropertyChangeListener listener, Object modelelement, String[] propertyNames) {
        this.unregisterModelEvent(listener, modelelement, propertyNames);
    }

    @Override
    public void removeModelEventListener(UmlChangeListener listener, Object modelelement, String[] propertyNames) {
        throw new NotImplementedException();
    }

    @Override
    public void removeModelEventListener(PropertyChangeListener listener, Object modelelement) {
        this.unregisterModelEvent(listener, modelelement, null);
    }

    @Override
    public void addClassModelEventListener(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        this.registerClassEvent(listener, modelClass, propertyNames);
    }

    @Override
    public void removeClassModelEventListener(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        this.unregisterClassEvent(listener, modelClass, propertyNames);
    }

    public void change(MDRChangeEvent mdrEvent) {
        String name;
        AttributeEvent ae;
        if (this.eventThread == null) {
            this.eventThread = Thread.currentThread();
        }
        this.decrementEvents();
        if (mdrEvent instanceof TransactionEvent) {
            return;
        }
        ArrayList<UmlChangeEvent> events = new ArrayList<UmlChangeEvent>();
        if (mdrEvent instanceof AttributeEvent) {
            ae = (AttributeEvent)mdrEvent;
            events.add(new AttributeChangeEvent(ae.getSource(), ae.getAttributeName(), ae.getOldElement(), ae.getNewElement(), (EventObject)mdrEvent));
        } else if (mdrEvent instanceof InstanceEvent && mdrEvent.isOfType(0x2010002)) {
            InstanceEvent ie = (InstanceEvent)mdrEvent;
            events.add(new DeleteInstanceEvent(ie.getSource(), "remove", null, null, (EventObject)mdrEvent));
            String mofid = ((InstanceEvent)mdrEvent).getInstance().refMofId();
            this.modelImpl.removeElement(mofid);
        } else if (mdrEvent instanceof AssociationEvent) {
            ae = (AssociationEvent)mdrEvent;
            if (ae.isOfType(67174402)) {
                events.add(new AddAssociationEvent(ae.getNewElement(), ModelEventPumpMDRImpl.mapPropertyName(ae.getEndName()), ae.getOldElement(), ae.getFixedElement(), ae.getFixedElement(), (EventObject)mdrEvent));
                events.add(new AttributeChangeEvent(ae.getNewElement(), ModelEventPumpMDRImpl.mapPropertyName(ae.getEndName()), ae.getOldElement(), ae.getFixedElement(), (EventObject)mdrEvent));
                events.add(new AddAssociationEvent(ae.getFixedElement(), this.otherAssocEnd((AssociationEvent)ae), ae.getOldElement(), ae.getNewElement(), ae.getNewElement(), (EventObject)mdrEvent));
                events.add(new AttributeChangeEvent(ae.getFixedElement(), this.otherAssocEnd((AssociationEvent)ae), ae.getOldElement(), ae.getNewElement(), (EventObject)mdrEvent));
            } else if (ae.isOfType(0x4010004)) {
                events.add(new RemoveAssociationEvent(ae.getOldElement(), ModelEventPumpMDRImpl.mapPropertyName(ae.getEndName()), ae.getFixedElement(), ae.getNewElement(), ae.getFixedElement(), (EventObject)mdrEvent));
                events.add(new AttributeChangeEvent(ae.getOldElement(), ModelEventPumpMDRImpl.mapPropertyName(ae.getEndName()), ae.getFixedElement(), ae.getNewElement(), (EventObject)mdrEvent));
                events.add(new RemoveAssociationEvent(ae.getFixedElement(), this.otherAssocEnd((AssociationEvent)ae), ae.getOldElement(), ae.getNewElement(), ae.getOldElement(), (EventObject)mdrEvent));
                events.add(new AttributeChangeEvent(ae.getFixedElement(), this.otherAssocEnd((AssociationEvent)ae), ae.getOldElement(), ae.getNewElement(), (EventObject)mdrEvent));
            } else if (ae.isOfType(0x4010001)) {
                LOG.error((Object)"Unexpected EVENT_ASSOCIATION_SET received");
            } else {
                LOG.error((Object)("Unknown association event type " + ae.getType()));
            }
        } else if (LOG.isDebugEnabled() && !(name = mdrEvent.getClass().getName()).endsWith("CreateInstanceEvent")) {
            LOG.debug((Object)("Ignoring MDR event " + mdrEvent));
        }
        for (UmlChangeEvent event : events) {
            this.fire(event);
            if (!(event instanceof DeleteInstanceEvent)) continue;
            this.elements.unregister(null, ((RefBaseObject)event.getSource()).refMofId(), null);
        }
    }

    private boolean isReadOnly(RefBaseObject object) {
        return this.modelImpl.isReadOnly(object.refOutermostPackage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plannedChange(MDRChangeEvent e) {
        RefObject element;
        if (e instanceof InstanceEvent) {
            if (e.isOfType(0x2010001)) {
                element = (RefBaseObject)((InstanceEvent)e).getSource();
                if (this.isReadOnly((RefBaseObject)element)) {
                    throw new VetoChangeException(e.getSource(), null);
                }
            } else {
                element = ((InstanceEvent)e).getInstance();
                if (this.isReadOnly((RefBaseObject)element)) {
                    throw new VetoChangeException(e.getSource(), element);
                }
            }
        } else if (!(e instanceof AssociationEvent) && e instanceof AttributeEvent && this.isReadOnly((RefBaseObject)(element = (RefObject)((AttributeEvent)e).getSource()))) {
            throw new VetoChangeException((Object)element, element);
        }
        Boolean bl = this.eventCountMutex;
        synchronized (bl) {
            ++this.pendingEvents;
        }
    }

    public void changeCancelled(MDRChangeEvent e) {
        this.decrementEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementEvents() {
        Boolean bl = this.eventCountMutex;
        synchronized (bl) {
            --this.pendingEvents;
            if (this.pendingEvents <= 0) {
                this.eventCountMutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(UmlChangeEvent event) {
        String mofId = ((RefBaseObject)event.getSource()).refMofId();
        String className = this.getClassName(event.getSource());
        HashSet<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
        Object object = this.registrationMutex;
        synchronized (object) {
            listeners.addAll(this.elements.getMatches(mofId, event.getPropertyName()));
            listeners.addAll(this.listenedClasses.getMatches(className, event.getPropertyName()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Firing " + this.modelImpl.getMetaTypes().getName(event) + " source " + this.modelImpl.getMetaTypes().getName(event.getSource()) + " [" + ((RefBaseObject)event.getSource()).refMofId() + "]." + event.getPropertyName() + "," + this.formatElement(event.getOldValue()) + "->" + this.formatElement(event.getNewValue())));
        }
        if (!listeners.isEmpty()) {
            for (PropertyChangeListener pcl : listeners) {
                pcl.propertyChange(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerModelEvent(PropertyChangeListener listener, Object modelElement, String[] propertyNames) {
        if (listener == null || modelElement == null) {
            throw new IllegalArgumentException("Neither listener (" + listener + ") or modelElement (" + modelElement + ") can be null! [Property names: " + propertyNames + "]");
        }
        String mofId = ((RefBaseObject)modelElement).refMofId();
        try {
            this.verifyAttributeNames(((RefBaseObject)modelElement).refMetaObject(), propertyNames);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register [ element:" + this.formatElement(modelElement) + ", properties:" + this.formatArray(propertyNames) + ", listener:" + listener + "]"));
        }
        Object object = this.registrationMutex;
        synchronized (object) {
            this.elements.register(listener, mofId, propertyNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterModelEvent(PropertyChangeListener listener, Object modelElement, String[] propertyNames) {
        if (listener == null || modelElement == null) {
            LOG.error((Object)("Attempt to unregister null listener(" + listener + ") or modelElement (" + modelElement + ")! [Property names: " + propertyNames + "]"));
            return;
        }
        if (!(modelElement instanceof RefBaseObject)) {
            LOG.error((Object)("Ignoring non-RefBaseObject received by unregisterModelEvent - " + modelElement));
            return;
        }
        String mofId = ((RefBaseObject)modelElement).refMofId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unregister [ element:" + this.formatElement(modelElement) + ", properties:" + this.formatArray(propertyNames) + ", listener:" + listener + "]"));
        }
        Object object = this.registrationMutex;
        synchronized (object) {
            this.elements.unregister(listener, mofId, propertyNames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerClassEvent(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        if (modelClass instanceof Class) {
            String className = this.getClassName(modelClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Register class [" + this.modelImpl.getMetaTypes().getName(modelClass) + "properties:" + this.formatArray(propertyNames) + ", listener:" + listener + "]"));
            }
            Collection<String> subtypes = this.subtypeMap.get(className);
            this.verifyAttributeNames(className, propertyNames);
            Object object = this.registrationMutex;
            synchronized (object) {
                this.listenedClasses.register(listener, className, propertyNames);
                for (String subtype : subtypes) {
                    this.listenedClasses.register(listener, subtype, propertyNames);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Don't know how to register class event for object " + modelClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterClassEvent(PropertyChangeListener listener, Object modelClass, String[] propertyNames) {
        if (modelClass instanceof Class) {
            String className = this.getClassName(modelClass);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Unregister class [" + className + ", properties:" + this.formatArray(propertyNames) + ", listener:" + listener + "]"));
            }
            Collection<String> subtypes = this.subtypeMap.get(className);
            Object object = this.registrationMutex;
            synchronized (object) {
                this.listenedClasses.unregister(listener, className, propertyNames);
                for (String subtype : subtypes) {
                    this.listenedClasses.unregister(listener, subtype, propertyNames);
                }
            }
            return;
        }
        throw new IllegalArgumentException("Don't know how to unregister class event for object " + modelClass);
    }

    private String getClassName(Object elementOrClass) {
        return this.modelImpl.getMetaTypes().getName(elementOrClass);
    }

    @Override
    public void startPumpingEvents() {
        LOG.debug((Object)"Start pumping events");
        this.repository.addListener((MDRChangeListener)this);
    }

    @Override
    public void stopPumpingEvents() {
        LOG.debug((Object)"Stop pumping events");
        this.repository.removeListener((MDRChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushModelEvents() {
        while (true) {
            Boolean bl = this.eventCountMutex;
            synchronized (bl) {
                if (this.pendingEvents <= 0 || Thread.currentThread().equals(this.eventThread)) {
                    return;
                }
                try {
                    this.eventCountMutex.wait();
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Interrupted while waiting in flushModelEvents");
                }
            }
        }
    }

    private String otherAssocEnd(AssociationEvent ae) {
        RefAssociation ra = (RefAssociation)ae.getSource();
        Association a = (Association)ra.refMetaObject();
        AssociationEnd aend = null;
        try {
            aend = (AssociationEnd)a.lookupElementExtended(ae.getEndName());
        }
        catch (NameNotFoundException e) {
            LOG.error((Object)("Failed to find other end of association : " + ae.getSource() + " -> " + ae.getEndName()));
            return null;
        }
        return aend.otherEnd().getName();
    }

    private static String mapPropertyName(String name) {
        if ("typedParameter".equals(name)) {
            return "parameter";
        }
        if ("typedFeature".equals(name)) {
            return "feature";
        }
        return name;
    }

    private String formatArray(String[] array) {
        if (array == null) {
            return null;
        }
        String result = "[";
        for (int i = 0; i < array.length; ++i) {
            result = result + array[i] + ", ";
        }
        return result.substring(0, result.length() - 2) + "]";
    }

    private String formatElement(Object element) {
        try {
            if (element instanceof RefBaseObject) {
                return this.modelImpl.getMetaTypes().getName(element) + "<" + ((RefBaseObject)element).refMofId() + ">";
            }
            if (element != null) {
                return element.toString();
            }
        }
        catch (InvalidObjectException e) {
            return this.modelImpl.getMetaTypes().getName(element) + "<deleted>";
        }
        return null;
    }

    private Map<String, Collection<String>> buildTypeMap(ModelPackage extent) {
        HashMap<String, Collection<String>> names = new HashMap<String, Collection<String>>();
        for (Object metaclass : extent.getMofClass().refAllOfClass()) {
            ModelElement element = (ModelElement)metaclass;
            String name = element.getName();
            if (names.containsKey(name)) {
                LOG.error((Object)("Found duplicate class '" + name + "' in metamodel"));
                continue;
            }
            names.put(name, this.getSubtypes(extent, element));
        }
        return names;
    }

    private Collection<String> getSubtypes(ModelPackage extent, ModelElement me) {
        HashSet<String> allSubtypes = new HashSet<String>();
        if (me instanceof GeneralizableElement) {
            GeneralizableElement ge = (GeneralizableElement)me;
            Collection subtypes = extent.getGeneralizes().getSubtype(ge);
            for (ModelElement st : subtypes) {
                allSubtypes.add(st.getName());
                allSubtypes.addAll(this.getSubtypes(extent, st));
            }
        }
        return allSubtypes;
    }

    private Map<String, Collection<String>> buildPropertyNameMap(ModelPackage extent) {
        HashMap<String, Collection<String>> names = new HashMap<String, Collection<String>>();
        for (Reference reference : extent.getReference().refAllOfClass()) {
            this.mapAssociationEnd(names, reference.getExposedEnd());
            this.mapAssociationEnd(names, reference.getReferencedEnd());
        }
        for (Attribute attribute : extent.getAttribute().refAllOfClass()) {
            this.mapPropertyName(names, (ModelElement)attribute.getContainer(), attribute.getName());
        }
        return names;
    }

    private void mapAssociationEnd(Map<String, Collection<String>> names, AssociationEnd end) {
        Classifier type = end.otherEnd().getType();
        this.mapPropertyName(names, (ModelElement)type, end.getName());
    }

    private boolean mapPropertyName(Map<String, Collection<String>> names, ModelElement type, String propertyName) {
        String typeName = type.getName();
        boolean added = this.mapPropertyName(names, typeName, propertyName);
        Collection<String> subtypes = this.subtypeMap.get(typeName);
        if (subtypes != null) {
            for (String subtype : subtypes) {
                added &= this.mapPropertyName(names, subtype, propertyName);
            }
        }
        return added;
    }

    private boolean mapPropertyName(Map<String, Collection<String>> names, String typeName, String propertyName) {
        if (!names.containsKey(typeName)) {
            names.put(typeName, new HashSet());
        }
        boolean added = names.get(typeName).add(propertyName);
        if (LOG.isDebugEnabled() && added) {
            LOG.debug((Object)("Added property name - " + typeName + ":" + propertyName));
        }
        return added;
    }

    private void verifyAttributeNames(String className, String[] attributes) {
        RefObject ro = null;
        this.verifyAttributeNames(ro, attributes);
    }

    private void verifyAttributeNames(RefObject metaobject, String[] attributes) {
        if (LOG.isDebugEnabled()) {
            if (metaobject == null || attributes == null) {
                return;
            }
            if (!(metaobject instanceof MofClass)) {
                metaobject = metaobject.refMetaObject();
            }
            if (!(metaobject instanceof MofClass)) {
                throw new IllegalArgumentException("Argument must be MofClass or instance of MofClass");
            }
            MofClass metaclass = (MofClass)metaobject;
            Collection<String> names = this.propertyNameMap.get(metaclass.getName());
            if (names == null) {
                names = Collections.emptySet();
            }
            for (String attribute : attributes) {
                if (names.contains(attribute) || "remove".equals(attribute)) continue;
                LOG.error((Object)("Property '" + attribute + "' for class '" + metaclass.getName() + "' doesn't exist in metamodel"));
            }
        }
    }

    @Override
    public List getDebugInfo() {
        ArrayList<Object> info = new ArrayList<Object>();
        info.add("Event Listeners");
        for (Map.Entry entry : this.elements.registry.entrySet()) {
            String item = entry.getKey().toString();
            List<String> modelElementNode = this.newDebugNode(this.getDebugDescription(item));
            info.add(modelElementNode);
            Map propertyMap = entry.getValue();
            for (Map.Entry propertyEntry : propertyMap.entrySet()) {
                List<String> propertyNode = this.newDebugNode(propertyEntry.getKey().toString());
                modelElementNode.add((String)((Object)propertyNode));
                List listenerList = propertyEntry.getValue();
                for (Object listener : listenerList) {
                    List<String> listenerNode = this.newDebugNode(listener.getClass().getName());
                    propertyNode.add((String)((Object)listenerNode));
                }
            }
        }
        return info;
    }

    private List<String> newDebugNode(String name) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        return list;
    }

    private String getDebugDescription(String mofId) {
        RefBaseObject modelElement = this.repository.getByMofId(mofId);
        String name = Model.getFacade().getName(modelElement);
        if (name != null && name.trim().length() != 0) {
            return "\"" + name + "\" - " + modelElement.toString();
        }
        return modelElement.toString();
    }
}

