/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.activity2.diagram;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.argouml.activity2.diagram.CreateDiagramElementAction;
import org.argouml.kernel.Owned;
import org.argouml.model.Model;
import org.argouml.uml.diagram.UMLMutableGraphSupport;
import org.argouml.uml.diagram.UmlDiagramRenderer;
import org.argouml.uml.diagram.ui.ActionSetMode;
import org.argouml.uml.diagram.ui.RadioAction;
import org.argouml.uml.diagram.ui.UMLDiagram;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.LayerPerspectiveMutable;
import org.tigris.gef.base.ModeCreatePolyEdge;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseDiagram
extends UMLDiagram
implements Owned {
    private static final Logger LOG = Logger.getLogger(BaseDiagram.class);
    final Object owner;
    private Map<String, Class<?>> metaTypeByName;
    private Map<Class<?>, String> nameByMetaType;

    BaseDiagram(Object owner) {
        this.owner = owner;
        UMLMutableGraphSupport gm = this.createGraphModel();
        this.setGraphModel((GraphModel)gm);
        LayerPerspectiveMutable lay = new LayerPerspectiveMutable(this.getName(), (MutableGraphModel)gm);
        this.setLayer((LayerPerspective)lay);
        UmlDiagramRenderer renderer = this.createDiagramRenderer();
        lay.setGraphNodeRenderer((GraphNodeRenderer)renderer);
        lay.setGraphEdgeRenderer((GraphEdgeRenderer)renderer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Constructing diagram for " + owner));
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    abstract UmlDiagramRenderer createDiagramRenderer();

    abstract UMLMutableGraphSupport createGraphModel();

    protected Object[] getUmlActions() {
        try {
            Document doc = this.getDocument();
            Element element = this.getElement(doc.getDocumentElement(), "classes");
            int size = element.getChildNodes().getLength();
            this.nameByMetaType = new HashMap(size);
            this.metaTypeByName = new HashMap(size);
            this.populateClassMaps(element, this.nameByMetaType, this.metaTypeByName);
            Element toolbarElement = this.getElement(doc.getDocumentElement(), "toolbar");
            return this.getToolbarActions(toolbarElement);
        }
        catch (DOMException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"", (Throwable)e);
        }
        return null;
    }

    private Element getElement(Element element, String tagName) {
        NodeList nl = element.getElementsByTagName(tagName);
        if (nl.getLength() == 0) {
            return null;
        }
        return (Element)nl.item(0);
    }

    private Object[] getToolbarActions(Element toolbarNode) {
        NodeList nl = toolbarNode.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            elements.add((Element)n);
        }
        Object[] toolbarActions = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            Class<?> metaType;
            String type;
            Object o;
            Element itemNode = (Element)elements.get(i);
            String style = itemNode.getNodeName();
            if (style.equals("dropdown")) {
                o = this.getToolbarActions(itemNode);
            } else if (style.equals("poly-edge")) {
                type = itemNode.getAttribute("type");
                metaType = this.metaTypeByName.get(type);
                o = this.getCreateEdgeAction(metaType);
            } else {
                type = itemNode.getAttribute("type");
                metaType = this.metaTypeByName.get(type);
                o = new CreateDiagramElementAction(metaType, style, Model.getMetaTypes().getName(metaType), this);
            }
            toolbarActions[i] = o;
        }
        return toolbarActions;
    }

    private void populateClassMaps(Element classesNode, Map<Class<?>, String> nameByMetaType, Map<String, Class<?>> metaTypeByName) {
        NodeList nl = classesNode.getElementsByTagName("class");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element classNode = (Element)nl.item(i);
            String className = classNode.getTextContent();
            try {
                String name = classNode.getAttribute("name");
                Class<?> clazz = Class.forName(className);
                metaTypeByName.put(name, clazz);
                nameByMetaType.put(clazz, name);
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Class not found " + className), (Throwable)e);
            }
        }
    }

    private Document getDocument() throws IOException, DOMException, ParserConfigurationException, SAXException {
        String filename = this.getDiagramXmlFile();
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename);
        InputSource inputSource = new InputSource(inputStream);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(inputSource);
    }

    protected abstract String getDiagramXmlFile();

    protected Action getCreateEdgeAction(Object metaType) {
        String label = Model.getMetaTypes().getName(metaType);
        return new RadioAction((Action)new ActionSetMode(ModeCreatePolyEdge.class, "edgeClass", metaType, label));
    }

    public boolean isRelocationAllowed(Object base) {
        return false;
    }

    public Collection getRelocationCandidates(Object root) {
        return Collections.EMPTY_LIST;
    }

    public boolean relocate(Object base) {
        return false;
    }
}

