/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.activity2.diagram;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;
import org.argouml.activity2.diagram.BaseDiagram;
import org.argouml.activity2.diagram.DiagramElementBuilder;
import org.argouml.activity2.diagram.FigBaseNode;
import org.argouml.model.Model;
import org.argouml.uml.diagram.DiagramSettings;
import org.tigris.gef.base.FigModifyingModeImpl;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.di.GraphNode;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.undo.UndoManager;

class ModePlaceDiagramElement
extends FigModifyingModeImpl {
    private static final Logger LOG = Logger.getLogger(ModePlaceDiagramElement.class);
    private final Object metaType;
    private final String style;
    private final String instructions;
    private final BaseDiagram diagram;
    private Object modelElement;
    private GraphNode graphNode;
    private static final int WIDTH = 90;
    private static final int HEIGHT = 25;

    public ModePlaceDiagramElement(BaseDiagram diagram, Object metaType, String style, String instructions) {
        this.diagram = diagram;
        this.metaType = metaType;
        this.style = style;
        this.instructions = instructions == null ? "" : instructions;
    }

    public String instructions() {
        return this.instructions;
    }

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        UndoManager.getInstance().addMementoLock((Object)this);
        this.modelElement = Model.getUmlFactory().buildNode(this.metaType, this.diagram.getOwner());
        LOG.info((Object)("Created " + this.modelElement));
        this.start();
        this.editor = Globals.curEditor();
        Layer lay = this.editor.getLayerManager().getActiveLayer();
        this.graphNode = this.createDiagramElement(lay, this.modelElement, this.diagram.getDiagramSettings());
        this.mouseMoved(me);
        me.consume();
    }

    private GraphNode createDiagramElement(Layer lay, Object owner, DiagramSettings settings) {
        FigBaseNode fig = new FigBaseNode(owner, new Rectangle(0, 0, 0, 0), settings);
        DiagramElementBuilder.buildDiagramElement(fig, this.style, owner, settings);
        fig.setLayer(lay);
        return fig;
    }

    public void mouseExited(MouseEvent me) {
        this.editor.damageAll();
        me.consume();
    }

    public void mouseMoved(MouseEvent me) {
        this.mouseDragged(me);
    }

    public void mouseDragged(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        if (this.graphNode == null) {
            me.consume();
            return;
        }
        this.editor.damageAll();
        Point snapPt = new Point(me.getX(), me.getY());
        this.editor.snap(snapPt);
        ((Fig)this.graphNode).setLocation(snapPt.x, snapPt.y);
        this.editor.damageAll();
        me.consume();
    }

    public void mouseEntered(MouseEvent me) {
        me.consume();
    }

    public void mouseReleased(MouseEvent me) {
        if (me.isConsumed()) {
            return;
        }
        LOG.info((Object)"Mouse released");
        MutableGraphModel mgm = (MutableGraphModel)this.editor.getGraphModel();
        UndoManager.getInstance().startChain();
        this.editor.add((Fig)this.graphNode);
        mgm.addNode(this.modelElement);
        this.editor.getSelectionManager().select((Fig)this.graphNode);
        LOG.info((Object)("The diagram element " + this.graphNode + " was added"));
        this.done();
        me.consume();
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getKeyChar() == '\u001b') {
            this.leave();
        }
    }

    public void paint(Graphics g) {
        if (this.graphNode != null) {
            ((Fig)this.graphNode).paint(g);
        }
    }
}

