/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLCollaborationRepresentedClassifierComboBoxModel
extends UMLComboBoxModel {
    public UMLCollaborationRepresentedClassifierComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        ArrayList classifiers = new ArrayList();
        Project p = ProjectManager.getManager().getCurrentProject();
        for (Object model : p.getUserDefinedModelList()) {
            Collection c = Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getClassifier());
            for (Object cls : c) {
                Collection s = Model.getModelManagementHelper().getAllSurroundingNamespaces(cls);
                if (s.contains(this.getTarget())) continue;
                classifiers.add(cls);
            }
        }
        this.setElements(classifiers);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAClassifier(element) && Model.getFacade().getRepresentedClassifier(this.getTarget()) == element;
    }

    protected Object getSelectedModelElement() {
        return Model.getFacade().getRepresentedClassifier(this.getTarget());
    }

    public Action getAction() {
        return new ActionSetRepresentedClassifierCollaboration();
    }

    private class ActionSetRepresentedClassifierCollaboration
    extends UndoableAction {
        ActionSetRepresentedClassifierCollaboration() {
            super(Translator.localize((String)"action.set"), (Icon)ResourceLoaderWrapper.lookupIcon((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object target = source.getTarget();
            Object newValue = source.getSelectedItem();
            if (!Model.getFacade().isAClassifier(newValue)) {
                newValue = null;
            }
            if (Model.getFacade().getRepresentedClassifier(target) != newValue) {
                Model.getCollaborationsHelper().setRepresentedClassifier(target, newValue);
            }
        }
    }
}

