/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.UMLExpressionBodyField;
import org.argouml.core.propertypanels.ui.UMLExpressionLanguageField;
import org.argouml.core.propertypanels.ui.UMLExpressionModel;
import org.tigris.swidgets.LabelledLayout;

class UMLExpressionPanel
extends JPanel
implements ChangeListener {
    private static final Logger LOG = Logger.getLogger(UMLExpressionPanel.class);
    private final UMLExpressionModel model;
    private final UMLExpressionLanguageField languageField;
    private final UMLExpressionBodyField bodyField;

    public UMLExpressionPanel(UMLExpressionModel model, String title) {
        super((LayoutManager)new LabelledLayout());
        boolean isReadOnly;
        LOG.debug((Object)">>New Expression panel created");
        TitledBorder border = new TitledBorder(title);
        this.setBorder(border);
        this.model = model;
        this.languageField = new UMLExpressionLanguageField(model, false);
        this.bodyField = new UMLExpressionBodyField(model, true);
        boolean bl = isReadOnly = !this.languageField.isEditable();
        if (isReadOnly) {
            this.bodyField.setEditable(false);
        } else {
            this.add(this.languageField);
        }
        this.add(new JScrollPane(this.bodyField));
        model.addChangeListener(this);
    }

    public void removeNotify() {
        this.model.removeChangeListener(this);
        super.removeNotify();
    }

    public void stateChanged(ChangeEvent e) {
        LOG.debug((Object)">>Values shown on panel are changed");
        this.bodyField.update();
        this.languageField.update();
    }
}

