/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.argouml.core.propertypanels.ui.Ordered;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AssociationChangeEvent;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.uml.ui.AbstractActionAddModelElement2;
import org.argouml.uml.ui.AbstractActionNewModelElement;
import org.argouml.uml.ui.AbstractActionRemoveElement;
import org.tigris.toolbar.ToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class UMLModelElementListModel
extends DefaultListModel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(UMLModelElementListModel.class);
    private String eventName = null;
    private Object listTarget = null;
    private AbstractActionAddModelElement2 addAction = null;
    private AbstractActionNewModelElement newAction = null;
    private AbstractActionRemoveElement removeAction = null;
    private static int count = 0;
    private final int instance = count++;
    private boolean fireListEvents = true;
    private boolean buildingModel = false;
    private Object metaType;
    private boolean reverseDropConnection;
    private final boolean showIcon;
    private final boolean showPath;

    UMLModelElementListModel() {
        this.showIcon = true;
        this.showPath = true;
    }

    UMLModelElementListModel(String name) {
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
    }

    UMLModelElementListModel(String name, boolean showIcon, boolean showPath) {
        this.eventName = name;
        this.showIcon = showIcon;
        this.showPath = showPath;
    }

    UMLModelElementListModel(String name, boolean showIcon, boolean showPath, Object metaType) {
        this.eventName = name;
        this.showIcon = showIcon;
        this.showPath = showPath;
        this.metaType = metaType;
    }

    UMLModelElementListModel(String name, Object theMetaType) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
    }

    public UMLModelElementListModel(String name, Object theMetaType, AbstractActionAddModelElement2 addAction, AbstractActionNewModelElement newAction, AbstractActionRemoveElement removeAction) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
        this.addAction = addAction;
        this.newAction = newAction;
        this.removeAction = removeAction;
    }

    public UMLModelElementListModel(String name, Object theMetaType, AbstractActionAddModelElement2 addAction) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
        this.addAction = addAction;
    }

    public UMLModelElementListModel(String name, Object theMetaType, AbstractActionNewModelElement newAction) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
        this.newAction = newAction;
    }

    public UMLModelElementListModel(String name, Object theMetaType, AbstractActionAddModelElement2 addAction, AbstractActionRemoveElement removeAction) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
        this.addAction = addAction;
        this.removeAction = removeAction;
    }

    public UMLModelElementListModel(String name, Object theMetaType, AbstractActionAddModelElement2 addAction, AbstractActionNewModelElement newAction) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.showIcon = true;
        this.showPath = true;
        this.addAction = addAction;
        this.newAction = newAction;
    }

    public UMLModelElementListModel(String name, Object theMetaType, boolean reverseTheDropConnection) {
        this.metaType = theMetaType;
        this.eventName = name;
        this.reverseDropConnection = reverseTheDropConnection;
        this.showIcon = true;
        this.showPath = true;
    }

    public Object getMetaType() {
        return this.metaType;
    }

    public boolean isReverseDropConnection() {
        return this.reverseDropConnection;
    }

    protected void setBuildingModel(boolean building) {
        this.buildingModel = building;
    }

    protected void setListTarget(Object t) {
        this.listTarget = t;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent e) {
        final UMLModelElementListModel lm = this;
        Runnable doWorkRunnable = new Runnable(){

            public void run() {
                block22: {
                    try {
                        if (e instanceof AddAssociationEvent) {
                            if (UMLModelElementListModel.this.isValidEvent(e)) {
                                Object o = UMLModelElementListModel.this.getChangedElement(e);
                                if (o instanceof Collection) {
                                    LOG.info((Object)"Elements added");
                                    ArrayList tempList = new ArrayList((Collection)o);
                                    for (Object o2 : tempList) {
                                        UMLModelElementListModel.this.addElement(o2);
                                    }
                                } else if (!UMLModelElementListModel.this.contains(o)) {
                                    if (lm instanceof Ordered) {
                                        Ordered ordered = (Ordered)((Object)lm);
                                        Collection elements = ordered.getModelElements();
                                        if (elements instanceof List) {
                                            int posn = ((List)elements).indexOf(o);
                                            UMLModelElementListModel.this.add(posn, o);
                                        } else {
                                            int posn = 0;
                                            for (Object element : elements) {
                                                if (element == o) break;
                                                ++posn;
                                            }
                                            UMLModelElementListModel.this.add(posn, o);
                                        }
                                    } else {
                                        UMLModelElementListModel.this.addElement(o);
                                    }
                                }
                            }
                        } else if (e instanceof RemoveAssociationEvent) {
                            boolean valid = false;
                            if (!(UMLModelElementListModel.this.getChangedElement(e) instanceof Collection)) {
                                valid = UMLModelElementListModel.this.contains(UMLModelElementListModel.this.getChangedElement(e));
                            } else {
                                Collection col = (Collection)UMLModelElementListModel.this.getChangedElement(e);
                                Iterator it = col.iterator();
                                valid = true;
                                while (it.hasNext()) {
                                    Object o = it.next();
                                    if (UMLModelElementListModel.this.contains(o)) continue;
                                    valid = false;
                                    break;
                                }
                            }
                            if (valid) {
                                Object o = UMLModelElementListModel.this.getChangedElement(e);
                                if (o instanceof Collection) {
                                    for (Object o3 : (Collection)o) {
                                        UMLModelElementListModel.this.removeElement(o3);
                                    }
                                } else {
                                    UMLModelElementListModel.this.removeElement(o);
                                }
                            }
                        }
                    }
                    catch (InvalidElementException e2) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug((Object)"updateLayout method accessed deleted element ", (Throwable)e2);
                    }
                }
            }
        };
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildModelList() {
        LOG.info((Object)"Rebuilding");
        this.removeAllElements();
        this.buildingModel = true;
        try {
            this.buildModelList();
        }
        catch (InvalidElementException exception) {
            LOG.debug((Object)("buildModelList threw exception for target " + this.getTarget() + ": " + (Object)((Object)exception)));
        }
        finally {
            this.buildingModel = false;
        }
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    protected abstract void buildModelList();

    protected void setAllElements(Collection col) {
        if (!this.isEmpty()) {
            this.removeAllElements();
        }
        this.addAll(col);
    }

    protected void addAll(Collection col) {
        int intervalStart;
        if (col.size() == 0) {
            return;
        }
        Iterator it = col.iterator();
        this.fireListEvents = false;
        int n = intervalStart = this.getSize() == 0 ? 0 : this.getSize() - 1;
        while (it.hasNext()) {
            Object o = it.next();
            this.addElement(o);
        }
        this.fireListEvents = true;
        this.fireIntervalAdded(this, intervalStart, this.getSize() - 1);
    }

    public Object getTarget() {
        return this.listTarget;
    }

    protected Object getChangedElement(PropertyChangeEvent e) {
        if (e instanceof AssociationChangeEvent) {
            return ((AssociationChangeEvent)e).getChangedValue();
        }
        if (e instanceof AttributeChangeEvent) {
            return ((AttributeChangeEvent)e).getSource();
        }
        return e.getNewValue();
    }

    @Override
    public boolean contains(Object elem) {
        if (super.contains(elem)) {
            return true;
        }
        if (elem instanceof Collection) {
            Iterator it = ((Collection)elem).iterator();
            while (it.hasNext()) {
                if (super.contains(it.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setTarget(Object theNewTarget) {
        assert (this.getTarget() == null);
        assert (Model.getFacade().isAUMLElement(theNewTarget));
        this.listTarget = theNewTarget;
        Model.getPump().addModelEventListener((PropertyChangeListener)this, this.listTarget, this.eventName);
        this.addOtherModelEventListeners(this.listTarget);
        this.rebuildModelList();
    }

    public void removeModelEventListener() {
        Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.listTarget, this.eventName);
    }

    protected void removeOtherModelEventListeners(Object oldTarget) {
    }

    protected void addOtherModelEventListeners(Object newTarget) {
    }

    protected abstract boolean isValidElement(Object var1);

    protected boolean isValidEvent(PropertyChangeEvent e) {
        boolean valid = false;
        if (!(this.getChangedElement(e) instanceof Collection)) {
            if (e.getNewValue() == null && e.getOldValue() != null || this.isValidElement(this.getChangedElement(e))) {
                valid = true;
            }
        } else {
            Collection col = (Collection)this.getChangedElement(e);
            Iterator it = col.iterator();
            if (!col.isEmpty()) {
                valid = true;
                while (it.hasNext()) {
                    Object o = it.next();
                    if (this.isValidElement(o)) continue;
                    valid = false;
                    break;
                }
            } else if (e.getOldValue() instanceof Collection && !((Collection)e.getOldValue()).isEmpty()) {
                valid = true;
            }
        }
        return valid;
    }

    public void addElement(Object obj) {
        if (obj != null && !this.contains(obj)) {
            super.addElement(obj);
        }
    }

    String getEventName() {
        return this.eventName;
    }

    protected void setEventName(String theEventName) {
        this.eventName = theEventName;
    }

    @Override
    protected final void fireContentsChanged(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireContentsChanged(source, index0, index1);
        }
    }

    @Override
    protected final void fireIntervalAdded(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireIntervalAdded(source, index0, index1);
        }
    }

    @Override
    protected final void fireIntervalRemoved(Object source, int index0, int index1) {
        if (this.fireListEvents && !this.buildingModel) {
            super.fireIntervalRemoved(source, index0, index1);
        }
    }

    public boolean buildPopup(JPopupMenu popup, int index) {
        return false;
    }

    public List<Action> getActions() {
        MenuElement[] elements;
        ArrayList<Action> actions = new ArrayList<Action>();
        JPopupMenu popup = new JPopupMenu();
        this.buildPopup(popup, 0);
        for (MenuElement element : elements = popup.getSubElements()) {
            if (!(element instanceof JMenuItem)) continue;
            actions.add(((JMenuItem)element).getAction());
        }
        return actions;
    }

    public ToolBar getToolbar() {
        return null;
    }

    protected boolean hasPopup() {
        return false;
    }

    boolean isShowIcon() {
        return this.showIcon;
    }

    boolean isShowPath() {
        return this.showPath;
    }

    public AbstractActionAddModelElement2 getAddAction() {
        return this.addAction;
    }

    public AbstractActionNewModelElement getNewAction() {
        return this.newAction;
    }

    public AbstractActionRemoveElement getRemoveAction() {
        return this.removeAction;
    }

    public List<Action> getNewActions() {
        return Collections.emptyList();
    }
}

