/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.tigris.toolbar.ToolBarManager;
import org.tigris.toolbar.toolbutton.ModalButton;
import org.tigris.toolbar.toolbutton.OverflowButton;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = -5763580513766833944L;
    private String javaVersion = System.getProperties().getProperty("java.specification.version");
    private JButton overflowButton;
    private List hiddenComponents;
    private String dropDownToolTip;

    public ToolBar() {
        this("");
    }

    public ToolBar(String string) {
        this(string, 0);
    }

    public ToolBar(String string, int n) {
        super(string, n);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.overflowButton = new OverflowButton(this, this.isRollover());
        this.addComponentListener(new SizeListener());
    }

    public ToolBar(int n) {
        this("", n);
    }

    public JButton add(Action action) {
        ModalButton modalButton = new ModalButton(action);
        this.add(modalButton);
        if (!ToolBarManager.alwaysUseStandardRollover()) {
            modalButton.setBorderPainted(false);
        }
        if (this.javaVersion.equals("1.3")) {
            modalButton.setMargin(new Insets(0, 0, 0, 0));
        }
        return modalButton;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof OverflowButton) {
            this.overflowButton = (OverflowButton)component;
        }
        super.addImpl(component, object, n);
    }

    public Component[] getOverflowActions() {
        Component[] componentArray = new Component[this.hiddenComponents.size()];
        this.hiddenComponents.toArray(componentArray);
        return componentArray;
    }

    public void setDropDownTooltip(String string) {
        this.dropDownToolTip = string;
    }

    public String getDropDownTooltip() {
        return this.dropDownToolTip;
    }

    private class SizeListener
    extends ComponentAdapter {
        private SizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component;
            int n;
            int n2;
            super.componentResized(componentEvent);
            if (ToolBar.this.hiddenComponents != null) {
                ToolBar.this.remove(ToolBar.this.overflowButton);
                for (n2 = 0; n2 < ToolBar.this.hiddenComponents.size(); ++n2) {
                    ToolBar.this.add((Component)ToolBar.this.hiddenComponents.get(n2));
                }
                ToolBar.this.hiddenComponents = null;
            }
            n2 = ToolBar.this.getWidth() - ToolBar.this.overflowButton.getWidth();
            ToolBar.this.overflowButton.setLocation(n2, ToolBar.this.overflowButton.getHeight());
            boolean bl = false;
            for (n = 0; n < ToolBar.this.getComponentCount() && !bl; ++n) {
                component = ToolBar.this.getComponent(n);
                if (component == ToolBar.this.overflowButton || component.getX() + component.getWidth() <= ToolBar.this.getWidth()) continue;
                bl = true;
            }
            if (bl) {
                ToolBar.this.hiddenComponents = new ArrayList();
                n = 0;
                while (n < ToolBar.this.getComponentCount()) {
                    component = ToolBar.this.getComponent(n);
                    if (component != ToolBar.this.overflowButton && component.getX() + component.getWidth() > n2) {
                        ToolBar.this.hiddenComponents.add(component);
                        ToolBar.this.remove(component);
                        continue;
                    }
                    ++n;
                }
                ToolBar.this.remove(ToolBar.this.overflowButton);
                ToolBar.this.add(ToolBar.this.overflowButton);
                ToolBar.this.validate();
            }
        }
    }
}

