/* test_ossl_ecx.h
 *
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#ifndef WOLFCRYPT_TEST_OSSL_ECX_H
#define WOLFCRYPT_TEST_OSSL_ECX_H

#include <tests/api/api_decl.h>

#ifdef OPENSSL_EXTRA

int test_EC25519(void);
int test_ED25519(void);
int test_EC448(void);
int test_ED448(void);

#define TEST_OSSL_ECX_DECLS                     \
    TEST_DECL_GROUP("ossl_ecx", test_EC25519),  \
    TEST_DECL_GROUP("ossl_ecx", test_ED25519),  \
    TEST_DECL_GROUP("ossl_ecx", test_EC448),    \
    TEST_DECL_GROUP("ossl_ecx", test_ED448)

#endif

#endif /* WOLFCRYPT_TEST_OSSL_ECX_H */

