require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ARCH_DESC_H)) {
    eval 'sub __ARCH_DESC_H () {1;}' unless defined(&__ARCH_DESC_H);
    require 'linux/threads.ph';
    require 'asm/ldt.ph';
    unless(defined(&__ASSEMBLY__)) {
	require 'linux/string.ph';
	require 'linux/smp.ph';
	require 'asm/segment.ph';
	require 'asm/mmu.ph';
	eval("sub GATE_INTERRUPT () { 0xE; }") unless defined(&GATE_INTERRUPT);
	eval("sub GATE_TRAP () { 0xF; }") unless defined(&GATE_TRAP);
	eval("sub GATE_CALL () { 0xC; }") unless defined(&GATE_CALL);
	eval 'sub PTR_LOW {
	    my($x) = @_;
    	    eval q((($x) & 0xffff));
	}' unless defined(&PTR_LOW);
	eval 'sub PTR_MIDDLE {
	    my($x) = @_;
    	    eval q(((($x) >> 16) & 0xffff));
	}' unless defined(&PTR_MIDDLE);
	eval 'sub PTR_HIGH {
	    my($x) = @_;
    	    eval q((($x) >> 32));
	}' unless defined(&PTR_HIGH);
	eval("sub DESC_TSS () { 0x9; }") unless defined(&DESC_TSS);
	eval("sub DESC_LDT () { 0x2; }") unless defined(&DESC_LDT);
	eval 'sub load_TR_desc () {
	    eval q( &asm  &volatile(\\"ltr %w0\\"::\\"r\\" ( &GDT_ENTRY_TSS*8)));
	}' unless defined(&load_TR_desc);
	eval 'sub load_LDT_desc () {
	    eval q( &asm  &volatile(\\"lldt %w0\\"::\\"r\\" ( &GDT_ENTRY_LDT*8)));
	}' unless defined(&load_LDT_desc);
	eval 'sub clear_LDT () {
	    eval q( &asm  &volatile(\\"lldt %w0\\"::\\"r\\" (0)));
	}' unless defined(&clear_LDT);
	eval 'sub cpu_gdt {
	    my($_cpu) = @_;
    	    eval q(( ($cpu_gdt_descr[$_cpu]->{address})));
	}' unless defined(&cpu_gdt);
	eval 'sub _set_gate {
	    my($adr,$type,$func,$dpl,$ist) = @_;
    	    eval q({ 1;  ($s->{offset_low}) =  &PTR_LOW($func);  ($s->{segment}) =  &__KERNEL_CS;  ($s->{ist}) = $ist;  ($s->{p}) = 1;  ($s->{dpl}) = $dpl;  ($s->{zero0}) = 0;  ($s->{zero1}) = 0;  ($s->{type}) = $type;  ($s->{offset_middle}) =  &PTR_MIDDLE($func);  ($s->{offset_high}) =  &PTR_HIGH($func);  &memcpy($adr,  &s, 16); } );
	}' unless defined(&_set_gate);
	eval 'sub set_intr_gate {
	    my($nr,$func) = @_;
    	    eval q({  &BUG_ON($nr > 0xff);  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 0, 0); } );
	}' unless defined(&set_intr_gate);
	eval 'sub set_intr_gate_ist {
	    my($nr,$func,$ist) = @_;
    	    eval q({  &BUG_ON($nr > 0xff);  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 0, $ist); } );
	}' unless defined(&set_intr_gate_ist);
	eval 'sub set_system_gate {
	    my($nr,$func) = @_;
    	    eval q({  &BUG_ON($nr > 0xff);  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 3, 0); } );
	}' unless defined(&set_system_gate);
	eval 'sub set_system_gate_ist {
	    my($nr,$func,$ist) = @_;
    	    eval q({  &_set_gate( $idt_table[$nr],  &GATE_INTERRUPT, $func, 3, $ist); });
	}' unless defined(&set_system_gate_ist);
	eval 'sub set_tssldt_descriptor {
	    my($ptr,$tss,$type,$size) = @_;
    	    eval q({ 1;  &memset( &d,0,$sizeof{ &d});  ($d->{limit0}) = $size & 0xffff;  ($d->{base0}) =  &PTR_LOW($tss);  ($d->{base1}) =  &PTR_MIDDLE($tss) & 0xff;  ($d->{type}) = $type;  ($d->{p}) = 1;  ($d->{limit1}) = ($size >> 16) & 0xf;  ($d->{base2}) = ( &PTR_MIDDLE($tss) >> 8) & 0xff;  ($d->{base3}) =  &PTR_HIGH($tss);  &memcpy($ptr,  &d, 16); });
	}' unless defined(&set_tssldt_descriptor);
	eval 'sub set_tss_desc {
	    my($cpu,$addr) = @_;
    	    eval q({  &set_tssldt_descriptor( $cpu_gdt[ &GDT_ENTRY_TSS], $addr,  &DESC_TSS,  &IO_BITMAP_OFFSET +  &IO_BITMAP_BYTES + $sizeof{my $long} - 1); } );
	}' unless defined(&set_tss_desc);
	eval 'sub set_ldt_desc {
	    my($cpu,$addr,$size) = @_;
    	    eval q({  &set_tssldt_descriptor( $cpu_gdt[ &GDT_ENTRY_LDT], $addr,  &DESC_LDT, $size * 8- 1); });
	}' unless defined(&set_ldt_desc);
	eval 'sub set_seg_base {
	    my($cpu,$entry,$base) = @_;
    	    eval q({ 1;  &u32  &addr = ( &u32)( &u64)$base;  &BUG_ON(( &u64)$base >> 32);  ($d->{base0}) =  &addr & 0xffff;  ($d->{base1}) = ( &addr >> 16) & 0xff;  ($d->{base2}) = ( &addr >> 24) & 0xff; } );
	}' unless defined(&set_seg_base);
	eval 'sub LDT_entry_a {
	    my($info) = @_;
    	    eval q((((($info)-> &base_addr & 0xffff) << 16) | (($info)-> &limit & 0xffff)));
	}' unless defined(&LDT_entry_a);
	eval 'sub LDT_entry_b {
	    my($info) = @_;
    	    eval q(((($info)-> &base_addr & 0xff000000) | ((($info)-> &base_addr & 0xff0000) >> 16) | (($info)-> &limit & 0xf0000) | ((($info)-> &read_exec_only ^ 1) << 9) | (($info)-> &contents << 10) | ((($info)-> &seg_not_present ^ 1) << 15) | (($info)-> &seg_32bit << 22) | (($info)-> &limit_in_pages << 23) | (($info)-> &useable << 20) | 0x7000));
	}' unless defined(&LDT_entry_b);
	eval 'sub LDT_empty {
	    my($info) = @_;
    	    eval q(( ($info)-> &base_addr == 0 && ($info)-> &limit == 0 && ($info)-> &contents == 0 && ($info)-> &read_exec_only == 1 && ($info)-> &seg_32bit == 0 && ($info)-> &limit_in_pages == 0 && ($info)-> &seg_not_present == 1 && ($info)-> &useable == 0 && ($info)-> &lm == 0));
	}' unless defined(&LDT_empty);
	if((defined(&TLS_SIZE) ? &TLS_SIZE : 0) != 24) {
	    die("update\ this\ code\.");
	}
	eval 'sub load_TLS {
	    my($t,$cpu) = @_;
    	    eval q({  &u64 * &gdt = ( &u64 *)( &cpu_gdt($cpu) +  &GDT_ENTRY_TLS_MIN);  $gdt[0] =  ($t->{tls_array[0]});  $gdt[1] =  ($t->{tls_array[1]});  $gdt[2] =  ($t->{tls_array[2]}); } );
	}' unless defined(&load_TLS);
	eval 'sub load_LDT {
	    my($pc) = @_;
    	    eval q({ \'int\'  &cpu =  &get_cpu();  &load_LDT_nolock($pc,  &cpu);  &put_cpu(); });
	}' unless defined(&load_LDT);
    }
}
1;
