#!/usr/bin/perl -w

use strict;
use CGI '3.12';
use mod_perl2 '1.9922';
use Proxmox::proxcfg;
use Proxmox::Utils;
use HTML::Entities;
use Proxmox::Config::System;

my $r = Apache2::RequestUtil->request();

my $system_cfg = Proxmox::Config::System->new ();
my $demo = $system_cfg->get ('administration', 'demo');

my $proxver = $demo ? 'Demo' : Proxmox::proxcfg::version();

sub send_output {
    my ($r, $form) = @_;

    $r->no_cache (1);
    my $x = length ($form);
    $r->content_type ("text/html");
    $r->headers_out->set ("Content-length", "$x");
    $r->headers_out->set ("Pragma", "no-cache");

    $r->print ($form);
}

# check if someone opens us directly
if (!$r->prev) {
    send_output ($r, "<p>do not call me directly</p>");
    exit (0);
}

my $uri = $r->prev->uri;

# if there are args, append that to the uri
my $args = $r->prev->args;
if ($args) {
    $uri .= "?$args";
}

my $reason = $r->prev->subprocess_env("AuthCookieReason");

my $errordoc = '';

if ($reason && $reason eq 'bad_credentials') {
    my $cgi = CGI->new($r);
    my %arghash =  $cgi->Vars();
    my $autologin = $arghash{credential_0} &&  $arghash{credential_0} eq '_autologin_';

    my $txt;

    if ($autologin) {
	$txt = __("You could not be logged on. Ticket is no longer valid.");
    } else {
	$txt = __("You could not be logged on. Make sure your user name and password are correct, and then try again.");
    }

    $txt = decode_entities ($txt);

    $errordoc = "<script type='text/javascript'>alert ('$txt');</script>\n";
}

my $untext = __("Username");
my $pwtext = __("Password");

my $demotxt = $demo ? 'value=demo' : '';

my $txt1 = __("Please use Microsoft Internet Explorer (> 6.0) or Firefox (> 1.5) for full functionality.");
my $txt2 = __("JavaScript is active: ok.");
my $txt3 = __("JavaScript is not available. Please activate it in your browser configuration.");

my $css = '/css/proxmox.css';
my $dyngraph = '/images/dyngraph.pl';
my $customhref = "http://www.proxmox.com";

if ($uri =~ m|/userquar|) {
    $css = '/css/custom.css';
    $dyngraph = '/images/dyngraph-custom.pl';
    if (my $href = $system_cfg->get ('spamquar', 'logolink')) {
	$href = "http://$href" if $href !~ m!^\s*(http://|https:|//)!i;
 	$customhref = $href;
    }
}
 
my $form = <<HERE;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>

<!-- Head Information -->
<head>
  <title>Proxmox Login</title>
  <meta http-equiv="Content-Type" content="text/html;charset=ISO-8859-1">
  <LINK REL="stylesheet" type="text/css" HREF="$css">
</head>


<!-- Body start -->
<body style="margin:0px;padding:0px;margin=0px" onLoad="document.forms[0].credential_0.focus();">
$errordoc
<form name="frm" method="POST" action="/nrd/LOGIN">
<INPUT TYPE=hidden NAME=destination VALUE="$uri">
<!--Logo Block -->

<div align=center>

<table border=0 cellspacing=0 cellpadding=2 style="width:1000px;">
<tr class="boxheadline"><td colspan=3 align=right style="padding-right:5px;">&nbsp;</td></tr>
<tr class="boxheadline menubg"><td colspan=3 style="padding:0px;"><a href="$customhref" target="_blank"> 
    <img alt="" style="display:block;border:0px;width:1000px;max-height:300px;" src='$dyngraph?shape=logo'>
    </a></td>
</tr>
<tr class="boxheadline">
    <td align=left style="width:30%;padding-left:5px;">&nbsp;</td>
    <td align=center style="width:40%;padding-left:5px;">
      <a href='http://www.proxmox.com' target='_blank' class="boxheadline">Proxmox Mail Gateway $proxver</a>
    </td>
    <td align=right style="width:30%;padding-right:5px;">
      <a href='http://www.proxmox.com' target='_blank' class="boxheadline">www.proxmox.com</a>&nbsp;
    </td>
</tr>
</table>
<br>
</div>

<table width="100%" style="margin-top:100px;">
<tr>
  <td align="center">

  <!-- Login Window -->
  <table width=200 border=0 cellspacing=0 cellpadding=0>
    <tr class="boxheadline">
        <td colspan=2 align="left" style="padding:2px;padding-left:5px;">Login</td>
    </tr>
    <tr><td colspan=2 class="menubg" style="height:2px;"></td></tr>
    <tr>
        <td class="highlightbg"><img alt='' src="/images/blank.gif" width=5></td>
        <td class="menubg" style="width:195px;">
        <p style="margin:10px; text-align:center">
        <b class="hlfont">$untext:</b><br>
        <input name="credential_0" $demotxt type="text" class="stdcolbd" style="width:145px;border:solid 1px;"><br><br>
        <b class="hlfont">$pwtext:</b><br>
        <input name="credential_1" $demotxt type="password" class="stdcolbd" style="width:145px;border:solid 1px;"><br><br>
        <input type="submit" value="Login" class="stdcolbd hlfont" style="width:60px;border:solid 1px;"></p>
        </td>
    </tr>
   
    <tr><td>&nbsp;</td></tr>
    
    <tr class="boxheadline">
        <td colspan=2 align="left" style="padding:2px;padding-left:5px;">Information</td>
    </tr>
    <tr>
        <td colspan=2 style="width:200px;padding:10px;" align="left">
            <p style="margin:0px; font-size:9px;">$txt1<br><br>
            <script type="text/javascript"><!-- 
            document.write("$txt2");
            document.write("<span style='visibility:hidden; color:#FFFFFF; size:1px;'>"); 
            --></script>
            <b class="highlightfg">$txt3</b> 
            </p>
        </td>
    </tr>
    
  </table>
  
  </td>
</tr>

</table>
</form>
</body>
</html>
HERE


send_output ($r, $form);
exit (0);
