require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_SYSTEM_H)) {
    eval 'sub __ASM_SYSTEM_H () {1;}' unless defined(&__ASM_SYSTEM_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'asm/segment.ph';
    eval 'sub nop () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&nop);
    eval 'sub xchg {
        my($ptr,$v) = @_;
	    eval q((( &__typeof__(*)) &__xchg(($v),($ptr),$sizeof{($ptr)})));
    }' unless defined(&xchg);
    eval 'sub tas {
        my($ptr) = @_;
	    eval q(( &xchg(($ptr),1)));
    }' unless defined(&tas);
    eval 'sub __xg {
        my($x) = @_;
	    eval q((( &volatile \'long\' *)($x)));
    }' unless defined(&__xg);
    eval 'sub set_64bit {
        my($ptr,$val) = @_;
	    eval q({ *$ptr = $val; });
    }' unless defined(&set_64bit);
    eval 'sub _set_64bit () { &set_64bit;}' unless defined(&_set_64bit);
    eval 'sub __HAVE_ARCH_CMPXCHG () {1;}' unless defined(&__HAVE_ARCH_CMPXCHG);
    eval 'sub __cmpxchg {
        my($ptr,$old,$new,$size) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__cmpxchg);
    eval 'sub cmpxchg {
        my($ptr,$o,$n) = @_;
	    eval q((( &__typeof__(*)) &__cmpxchg(,, ($n),$sizeof{($ptr)})));
    }' unless defined(&cmpxchg);
    if(defined(&CONFIG_SMP)) {
	eval 'sub smp_mb () {
	    eval q( &mb());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &rmb());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &wmb());
	}' unless defined(&smp_wmb);
    } else {
	eval 'sub smp_mb () {
	    eval q( &barrier());
	}' unless defined(&smp_mb);
	eval 'sub smp_rmb () {
	    eval q( &barrier());
	}' unless defined(&smp_rmb);
	eval 'sub smp_wmb () {
	    eval q( &barrier());
	}' unless defined(&smp_wmb);
    }
    eval 'sub mb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&mb);
    eval 'sub rmb () {
        eval q( &mb());
    }' unless defined(&rmb);
    eval 'sub wmb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&wmb);
    eval 'sub set_mb {
        my($var, $value) = @_;
	    eval q( &do {  &xchg($var, $value); }  &while (0));
    }' unless defined(&set_mb);
    eval 'sub set_wmb {
        my($var, $value) = @_;
	    eval q( &do { $var = $value;  &wmb(); }  &while (0));
    }' unless defined(&set_wmb);
    eval 'sub __save_flags {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__save_flags);
    eval 'sub __restore_flags {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__restore_flags);
    eval 'sub __cli () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__cli);
    eval 'sub __sti () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__sti);
    eval 'sub safe_halt () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&safe_halt);
    eval 'sub local_irq_save {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&local_irq_save);
    eval 'sub local_irq_restore {
        my($x) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&local_irq_restore);
    eval 'sub local_irq_disable () {
        eval q( &__cli());
    }' unless defined(&local_irq_disable);
    eval 'sub local_irq_enable () {
        eval q( &__sti());
    }' unless defined(&local_irq_enable);
    if(defined(&CONFIG_SMP)) {
	eval 'sub cli () {
	    eval q( &__global_cli());
	}' unless defined(&cli);
	eval 'sub sti () {
	    eval q( &__global_sti());
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q((($x)= &__global_save_flags()));
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q( &__global_restore_flags($x));
	}' unless defined(&restore_flags);
    } else {
	eval 'sub cli () {
	    eval q( &__cli());
	}' unless defined(&cli);
	eval 'sub sti () {
	    eval q( &__sti());
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q( &__save_flags($x));
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q( &__restore_flags($x));
	}' unless defined(&restore_flags);
    }
    eval 'sub icebp () {
        eval q( &asm  &volatile(\\"xchg %%bx,%%bx\\" ::: \\"ebx\\"));
    }' unless defined(&icebp);
    eval 'sub HAVE_DISABLE_HLT () {1;}' unless defined(&HAVE_DISABLE_HLT);
}
1;
