#!/bin/bash
########################################################################
# If not defined, we've yum issues.
# If no file, set to 'point release'
#    for beta this file is packaged within sl-release so this never executes
# If yum-conf-7x is installed and we are not in beta, the file already exists
#    so there is nothing to do
########################################################################
SELFCOPIES=${1:-0}
TRIGGERCOPIES=${2:-0}
########################################################################
if [[ ! -f /etc/yum/vars/slreleasever ]]; then
    if [[ ! -d /etc/yum/vars/ ]]; then
        /usr/bin/mkdir -p /etc/yum/vars/
        /usr/bin/chmod 755 /etc/yum/vars/
    fi
    echo 7.3 > /etc/yum/vars/slreleasever
    /usr/bin/chmod 644 /etc/yum/vars/slreleasever
fi

# Make sure metadata looks like we expect, so we should expire
# any existing repomd.xml files but not necessarily the primary.sqlite
THISFILE=$(mktemp)
echo  '#!/bin/bash' > ${THISFILE}
echo  "yum clean expire-cache" >> ${THISFILE}
echo  "rm -rf /tmp/nohup.out" >> ${THISFILE}
echo  "rm -rf ${THISFILE}" >> ${THISFILE}
/usr/bin/chmod 755 ${THISFILE}
(cd /tmp
 nohup ${THISFILE} &
) >/dev/null 2>&1

