require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_RWSEM_H)) {
    eval 'sub _I386_RWSEM_H () {1;}' unless defined(&_I386_RWSEM_H);
    unless(defined(&_LINUX_RWSEM_H)) {
	die("please don't include asm/rwsem.h directly, use linux/rwsem.h instead");
    }
    if(defined(&__KERNEL__)) {
	require 'linux/list.ph';
	require 'linux/spinlock.ph';
	require 'linux/lockdep.ph';
	eval 'sub RWSEM_UNLOCKED_VALUE () {0x;}' unless defined(&RWSEM_UNLOCKED_VALUE);
	eval 'sub RWSEM_ACTIVE_BIAS () {0x1;}' unless defined(&RWSEM_ACTIVE_BIAS);
	eval 'sub RWSEM_ACTIVE_MASK () {0xffff;}' unless defined(&RWSEM_ACTIVE_MASK);
	eval 'sub RWSEM_WAITING_BIAS () {(-0x10000);}' unless defined(&RWSEM_WAITING_BIAS);
	eval 'sub RWSEM_ACTIVE_READ_BIAS () { &RWSEM_ACTIVE_BIAS;}' unless defined(&RWSEM_ACTIVE_READ_BIAS);
	eval 'sub RWSEM_ACTIVE_WRITE_BIAS () {( &RWSEM_WAITING_BIAS +  &RWSEM_ACTIVE_BIAS);}' unless defined(&RWSEM_ACTIVE_WRITE_BIAS);
	if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	}
	if(defined(&CONFIG_DEBUG_LOCK_ALLOC)) {
	    eval 'sub __RWSEM_DEP_MAP_INIT {
	        my($lockname) = @_;
    		eval q(, . &dep_map = { . &name = $lockname });
	    }' unless defined(&__RWSEM_DEP_MAP_INIT);
	} else {
	    eval 'sub __RWSEM_DEP_MAP_INIT {
	        my($lockname) = @_;
    		eval q();
	    }' unless defined(&__RWSEM_DEP_MAP_INIT);
	}
	eval 'sub __RWSEM_INITIALIZER {
	    my($name) = @_;
    	    eval q({  &RWSEM_UNLOCKED_VALUE,  &SPIN_LOCK_UNLOCKED,  &LIST_HEAD_INIT(($name). &wait_list)  &__RWSEM_DEP_MAP_INIT($name) });
	}' unless defined(&__RWSEM_INITIALIZER);
	eval 'sub DECLARE_RWSEM {
	    my($name) = @_;
    	    eval q(1;
	}' unless defined(&DECLARE_RWSEM);
	eval 'sub init_rwsem {
	    my($sem) = @_;
    	    eval q( &do {  &static 1;  &__init_rwsem(($sem), $sem, & &__key); }  &while (0));
	}' unless defined(&init_rwsem);
	eval 'sub __down_write {
	    my($sem) = @_;
    	    eval q({  &__down_write_nested($sem, 0); });
	}' unless defined(&__down_write);
	eval 'sub rwsem_is_locked {
	    my($sem) = @_;
    	    eval q({ ( ($sem->{count}) != 0); });
	}' unless defined(&rwsem_is_locked);
    }
}
1;
