require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&X86_64_PDA_H)) {
    eval 'sub X86_64_PDA_H () {1;}' unless defined(&X86_64_PDA_H);
    require 'linux/stddef.ph';
    unless(defined(&ASM_OFFSET_H)) {
	require 'asm/offset.ph';
    }
    eval 'sub PDA_STACKOFFSET () {(5*8);}' unless defined(&PDA_STACKOFFSET);
    eval 'sub IRQSTACK_ORDER () {2;}' unless defined(&IRQSTACK_ORDER);
    eval 'sub IRQSTACKSIZE () {( &PAGE_SIZE <<  &IRQSTACK_ORDER);}' unless defined(&IRQSTACKSIZE);
    eval 'sub sizeof_field {
        my($type,$field) = @_;
	    eval q(($sizeof{(($type )0)->$field}));
    }' unless defined(&sizeof_field);
    eval 'sub typeof_field {
        my($type,$field) = @_;
	    eval q( &typeof((($type *)0)->$field));
    }' unless defined(&typeof_field);
    unless(defined(&__STR)) {
	eval 'sub __STR {
	    my($x) = @_;
    	    eval q($x);
	}' unless defined(&__STR);
    }
    eval 'sub __STR2 {
        my($x) = @_;
	    eval q( &__STR($x));
    }' unless defined(&__STR2);
    eval 'sub pda_to_op {
        my($op,$field,$val) = @_;
	    eval q( &do {  &switch ( &sizeof_field(\'struct x8664_pda\', $field)) {  &case 2:  &asm  &volatile($op \\"w %0,%%gs:\\"  &__STR2( &pda_  $field) ::\\"r\\" ($val):\\"memory\\");  &break;  &case 4:  &asm  &volatile($op \\"l %0,%%gs:\\"  &__STR2( &pda_  $field) ::\\"r\\" ($val):\\"memory\\");  &break;  &case 8:  &asm  &volatile($op \\"q %0,%%gs:\\"  &__STR2( &pda_  $field) ::\\"r\\" ($val):\\"memory\\");  &break;  &default:  &__bad_pda_field(); } }  &while (0));
    }' unless defined(&pda_to_op);
    eval 'sub pda_from_op {
        my($op,$field) = @_;
	    eval q(({  &typedef  &typeof_field(\'struct x8664_pda\', $field)  &T__;  &T__  &ret__;  &switch ( &sizeof_field(\'struct x8664_pda\', $field)) {  &case 2:  &asm  &volatile($op \\"w %%gs:\\"  &__STR2( &pda_  $field) \\",%0\\":\\"=r\\" ( &ret__)::\\"memory\\");  &break;  &case 4:  &asm  &volatile($op \\"l %%gs:\\"  &__STR2( &pda_  $field) \\",%0\\":\\"=r\\" ( &ret__)::\\"memory\\");  &break;  &case 8:  &asm  &volatile($op \\"q %%gs:\\"  &__STR2( &pda_  $field) \\",%0\\":\\"=r\\" ( &ret__)::\\"memory\\");  &break;  &default:  &__bad_pda_field(); }  &ret__; }));
    }' unless defined(&pda_from_op);
    eval 'sub read_pda {
        my($field) = @_;
	    eval q( &pda_from_op(\\"mov\\",$field));
    }' unless defined(&read_pda);
    eval 'sub write_pda {
        my($field,$val) = @_;
	    eval q( &pda_to_op(\\"mov\\",$field,$val));
    }' unless defined(&write_pda);
    eval 'sub add_pda {
        my($field,$val) = @_;
	    eval q( &pda_to_op(\\"add\\",$field,$val));
    }' unless defined(&add_pda);
    eval 'sub sub_pda {
        my($field,$val) = @_;
	    eval q( &pda_to_op(\\"sub\\",$field,$val));
    }' unless defined(&sub_pda);
}
1;
