require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_X86_64_PROCESSOR_H)) {
    eval 'sub __ASM_X86_64_PROCESSOR_H () {1;}' unless defined(&__ASM_X86_64_PROCESSOR_H);
    require 'asm/segment.ph';
    require 'asm/page.ph';
    require 'asm/types.ph';
    require 'asm/sigcontext.ph';
    require 'asm/cpufeature.ph';
    require 'linux/config.ph';
    require 'linux/threads.ph';
    require 'asm/msr.ph';
    require 'asm/current.ph';
    require 'asm/system.ph';
    eval 'sub TF_MASK () {0x100;}' unless defined(&TF_MASK);
    eval 'sub IF_MASK () {0x200;}' unless defined(&IF_MASK);
    eval 'sub IOPL_MASK () {0x3000;}' unless defined(&IOPL_MASK);
    eval 'sub NT_MASK () {0x4000;}' unless defined(&NT_MASK);
    eval 'sub VM_MASK () {0x20000;}' unless defined(&VM_MASK);
    eval 'sub AC_MASK () {0x40000;}' unless defined(&AC_MASK);
    eval 'sub VIF_MASK () {0x80000;}' unless defined(&VIF_MASK);
    eval 'sub VIP_MASK () {0x100000;}' unless defined(&VIP_MASK);
    eval 'sub ID_MASK () {0x200000;}' unless defined(&ID_MASK);
    eval 'sub current_text_addr () {
        eval q(({  &void * &pc;  &asm  &volatile(\\"leaq 1f(%%rip),%0\\\\n1:\\":\\"=r\\"( &pc));  &pc; }));
    }' unless defined(&current_text_addr);
    eval 'sub X86_VENDOR_INTEL () {0;}' unless defined(&X86_VENDOR_INTEL);
    eval 'sub X86_VENDOR_CYRIX () {1;}' unless defined(&X86_VENDOR_CYRIX);
    eval 'sub X86_VENDOR_AMD () {2;}' unless defined(&X86_VENDOR_AMD);
    eval 'sub X86_VENDOR_UMC () {3;}' unless defined(&X86_VENDOR_UMC);
    eval 'sub X86_VENDOR_NEXGEN () {4;}' unless defined(&X86_VENDOR_NEXGEN);
    eval 'sub X86_VENDOR_CENTAUR () {5;}' unless defined(&X86_VENDOR_CENTAUR);
    eval 'sub X86_VENDOR_RISE () {6;}' unless defined(&X86_VENDOR_RISE);
    eval 'sub X86_VENDOR_TRANSMETA () {7;}' unless defined(&X86_VENDOR_TRANSMETA);
    eval 'sub X86_VENDOR_UNKNOWN () {0xff;}' unless defined(&X86_VENDOR_UNKNOWN);
    if(defined(&CONFIG_SMP)) {
	eval 'sub current_cpu_data () { $cpu_data[ &smp_processor_id()];}' unless defined(&current_cpu_data);
    } else {
	eval 'sub cpu_data () { &boot_cpu_data;}' unless defined(&cpu_data);
	eval 'sub current_cpu_data () { &boot_cpu_data;}' unless defined(&current_cpu_data);
    }
    eval 'sub cpu_has_pge () {1;}' unless defined(&cpu_has_pge);
    eval 'sub cpu_has_pse () {1;}' unless defined(&cpu_has_pse);
    eval 'sub cpu_has_pae () {1;}' unless defined(&cpu_has_pae);
    eval 'sub cpu_has_tsc () {1;}' unless defined(&cpu_has_tsc);
    eval 'sub cpu_has_de () {1;}' unless defined(&cpu_has_de);
    eval 'sub cpu_has_vme () {1;}' unless defined(&cpu_has_vme);
    eval 'sub cpu_has_fxsr () {1;}' unless defined(&cpu_has_fxsr);
    eval 'sub cpu_has_xmm () {1;}' unless defined(&cpu_has_xmm);
    eval 'sub cpu_has_apic () {1;}' unless defined(&cpu_has_apic);
    eval 'sub X86_EFLAGS_CF () {0x1;}' unless defined(&X86_EFLAGS_CF);
    eval 'sub X86_EFLAGS_PF () {0x4;}' unless defined(&X86_EFLAGS_PF);
    eval 'sub X86_EFLAGS_AF () {0x10;}' unless defined(&X86_EFLAGS_AF);
    eval 'sub X86_EFLAGS_ZF () {0x40;}' unless defined(&X86_EFLAGS_ZF);
    eval 'sub X86_EFLAGS_SF () {0x80;}' unless defined(&X86_EFLAGS_SF);
    eval 'sub X86_EFLAGS_TF () {0x100;}' unless defined(&X86_EFLAGS_TF);
    eval 'sub X86_EFLAGS_IF () {0x200;}' unless defined(&X86_EFLAGS_IF);
    eval 'sub X86_EFLAGS_DF () {0x400;}' unless defined(&X86_EFLAGS_DF);
    eval 'sub X86_EFLAGS_OF () {0x800;}' unless defined(&X86_EFLAGS_OF);
    eval 'sub X86_EFLAGS_IOPL () {0x3000;}' unless defined(&X86_EFLAGS_IOPL);
    eval 'sub X86_EFLAGS_NT () {0x4000;}' unless defined(&X86_EFLAGS_NT);
    eval 'sub X86_EFLAGS_RF () {0x10000;}' unless defined(&X86_EFLAGS_RF);
    eval 'sub X86_EFLAGS_VM () {0x20000;}' unless defined(&X86_EFLAGS_VM);
    eval 'sub X86_EFLAGS_AC () {0x40000;}' unless defined(&X86_EFLAGS_AC);
    eval 'sub X86_EFLAGS_VIF () {0x80000;}' unless defined(&X86_EFLAGS_VIF);
    eval 'sub X86_EFLAGS_VIP () {0x100000;}' unless defined(&X86_EFLAGS_VIP);
    eval 'sub X86_EFLAGS_ID () {0x200000;}' unless defined(&X86_EFLAGS_ID);
    eval 'sub cpuid_ebx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_ebx);
    eval 'sub cpuid_ecx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_ecx);
    eval 'sub cpuid_edx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_edx);
    eval 'sub X86_CR4_VME () {0x1;}' unless defined(&X86_CR4_VME);
    eval 'sub X86_CR4_PVI () {0x2;}' unless defined(&X86_CR4_PVI);
    eval 'sub X86_CR4_TSD () {0x4;}' unless defined(&X86_CR4_TSD);
    eval 'sub X86_CR4_DE () {0x8;}' unless defined(&X86_CR4_DE);
    eval 'sub X86_CR4_PSE () {0x10;}' unless defined(&X86_CR4_PSE);
    eval 'sub X86_CR4_PAE () {0x20;}' unless defined(&X86_CR4_PAE);
    eval 'sub X86_CR4_MCE () {0x40;}' unless defined(&X86_CR4_MCE);
    eval 'sub X86_CR4_PGE () {0x80;}' unless defined(&X86_CR4_PGE);
    eval 'sub X86_CR4_PCE () {0x100;}' unless defined(&X86_CR4_PCE);
    eval 'sub X86_CR4_OSFXSR () {0x200;}' unless defined(&X86_CR4_OSFXSR);
    eval 'sub X86_CR4_OSXMMEXCPT () {0x400;}' unless defined(&X86_CR4_OSXMMEXCPT);
    eval 'sub set_in_cr4 {
        my($mask) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&set_in_cr4);
    eval 'sub clear_in_cr4 {
        my($mask) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&clear_in_cr4);
    eval 'sub CX86_CCR0 () {0xc0;}' unless defined(&CX86_CCR0);
    eval 'sub CX86_CCR1 () {0xc1;}' unless defined(&CX86_CCR1);
    eval 'sub CX86_CCR2 () {0xc2;}' unless defined(&CX86_CCR2);
    eval 'sub CX86_CCR3 () {0xc3;}' unless defined(&CX86_CCR3);
    eval 'sub CX86_CCR4 () {0xe8;}' unless defined(&CX86_CCR4);
    eval 'sub CX86_CCR5 () {0xe9;}' unless defined(&CX86_CCR5);
    eval 'sub CX86_CCR6 () {0xea;}' unless defined(&CX86_CCR6);
    eval 'sub CX86_CCR7 () {0xeb;}' unless defined(&CX86_CCR7);
    eval 'sub CX86_DIR0 () {0xfe;}' unless defined(&CX86_DIR0);
    eval 'sub CX86_DIR1 () {0xff;}' unless defined(&CX86_DIR1);
    eval 'sub CX86_ARR_BASE () {0xc4;}' unless defined(&CX86_ARR_BASE);
    eval 'sub CX86_RCR_BASE () {0xdc;}' unless defined(&CX86_RCR_BASE);
    eval 'sub getCx86 {
        my($reg) = @_;
	    eval q(({  &outb(($reg), 0x22);  &inb(0x23); }));
    }' unless defined(&getCx86);
    eval 'sub setCx86 {
        my($reg, $data) = @_;
	    eval q( &do {  &outb(($reg), 0x22);  &outb(($data), 0x23); }  &while (0));
    }' unless defined(&setCx86);
    eval 'sub EISA_bus () {0;}' unless defined(&EISA_bus);
    eval 'sub MCA_bus () {0;}' unless defined(&MCA_bus);
    eval 'sub MCA_bus__is_a_macro () {1;}' unless defined(&MCA_bus__is_a_macro);
    eval 'sub TASK_SIZE () {(0x7fc0000000);}' unless defined(&TASK_SIZE);
    eval 'sub TASK_UNMAPPED_32 () {0x40000000;}' unless defined(&TASK_UNMAPPED_32);
    eval 'sub TASK_UNMAPPED_64 () {( &TASK_SIZE/3);}' unless defined(&TASK_UNMAPPED_64);
    eval 'sub TASK_UNMAPPED_BASE () {(( ($current->{thread}->{flags}) &  &THREAD_IA32) ?  &TASK_UNMAPPED_32 :  &TASK_UNMAPPED_64);}' unless defined(&TASK_UNMAPPED_BASE);
    eval 'sub IO_BITMAP_SIZE () {32;}' unless defined(&IO_BITMAP_SIZE);
    eval 'sub IO_BITMAP_OFFSET () { &offsetof(\'struct tss_struct\', &io_bitmap);}' unless defined(&IO_BITMAP_OFFSET);
    eval 'sub INVALID_IO_BITMAP_OFFSET () {0x8000;}' unless defined(&INVALID_IO_BITMAP_OFFSET);
    eval("sub THREAD_IA32 () { 0x0001; }") unless defined(&THREAD_IA32);
    eval 'sub INIT_THREAD () {{  &debugreg: { [0... 7] = 0}, };}' unless defined(&INIT_THREAD);
    eval 'sub INIT_MMAP () {{  &init_mm, 0, 0,  &NULL,  &PAGE_SHARED,  &VM_READ |  &VM_WRITE |  &VM_EXEC, 1,  &NULL,  &NULL };}' unless defined(&INIT_MMAP);
    eval 'sub STACKFAULT_STACK () {1;}' unless defined(&STACKFAULT_STACK);
    eval 'sub DOUBLEFAULT_STACK () {2;}' unless defined(&DOUBLEFAULT_STACK);
    eval 'sub NMI_STACK () {3;}' unless defined(&NMI_STACK);
    eval 'sub N_EXCEPTION_STACKS () {3;}' unless defined(&N_EXCEPTION_STACKS);
    eval 'sub EXCEPTION_STKSZ () {1024;}' unless defined(&EXCEPTION_STKSZ);
    eval 'sub start_thread {
        my($regs,$new_rip,$new_rsp) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&start_thread);
    eval 'sub KSTK_EIP {
        my($tsk) = @_;
	    eval q(((( ($tsk->{thread}->{rsp0}) - $sizeof{\'struct pt_regs\'}))-> &rip));
    }' unless defined(&KSTK_EIP);
    eval 'sub KSTK_ESP {
        my($tsk) = @_;
	    eval q(-1);
    }' unless defined(&KSTK_ESP);
    eval 'sub alloc_task_struct () {
        eval q((  &__get_free_pages( &GFP_KERNEL,1)));
    }' unless defined(&alloc_task_struct);
    eval 'sub free_task_struct {
        my($p) = @_;
	    eval q( &free_pages( ($p), 1));
    }' unless defined(&free_task_struct);
    eval 'sub get_task_struct {
        my($tsk) = @_;
	    eval q( &atomic_inc( &virt_to_page($tsk)-> &count));
    }' unless defined(&get_task_struct);
    eval 'sub init_task () {( ($init_task_union->{task}));}' unless defined(&init_task);
    eval 'sub init_stack () {( ($init_task_union->{stack}));}' unless defined(&init_stack);
    eval 'sub cpu_has_fpu () {1;}' unless defined(&cpu_has_fpu);
    eval 'sub ARCH_HAS_PREFETCH () {1;}' unless defined(&ARCH_HAS_PREFETCH);
    eval 'sub ARCH_HAS_PREFETCHW () {1;}' unless defined(&ARCH_HAS_PREFETCHW);
    eval 'sub ARCH_HAS_SPINLOCK_PREFETCH () {1;}' unless defined(&ARCH_HAS_SPINLOCK_PREFETCH);
    eval 'sub prefetch {
        my($x) = @_;
	    eval q( &__builtin_prefetch(($x),0));
    }' unless defined(&prefetch);
    eval 'sub prefetchw {
        my($x) = @_;
	    eval q( &__builtin_prefetch(($x),1));
    }' unless defined(&prefetchw);
    eval 'sub spin_lock_prefetch {
        my($x) = @_;
	    eval q( &prefetchw($x));
    }' unless defined(&spin_lock_prefetch);
    eval 'sub cpu_relax () {
        eval q( &rep_nop());
    }' unless defined(&cpu_relax);
}
1;
