# To get a package list without version numbers from a target system
# rpm -qa --qf "%{n} " > packages.txt
# Put contents of packages.txt after "-y install \" line below

rm -rf /ostemplate ; mkdir /ostemplate
mkdir -p /ostemplate/etc/yum/vars/ ; cp /etc/yum/vars/releasever /etc/yum/vars/slreleasever /ostemplate/etc/yum/vars/

yum -y install --nogpg \
--disablerepo=* --enablerepo=sl --enablerepo=sl-security --enablerepo=sl-fastbugs \
--installroot /ostemplate \
openssh-server yum yum-utils man wget sudo tar passwd vim-minimal net-tools sl-release net-tools initscripts openssh-clients yum-conf-sl7x

# Do some cleanup
rm -rf /ostemplate/var/cache/yum/x86_64

# Copy our script and related files
cp /root/create-sl7*.sh /ostemplate/root/

ln -sf /proc/mounts /ostemplate/etc/mtab
touch /ostemplate/etc/fstab

# I want Mountain time to be the default
ln -sf /usr/share/zoneinfo/America/Denver /ostemplate/etc/localtime

# Now compress that sucker, assumes you have xz installed
cd /ostemplate ; tar -cvJf /root/scientific-7-x86_64-minimal-$(date +%Y%m%d).tar.xz . ; cd
ls -lh /root/scientific-7-x86_64-minimal-$(date +%Y%m%d).tar.xz
echo "Done building OS Template.  Now test it."
