UPDATESIMG=/tmp/product.img
MNTPOINT=/tmp/productimg
PRODUCTDIR=../product.img.dir
if [ ! -d $PRODUCTDIR ] ; then
  echo "You do not have $PRODUCTDIR, so skipping creation of product.img"
  exit
else
  echo "You have $PRODUCTDIR so creating product.img"
fi
IMAGESIZE=`du -s $PRODUCTDIR | cut -f1`
if [ $IMAGESIZE -le 65 ] ; then
	echo "Image was too small so had to make it bigger"
	IMAGESIZE=65
fi
echo $IMAGESIZE
dd if=/dev/zero of=$UPDATESIMG bs=1k count=$IMAGESIZE 
/sbin/mke2fs -F -q -i 1024 -b 1024 $UPDATESIMG $IMAGESIZE
rm -rf $MNTPOINT
mkdir $MNTPOINT
mount -o loop -t ext2 $UPDATESIMG $MNTPOINT
/bin/rm -r $MNTPOINT/lost+found
(cd $PRODUCTDIR ; find . | cpio -pvdum $MNTPOINT)
umount $MNTPOINT
if [ -f ../../base/stage2.img ]; then
    mount -o loop ../../base/stage2.img $MNTPOINT
    cp $MNTPOINT/.buildstamp /tmp/.buildstamp
    umount $MNTPOINT
fi
mount -o loop -t ext2 $UPDATESIMG $MNTPOINT
cp /tmp/.buildstamp $MNTPOINT/.buildstamp
umount $MNTPOINT
cp -v $UPDATESIMG ../../base 
