/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include "model/SlsPageEnumerationProvider.hxx"
#include "model/SlsPageEnumeration.hxx"
#include "model/SlsPageDescriptor.hxx"
#include <boost/function.hpp>

namespace sd { namespace slidesorter { namespace model {

namespace {

class AllPagesPredicate
{
public:
    bool operator() (const SharedPageDescriptor& rpDescriptor) const
    {
        (void)rpDescriptor;
        return true;
    }
};

class SelectedPagesPredicate
{
public:
    bool operator() (const SharedPageDescriptor& rpDescriptor)
    {
        return rpDescriptor->HasState(PageDescriptor::ST_Selected);
    }
};

class VisiblePagesPredicate
{
public:
    bool operator() (const SharedPageDescriptor& rpDescriptor)
    {
        return rpDescriptor->HasState(PageDescriptor::ST_Visible);
    }
};

}

PageEnumeration PageEnumerationProvider::CreateAllPagesEnumeration (
    const SlideSorterModel& rModel)
{
    return PageEnumeration::Create(rModel, AllPagesPredicate());
}

PageEnumeration PageEnumerationProvider::CreateSelectedPagesEnumeration (
    const SlideSorterModel& rModel)
{
    return PageEnumeration::Create(
        rModel,
        SelectedPagesPredicate());
}

PageEnumeration PageEnumerationProvider::CreateVisiblePagesEnumeration (
    const SlideSorterModel& rModel)
{
    return PageEnumeration::Create(
        rModel,
        VisiblePagesPredicate());
}

} } } // end of namespace ::sd::slidesorter::model

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
