# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

include $(SRCDIR)/vcl/commonfuzzer.mk

$(eval $(call gb_Executable_Executable,metfuzzer))

$(eval $(call gb_Executable_use_api,metfuzzer,\
    offapi \
    udkapi \
))

$(eval $(call gb_Executable_use_externals,metfuzzer,\
	$(fuzzer_externals) \
))

$(eval $(call gb_Executable_set_include,metfuzzer,\
    $$(INCLUDE) \
    -I$(SRCDIR)/vcl/inc \
))

$(eval $(call gb_Executable_use_libraries,metfuzzer,\
	$(fuzzer_libraries) \
))

$(eval $(call gb_Executable_use_static_libraries,metfuzzer,\
    findsofficepath \
    ulingu \
    fuzzer \
))

$(eval $(call gb_Executable_add_exception_objects,metfuzzer,\
	vcl/workben/metfuzzer \
))

$(eval $(call gb_Executable_add_libs,metfuzzer,\
	-lFuzzingEngine \
))

# vim: set noet sw=4 ts=4:
