/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_VCL_SOURCE_PDF_BUILDIN_FONTS_HXX
#define INCLUDED_VCL_SOURCE_PDF_BUILDIN_FONTS_HXX

#include <PhysicalFontFace.hxx>
#include <fontinstance.hxx>

namespace vcl::pdf
{
struct BuildinFont
{
    const char* m_pName;
    const char* m_pStyleName;
    const char* m_pPSName;
    int const m_nAscent;
    int const m_nDescent;
    FontFamily const m_eFamily;
    rtl_TextEncoding const m_eCharSet;
    FontPitch const m_ePitch;
    FontWidth const m_eWidthType;
    FontWeight const m_eWeight;
    FontItalic const m_eItalic;
    int const m_aWidths[256];
    mutable FontCharMapRef m_xFontCharMap;

    OString getNameObject() const;
    const FontCharMapRef& GetFontCharMap() const;
    FontAttributes GetFontAttributes() const;
};

class BuildinFontInstance final : public LogicalFontInstance
{
    bool ImplGetGlyphBoundRect(sal_GlyphId nID, tools::Rectangle& rRect, bool) const override;

public:
    BuildinFontInstance(const PhysicalFontFace&, const FontSelectPattern&);

    bool GetGlyphOutline(sal_GlyphId nId, basegfx::B2DPolyPolygon& rPoly, bool) const override;
};

class BuildinFontFace final : public PhysicalFontFace
{
    static const BuildinFont m_aBuildinFonts[14];
    const BuildinFont& mrBuildin;

    rtl::Reference<LogicalFontInstance>
    CreateFontInstance(const FontSelectPattern& rFSD) const override;

public:
    explicit BuildinFontFace(int nId);

    const BuildinFont& GetBuildinFont() const { return mrBuildin; }
    sal_IntPtr GetFontId() const override { return reinterpret_cast<sal_IntPtr>(&mrBuildin); }
    FontCharMapRef GetFontCharMap() const override { return mrBuildin.GetFontCharMap(); }
    bool GetFontCapabilities(vcl::FontCapabilities&) const override { return false; }

    static const BuildinFont& Get(int nId) { return m_aBuildinFonts[nId]; }
};

} // namespace vcl::pdf

#endif // INCLUDED_VCL_SOURCE_PDF_BUILDIN_FONTS_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
