/* Copyright (C) 2001-2012 Artifex Software, Inc.
   All Rights Reserved.

   This software is provided AS-IS with no warranty, either express or
   implied.

   This software is distributed under license and may not be copied,
   modified or distributed except as expressly authorized under the terms
   of the license contained in the file LICENSE in this distribution.

   Refer to licensing information at http://www.artifex.com or contact
   Artifex Software, Inc.,  7 Mt. Lassen Drive - Suite A-134, San Rafael,
   CA  94903, U.S.A., +1(415)492-9861, for further information.
*/

/* pxsymbol.c */
/* PCL XL symbol set mapping definitions */

#include "pxsymbol.h"

typedef enum {
  pxg__notdef = 0,
  pxg_Aacute,
  pxg_Atilde,
  pxg_Aring,
  pxg_Alpha,
  pxg_AE,
  pxg_Agrave,
  pxg_Acircumflex,
  pxg_Adieresis,
  pxg_Aacutesmall,
  pxg_Acircumflexsmall,
  pxg_Atildesmall,
  pxg_Agravesmall,
  pxg_Adieresissmall,
  pxg_Aringsmall,
  pxg_Asmall,
  pxg_AEsmall,
  pxg_Acutesmall,
  pxg_A,
  pxg_Beta,
  pxg_Brevesmall,
  pxg_Bsmall,
  pxg_B,
  pxg_Chi,
  pxg_Ccedilla,
  pxg_Circumflexsmall,
  pxg_Ccedillasmall,
  pxg_Cedillasmall,
  pxg_Csmall,
  pxg_Caronsmall,
  pxg_C,
  pxg_Delta,
  pxg_Dotaccentsmall,
  pxg_Dieresissmall,
  pxg_Dsmall,
  pxg_D,
  pxg_Eta,
  pxg_Egrave,
  pxg_Ecircumflex,
  pxg_Eth,
  pxg_Epsilon,
  pxg_Eacute,
  pxg_Edieresis,
  pxg_Egravesmall,
  pxg_Edieresissmall,
  pxg_Ethsmall,
  pxg_Eacutesmall,
  pxg_Ecircumflexsmall,
  pxg_Esmall,
  pxg_E,
  pxg_Fsmall,
  pxg_F,
  pxg_Gamma,
  pxg_Gsmall,
  pxg_Gravesmall,
  pxg_G,
  pxg_Hsmall,
  pxg_Hungarumlautsmall,
  pxg_H,
  pxg_Ifraktur,
  pxg_Iacute,
  pxg_Idieresis,
  pxg_Igrave,
  pxg_Icircumflex,
  pxg_Iota,
  pxg_Icircumflexsmall,
  pxg_Ismall,
  pxg_Igravesmall,
  pxg_Idieresissmall,
  pxg_Iacutesmall,
  pxg_I,
  pxg_Jsmall,
  pxg_J,
  pxg_Kappa,
  pxg_Ksmall,
  pxg_K,
  pxg_Lambda,
  pxg_Lslash,
  pxg_Lsmall,
  pxg_Lslashsmall,
  pxg_L,
  pxg_Mu,
  pxg_Msmall,
  pxg_Macronsmall,
  pxg_M,
  pxg_Ntilde,
  pxg_Nu,
  pxg_Ntildesmall,
  pxg_Nsmall,
  pxg_N,
  pxg_Omicron,
  pxg_Oslash,
  pxg_Oacute,
  pxg_Otilde,
  pxg_Omega,
  pxg_Ograve,
  pxg_Ocircumflex,
  pxg_Odieresis,
  pxg_OE,
  pxg_OEsmall,
  pxg_Ogravesmall,
  pxg_Odieresissmall,
  pxg_Osmall,
  pxg_Oslashsmall,
  pxg_Oacutesmall,
  pxg_Ocircumflexsmall,
  pxg_Ogoneksmall,
  pxg_Otildesmall,
  pxg_O,
  pxg_Phi,
  pxg_Psi,
  pxg_Pi,
  pxg_Psmall,
  pxg_P,
  pxg_Qsmall,
  pxg_Q,
  pxg_Rfraktur,
  pxg_Rho,
  pxg_Ringsmall,
  pxg_Rsmall,
  pxg_R,
  pxg_Sigma,
  pxg_Ssmall,
  pxg_Scaronsmall,
  pxg_Scaron,
  pxg_S,
  pxg_Theta,
  pxg_Thorn,
  pxg_Tau,
  pxg_Tsmall,
  pxg_Tildesmall,
  pxg_Thornsmall,
  pxg_T,
  pxg_Upsilon1,
  pxg_Ucircumflex,
  pxg_Upsilon,
  pxg_Uacute,
  pxg_Udieresis,
  pxg_Ugrave,
  pxg_Uacutesmall,
  pxg_Ucircumflexsmall,
  pxg_Usmall,
  pxg_Ugravesmall,
  pxg_Udieresissmall,
  pxg_U,
  pxg_Vsmall,
  pxg_V,
  pxg_Wsmall,
  pxg_W,
  pxg_Xi,
  pxg_Xsmall,
  pxg_X,
  pxg_Yacute,
  pxg_Ydieresissmall,
  pxg_Yacutesmall,
  pxg_Ysmall,
  pxg_Ydieresis,
  pxg_Y,
  pxg_Zeta,
  pxg_Zsmall,
  pxg_Zcaronsmall,
  pxg_Zcaron,
  pxg_Z,
  pxg_arrowleft,
  pxg_arrowdblboth,
  pxg_a11,
  pxg_arrowright,
  pxg_arrowdblup,
  pxg_a13,
  pxg_alpha,
  pxg_angle,
  pxg_arrowdbldown,
  pxg_a15,
  pxg_angleleft,
  pxg_a2,
  pxg_angleright,
  pxg_a4,
  pxg_approxequal,
  pxg_a119,
  pxg_a105,
  pxg_arrowboth,
  pxg_arrowhorizex,
  pxg_a117,
  pxg_arrowup,
  pxg_aleph,
  pxg_arrowdblleft,
  pxg_a12,
  pxg_arrowdown,
  pxg_arrowdblright,
  pxg_a14,
  pxg_a1,
  pxg_a3,
  pxg_a202,
  pxg_a5,
  pxg_arrowvertex,
  pxg_a118,
  pxg_a16,
  pxg_agrave,
  pxg_acircumflex,
  pxg_adieresis,
  pxg_acute,
  pxg_aacute,
  pxg_ae,
  pxg_atilde,
  pxg_aring,
  pxg_asteriskmath,
  pxg_asterisk,
  pxg_asciicircum,
  pxg_a17,
  pxg_a18,
  pxg_a19,
  pxg_a20,
  pxg_asciitilde,
  pxg_a6,
  pxg_a7,
  pxg_a8,
  pxg_a9,
  pxg_a10,
  pxg_a112,
  pxg_a111,
  pxg_a110,
  pxg_a109,
  pxg_a120,
  pxg_a121,
  pxg_a122,
  pxg_a123,
  pxg_a124,
  pxg_a125,
  pxg_a126,
  pxg_a127,
  pxg_a128,
  pxg_a129,
  pxg_a130,
  pxg_a131,
  pxg_a132,
  pxg_a133,
  pxg_a134,
  pxg_a135,
  pxg_a136,
  pxg_a137,
  pxg_a138,
  pxg_a139,
  pxg_a140,
  pxg_a141,
  pxg_a142,
  pxg_a143,
  pxg_a144,
  pxg_a145,
  pxg_a146,
  pxg_a147,
  pxg_a148,
  pxg_a149,
  pxg_a150,
  pxg_a151,
  pxg_a152,
  pxg_a153,
  pxg_a154,
  pxg_a155,
  pxg_a156,
  pxg_a157,
  pxg_a158,
  pxg_ampersand,
  pxg_at,
  pxg_asuperior,
  pxg_a159,
  pxg_a160,
  pxg_a161,
  pxg_a163,
  pxg_a164,
  pxg_a196,
  pxg_a165,
  pxg_a192,
  pxg_a166,
  pxg_ampersandsmall,
  pxg_a179,
  pxg_a198,
  pxg_a169,
  pxg_a180,
  pxg_a195,
  pxg_a171,
  pxg_a181,
  pxg_a188,
  pxg_a173,
  pxg_a182,
  pxg_a190,
  pxg_a174,
  pxg_a183,
  pxg_a176,
  pxg_a197,
  pxg_a178,
  pxg_a194,
  pxg_a168,
  pxg_a193,
  pxg_a186,
  pxg_a170,
  pxg_a199,
  pxg_a187,
  pxg_a172,
  pxg_a200,
  pxg_a189,
  pxg_a162,
  pxg_a201,
  pxg_a191,
  pxg_a175,
  pxg_a184,
  pxg_a177,
  pxg_a185,
  pxg_a167,
  pxg_a34,
  pxg_a47,
  pxg_a60,
  pxg_a73,
  pxg_a97,
  pxg_a23,
  pxg_a36,
  pxg_a49,
  pxg_a62,
  pxg_a203,
  pxg_a99,
  pxg_a25,
  pxg_a38,
  pxg_a51,
  pxg_a64,
  pxg_a204,
  pxg_a101,
  pxg_a27,
  pxg_a40,
  pxg_a53,
  pxg_a66,
  pxg_a77,
  pxg_a103,
  pxg_a29,
  pxg_a42,
  pxg_a55,
  pxg_a68,
  pxg_a79,
  pxg_a106,
  pxg_a31,
  pxg_a44,
  pxg_a57,
  pxg_a70,
  pxg_a82,
  pxg_a108,
  pxg_a33,
  pxg_a46,
  pxg_a59,
  pxg_a72,
  pxg_a84,
  pxg_a22,
  pxg_a35,
  pxg_a48,
  pxg_a61,
  pxg_a74,
  pxg_a98,
  pxg_a24,
  pxg_a37,
  pxg_a50,
  pxg_a63,
  pxg_a75,
  pxg_a100,
  pxg_a26,
  pxg_a39,
  pxg_a52,
  pxg_a65,
  pxg_a76,
  pxg_a102,
  pxg_a28,
  pxg_a41,
  pxg_a54,
  pxg_a67,
  pxg_a78,
  pxg_a,
  pxg_a104,
  pxg_a30,
  pxg_a43,
  pxg_a56,
  pxg_a69,
  pxg_a81,
  pxg_a107,
  pxg_a32,
  pxg_a45,
  pxg_a58,
  pxg_a71,
  pxg_a83,
  pxg_a21,
  pxg_bracketleftex,
  pxg_bracelefttp,
  pxg_bracketrightex,
  pxg_braceleftbt,
  pxg_bracerighttp,
  pxg_bracerightbt,
  pxg_bracketlefttp,
  pxg_bracketleftbt,
  pxg_bracketrighttp,
  pxg_beta,
  pxg_braceleftmid,
  pxg_bracketrightbt,
  pxg_braceex,
  pxg_bracerightmid,
  pxg_brokenbar,
  pxg_bullet,
  pxg_breve,
  pxg_backslash,
  pxg_bar,
  pxg_bracketleft,
  pxg_bracketright,
  pxg_braceleft,
  pxg_braceright,
  pxg_bsuperior,
  pxg_b,
  pxg_carriagereturn,
  pxg_chi,
  pxg_circleplus,
  pxg_club,
  pxg_copyrightsans,
  pxg_circlemultiply,
  pxg_copyrightserif,
  pxg_circumflex,
  pxg_caron,
  pxg_ccedilla,
  pxg_currency,
  pxg_cedilla,
  pxg_comma,
  pxg_cent,
  pxg_colon,
  pxg_commasuperior,
  pxg_centinferior,
  pxg_centsuperior,
  pxg_commainferior,
  pxg_colonmonetary,
  pxg_centoldstyle,
  pxg_copyright,
  pxg_congruent,
  pxg_c,
  pxg_dotmath,
  pxg_delta,
  pxg_diamond,
  pxg_divide,
  pxg_dotaccent,
  pxg_dotlessi,
  pxg_degree,
  pxg_dieresis,
  pxg_dagger,
  pxg_daggerdbl,
  pxg_dollar,
  pxg_dollarinferior,
  pxg_dsuperior,
  pxg_dollarsuperior,
  pxg_dollaroldstyle,
  pxg_d,
  pxg_element,
  pxg_epsilon,
  pxg_emptyset,
  pxg_equivalence,
  pxg_eta,
  pxg_endash,
  pxg_emdash,
  pxg_ecircumflex,
  pxg_ellipsis,
  pxg_eth,
  pxg_eacute,
  pxg_edieresis,
  pxg_existential,
  pxg_egrave,
  pxg_exclam,
  pxg_equal,
  pxg_eight,
  pxg_exclamdown,
  pxg_eightsuperior,
  pxg_eightoldstyle,
  pxg_eightinferior,
  pxg_exclamdownsmall,
  pxg_esuperior,
  pxg_exclamsmall,
  pxg_e,
  pxg_fl,
  pxg_fraction,
  pxg_florin,
  pxg_fi,
  pxg_five,
  pxg_four,
  pxg_ffi,
  pxg_fourinferior,
  pxg_fivesuperior,
  pxg_fiveeighths,
  pxg_ff,
  pxg_ffl,
  pxg_figuredash,
  pxg_foursuperior,
  pxg_fiveinferior,
  pxg_fouroldstyle,
  pxg_fiveoldstyle,
  pxg_f,
  pxg_gamma,
  pxg_greaterequal,
  pxg_gradient,
  pxg_grave,
  pxg_guillemotleft,
  pxg_germandbls,
  pxg_guillemotright,
  pxg_guilsinglleft,
  pxg_guilsinglright,
  pxg_greater,
  pxg_guilsingleft,
  pxg_guilsingright,
  pxg_g,
  pxg_heart,
  pxg_hungarumlaut,
  pxg_hyphen,
  pxg_hyphensuperior,
  pxg_hypheninferior,
  pxg_h,
  pxg_intersection,
  pxg_integraltp,
  pxg_iota,
  pxg_integralbt,
  pxg_infinity,
  pxg_integral,
  pxg_integralex,
  pxg_igrave,
  pxg_icircumflex,
  pxg_iacute,
  pxg_idieresis,
  pxg_isuperior,
  pxg_i,
  pxg_j,
  pxg_kappa,
  pxg_k,
  pxg_lambda,
  pxg_lessequal,
  pxg_logicalor,
  pxg_lozenge,
  pxg_logicaland,
  pxg_logicalnot,
  pxg_lslash,
  pxg_less,
  pxg_lsuperior,
  pxg_l,
  pxg_minute,
  pxg_macron,
  pxg_multiply,
  pxg_minus,
  pxg_mu,
  pxg_msuperior,
  pxg_m,
  pxg_notequal,
  pxg_notsubset,
  pxg_nu,
  pxg_notelement,
  pxg_ntilde,
  pxg_nine,
  pxg_numbersign,
  pxg_nineoldstyle,
  pxg_nineinferior,
  pxg_ninesuperior,
  pxg_nsuperior,
  pxg_n,
  pxg_omicron,
  pxg_omega,
  pxg_omega1,
  pxg_ordfeminine,
  pxg_ordmasculine,
  pxg_onesuperior,
  pxg_onehalf,
  pxg_ograve,
  pxg_ogonek,
  pxg_oacute,
  pxg_onequarter,
  pxg_ocircumflex,
  pxg_otilde,
  pxg_odieresis,
  pxg_oslash,
  pxg_oe,
  pxg_one,
  pxg_oneeighth,
  pxg_onefitted,
  pxg_onethird,
  pxg_osuperior,
  pxg_oneinferior,
  pxg_onedotenleader,
  pxg_oneoldstyle,
  pxg_o,
  pxg_phi1,
  pxg_propersubset,
  pxg_parenleftbt,
  pxg_parenrighttp,
  pxg_perpendicular,
  pxg_parenrightbt,
  pxg_proportional,
  pxg_propersuperset,
  pxg_parenleftex,
  pxg_psi,
  pxg_parenrightex,
  pxg_pi,
  pxg_partialdiff,
  pxg_phi,
  pxg_parenlefttp,
  pxg_paragraph,
  pxg_plusminus,
  pxg_periodcentered,
  pxg_parenleft,
  pxg_perthousand,
  pxg_period,
  pxg_percent,
  pxg_periodsuperior,
  pxg_parenright,
  pxg_plus,
  pxg_periodinferior,
  pxg_parenleftinferior,
  pxg_parenrightinferior,
  pxg_parenleftsuperior,
  pxg_parenrightsuperior,
  pxg_product,
  pxg_p,
  pxg_questiondown,
  pxg_quotesingle,
  pxg_quotedblleft,
  pxg_quoteleft,
  pxg_quotesinglbase,
  pxg_quotedblbase,
  pxg_quotedblright,
  pxg_question,
  pxg_quoteright,
  pxg_quotedbl,
  pxg_questionsmall,
  pxg_questiondownsmall,
  pxg_q,
  pxg_registerserif,
  pxg_reflexsubset,
  pxg_radicalex,
  pxg_rho,
  pxg_registersans,
  pxg_radical,
  pxg_reflexsuperset,
  pxg_registered,
  pxg_ring,
  pxg_rsuperior,
  pxg_rupiah,
  pxg_r,
  pxg_second,
  pxg_sigma,
  pxg_summation,
  pxg_similar,
  pxg_spade,
  pxg_section,
  pxg_suchthat,
  pxg_sigma1,
  pxg_sterling,
  pxg_seven,
  pxg_semicolon,
  pxg_six,
  pxg_space,
  pxg_slash,
  pxg_sixinferior,
  pxg_ssuperior,
  pxg_seveninferior,
  pxg_sevensuperior,
  pxg_sixsuperior,
  pxg_seveneighths,
  pxg_sevenoldstyle,
  pxg_scaron,
  pxg_sixoldstyle,
  pxg_s,
  pxg_theta,
  pxg_trademarkserif,
  pxg_therefore,
  pxg_tau,
  pxg_trademarksans,
  pxg_threequarters,
  pxg_threesuperior,
  pxg_theta1,
  pxg_tilde,
  pxg_twosuperior,
  pxg_thorn,
  pxg_two,
  pxg_three,
  pxg_tsuperior,
  pxg_threeinferior,
  pxg_threequartersemdash,
  pxg_threeeighths,
  pxg_twoinferior,
  pxg_twothirds,
  pxg_trademark,
  pxg_twodotenleader,
  pxg_twooldstyle,
  pxg_threeoldstyle,
  pxg_t,
  pxg_upsilon,
  pxg_union,
  pxg_universal,
  pxg_ugrave,
  pxg_uacute,
  pxg_ucircumflex,
  pxg_udieresis,
  pxg_underscore,
  pxg_u,
  pxg_v,
  pxg_weierstrass,
  pxg_w,
  pxg_xi,
  pxg_x,
  pxg_yen,
  pxg_yacute,
  pxg_ydieresis,
  pxg_y,
  pxg_zeta,
  pxg_zero,
  pxg_zerosuperior,
  pxg_zeroinferior,
  pxg_zcaron,
  pxg_zerooldstyle,
  pxg_z
} px_glyph_t;

const unsigned short pxSymbolEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_universal, pxg_numbersign,
  pxg_existential, pxg_percent, pxg_ampersand, pxg_suchthat,
  pxg_parenleft, pxg_parenright, pxg_asteriskmath, pxg_plus,
  pxg_comma, pxg_minus, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_congruent, pxg_Alpha, pxg_Beta, pxg_Chi,
  pxg_Delta, pxg_Epsilon, pxg_Phi, pxg_Gamma,
  pxg_Eta, pxg_Iota, pxg_theta1, pxg_Kappa,
  pxg_Lambda, pxg_Mu, pxg_Nu, pxg_Omicron,
  pxg_Pi, pxg_Theta, pxg_Rho, pxg_Sigma,
  pxg_Tau, pxg_Upsilon, pxg_sigma1, pxg_Omega,
  pxg_Xi, pxg_Psi, pxg_Zeta, pxg_bracketleft,
  pxg_therefore, pxg_bracketright, pxg_perpendicular, pxg_underscore,
  pxg_radicalex, pxg_alpha, pxg_beta, pxg_chi,
  pxg_delta, pxg_epsilon, pxg_phi, pxg_gamma,
  pxg_eta, pxg_iota, pxg_phi1, pxg_kappa,
  pxg_lambda, pxg_mu, pxg_nu, pxg_omicron,
  pxg_pi, pxg_theta, pxg_rho, pxg_sigma,
  pxg_tau, pxg_upsilon, pxg_omega1, pxg_omega,
  pxg_xi, pxg_psi, pxg_zeta, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_similar, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_Upsilon1, pxg_minute, pxg_lessequal,
  pxg_fraction, pxg_infinity, pxg_florin, pxg_club,
  pxg_diamond, pxg_heart, pxg_spade, pxg_arrowboth,
  pxg_arrowleft, pxg_arrowup, pxg_arrowright, pxg_arrowdown,
  pxg_degree, pxg_plusminus, pxg_second, pxg_greaterequal,
  pxg_multiply, pxg_proportional, pxg_partialdiff, pxg_bullet,
  pxg_divide, pxg_notequal, pxg_equivalence, pxg_approxequal,
  pxg_ellipsis, pxg_arrowvertex, pxg_arrowhorizex, pxg_carriagereturn,
  pxg_aleph, pxg_Ifraktur, pxg_Rfraktur, pxg_weierstrass,
  pxg_circlemultiply, pxg_circleplus, pxg_emptyset, pxg_intersection,
  pxg_union, pxg_propersuperset, pxg_reflexsuperset, pxg_notsubset,
  pxg_propersubset, pxg_reflexsubset, pxg_element, pxg_notelement,
  pxg_angle, pxg_gradient, pxg_registerserif, pxg_copyrightserif,
  pxg_trademarkserif, pxg_product, pxg_radical, pxg_dotmath,
  pxg_logicalnot, pxg_logicaland, pxg_logicalor, pxg_arrowdblboth,
  pxg_arrowdblleft, pxg_arrowdblup, pxg_arrowdblright, pxg_arrowdbldown,
  pxg_lozenge, pxg_angleleft, pxg_registersans, pxg_copyrightsans,
  pxg_trademarksans, pxg_summation, pxg_parenlefttp, pxg_parenleftex,
  pxg_parenleftbt, pxg_bracketlefttp, pxg_bracketleftex, pxg_bracketleftbt,
  pxg_bracelefttp, pxg_braceleftmid, pxg_braceleftbt, pxg_braceex,
  pxg__notdef, pxg_angleright, pxg_integral, pxg_integraltp,
  pxg_integralex, pxg_integralbt, pxg_parenrighttp, pxg_parenrightex,
  pxg_parenrightbt, pxg_bracketrighttp, pxg_bracketrightex, pxg_bracketrightbt,
  pxg_bracerighttp, pxg_bracerightmid, pxg_bracerightbt, pxg__notdef,
  pxg__notdef
};

const unsigned short pxMacExpertEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclamsmall, pxg_Hungarumlautsmall, pxg_centoldstyle,
  pxg_dollaroldstyle, pxg_dollarsuperior, pxg_ampersandsmall, pxg_Acutesmall,
  pxg_parenleftsuperior, pxg_parenrightsuperior, pxg_twodotenleader, pxg_onedotenleader,
  pxg_comma, pxg_hyphen, pxg_period, pxg_fraction,
  pxg_zerooldstyle, pxg_oneoldstyle, pxg_twooldstyle, pxg_threeoldstyle,
  pxg_fouroldstyle, pxg_fiveoldstyle, pxg_sixoldstyle, pxg_sevenoldstyle,
  pxg_eightoldstyle, pxg_nineoldstyle, pxg_colon, pxg_semicolon,
  pxg__notdef, pxg_threequartersemdash, pxg__notdef, pxg_questionsmall,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_Ethsmall, pxg__notdef, pxg__notdef, pxg_onequarter,
  pxg_onehalf, pxg_threequarters, pxg_oneeighth, pxg_threeeighths,
  pxg_fiveeighths, pxg_seveneighths, pxg_onethird, pxg_twothirds,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg_ff, pxg_fi,
  pxg_fl, pxg_ffi, pxg_ffl, pxg_parenleftinferior,
  pxg__notdef, pxg_parenrightinferior, pxg_Circumflexsmall, pxg_hypheninferior,
  pxg_Gravesmall, pxg_Asmall, pxg_Bsmall, pxg_Csmall,
  pxg_Dsmall, pxg_Esmall, pxg_Fsmall, pxg_Gsmall,
  pxg_Hsmall, pxg_Ismall, pxg_Jsmall, pxg_Ksmall,
  pxg_Lsmall, pxg_Msmall, pxg_Nsmall, pxg_Osmall,
  pxg_Psmall, pxg_Qsmall, pxg_Rsmall, pxg_Ssmall,
  pxg_Tsmall, pxg_Usmall, pxg_Vsmall, pxg_Wsmall,
  pxg_Xsmall, pxg_Ysmall, pxg_Zsmall, pxg_colonmonetary,
  pxg_onefitted, pxg_rupiah, pxg_Tildesmall, pxg__notdef,
  pxg__notdef, pxg_asuperior, pxg_centsuperior, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg_Aacutesmall,
  pxg_Agravesmall, pxg_Acircumflexsmall, pxg_Adieresissmall, pxg_Atildesmall,
  pxg_Aringsmall, pxg_Ccedillasmall, pxg_Eacutesmall, pxg_Egravesmall,
  pxg_Ecircumflexsmall, pxg_Edieresissmall, pxg_Iacutesmall, pxg_Igravesmall,
  pxg_Icircumflexsmall, pxg_Idieresissmall, pxg_Ntildesmall, pxg_Oacutesmall,
  pxg_Ogravesmall, pxg_Ocircumflexsmall, pxg_Odieresissmall, pxg_Otildesmall,
  pxg_Uacutesmall, pxg_Ugravesmall, pxg_Ucircumflexsmall, pxg_Udieresissmall,
  pxg__notdef, pxg_eightsuperior, pxg_fourinferior, pxg_threeinferior,
  pxg_sixinferior, pxg_eightinferior, pxg_seveninferior, pxg_Scaronsmall,
  pxg__notdef, pxg_centinferior, pxg_twoinferior, pxg__notdef,
  pxg_Dieresissmall, pxg__notdef, pxg_Caronsmall, pxg_osuperior,
  pxg_fiveinferior, pxg__notdef, pxg_commainferior, pxg_periodinferior,
  pxg_Yacutesmall, pxg__notdef, pxg_dollarinferior, pxg__notdef,
  pxg__notdef, pxg_Thornsmall, pxg__notdef, pxg_nineinferior,
  pxg_zeroinferior, pxg_Zcaronsmall, pxg_AEsmall, pxg_Oslashsmall,
  pxg_questiondownsmall, pxg_oneinferior, pxg_Lslashsmall, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_Cedillasmall, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg_OEsmall,
  pxg_figuredash, pxg_hyphensuperior, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg_exclamdownsmall, pxg__notdef,
  pxg_Ydieresissmall, pxg__notdef, pxg_onesuperior, pxg_twosuperior,
  pxg_threesuperior, pxg_foursuperior, pxg_fivesuperior, pxg_sixsuperior,
  pxg_sevensuperior, pxg_ninesuperior, pxg_zerosuperior, pxg__notdef,
  pxg_esuperior, pxg_rsuperior, pxg_tsuperior, pxg__notdef,
  pxg__notdef, pxg_isuperior, pxg_ssuperior, pxg_dsuperior,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_lsuperior, pxg_Ogoneksmall, pxg_Brevesmall,
  pxg_Macronsmall, pxg_bsuperior, pxg_nsuperior, pxg_msuperior,
  pxg_commasuperior, pxg_periodsuperior, pxg_Dotaccentsmall, pxg_Ringsmall,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef
};

const unsigned short pxISOLatin1Encoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_quotedbl, pxg_numbersign,
  pxg_dollar, pxg_percent, pxg_ampersand, pxg_quoteright,
  pxg_parenleft, pxg_parenright, pxg_asterisk, pxg_plus,
  pxg_comma, pxg_minus, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_at, pxg_A, pxg_B, pxg_C,
  pxg_D, pxg_E, pxg_F, pxg_G,
  pxg_H, pxg_I, pxg_J, pxg_K,
  pxg_L, pxg_M, pxg_N, pxg_O,
  pxg_P, pxg_Q, pxg_R, pxg_S,
  pxg_T, pxg_U, pxg_V, pxg_W,
  pxg_X, pxg_Y, pxg_Z, pxg_bracketleft,
  pxg_backslash, pxg_bracketright, pxg_asciicircum, pxg_underscore,
  pxg_quoteleft, pxg_a, pxg_b, pxg_c,
  pxg_d, pxg_e, pxg_f, pxg_g,
  pxg_h, pxg_i, pxg_j, pxg_k,
  pxg_l, pxg_m, pxg_n, pxg_o,
  pxg_p, pxg_q, pxg_r, pxg_s,
  pxg_t, pxg_u, pxg_v, pxg_w,
  pxg_x, pxg_y, pxg_z, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_asciitilde, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_dotlessi, pxg_grave, pxg_acute, pxg_circumflex,
  pxg_tilde, pxg_macron, pxg_breve, pxg_dotaccent,
  pxg_dieresis, pxg__notdef, pxg_ring, pxg_cedilla,
  pxg__notdef, pxg_hungarumlaut, pxg_ogonek, pxg_caron,
  pxg_space, pxg_exclamdown, pxg_cent, pxg_sterling,
  pxg_currency, pxg_yen, pxg_brokenbar, pxg_section,
  pxg_dieresis, pxg_copyright, pxg_ordfeminine, pxg_guillemotleft,
  pxg_logicalnot, pxg_hyphen, pxg_registered, pxg_macron,
  pxg_degree, pxg_plusminus, pxg_twosuperior, pxg_threesuperior,
  pxg_acute, pxg_mu, pxg_paragraph, pxg_periodcentered,
  pxg_cedilla, pxg_onesuperior, pxg_ordmasculine, pxg_guillemotright,
  pxg_onequarter, pxg_onehalf, pxg_threequarters, pxg_questiondown,
  pxg_Agrave, pxg_Aacute, pxg_Acircumflex, pxg_Atilde,
  pxg_Adieresis, pxg_Aring, pxg_AE, pxg_Ccedilla,
  pxg_Egrave, pxg_Eacute, pxg_Ecircumflex, pxg_Edieresis,
  pxg_Igrave, pxg_Iacute, pxg_Icircumflex, pxg_Idieresis,
  pxg_Eth, pxg_Ntilde, pxg_Ograve, pxg_Oacute,
  pxg_Ocircumflex, pxg_Otilde, pxg_Odieresis, pxg_multiply,
  pxg_Oslash, pxg_Ugrave, pxg_Uacute, pxg_Ucircumflex,
  pxg_Udieresis, pxg_Yacute, pxg_Thorn, pxg_germandbls,
  pxg_agrave, pxg_aacute, pxg_acircumflex, pxg_atilde,
  pxg_adieresis, pxg_aring, pxg_ae, pxg_ccedilla,
  pxg_egrave, pxg_eacute, pxg_ecircumflex, pxg_edieresis,
  pxg_igrave, pxg_iacute, pxg_icircumflex, pxg_idieresis,
  pxg_eth, pxg_ntilde, pxg_ograve, pxg_oacute,
  pxg_ocircumflex, pxg_otilde, pxg_odieresis, pxg_divide,
  pxg_oslash, pxg_ugrave, pxg_uacute, pxg_ucircumflex,
  pxg_udieresis, pxg_yacute, pxg_thorn, pxg_ydieresis,
  pxg__notdef
};

const unsigned short pxStandardEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_quotedbl, pxg_numbersign,
  pxg_dollar, pxg_percent, pxg_ampersand, pxg_quoteright,
  pxg_parenleft, pxg_parenright, pxg_asterisk, pxg_plus,
  pxg_comma, pxg_hyphen, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_at, pxg_A, pxg_B, pxg_C,
  pxg_D, pxg_E, pxg_F, pxg_G,
  pxg_H, pxg_I, pxg_J, pxg_K,
  pxg_L, pxg_M, pxg_N, pxg_O,
  pxg_P, pxg_Q, pxg_R, pxg_S,
  pxg_T, pxg_U, pxg_V, pxg_W,
  pxg_X, pxg_Y, pxg_Z, pxg_bracketleft,
  pxg_backslash, pxg_bracketright, pxg_asciicircum, pxg_underscore,
  pxg_quoteleft, pxg_a, pxg_b, pxg_c,
  pxg_d, pxg_e, pxg_f, pxg_g,
  pxg_h, pxg_i, pxg_j, pxg_k,
  pxg_l, pxg_m, pxg_n, pxg_o,
  pxg_p, pxg_q, pxg_r, pxg_s,
  pxg_t, pxg_u, pxg_v, pxg_w,
  pxg_x, pxg_y, pxg_z, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_asciitilde, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_exclamdown, pxg_cent, pxg_sterling,
  pxg_fraction, pxg_yen, pxg_florin, pxg_section,
  pxg_currency, pxg_quotesingle, pxg_quotedblleft, pxg_guillemotleft,
  pxg_guilsinglleft, pxg_guilsinglright, pxg_fi, pxg_fl,
  pxg__notdef, pxg_endash, pxg_dagger, pxg_daggerdbl,
  pxg_periodcentered, pxg__notdef, pxg_paragraph, pxg_bullet,
  pxg_quotesinglbase, pxg_quotedblbase, pxg_quotedblright, pxg_guillemotright,
  pxg_ellipsis, pxg_perthousand, pxg__notdef, pxg_questiondown,
  pxg__notdef, pxg_grave, pxg_acute, pxg_circumflex,
  pxg_tilde, pxg_macron, pxg_breve, pxg_dotaccent,
  pxg_dieresis, pxg__notdef, pxg_ring, pxg_cedilla,
  pxg__notdef, pxg_hungarumlaut, pxg_ogonek, pxg_caron,
  pxg_emdash, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_AE, pxg__notdef, pxg_ordfeminine,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_Lslash, pxg_Oslash, pxg_OE, pxg_ordmasculine,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_ae, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_dotlessi, pxg__notdef, pxg__notdef,
  pxg_lslash, pxg_oslash, pxg_oe, pxg_germandbls,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef
};

const unsigned short pxDingbatsEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_a1, pxg_a2, pxg_a202,
  pxg_a3, pxg_a4, pxg_a5, pxg_a119,
  pxg_a118, pxg_a117, pxg_a11, pxg_a12,
  pxg_a13, pxg_a14, pxg_a15, pxg_a16,
  pxg_a105, pxg_a17, pxg_a18, pxg_a19,
  pxg_a20, pxg_a21, pxg_a22, pxg_a23,
  pxg_a24, pxg_a25, pxg_a26, pxg_a27,
  pxg_a28, pxg_a6, pxg_a7, pxg_a8,
  pxg_a9, pxg_a10, pxg_a29, pxg_a30,
  pxg_a31, pxg_a32, pxg_a33, pxg_a34,
  pxg_a35, pxg_a36, pxg_a37, pxg_a38,
  pxg_a39, pxg_a40, pxg_a41, pxg_a42,
  pxg_a43, pxg_a44, pxg_a45, pxg_a46,
  pxg_a47, pxg_a48, pxg_a49, pxg_a50,
  pxg_a51, pxg_a52, pxg_a53, pxg_a54,
  pxg_a55, pxg_a56, pxg_a57, pxg_a58,
  pxg_a59, pxg_a60, pxg_a61, pxg_a62,
  pxg_a63, pxg_a64, pxg_a65, pxg_a66,
  pxg_a67, pxg_a68, pxg_a69, pxg_a70,
  pxg_a71, pxg_a72, pxg_a73, pxg_a74,
  pxg_a203, pxg_a75, pxg_a204, pxg_a76,
  pxg_a77, pxg_a78, pxg_a79, pxg_a81,
  pxg_a82, pxg_a83, pxg_a84, pxg_a97,
  pxg_a98, pxg_a99, pxg_a100, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg_a101, pxg_a102, pxg_a103,
  pxg_a104, pxg_a106, pxg_a107, pxg_a108,
  pxg_a112, pxg_a111, pxg_a110, pxg_a109,
  pxg_a120, pxg_a121, pxg_a122, pxg_a123,
  pxg_a124, pxg_a125, pxg_a126, pxg_a127,
  pxg_a128, pxg_a129, pxg_a130, pxg_a131,
  pxg_a132, pxg_a133, pxg_a134, pxg_a135,
  pxg_a136, pxg_a137, pxg_a138, pxg_a139,
  pxg_a140, pxg_a141, pxg_a142, pxg_a143,
  pxg_a144, pxg_a145, pxg_a146, pxg_a147,
  pxg_a148, pxg_a149, pxg_a150, pxg_a151,
  pxg_a152, pxg_a153, pxg_a154, pxg_a155,
  pxg_a156, pxg_a157, pxg_a158, pxg_a159,
  pxg_a160, pxg_a161, pxg_a163, pxg_a164,
  pxg_a196, pxg_a165, pxg_a192, pxg_a166,
  pxg_a167, pxg_a168, pxg_a169, pxg_a170,
  pxg_a171, pxg_a172, pxg_a173, pxg_a162,
  pxg_a174, pxg_a175, pxg_a176, pxg_a177,
  pxg_a178, pxg_a179, pxg_a193, pxg_a180,
  pxg_a199, pxg_a181, pxg_a200, pxg_a182,
  pxg__notdef, pxg_a201, pxg_a183, pxg_a184,
  pxg_a197, pxg_a185, pxg_a194, pxg_a198,
  pxg_a186, pxg_a195, pxg_a187, pxg_a188,
  pxg_a189, pxg_a190, pxg_a191, pxg__notdef,
  pxg__notdef
};

const unsigned short pxMacRomanEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_quotedbl, pxg_numbersign,
  pxg_dollar, pxg_percent, pxg_ampersand, pxg_quotesingle,
  pxg_parenleft, pxg_parenright, pxg_asterisk, pxg_plus,
  pxg_comma, pxg_hyphen, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_at, pxg_A, pxg_B, pxg_C,
  pxg_D, pxg_E, pxg_F, pxg_G,
  pxg_H, pxg_I, pxg_J, pxg_K,
  pxg_L, pxg_M, pxg_N, pxg_O,
  pxg_P, pxg_Q, pxg_R, pxg_S,
  pxg_T, pxg_U, pxg_V, pxg_W,
  pxg_X, pxg_Y, pxg_Z, pxg_bracketleft,
  pxg_backslash, pxg_bracketright, pxg_asciicircum, pxg_underscore,
  pxg_grave, pxg_a, pxg_b, pxg_c,
  pxg_d, pxg_e, pxg_f, pxg_g,
  pxg_h, pxg_i, pxg_j, pxg_k,
  pxg_l, pxg_m, pxg_n, pxg_o,
  pxg_p, pxg_q, pxg_r, pxg_s,
  pxg_t, pxg_u, pxg_v, pxg_w,
  pxg_x, pxg_y, pxg_z, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_asciitilde, pxg__notdef,
  pxg_Adieresis, pxg_Aring, pxg_Ccedilla, pxg_Eacute,
  pxg_Ntilde, pxg_Odieresis, pxg_Udieresis, pxg_aacute,
  pxg_agrave, pxg_acircumflex, pxg_adieresis, pxg_atilde,
  pxg_aring, pxg_ccedilla, pxg_eacute, pxg_egrave,
  pxg_ecircumflex, pxg_edieresis, pxg_iacute, pxg_igrave,
  pxg_icircumflex, pxg_idieresis, pxg_ntilde, pxg_oacute,
  pxg_ograve, pxg_ocircumflex, pxg_odieresis, pxg_otilde,
  pxg_uacute, pxg_ugrave, pxg_ucircumflex, pxg_udieresis,
  pxg_dagger, pxg_degree, pxg_cent, pxg_sterling,
  pxg_section, pxg_bullet, pxg_paragraph, pxg_germandbls,
  pxg_registered, pxg_copyright, pxg_trademark, pxg_acute,
  pxg_dieresis, pxg__notdef, pxg_AE, pxg_Oslash,
  pxg__notdef, pxg_plusminus, pxg__notdef, pxg__notdef,
  pxg_yen, pxg_mu, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg_ordfeminine,
  pxg_ordmasculine, pxg__notdef, pxg_ae, pxg_oslash,
  pxg_questiondown, pxg_exclamdown, pxg_logicalnot, pxg__notdef,
  pxg_florin, pxg__notdef, pxg__notdef, pxg_guillemotleft,
  pxg_guillemotright, pxg_ellipsis, pxg_space, pxg_Agrave,
  pxg_Atilde, pxg_Otilde, pxg_OE, pxg_oe,
  pxg_endash, pxg_emdash, pxg_quotedblleft, pxg_quotedblright,
  pxg_quoteleft, pxg_quoteright, pxg_divide, pxg__notdef,
  pxg_ydieresis, pxg_Ydieresis, pxg_fraction, pxg_currency,
  pxg_guilsingleft, pxg_guilsingright, pxg_fi, pxg_fl,
  pxg_daggerdbl, pxg_periodcentered, pxg_quotesinglbase, pxg_quotedblbase,
  pxg_perthousand, pxg_Acircumflex, pxg_Ecircumflex, pxg_Aacute,
  pxg_Edieresis, pxg_Egrave, pxg_Iacute, pxg_Icircumflex,
  pxg_Idieresis, pxg_Igrave, pxg_Oacute, pxg_Ocircumflex,
  pxg__notdef, pxg_Ograve, pxg_Uacute, pxg_Ucircumflex,
  pxg_Ugrave, pxg_dotlessi, pxg_circumflex, pxg_tilde,
  pxg_macron, pxg_breve, pxg_dotaccent, pxg_ring,
  pxg_cedilla, pxg_hungarumlaut, pxg_ogonek, pxg_caron,
  pxg__notdef
};

const unsigned short pxWinAnsiEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_quotedbl, pxg_numbersign,
  pxg_dollar, pxg_percent, pxg_ampersand, pxg_quotesingle,
  pxg_parenleft, pxg_parenright, pxg_asterisk, pxg_plus,
  pxg_comma, pxg_minus, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_at, pxg_A, pxg_B, pxg_C,
  pxg_D, pxg_E, pxg_F, pxg_G,
  pxg_H, pxg_I, pxg_J, pxg_K,
  pxg_L, pxg_M, pxg_N, pxg_O,
  pxg_P, pxg_Q, pxg_R, pxg_S,
  pxg_T, pxg_U, pxg_V, pxg_W,
  pxg_X, pxg_Y, pxg_Z, pxg_bracketleft,
  pxg_backslash, pxg_bracketright, pxg_asciicircum, pxg_underscore,
  pxg_grave, pxg_a, pxg_b, pxg_c,
  pxg_d, pxg_e, pxg_f, pxg_g,
  pxg_h, pxg_i, pxg_j, pxg_k,
  pxg_l, pxg_m, pxg_n, pxg_o,
  pxg_p, pxg_q, pxg_r, pxg_s,
  pxg_t, pxg_u, pxg_v, pxg_w,
  pxg_x, pxg_y, pxg_z, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_asciitilde, pxg_bullet,
  pxg_bullet, pxg_bullet, pxg_quotesinglbase, pxg_florin,
  pxg_quotedblbase, pxg_ellipsis, pxg_dagger, pxg_daggerdbl,
  pxg_circumflex, pxg_perthousand, pxg_Scaron, pxg_guilsinglleft,
  pxg_OE, pxg_bullet, pxg_bullet, pxg_bullet,
  pxg_bullet, pxg_quoteleft, pxg_quoteright, pxg_quotedblleft,
  pxg_quotedblright, pxg_bullet, pxg_endash, pxg_emdash,
  pxg_tilde, pxg_trademark, pxg_scaron, pxg_guilsinglright,
  pxg_oe, pxg_bullet, pxg_bullet, pxg_Ydieresis,
  pxg_space, pxg_exclamdown, pxg_cent, pxg_sterling,
  pxg_currency, pxg_yen, pxg_brokenbar, pxg_section,
  pxg_dieresis, pxg_copyright, pxg_ordfeminine, pxg_guillemotleft,
  pxg_logicalnot, pxg_hyphen, pxg_registered, pxg_macron,
  pxg_degree, pxg_plusminus, pxg_twosuperior, pxg_threesuperior,
  pxg_acute, pxg_mu, pxg_paragraph, pxg_periodcentered,
  pxg_cedilla, pxg_onesuperior, pxg_ordmasculine, pxg_guillemotright,
  pxg_onequarter, pxg_onehalf, pxg_threequarters, pxg_questiondown,
  pxg_Agrave, pxg_Aacute, pxg_Acircumflex, pxg_Atilde,
  pxg_Adieresis, pxg_Aring, pxg_AE, pxg_Ccedilla,
  pxg_Egrave, pxg_Eacute, pxg_Ecircumflex, pxg_Edieresis,
  pxg_Igrave, pxg_Iacute, pxg_Icircumflex, pxg_Idieresis,
  pxg_Eth, pxg_Ntilde, pxg_Ograve, pxg_Oacute,
  pxg_Ocircumflex, pxg_Otilde, pxg_Odieresis, pxg_multiply,
  pxg_Oslash, pxg_Ugrave, pxg_Uacute, pxg_Ucircumflex,
  pxg_Udieresis, pxg_Yacute, pxg_Thorn, pxg_germandbls,
  pxg_agrave, pxg_aacute, pxg_acircumflex, pxg_atilde,
  pxg_adieresis, pxg_aring, pxg_ae, pxg_ccedilla,
  pxg_egrave, pxg_eacute, pxg_ecircumflex, pxg_edieresis,
  pxg_igrave, pxg_iacute, pxg_icircumflex, pxg_idieresis,
  pxg_eth, pxg_ntilde, pxg_ograve, pxg_oacute,
  pxg_ocircumflex, pxg_otilde, pxg_odieresis, pxg_divide,
  pxg_oslash, pxg_ugrave, pxg_uacute, pxg_ucircumflex,
  pxg_udieresis, pxg_yacute, pxg_thorn, pxg_ydieresis,
  pxg__notdef
};

const unsigned short pxPDFDocEncoding[257] = {
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg__notdef, pxg__notdef, pxg__notdef, pxg__notdef,
  pxg_space, pxg_exclam, pxg_quotedbl, pxg_numbersign,
  pxg_dollar, pxg_percent, pxg_ampersand, pxg_quotesingle,
  pxg_parenleft, pxg_parenright, pxg_asterisk, pxg_plus,
  pxg_comma, pxg_minus, pxg_period, pxg_slash,
  pxg_zero, pxg_one, pxg_two, pxg_three,
  pxg_four, pxg_five, pxg_six, pxg_seven,
  pxg_eight, pxg_nine, pxg_colon, pxg_semicolon,
  pxg_less, pxg_equal, pxg_greater, pxg_question,
  pxg_at, pxg_A, pxg_B, pxg_C,
  pxg_D, pxg_E, pxg_F, pxg_G,
  pxg_H, pxg_I, pxg_J, pxg_K,
  pxg_L, pxg_M, pxg_N, pxg_O,
  pxg_P, pxg_Q, pxg_R, pxg_S,
  pxg_T, pxg_U, pxg_V, pxg_W,
  pxg_X, pxg_Y, pxg_Z, pxg_bracketleft,
  pxg_backslash, pxg_bracketright, pxg_asciicircum, pxg_underscore,
  pxg_grave, pxg_a, pxg_b, pxg_c,
  pxg_d, pxg_e, pxg_f, pxg_g,
  pxg_h, pxg_i, pxg_j, pxg_k,
  pxg_l, pxg_m, pxg_n, pxg_o,
  pxg_p, pxg_q, pxg_r, pxg_s,
  pxg_t, pxg_u, pxg_v, pxg_w,
  pxg_x, pxg_y, pxg_z, pxg_braceleft,
  pxg_bar, pxg_braceright, pxg_asciitilde, pxg__notdef,
  pxg_bullet, pxg_dagger, pxg_daggerdbl, pxg_ellipsis,
  pxg_emdash, pxg_endash, pxg_florin, pxg_fraction,
  pxg_guilsinglleft, pxg_guilsinglright, pxg_minus, pxg_perthousand,
  pxg_quotedblbase, pxg_quotedblleft, pxg_quotedblright, pxg_quoteleft,
  pxg_quoteright, pxg_quotesinglbase, pxg_trademark, pxg_fi,
  pxg_fl, pxg_Lslash, pxg_OE, pxg_Scaron,
  pxg_Ydieresis, pxg_Zcaron, pxg_dotlessi, pxg_lslash,
  pxg_oe, pxg_scaron, pxg_zcaron, pxg__notdef,
  pxg__notdef, pxg_exclamdown, pxg_cent, pxg_sterling,
  pxg_currency, pxg_yen, pxg_brokenbar, pxg_section,
  pxg_dieresis, pxg_copyright, pxg_ordfeminine, pxg_guillemotleft,
  pxg_logicalnot, pxg__notdef, pxg_registered, pxg_macron,
  pxg_degree, pxg_plusminus, pxg_twosuperior, pxg_threesuperior,
  pxg_acute, pxg_mu, pxg_paragraph, pxg_periodcentered,
  pxg_cedilla, pxg_onesuperior, pxg_ordmasculine, pxg_guillemotright,
  pxg_onequarter, pxg_onehalf, pxg_threequarters, pxg_questiondown,
  pxg_Agrave, pxg_Aacute, pxg_Acircumflex, pxg_Atilde,
  pxg_Adieresis, pxg_Aring, pxg_AE, pxg_Ccedilla,
  pxg_Egrave, pxg_Eacute, pxg_Ecircumflex, pxg_Edieresis,
  pxg_Igrave, pxg_Iacute, pxg_Icircumflex, pxg_Idieresis,
  pxg_Eth, pxg_Ntilde, pxg_Ograve, pxg_Oacute,
  pxg_Ocircumflex, pxg_Otilde, pxg_Odieresis, pxg_multiply,
  pxg_Oslash, pxg_Ugrave, pxg_Uacute, pxg_Ucircumflex,
  pxg_Udieresis, pxg_Yacute, pxg_Thorn, pxg_germandbls,
  pxg_agrave, pxg_aacute, pxg_acircumflex, pxg_atilde,
  pxg_adieresis, pxg_aring, pxg_ae, pxg_ccedilla,
  pxg_egrave, pxg_eacute, pxg_ecircumflex, pxg_edieresis,
  pxg_igrave, pxg_iacute, pxg_icircumflex, pxg_idieresis,
  pxg_eth, pxg_ntilde, pxg_ograve, pxg_oacute,
  pxg_ocircumflex, pxg_otilde, pxg_odieresis, pxg_divide,
  pxg_oslash, pxg_ugrave, pxg_uacute, pxg_ucircumflex,
  pxg_udieresis, pxg_yacute, pxg_thorn, pxg_ydieresis,
  pxg__notdef
};
