; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+experimental-v -verify-machineinstrs < %s | FileCheck %s

; This demonstrates that we can pass a struct containing scalable vectors across
; a basic block.

define i32 @foo({ {<vscale x 2 x i32>, <vscale x 2 x i32>}, i32 } %x, <vscale x 2 x i32>* %y, <vscale x 2 x i32>* %z) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli a3, zero, e32,m1,ta,mu
; CHECK-NEXT:    vse32.v v8, (a1)
; CHECK-NEXT:    vse32.v v9, (a2)
; CHECK-NEXT:    ret
entry:
  br label %return

return:
  %a = extractvalue { {<vscale x 2 x i32>, <vscale x 2 x i32>}, i32 } %x, 1
  %b = extractvalue { {<vscale x 2 x i32>, <vscale x 2 x i32>}, i32 } %x, 0, 0
  %c = extractvalue { {<vscale x 2 x i32>, <vscale x 2 x i32>}, i32 } %x, 0, 1
  store <vscale x 2 x i32> %b, <vscale x 2 x i32>* %y
  store <vscale x 2 x i32> %c, <vscale x 2 x i32>* %z

  ret i32 %a
}
