/*
  libheif unit tests

  MIT License

  Copyright (c) 2025 Dirk Farin <dirk.farin@gmail.com>

  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all
  copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/

#include "catch_amalgamated.hpp"
#include "test_utils.h"
#include <libheif/heif_cxx.h>
#include <iostream>

TEST_CASE( "C++ object copy (ColorProfile_nclx)" )
{
  // This is the reproducer from issue #1641

  heif::Image img;

  img.create(16,16, heif_colorspace_RGB, heif_chroma_interleaved_RGBA);

  heif::ColorProfile_nclx nclx;
  nclx.set_matrix_coefficients(heif_matrix_coefficients_SMPTE_240M);
  img.set_nclx_color_profile(nclx);

  heif::ColorProfile_nclx a = img.get_nclx_color_profile();
  heif::ColorProfile_nclx b(a);
}