/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import org.jhotdraw.gui.VerticalGridLayout;
import org.jhotdraw.gui.plaf.palette.PaletteMenuItemUI;

public class JPopupButton
extends JButton {
    private JPopupMenu popupMenu;
    private int columnCount = 1;
    private Action action;
    private Rectangle actionArea;
    private Font itemFont;
    public static final Font ITEM_FONT = new Font("Dialog", 0, 10);
    private int popupAnchor = 6;
    private ActionPropertyHandler actionPropertyHandler = new ActionPropertyHandler();

    public JPopupButton() {
        this.initComponents();
        this.setFocusable(false);
        this.itemFont = ITEM_FONT;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        if (this.popupMenu != null) {
            this.updateFont(this.popupMenu);
        }
    }

    public void setAction(Action action, Rectangle rectangle) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyHandler);
        }
        this.action = action;
        this.actionArea = rectangle;
        if (action != null) {
            action.addPropertyChangeListener(this.actionPropertyHandler);
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int n, boolean bl) {
        this.columnCount = n;
        this.getPopupMenu().setLayout(new VerticalGridLayout(0, this.getColumnCount(), bl));
    }

    public AbstractButton add(Action action) {
        JMenuItem jMenuItem = this.getPopupMenu().add(action);
        if (this.getColumnCount() > 1) {
            jMenuItem.setUI(new PaletteMenuItemUI());
        }
        jMenuItem.setFont(this.itemFont);
        return jMenuItem;
    }

    public void add(JMenu jMenu) {
        JMenuItem jMenuItem = this.getPopupMenu().add(jMenu);
        this.updateFont(jMenu);
    }

    public void add(JComponent jComponent) {
        this.getPopupMenu().add(jComponent);
    }

    private void updateFont(MenuElement menuElement) {
        menuElement.getComponent().setFont(this.itemFont);
        for (MenuElement menuElement2 : menuElement.getSubElements()) {
            this.updateFont(menuElement2);
        }
    }

    public void add(JMenuItem jMenuItem) {
        this.getPopupMenu().add(jMenuItem);
        jMenuItem.setFont(this.itemFont);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setLayout(new VerticalGridLayout(0, this.getColumnCount()));
        }
        return this.popupMenu;
    }

    public void setPopupAlpha(float f) {
        float f2 = this.getPopupAlpha();
        this.getPopupMenu().putClientProperty("Quaqua.PopupMenu.alpha", Float.valueOf(f));
        this.firePropertyChange("popupAlpha", f2, f);
    }

    public float getPopupAlpha() {
        Float f = (Float)this.getPopupMenu().getClientProperty("Quaqua.PopupMenu.alpha");
        return f == null ? 0.75f : f.floatValue();
    }

    public int getPopupAnchor() {
        return this.popupAnchor;
    }

    public void setPopupAnchor(int n) {
        this.popupAnchor = n;
    }

    protected void showPopup(MouseEvent mouseEvent) {
        if (!(this.popupMenu == null || this.actionArea != null && this.actionArea.contains(mouseEvent.getX() - this.getInsets().left, mouseEvent.getY() - this.getInsets().top))) {
            int n;
            int n2;
            switch (this.popupAnchor) {
                case 4: {
                    n2 = this.getWidth() - this.popupMenu.getPreferredSize().width;
                    n = this.getHeight();
                    break;
                }
                default: {
                    n2 = 0;
                    n = this.getHeight();
                }
            }
            if (this.getParent() instanceof JToolBar) {
                JToolBar jToolBar = (JToolBar)this.getParent();
                if (jToolBar.getOrientation() == 1) {
                    n = 0;
                    n2 = jToolBar.getX() > jToolBar.getParent().getInsets().left ? -this.popupMenu.getPreferredSize().width : this.getWidth();
                } else if (jToolBar.getY() > jToolBar.getParent().getInsets().top) {
                    n = -this.popupMenu.getPreferredSize().height;
                }
            }
            this.popupMenu.show(this, n2, n);
            this.popupMenu.repaint();
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                JPopupButton.this.handleMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JPopupButton.this.performAction(mouseEvent);
            }
        });
    }

    private void performAction(MouseEvent mouseEvent) {
        if (this.actionArea != null && this.actionArea.contains(mouseEvent.getX() - this.getInsets().left, mouseEvent.getY() - this.getInsets().top)) {
            this.action.actionPerformed(new ActionEvent(this, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        }
    }

    private void handleMousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private class ActionPropertyHandler
    implements PropertyChangeListener {
        private ActionPropertyHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                JPopupButton.this.setEnabled((Boolean)propertyChangeEvent.getNewValue());
            } else {
                JPopupButton.this.repaint();
            }
        }
    }
}

