// Copyright (c) 2012 Ecma International.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.filter
es5id: 15.4.4.20-9-c-iii-5
description: >
    Array.prototype.filter - return value of callbackfn is a boolean
    (value is true)
---*/

function callbackfn(val, idx, obj) {
  return true;
}

var obj = {
  0: 11,
  length: 1
};

var newArr = Array.prototype.filter.call(obj, callbackfn);

assert.sameValue(newArr.length, 1, 'newArr.length');
assert.sameValue(newArr[0], 11, 'newArr[0]');

reportCompare(0, 0);
