!{\src2tex{textfont=tt}}
!!****f* ABINIT/dtsetcopy
!! NAME
!! dtsetcopy
!!
!! FUNCTION
!! Copy all values of dataset dtin to dataset dtout. Pointers of dtout are
!! allocated if required. Use dtsetFree() to free a dataset after use.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR, MF, GZ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtin <type(dataset_type)>=all input variables in this dataset
!!
!! OUTPUT
!!  dtout <type(dataset_type)>
!!
!! PARENTS
!!      afterscfloop,cvxclda,driver,kxc_alda,outkss
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine dtsetCopy(dtout, dtin)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_11util, except_this_one => dtsetCopy
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 type(dataset_type),intent(in) :: dtin
 type(dataset_type),intent(out) :: dtout

!Local variables-------------------------------
 integer :: chosen_size1,chosen_size2,chosen_size3
 character(len=12) name
! *************************************************************************

  !Copy integers from dtin to dtout
  dtout%accesswff          = dtin%accesswff
  dtout%berryopt           = dtin%berryopt
  dtout%brvltt             = dtin%brvltt
  dtout%ceksph             = dtin%ceksph
  dtout%chkexit            = dtin%chkexit
  dtout%chkprim            = dtin%chkprim
  dtout%delayperm          = dtin%delayperm
  dtout%enunit             = dtin%enunit
  dtout%exchn2n3           = dtin%exchn2n3
  dtout%fft_opt_lob        = dtin%fft_opt_lob
  dtout%freqremax          = dtin%freqremax
  dtout%freqspmax          = dtin%freqspmax
  dtout%frzfermi           = dtin%frzfermi
  dtout%getacfd            = dtin%getacfd
  dtout%getcell            = dtin%getcell
  dtout%getddk             = dtin%getddk
  dtout%getden             = dtin%getden
  dtout%getkss             = dtin%getkss
  dtout%getocc             = dtin%getocc
  dtout%getqps             = dtin%getqps
  dtout%getscr             = dtin%getscr
  dtout%getvel             = dtin%getvel
  dtout%getwfk             = dtin%getwfk
  dtout%getwfq             = dtin%getwfq
  dtout%getxcart           = dtin%getxcart
  dtout%getxred            = dtin%getxred
  dtout%get1den            = dtin%get1den
  dtout%get1wf             = dtin%get1wf
  dtout%gpara              = dtin%gpara
  dtout%gwcalctyp          = dtin%gwcalctyp
  dtout%gwpara             = dtin%gwpara   
  dtout%iboxcut            = dtin%iboxcut
  dtout%icoultrtmt         = dtin%icoultrtmt
  dtout%idyson             = dtin%idyson
  dtout%ikhxc              = dtin%ikhxc
  dtout%inclvkb            = dtin%inclvkb
  dtout%intexact           = dtin%intexact
  dtout%intxc              = dtin%intxc
  dtout%ionmov             = dtin%ionmov
  dtout%iprcch             = dtin%iprcch
  dtout%iprcel             = dtin%iprcel
  dtout%iprctfvw           = dtin%iprctfvw
  dtout%iprcfc             = dtin%iprcfc
  dtout%irdddk             = dtin%irdddk
  dtout%irdkss             = dtin%irdkss
  dtout%irdqps             = dtin%irdqps
  dtout%irdscr             = dtin%irdscr
  dtout%irdwfk             = dtin%irdwfk
  dtout%irdwfq             = dtin%irdwfq
  dtout%ird1wf             = dtin%ird1wf
  dtout%iscf               = dtin%iscf
  dtout%isecur             = dtin%isecur
  dtout%istatr             = dtin%istatr
  dtout%istatshft          = dtin%istatshft
  dtout%ixc                = dtin%ixc
  dtout%ixcpositron        = dtin%ixcpositron
  dtout%jdtset             = dtin%jdtset
  dtout%kpara              = dtin%kpara
  dtout%kptopt             = dtin%kptopt
  dtout%kssform            = dtin%kssform
  dtout%ldgapp             = dtin%ldgapp
  dtout%localrdwf          = dtin%localrdwf
  dtout%lofwrite           = dtin%lofwrite
  dtout%mband              = dtin%mband
  dtout%mffmem             = dtin%mffmem
  dtout%mgfft              = dtin%mgfft
  dtout%mgfftdg            = dtin%mgfftdg
  dtout%mkmem              = dtin%mkmem
  dtout%mkqmem             = dtin%mkqmem
  dtout%mk1mem             = dtin%mk1mem
  dtout%mpw                = dtin%mpw
  dtout%mqgrid             = dtin%mqgrid
  dtout%mqgriddg           = dtin%mqgriddg
  dtout%natom              = dtin%natom
  dtout%natrd              = dtin%natrd
  dtout%natsph             = dtin%natsph
  dtout%nbandsus           = dtin%nbandsus
  dtout%nbdblock           = dtin%nbdblock
  dtout%nbdbuf             = dtin%nbdbuf
  dtout%nberry             = dtin%nberry
  dtout%nbandkss           = dtin%nbandkss
  dtout%ncenter            = dtin%ncenter
  dtout%nconeq             = dtin%nconeq
  dtout%nctime             = dtin%nctime
  dtout%ndtset             = dtin%ndtset
  dtout%ndyson             = dtin%ndyson
  dtout%nfft               = dtin%nfft
  dtout%nfftdg             = dtin%nfftdg
  dtout%nfreqim            = dtin%nfreqim
  dtout%nfreqre            = dtin%nfreqre
  dtout%nfreqsp            = dtin%nfreqsp
  dtout%nfreqsus           = dtin%nfreqsus
  dtout%ngeohist           = dtin%ngeohist
  dtout%ngroup_rf          = dtin%ngroup_rf
  dtout%nkptgw             = dtin%nkptgw
  dtout%nkpt               = dtin%nkpt
  dtout%nline              = dtin%nline
  dtout%nnsclo             = dtin%nnsclo
  dtout%nomegasrd          = dtin%nomegasrd
  dtout%norb               = dtin%norb
  dtout%npack              = dtin%npack
  dtout%npara              = dtin%npara
  dtout%npband             = dtin%npband
  dtout%npfft              = dtin%npfft
  dtout%npsp               = dtin%npsp
  dtout%npspalch           = dtin%npspalch
  dtout%npulayit           = dtin%npulayit
  dtout%npweps             = dtin%npweps
  dtout%npwkss             = dtin%npwkss
  dtout%npwsigx            = dtin%npwsigx
  dtout%npwwfn             = dtin%npwwfn
  dtout%nqpt               = dtin%nqpt
  dtout%nqptdm             = dtin%nqptdm
  dtout%nscforder          = dtin%nscforder
  dtout%nsheps             = dtin%nsheps
  dtout%nshiftk            = dtin%nshiftk
  dtout%nshsigx            = dtin%nshsigx
  dtout%nshwfn             = dtin%nshwfn
  dtout%nspden             = dtin%nspden
  dtout%nspinor            = dtin%nspinor
  dtout%nsppol             = dtin%nsppol
  dtout%nstep              = dtin%nstep
  dtout%nsym               = dtin%nsym
  dtout%ntime              = dtin%ntime
  dtout%ntypalch           = dtin%ntypalch
  dtout%ntypat             = dtin%ntypat
  dtout%ntyppure           = dtin%ntyppure
  dtout%nwfshist           = dtin%nwfshist
  dtout%occopt             = dtin%occopt
  dtout%optcell            = dtin%optcell
  dtout%optdriver          = dtin%optdriver
  dtout%optforces          = dtin%optforces
  dtout%optfreqsus         = dtin%optfreqsus
  dtout%optnlxccc          = dtin%optnlxccc
  dtout%optstress          = dtin%optstress
  dtout%ortalg             = dtin%ortalg
  dtout%outputXML          = dtin%outputXML
  dtout%paral_rf           = dtin%paral_rf
  dtout%parareel           = dtin%parareel
  dtout%pawlcutd           = dtin%pawlcutd
  dtout%pawlmix            = dtin%pawlmix
  dtout%pawmixdg           = dtin%pawmixdg
  dtout%pawnphi            = dtin%pawnphi
  dtout%pawntheta          = dtin%pawntheta
  dtout%pawnzlm            = dtin%pawnzlm
  dtout%pawoptmix          = dtin%pawoptmix
  dtout%pawprtvol          = dtin%pawprtvol
  dtout%pawstgylm          = dtin%pawstgylm
  dtout%pawxcdev           = dtin%pawxcdev
  dtout%positron           = dtin%positron
  dtout%ppmodel            = dtin%ppmodel
  dtout%prepanl            = dtin%prepanl
  dtout%prtacfd            = dtin%prtacfd
  dtout%prtbbb             = dtin%prtbbb
  dtout%prtcml             = dtin%prtcml
  dtout%prtden             = dtin%prtden
  dtout%prtdos             = dtin%prtdos
  dtout%prteig             = dtin%prteig
  dtout%prtfsurf           = dtin%prtfsurf
  dtout%prtgeo             = dtin%prtgeo
  dtout%prtgkk             = dtin%prtgkk
  dtout%prtkpt             = dtin%prtkpt
  dtout%prtnabla           = dtin%prtnabla
  dtout%prtpot             = dtin%prtpot
  dtout%prtstm             = dtin%prtstm
  dtout%prtvha             = dtin%prtvha
  dtout%prtvhxc            = dtin%prtvhxc
  dtout%prtvol             = dtin%prtvol
  dtout%prtvxc             = dtin%prtvxc
  dtout%prtwant            = dtin%prtwant
  dtout%prtwf              = dtin%prtwf
  dtout%prt1dm             = dtin%prt1dm
  dtout%ptgroupma          = dtin%ptgroupma
  dtout%restartxf          = dtin%restartxf
  dtout%rfasr              = dtin%rfasr
  dtout%rfelfd             = dtin%rfelfd
  dtout%rfmeth             = dtin%rfmeth
  dtout%rfphon             = dtin%rfphon
  dtout%rfstrs             = dtin%rfstrs
  dtout%rfthrd             = dtin%rfthrd
  dtout%rfuser             = dtin%rfuser
  dtout%rf1elfd            = dtin%rf1elfd
  dtout%rf1phon            = dtin%rf1phon
  dtout%rf2elfd            = dtin%rf2elfd
  dtout%rf2phon            = dtin%rf2phon
  dtout%rf3elfd            = dtin%rf3elfd
  dtout%rf3phon            = dtin%rf3phon
  dtout%rhoqpmix           = dtin%rhoqpmix
  dtout%signperm           = dtin%signperm
  dtout%spgaxor            = dtin%spgaxor
  dtout%spgorig            = dtin%spgorig
  dtout%spgroup            = dtin%spgroup
  dtout%splitsigc          = dtin%splitsigc
  dtout%suskxcrs           = dtin%suskxcrs
  dtout%symchi             = dtin%symchi    
  dtout%symmorphi          = dtin%symmorphi
  dtout%symsigma           = dtin%symsigma 
  dtout%td_mexcit          = dtin%td_mexcit
  dtout%tfkinfunc          = dtin%tfkinfunc
  dtout%timopt             = dtin%timopt
  dtout%usepaw             = dtin%usepaw
  dtout%usepawu            = dtin%usepawu
  dtout%useria             = dtin%useria
  dtout%userib             = dtin%userib
  dtout%useric             = dtin%useric
  dtout%userid             = dtin%userid
  dtout%userie             = dtin%userie
  dtout%usewvl             = dtin%usewvl
  dtout%useylm             = dtin%useylm
  dtout%vacnum             = dtin%vacnum
  dtout%wfoptalg           = dtin%wfoptalg
  
  !Copy allocated integer arrays from dtin to dtout
  dtout%bdberry(:)         = dtin%bdberry(:)
  dtout%dsifkpt(:)         = dtin%dsifkpt(:)
  dtout%kptrlatt(:,:)      = dtin%kptrlatt(:,:)
  dtout%ngfft(:)           = dtin%ngfft(:)
  dtout%ngfftdg(:)         = dtin%ngfftdg(:)
  dtout%nloalg(:)          = dtin%nloalg(:)
  dtout%qprtrb(:)          = dtin%qprtrb(:)
  dtout%rfatpol(:)         = dtin%rfatpol(:)
  dtout%rfdir(:)           = dtin%rfdir(:)
  dtout%rf1atpol(:)        = dtin%rf1atpol(:)
  dtout%rf1dir(:)          = dtin%rf1dir(:)
  dtout%rf2atpol(:)        = dtin%rf2atpol(:)
  dtout%rf2dir(:)          = dtin%rf2dir(:)
  dtout%rf3atpol(:)        = dtin%rf3atpol(:)
  dtout%rf3dir(:)          = dtin%rf3dir(:)
  dtout%supercell(:)       = dtin%supercell(:)

  !Copy reals from dtin to dtout
  dtout%alpha              = dtin%alpha
  dtout%boxcutmin          = dtin%boxcutmin
  dtout%bxctmindg          = dtin%bxctmindg
  dtout%charge             = dtin%charge
  dtout%cpus               = dtin%cpus
  dtout%dedlnn             = dtin%dedlnn
  dtout%diecut             = dtin%diecut
  dtout%diegap             = dtin%diegap
  dtout%dielam             = dtin%dielam
  dtout%dielng             = dtin%dielng
  dtout%diemac             = dtin%diemac
  dtout%diemix             = dtin%diemix
  dtout%dilatmx            = dtin%dilatmx
  dtout%dosdeltae          = dtin%dosdeltae
  dtout%dtion              = dtin%dtion
  dtout%ecut               = dtin%ecut
  dtout%ecuteps            = dtin%ecuteps
  dtout%ecutsigx           = dtin%ecutsigx
  dtout%ecutsm             = dtin%ecutsm
  dtout%ecutwfn            = dtin%ecutwfn
  dtout%effmass            = dtin%effmass
  dtout%eshift             = dtin%eshift
  dtout%fband              = dtin%fband
  dtout%fixmom             = dtin%fixmom
  dtout%freqsusin          = dtin%freqsusin
  dtout%freqsuslo          = dtin%freqsuslo
  dtout%friction           = dtin%friction
  dtout%kptnrm             = dtin%kptnrm
  dtout%kptrlen            = dtin%kptrlen
  dtout%mdftemp            = dtin%mdftemp
  dtout%mditemp            = dtin%mditemp
  dtout%mdwall             = dtin%mdwall
  dtout%nelect             = dtin%nelect
  dtout%noseinert          = dtin%noseinert
  dtout%omegasrdmax        = dtin%omegasrdmax
  dtout%pawecutdg          = dtin%pawecutdg
  dtout%pawovlp            = dtin%pawovlp
  dtout%pawsphmix          = dtin%pawsphmix
  dtout%ppmfrq             = dtin%ppmfrq
  dtout%qptnrm             = dtin%qptnrm
  dtout%ratsph             = dtin%ratsph
  dtout%sciss              = dtin%sciss
  dtout%soenergy           = dtin%soenergy
  dtout%stmbias            = dtin%stmbias
  dtout%strfact            = dtin%strfact
  dtout%strprecon          = dtin%strprecon
  dtout%td_maxene          = dtin%td_maxene
  dtout%tfnewton           = dtin%tfnewton
  dtout%toldfe             = dtin%toldfe
  dtout%toldff             = dtin%toldff
  dtout%tolrff             = dtin%tolrff
  dtout%tolmxf             = dtin%tolmxf
  dtout%tolvrs             = dtin%tolvrs
  dtout%tolwfr             = dtin%tolwfr
  dtout%tphysel            = dtin%tphysel
  dtout%tsmear             = dtin%tsmear
  dtout%userra             = dtin%userra
  dtout%userrb             = dtin%userrb
  dtout%userrc             = dtin%userrc
  dtout%userrd             = dtin%userrd
  dtout%userre             = dtin%userre
  dtout%vacwidth           = dtin%vacwidth
  dtout%vis                = dtin%vis
  dtout%wvl_hgrid          = dtin%wvl_hgrid
  dtout%wvl_crmult         = dtin%wvl_crmult
  dtout%wvl_frmult         = dtin%wvl_frmult
  dtout%wvl_cpmult         = dtin%wvl_cpmult
  dtout%wvl_fpmult         = dtin%wvl_fpmult
  dtout%wvl_nprccg         = dtin%wvl_nprccg
  dtout%zcut               = dtin%zcut

  !Copy type values from dtin to dtout
  dtout%wvl_internal%nSize(:)       = dtin%wvl_internal%nSize(:)
  dtout%wvl_internal%dpSize(:)      = dtin%wvl_internal%dpSize(:)
  dtout%wvl_internal%nDpPoints      = dtin%wvl_internal%nDpPoints
  dtout%wvl_internal%buffer         = dtin%wvl_internal%buffer
  dtout%wvl_internal%orbital_path   = dtin%wvl_internal%orbital_path

  !Copy allocated real arrays from dtin to dtout
  dtout%acell_orig(:)      = dtin%acell_orig(:)
  dtout%angdeg_orig(:)     = dtin%angdeg_orig(:)
  dtout%boxcenter(:)       = dtin%boxcenter(:)
  dtout%efield(:)          = dtin%efield(:)
  dtout%genafm(:)          = dtin%genafm(:)
  dtout%qpt(:)             = dtin%qpt(:)
  dtout%qptn(:)            = dtin%qptn(:)
  dtout%rprim_orig(:,:)    = dtin%rprim_orig(:,:)
  dtout%rprimd_orig(:,:)   = dtin%rprimd_orig(:,:)
  dtout%strtarget(:)       = dtin%strtarget(:)
  dtout%vprtrb(:)          = dtin%vprtrb(:)

  ! This list of variables are allocated using the maximum size
  ! over all datasets, so we just read the allocated size and reproduce
  ! it.
  !  bdgw(2,mxnkptgw))
  !  kpt(3,mxnkpt))
  !  kptgw(3,mxnkptgw))
  !  kptns(3,mxnkpt))
  !  iatsph(mxnatsph))
  !  istwfk(mxnkpt))
  !  ltypeorb(mxnorb))
  !  nband(mxnkpt*mxnsppol))
  !  numorb(mxncenter))
  !  occ_orig(mxmband_upper*mxnkpt*mxnsppol))
  !  qptdm(3,mxnqptdm))
  !  rcoord(3,mxncenter))
  !  rtheta(3,mxnorb))
  !  symafm(mxnsym))
  !  symrel(3,3,mxnsym))
  !  tnons(3,mxnsym))
  !  wtatcon(3,mxnatom,mxnconeq))
  !  wtk(mxnkpt))
  !  iatfix(3,mxnatom))
  !  spinat(3,mxnatom))
  !  typat(mxnatom))
  !  vel_orig(3,mxnatom))
  !  xred_orig(3,mxnatom))
  !  algalch(mxntypat))
  !  amu(mxntypat))
  !  densty(mxntypat,4))
  !  jpawu(mxntypat))
  !  lpawu(mxntypat))
  !  mixalch(npsp,mxntypat))
  !  so_typat(mxntypat))
  !  upawu(mxntypat))
  !  ziontypat(mxntypat))
  !  znucl(npsp))

!#define DTSET_AREA_NAME_STR
!#define DTSET_AREA_NAME  
!#define DTSET_AREA_SIZE1  
!  if (associated(dtin%DTSET_AREA_NAME)) then
!     write(name,*) DTSET_AREA_NAME_STR
!     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
!     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
!     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
!  end if
!#undef DTSET_AREA_NAME
!#undef DTSET_AREA_SIZE1
!#undef DTSET_AREA_NAME_STR 
!
!#define DTSET_AREA_NAME_STR
!#define DTSET_AREA_NAME  
!#define DTSET_AREA_SIZE1  
!#define DTSET_AREA_SIZE2  
!  if (associated(dtin%DTSET_AREA_NAME)) then
!     write(name,*) DTSET_AREA_NAME_STR
!     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
!     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
!     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
!     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
!  end if
!#undef DTSET_AREA_NAME
!#undef DTSET_AREA_SIZE1
!#undef DTSET_AREA_SIZE2
!#undef DTSET_AREA_NAME_STR 



#define DTSET_AREA_NAME_STR "algalch"
#define DTSET_AREA_NAME  algalch
#define DTSET_AREA_SIZE1  ntypalch
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%algalch)) allocate(dtout%algalch(dtin%ntypalch))
!  dtout%algalch(:)         = dtin%algalch(:)

#define DTSET_AREA_NAME_STR "bdgw"
#define DTSET_AREA_NAME  bdgw
#define DTSET_AREA_SIZE1  2
#define DTSET_AREA_SIZE2  nkptgw
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,2,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))     
     dtout%DTSET_AREA_NAME(:,1:size(dtin%DTSET_AREA_NAME,2))=dtin%DTSET_AREA_NAME(:,1:size(dtin%DTSET_AREA_NAME,2))          
  end if 
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2 
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%bdgw)) allocate(dtout%bdgw(2, dtin%nkptgw))
!  dtout%bdgw(:,:)          = dtin%bdgw(:,:)


#define DTSET_AREA_NAME_STR "iatfix"
#define DTSET_AREA_NAME  iatfix
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  natom
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%iatfix)) allocate(dtout%iatfix(3, dtin%natom))
!  dtout%iatfix(:,:)        = dtin%iatfix(:,:)

#define DTSET_AREA_NAME_STR "iatsph"
#define DTSET_AREA_NAME  iatsph
#define DTSET_AREA_SIZE1  natsph
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%iatsph)) allocate(dtout%iatsph(dtin%natsph))
!  dtout%iatsph(:)          = dtin%iatsph(:)

#define DTSET_AREA_NAME_STR "istwfk"
#define DTSET_AREA_NAME  istwfk
#define DTSET_AREA_SIZE1  nkpt
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%istwfk)) allocate(dtout%istwfk(dtin%nkpt))
!  dtout%istwfk(:)          = dtin%istwfk(:)

#define DTSET_AREA_NAME_STR "kberry"
#define DTSET_AREA_NAME  kberry
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nberry
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%kberry)) allocate(dtout%kberry(3, dtin%nberry))
!  dtout%kberry(:,:)        = dtin%kberry(:,:)

#define DTSET_AREA_NAME_STR "lpawu"
#define DTSET_AREA_NAME  lpawu
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  if (associated(dtin%lpawu)) allocate(dtout%lpawu(dtin%ntypat))
!  dtout%lpawu(:)        = dtin%lpawu(:)

#define DTSET_AREA_NAME_STR "ltypeorb"
#define DTSET_AREA_NAME  ltypeorb
#define DTSET_AREA_SIZE1  norb
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%ltypeorb(dtin%norb))
 ! dtout%ltypeorb(:)        = dtin%ltypeorb(:)

#define DTSET_AREA_NAME_STR "nband"
#define DTSET_AREA_NAME  nband
#define DTSET_AREA_SIZE1  nsppol
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%nband(dtin%nkpt * dtin%nsppol))
!  dtout%nband(:)           = dtin%nband(:)

#define DTSET_AREA_NAME_STR "numorb"
#define DTSET_AREA_NAME  numorb
#define DTSET_AREA_SIZE1  ncenter
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%numorb(dtin%ncenter))
!  dtout%numorb(:)          = dtin%numorb(:)

#define DTSET_AREA_NAME_STR "so_typat"
#define DTSET_AREA_NAME  so_typat
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%so_typat(dtin%ntypat))
!  dtout%so_typat(:)        = dtin%so_typat(:)

#define DTSET_AREA_NAME_STR "symafm"
#define DTSET_AREA_NAME  symafm
#define DTSET_AREA_SIZE1  nsym
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%symafm(dtin%nsym))
!  dtout%symafm(:)          = dtin%symafm(:)

#define DTSET_AREA_NAME_STR "symrel"
#define DTSET_AREA_NAME  symrel
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  3
#define DTSET_AREA_SIZE3  nsym
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     call tells_sizes(chosen_size3,name,3,dtin%DTSET_AREA_SIZE3,size(dtin%DTSET_AREA_NAME,3))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2,chosen_size3))
     dtout%DTSET_AREA_NAME(:,:,:)=dtin%DTSET_AREA_NAME(:,:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_SIZE3 
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%symrel(3, 3, dtin%nsym))
!  dtout%symrel(:,:,:)      = dtin%symrel(:,:,:)

#define DTSET_AREA_NAME_STR "typat"
#define DTSET_AREA_NAME  typat
#define DTSET_AREA_SIZE1  natom
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%typat(dtin%natom))
!  dtout%typat(:)           = dtin%typat(:)





  !Allocate and copy real pointers
  !same syntax as the one for integer pointers

#define DTSET_AREA_NAME_STR "amu"
#define DTSET_AREA_NAME  amu
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
 ! allocate(dtout%amu(dtin%ntypat))
 ! dtout%amu(:)             = dtin%amu(:)

#define DTSET_AREA_NAME_STR "densty"
#define DTSET_AREA_NAME  densty
#define DTSET_AREA_SIZE1  ntypat
#define DTSET_AREA_SIZE2  4
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%densty(dtin%ntypat, 4))
!  dtout%densty(:,:)        = dtin%densty(:,:)

#define DTSET_AREA_NAME_STR "jpawu"
#define DTSET_AREA_NAME  jpawu
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%jpawu(dtin%ntypat))
!  dtout%jpawu(:)            = dtin%jpawu(:)
 
#define DTSET_AREA_NAME_STR "kpt"
#define DTSET_AREA_NAME  kpt
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nkpt
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
 ! allocate(dtout%kpt(3, dtin%nkpt))
 ! dtout%kpt(:,:)           = dtin%kpt(:,:)

#define DTSET_AREA_NAME_STR "kptgw"
#define DTSET_AREA_NAME  kptgw
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nkptgw
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%kptgw(3, dtin%nkptgw))
!  dtout%kptgw(:,:)         = dtin%kptgw(:,:)

#define DTSET_AREA_NAME_STR "kptns"
#define DTSET_AREA_NAME  kptns
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nkpt
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%kptns(3, dtin%nkpt))
!  dtout%kptns(:,:)         = dtin%kptns(:,:)

#define DTSET_AREA_NAME_STR "mixalch"
#define DTSET_AREA_NAME  mixalch
#define DTSET_AREA_SIZE1  npspalch
#define DTSET_AREA_SIZE2  ntypalch
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2 
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%mixalch(dtin%npspalch, dtin%ntypalch))
!dtout%mixalch(:,:)       = dtin%mixalch(:,:)

#define DTSET_AREA_NAME_STR "occ_orig"
#define DTSET_AREA_NAME  occ_orig
#define DTSET_AREA_SIZE1  (dtin%mband*dtin%nkpt*dtin%nsppol)
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%occ_orig(dtin%mband * dtin%nkpt * dtin%nsppol))
!  dtout%occ_orig(:)        = dtin%occ_orig(:)

#define DTSET_AREA_NAME_STR "qptdm"
#define DTSET_AREA_NAME  qptdm
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nqptdm
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%qptdm(3, dtin%nqptdm))
!  dtout%qptdm(:,:)         = dtin%qptdm(:,:)

#define DTSET_AREA_NAME_STR "rcoord"
#define DTSET_AREA_NAME  rcoord
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  ncenter
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%rcoord(3, dtin%ncenter))
!  dtout%rcoord(:,:)        = dtin%rcoord(:,:)

#define DTSET_AREA_NAME_STR "rtheta"
#define DTSET_AREA_NAME  rtheta
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  norb
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%rtheta(3, dtin%norb))
!  dtout%rtheta(:,:)        = dtin%rtheta(:,:)

#define DTSET_AREA_NAME_STR "shiftk"
#define DTSET_AREA_NAME  shiftk
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nshiftk
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%shiftk(3, dtin%nshiftk))
!  dtout%shiftk(:,:)        = dtin%shiftk(:,:)

#define DTSET_AREA_NAME_STR "spinat"
#define DTSET_AREA_NAME  spinat
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  natom
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%spinat(3, dtin%natom))
!  dtout%spinat(:,:)        = dtin%spinat(:,:)

#define DTSET_AREA_NAME_STR "tnons"
#define DTSET_AREA_NAME  tnons
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  nsym
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%tnons(3, dtin%nsym))
!  dtout%tnons(:,:)         = dtin%tnons(:,:)

#define DTSET_AREA_NAME_STR "upawu"
#define DTSET_AREA_NAME  upawu
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%upawu(dtin%ntypat))
!  dtout%upawu(:)            = dtin%upawu(:)

#define DTSET_AREA_NAME_STR "vel_orig"
#define DTSET_AREA_NAME  vel_orig
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  natom
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%vel_orig(3, dtin%natom))
!  dtout%vel_orig(:,:)      = dtin%vel_orig(:,:)

#define DTSET_AREA_NAME_STR "wtatcon"
#define DTSET_AREA_NAME  wtatcon
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  natom
#define DTSET_AREA_SIZE3  nconeq
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     call tells_sizes(chosen_size3,name,3,dtin%DTSET_AREA_SIZE3,size(dtin%DTSET_AREA_NAME,3))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2,chosen_size3))
     dtout%DTSET_AREA_NAME(:,:,:)=dtin%DTSET_AREA_NAME(:,:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_SIZE3
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%wtatcon(3, dtin%natom, dtin%nconeq))
!  dtout%wtatcon(:,:,:)     = dtin%wtatcon(:,:,:)

#define DTSET_AREA_NAME_STR "wtk"
#define DTSET_AREA_NAME  wtk
#define DTSET_AREA_SIZE1  nkpt
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%wtk(dtin%nkpt))
!  dtout%wtk(:)             = dtin%wtk(:)

#define DTSET_AREA_NAME_STR "xred_orig"
#define DTSET_AREA_NAME  xred_orig
#define DTSET_AREA_SIZE1  3
#define DTSET_AREA_SIZE2  natom
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     call tells_sizes(chosen_size2,name,2,dtin%DTSET_AREA_SIZE2,size(dtin%DTSET_AREA_NAME,2))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1,chosen_size2))
     dtout%DTSET_AREA_NAME(:,:)=dtin%DTSET_AREA_NAME(:,:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_SIZE2
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%xred_orig(3, dtin%natom))
!  dtout%xred_orig(:,:)     = dtin%xred_orig(:,:)

#define DTSET_AREA_NAME_STR "ziontypat"
#define DTSET_AREA_NAME  ziontypat
#define DTSET_AREA_SIZE1  ntypat
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%ziontypat(dtin%ntypat))
!  dtout%ziontypat(:)       = dtin%ziontypat(:)

#define DTSET_AREA_NAME_STR "znucl"
#define DTSET_AREA_NAME  znucl
#define DTSET_AREA_SIZE1  npsp
  if (associated(dtin%DTSET_AREA_NAME)) then
     write(name,*) DTSET_AREA_NAME_STR
     call tells_sizes(chosen_size1,name,1,dtin%DTSET_AREA_SIZE1,size(dtin%DTSET_AREA_NAME,1))
     allocate (dtout%DTSET_AREA_NAME(chosen_size1))
     dtout%DTSET_AREA_NAME(:)=dtin%DTSET_AREA_NAME(:)          
  end if
#undef DTSET_AREA_NAME
#undef DTSET_AREA_SIZE1
#undef DTSET_AREA_NAME_STR 
!  allocate(dtout%znucl(dtin%npsp))
!  dtout%znucl(:)           = dtin%znucl(:)

end subroutine dtsetCopy
  
subroutine  tells_sizes(chosen_size,name,index,default_size,actual_size)

  use defs_basis
  implicit none
  !Arguments ------------------------------------
  character(len=12),intent(in) :: name
  integer, intent(in) :: index 
  integer, intent(in) :: default_size
  integer, intent(in) :: actual_size
  integer, intent(out) ::chosen_size
  
  !Local variables-------------------------------
  logical :: warn
  warn = .FALSE.
  if (default_size .ne. actual_size) then
     warn = .TRUE.
  end if
  chosen_size=actual_size
  if (chosen_size < 0) then
      write(6,*) 'dtsetcopy : copying area ',name,' whose size (',chosen_size,') appear to be uncorrectly defined'
     chosen_size = 0
  end if
  if (warn) then
     write(6,*) 'dtsetcopy : copying area ',name, 'the actual size (',actual_size,&
          &') of the index (',index,')  differs from its standard size (',default_size,')' 
     write(6,*) 'dtsetcopy : this could be a bug'
  end if
   end subroutine  tells_sizes


!!***
