!!****h* BigDFT/lazy_14
!! NAME
!!   lazy_14
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 14)
!!
!! SOURCE
!!
integer, parameter :: m=16
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp,0._dp,0._dp,0.0000275373458862304687e0_dp,0.e0_dp,-0.000423073768615722656e0_dp,0.e0_dp,&
     0.00310254096984863281e0_dp,0.e0_dp,-0.0146262645721435547e0_dp,0.e0_dp,&
     0.0511919260025024414e0_dp,0.e0_dp,-0.153575778007507324e0_dp,0.e0_dp,0.614303112030029297e0_dp,&
     1.e0_dp,0.614303112030029297e0_dp,0.e0_dp,-0.153575778007507324e0_dp,0.e0_dp,&
     0.0511919260025024414e0_dp,0.e0_dp,-0.0146262645721435547e0_dp,0.e0_dp,&
     0.00310254096984863281e0_dp,0.e0_dp,-0.000423073768615722656e0_dp,0.e0_dp,&
     0.0000275373458862304687e0_dp,0._dp,0._dp,0._dp&
     /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1.e0_dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

