!!****m* ABINIT/interfaces_15gw
!! NAME
!! interfaces_15gw
!!
!! FUNCTION
!! This module contains the interfaces of the routines
!! in the directory src/15gw
!!
!! COPYRIGHT
!! Copyright (C) 2005 ABINIT group
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! NOTES
!! THIS FILE IS GENERATED AUTOMATICALLY BY abilint.
!! To do that: abilint . .
!!             (see util/maintainers/abilint.py)
!!
!! SOURCE

module interfaces_15gw

 interface
  subroutine assemblychi0(npwsigx,nomega,chi0,rhotwg,den)
   use defs_basis
   integer,intent(in) :: nomega
   integer,intent(in) :: npwsigx
   complex,target :: chi0(npwsigx,npwsigx,nomega)
   complex(kind(0.0_dp)),intent(in) :: den(nomega)
   complex,intent(in) :: rhotwg(npwsigx)
  end subroutine assemblychi0
 end interface

 interface
  subroutine assemblychi0_sym(npwvec,npwsigx,ninv,nop,nkbz,wtksym,grottbm1,nomega,chi0,rhotwg,den)
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nomega
   integer,intent(in) :: nop
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwvec
   complex,target :: chi0(npwsigx,npwsigx,nomega)
   complex (kind(0.0d0)),intent(in) :: den(nomega)
   integer,intent(in) :: grottbm1(npwvec,2,nop)
   complex,intent(in) :: rhotwg(npwsigx)
   integer,intent(in) :: wtksym(2,nop)
  end subroutine assemblychi0_sym
 end interface

 interface
  subroutine assemblychi0q0_sym(qq,npwvec,npwwfn,npwsigx,ninv,nop,op,&  
&  nkbz,wtksym,grottbm1,nomega,chi0,rhotwx,rhotwg,den,b1,b2,b3)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nomega
   integer,intent(in) :: nop
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwvec
   integer,intent(in) :: npwwfn
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   real(dp),intent(in) :: qq(3)
   complex,intent(in) :: rhotwx(3)
   complex,target :: chi0(npwsigx,npwsigx,nomega)
   complex (kind(0.0d0)),intent(in) :: den(nomega)
   integer,intent(in) :: grottbm1(npwvec,2,nop)
   real(dp),intent(in) :: op(3,3,nop)
   complex,intent(in) :: rhotwg(npwsigx)
   integer,intent(in) :: wtksym(2,nop)
  end subroutine assemblychi0q0_sym
 end interface

 interface
  subroutine bz1(k,g,b1,b2,b3)
   use defs_basis
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   integer,intent(out) :: g(3)
   real(dp),intent(inout) :: k(3)
  end subroutine bz1
 end interface

 interface
  subroutine calc_coh(nr,npwx,npwc,ngfft1a,ngfft1,ngfft2,ngfft3,&  
&  gvec,epsm1q_o,qbzpg,i_sz,iqibz,jb,kb,wfg2_jk,sigcohme)
   use defs_basis
   integer,intent(in) :: iqibz
   integer,intent(in) :: jb
   integer,intent(in) :: kb
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: npwc
   integer,intent(in) :: npwx
   integer,intent(in) :: nr
   real(dp),intent(in) :: i_sz
   complex,intent(out) :: sigcohme
   complex,intent(in) :: epsm1q_o(npwc,npwc)
   integer,intent(in) :: gvec(3,npwx)
   real(dp),intent(in) :: qbzpg(npwx)
   complex,intent(in) :: wfg2_jk(nr)
  end subroutine calc_coh
 end interface

 interface
  subroutine calc_sig_noppm(npwc,nomega,nomegae,nomegaer,nomegaei,rhotwgp,&  
&  omega,epsm1q,omegame0i,theta_mu_minus_e0i,ket)
   use defs_basis
   integer,intent(in) :: nomega
   integer,intent(in) :: nomegae
   integer,intent(in) :: nomegaei
   integer,intent(in) :: nomegaer
   integer,intent(in) :: npwc
   real(dp),intent(in) :: theta_mu_minus_e0i
   complex,intent(in) :: epsm1q(npwc,npwc,nomegae)
   complex,intent(inout) :: ket(npwc,nomega)
   complex,intent(in) :: omega(nomegae)
   real(dp),intent(in) :: omegame0i(nomega)
   complex,intent(in) :: rhotwgp(npwc)
  end subroutine calc_sig_noppm
 end interface

 interface
  subroutine calc_sig_ppm(npwc,nomega,rhotwgp,botsq,otq,omegame0i,zcut,theta_mu_minus_e0i,ket,ppmodel,&  
&  eig,sigcme,npwx,npwc1,npwc2)
   use defs_basis
   integer,intent(in) :: nomega
   integer,intent(in) :: npwc
   integer,intent(in) :: npwc1
   integer,intent(in) :: npwc2
   integer,intent(in) :: npwx
   integer,intent(in) :: ppmodel
   real(dp),intent(in) :: theta_mu_minus_e0i
   real(dp),intent(in) :: zcut
   complex,intent(in) :: botsq(npwc,npwc1)
   complex,intent(in) :: eig(npwc,npwc)
   complex,intent(inout) :: ket(npwc,nomega)
   real(dp),intent(in) :: omegame0i(nomega)
   real(dp),intent(in) :: otq(npwc,npwc2)
   complex,intent(in) :: rhotwgp(npwx)
   complex,intent(out) :: sigcme(nomega)
  end subroutine calc_sig_ppm
 end interface

 interface
  subroutine ccgradvnl(npwwfn,nkibz,b1,b2,b3,gvec,kibz,ntypat,natom,&  
&  mpsang,typat,xcart,vkbsign,vkb,vkbd,gradvnl)
   use defs_basis
   integer :: mpsang
   integer :: natom
   integer :: nkibz
   integer :: npwwfn
   integer :: ntypat
   real(dp) :: b1(3)
   real(dp) :: b2(3)
   real(dp) :: b3(3)
   complex :: gradvnl(3,npwwfn,npwwfn,nkibz)
   integer :: gvec(3,npwwfn)
   real(dp) :: kibz(3,nkibz)
   integer :: typat(natom)
   real(dp) :: vkb(npwwfn,ntypat,mpsang,nkibz)
   real(dp) :: vkbd(npwwfn,ntypat,mpsang,nkibz)
   real(dp) :: vkbsign(mpsang,ntypat)
   real(dp) :: xcart(3,natom)
  end subroutine ccgradvnl
 end interface

 interface
  subroutine ccgradvnl_ylm(npwwfn,nkibz,a1,a2,a3,b1,b2,b3,gvec,kibz,ntypat,natom,&  
&  mpsang,typat,xcart,vkbsign,vkb,vkbd,l_fnl,l_fnld)
   use defs_basis
   integer,intent(in) :: mpsang
   integer,intent(in) :: natom
   integer,intent(in) :: nkibz
   integer,intent(in) :: npwwfn
   integer,intent(in) :: ntypat
   real(dp),intent(in) :: a1(3)
   real(dp),intent(in) :: a2(3)
   real(dp),intent(in) :: a3(3)
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   integer,intent(in) :: gvec(3,npwwfn)
   real(dp),intent(in) :: kibz(3,nkibz)
   complex,intent(out) :: l_fnl(npwwfn,mpsang*mpsang,natom,nkibz)
   complex,intent(out) :: l_fnld(3,npwwfn,mpsang*mpsang,natom,nkibz)
   integer,intent(in) :: typat(natom)
   real(dp),intent(in) :: vkb(npwwfn,ntypat,mpsang,nkibz)
   real(dp),intent(in) :: vkbd(npwwfn,ntypat,mpsang,nkibz)
   real(dp),intent(in) :: vkbsign(mpsang,ntypat)
   real(dp),intent(in) :: xcart(3,natom)
  end subroutine ccgradvnl_ylm
 end interface

 interface
  subroutine cchi0(qq,nomega,omega,npwvec,npwsigx,npwwfn,nkibz,nkibzm,nbnds,&  
&  nbv,nsppol,occ,ktab,ktabr,ktabi,kbz,nkbz,ngfft1,ngfft1a,ngfft2,ngfft3,igfft,&  
&  nr,energy,gwenergy,etadelta,chi0,mpi_enreg,nop,grottbm1,lt_q,min_band_proc,max_band_proc,&  
&  parallelism_is_on_kpoints,parallelism_is_on_bands,nbnds_per_proc,distributed,nonlocal,wfr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nbnds
   integer,intent(in) :: nbnds_per_proc
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nkbz
   integer,intent(in) :: nkibz
   integer,intent(in) :: nkibzm
   integer,intent(in) :: nomega
   integer,intent(in) :: nop
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwvec
   integer,intent(in) :: npwwfn
   integer,intent(in) :: nr
   integer,intent(in) :: nsppol
   logical,intent(in) :: distributed
   real(dp),intent(in) :: etadelta
   type(little_group),intent(in) :: lt_q
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: nonlocal
   logical,intent(in) :: parallelism_is_on_bands
   logical,intent(in) :: parallelism_is_on_kpoints
   real(dp),intent(in) :: qq(3)
   complex,intent(out) :: chi0(npwsigx,npwsigx,nomega)
   real(dp),intent(in) :: energy(nkibz,min_band_proc:max_band_proc,nsppol)
   integer,intent(in) :: grottbm1(npwvec,2,nop)
   real(dp),intent(in) :: gwenergy(nkibz,min_band_proc:max_band_proc,nsppol)
   integer,intent(in) :: igfft(npwvec,5,5,5)
   real(dp),intent(in) :: kbz(3,nkbz)
   integer,intent(in) :: ktab(nkibzm)
   integer,intent(in) :: ktabi(nkibzm)
   integer,intent(in) :: ktabr(nr,nkibzm)
   integer,intent(in) :: nbv(nsppol)
   real(dp),intent(in) :: occ(nkibz,min_band_proc:max_band_proc,nsppol)
   complex,intent(in) :: omega(nomega)
   complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
  end subroutine cchi0
 end interface

 interface
  subroutine cchi0q0(qq,nomega,omega,gvec,npwvec,npwsigx,npwwfn,op,nop,kibz,&  
&  nkibz,nkibzm,nbnds,nbv,nsppol,occ,ktab,ktabr,ktabi,ktabo,kbz,nkbz,irottb,&  
&  ngfft1,ngfft1a,ngfft2,ngfft3,igfft,nr,energy,gwenergy,etadelta,chi0,b1,b2,b3,ucvol,&  
&  wtk,grottb,inclvkb,gradvnl,mpi_enreg,&  
&  grottbm1,lt_q,natom,mpsang,fnl,fnld,&  
&  min_band_proc,max_band_proc,&  
&  parallelism_is_on_kpoints,parallelism_is_on_bands,nbnds_per_proc,distributed,nonlocal,wfr,wfg)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: inclvkb
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: mpsang
   integer,intent(in) :: natom
   integer,intent(in) :: nbnds
   integer,intent(in) :: nbnds_per_proc
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nkbz
   integer,intent(in) :: nkibz
   integer,intent(in) :: nkibzm
   integer,intent(in) :: nomega
   integer,intent(in) :: nop
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwvec
   integer,intent(in) :: npwwfn
   integer,intent(in) :: nr
   integer,intent(in) :: nsppol
   logical,intent(in) :: distributed
   real(dp),intent(in) :: etadelta
   type(little_group),intent(in) :: lt_q
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: nonlocal
   logical,intent(in) :: parallelism_is_on_bands
   logical,intent(in) :: parallelism_is_on_kpoints
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   real(dp),intent(in) :: qq(3)
   complex,intent(out) :: chi0(npwsigx,npwsigx,nomega)
   real(dp),intent(in) :: energy(nkibz,min_band_proc:max_band_proc,nsppol)
   complex,intent(in) :: fnl(npwwfn,mpsang*mpsang,natom,nkibz)
   complex,intent(in) :: fnld(3,npwwfn,mpsang*mpsang,natom,nkibz)
   complex,intent(in) :: gradvnl(3,npwwfn,npwwfn,nkibz)
   integer,intent(in) :: grottb(npwvec,2,nop)
   integer,intent(in) :: grottbm1(npwvec,2,nop)
   integer,intent(in) :: gvec(3,npwvec)
   real(dp),intent(in) :: gwenergy(nkibz,min_band_proc:max_band_proc,nsppol)
   integer,intent(in) :: igfft(npwvec,5,5,5)
   integer,intent(in) :: irottb(nr,nop)
   real(dp),intent(in) :: kbz(3,nkibzm)
   real(dp),intent(in) :: kibz(3,nkibz)
   integer,intent(in) :: ktab(nkibzm)
   integer,intent(in) :: ktabi(nkibzm)
   integer,intent(in) :: ktabo(nkibzm)
   integer,intent(in) :: ktabr(nr,nkibzm)
   integer,intent(in) :: nbv(nsppol)
   real(dp),intent(in) :: occ(nkibz,min_band_proc:max_band_proc,nsppol)
   complex,intent(in) :: omega(nomega)
   real(dp),intent(in) :: op(3,3,nop)
   complex,intent(in),optional :: wfg(npwwfn,min_band_proc:max_band_proc,nkibz,nsppol)
   complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
   real(dp),intent(in) :: wtk(nkibz)
  end subroutine cchi0q0
 end interface

 interface
  subroutine cggfft(npwvec,ngfft1,ngfft2,ngfft3,gvec,igfft)
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: npwvec
   integer,intent(in) :: gvec(3,npwvec)
   integer,intent(out) :: igfft(npwvec,npwvec)
  end subroutine cggfft
 end interface

 interface
  subroutine cigfft(npwvec,n1d,n1,n2,n3,gvec,igfft)
   integer,intent(in) :: n1
   integer,intent(in) :: n1d
   integer,intent(in) :: n2
   integer,intent(in) :: n3
   integer,intent(in) :: npwvec
   integer,intent(in) :: gvec(3,npwvec)
   integer,intent(out) :: igfft(npwvec,5,5,5)
  end subroutine cigfft
 end interface

 interface
  subroutine ckxcldag(ngfft1,ngfft1a,ngfft2,ngfft3,nr,rho2,kxclda)
   use defs_basis
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nr
   complex,intent(out) :: kxclda(nr)
   real(dp),intent(in) :: rho2(nr)
  end subroutine ckxcldag
 end interface

 interface
  subroutine ckxcldar(nr,rho2,kxclda)
   use defs_basis
   integer,intent(in) :: nr
   complex,intent(out) :: kxclda(nr)
   real(dp),intent(in) :: rho2(nr)
  end subroutine ckxcldar
 end interface

 interface
  subroutine clcqpg(npwx,npwc,gvec,q,nq,b1,b2,b3,qpg,qratio)
   use defs_basis
   integer,intent(in) :: npwc
   integer,intent(in) :: npwx
   integer,intent(in) :: nq
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   integer,intent(in) :: gvec(3,npwx)
   real(dp),intent(in) :: q(3,nq)
   real(dp),intent(out) :: qpg(npwx,nq)
   real(dp),intent(out) :: qratio(npwc,npwc,nq)
  end subroutine clcqpg
 end interface

 interface
  subroutine cmevxclda(dtset,ixc,mpi_enreg,nbnds,ngfft1,ngfft2,ngfft3,nkibz,nr,nrb,nsppol,&  
&  rho,rprimd,wfr,vxcme,min_band_proc,max_band_proc,parallelism_is_on_bands)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nbnds
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nkibz
   integer,intent(in) :: nr
   integer,intent(in) :: nrb
   integer,intent(in) :: nsppol
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: parallelism_is_on_bands
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: rho(nr,nsppol)
   complex,intent(out) :: vxcme(nbnds,nbnds,nkibz,nsppol)
   complex,intent(in) :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
  end subroutine cmevxclda
 end interface

 interface
  subroutine cppm1par(npwvec,nq,nomega,epsm1,omega,bigomegatwsq,omegatw,&  
&  omegaplasma)
   use defs_basis
   integer,intent(in) :: nomega
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   real(dp),intent(in) :: omegaplasma
   complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq)
   complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
   complex,intent(in) :: omega(nomega)
   complex,intent(out) :: omegatw(npwvec,npwvec,nq)
  end subroutine cppm1par
 end interface

 interface
  subroutine cppm2par(npwvec,nq,nomega,epsm1,bigomegatwsq,omegatw,&  
&  ngfft1,ngfft2,ngfft3,gvec,qratio,rho,nr,q,b1,b2,b3)
   use defs_basis
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nomega
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   integer,intent(in) :: nr
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq)
   complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
   integer,intent(in) :: gvec(3,npwvec)
   complex,intent(out) :: omegatw(npwvec,npwvec,nq)
   real(dp),intent(in) :: q(nq)
   real(dp),intent(in) :: qratio(npwvec,npwvec,nq)
   real(dp),intent(inout) :: rho(nr)
  end subroutine cppm2par
 end interface

 interface
  subroutine cppm3par(npwvec,nq,nomega,epsm1,bigomegatwsq,omegatw,&  
&  ngfft1,ngfft2,ngfft3,gvec,rho,nr,eigtot,q,b1,b2,b3)
   use defs_basis
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nomega
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   integer,intent(in) :: nr
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   complex,intent(out) :: bigomegatwsq(npwvec,1,nq)
   complex,intent(out) :: eigtot(npwvec,npwvec,nq)
   complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
   integer,intent(in) :: gvec(3,npwvec)
   complex,intent(out) :: omegatw(npwvec,1,nq)
   real(dp),intent(in) :: q(3,nq)
   real(dp),intent(inout) :: rho(nr)
  end subroutine cppm3par
 end interface

 interface
  subroutine cppm4par(npwvec,nq,epsm1,nomega,bigomegatwsq,omegatw,&  
&  ngfft1,ngfft2,ngfft3,gvec,rho,nr,q,b1,b2,b3)
   use defs_basis
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nomega
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   integer,intent(in) :: nr
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   complex,intent(out) :: bigomegatwsq(npwvec,npwvec,nq)
   complex,intent(in) :: epsm1(npwvec,npwvec,nomega,nq)
   integer,intent(in) :: gvec(3,npwvec)
   complex,intent(out) :: omegatw(npwvec,1,nq)
   real(dp),intent(in) :: q(3,nq)
   real(dp),intent(inout) :: rho(nr)
  end subroutine cppm4par
 end interface

 interface
  subroutine crho(irottb,nbnds,ninv,nkbz,nkibz,nkibzm,nop,nr,nrb,nsppol,occ,omegaplasma,rho,ucvol,wfr,wtk,&  
mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nbnds
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nkibz
   integer,intent(in) :: nkibzm
   integer,intent(in) :: nop
   integer,intent(in) :: nr
   integer,intent(in) :: nrb
   integer,intent(in) :: nsppol
   type(MPI_type),intent(in) :: mpi_enreg
   real(dp),intent(out) :: omegaplasma
   logical,intent(in) :: parallelism_is_on_bands
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: irottb(nr,nop)
   real(dp),intent(in) :: occ(nkibzm,min_band_proc:max_band_proc,nsppol)
   real(dp),intent(out) :: rho(nr,nsppol)
   complex,intent(in) :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
   real(dp),intent(in) :: wtk(nkibz)
  end subroutine crho
 end interface

 interface
  subroutine csigme(sp,ep,jk,minbnd,maxbnd,&  
&  q,gvec,npwvec,op,nop,kibz,ktab,ktabr,ktabi,kbz,&  
&  ngfft1,ngfft1a,ngfft2,ngfft3,igfft,nr,en,occ,qbz,qtab,qtabi,&  
&  qtabo,qpg,ucvol,grottb,wfr,efermi,&  
&  er,sr,mpi_enreg,ppmodel,eigpot,b1,b2,b3,nbnds_per_proc,min_band_proc,max_band_proc,&  
&  parallelism_is_on_kpoints,parallelism_is_on_bands,lt_k)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: jk
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: maxbnd
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: minbnd
   integer,intent(in) :: nbnds_per_proc
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nop
   integer,intent(in) :: npwvec
   integer,intent(in) :: nr
   integer,intent(in) :: ppmodel
   real(dp),intent(in) :: efermi
   type(epsilonm1_parameters),intent(in) :: ep
   type(epsilonm1_results),intent(in) :: er
   type(little_group),intent(in) :: lt_k
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: parallelism_is_on_bands
   logical,intent(in) :: parallelism_is_on_kpoints
   type(sigma_parameters),intent(in) :: sp
   type(sigma_results),intent(inout) :: sr
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   complex,intent(in) :: eigpot(sp%npwc,sp%npwc,sp%nq)
   real(dp),intent(in) :: en(sp%nk,min_band_proc:max_band_proc,sp%nsppol)
   integer,intent(in) :: grottb(npwvec,2,nop)
   integer,intent(in) :: gvec(3,npwvec)
   integer,target :: igfft(npwvec,5,5,5)
   real(dp),intent(in) :: kbz(3,sp%nkbz)
   real(dp),intent(in) :: kibz(3,sp%nk)
   integer,intent(in) :: ktab(sp%nkbz)
   integer,intent(in) :: ktabi(sp%nkbz)
   integer,intent(in) :: ktabr(nr,sp%nkbz)
   real(dp),intent(in) :: occ(sp%nk,min_band_proc:max_band_proc,sp%nsppol)
   real(dp),intent(in) :: op(3,3,nop)
   real(dp),intent(in) :: q(3,sp%nq)
   real(dp),intent(in) :: qbz(3,sp%nqbz)
   real(dp),intent(in) :: qpg(sp%npwx,sp%nq)
   integer,intent(in) :: qtab(sp%nqbz)
   integer,intent(in) :: qtabi(sp%nqbz)
   integer,intent(in) :: qtabo(sp%nqbz)
   complex,intent(in) :: wfr(nr,min_band_proc:max_band_proc,sp%nk,sp%nsppol)
  end subroutine csigme
 end interface

 interface
  subroutine cvc(nq,iq,q,b1,b2,b3,npwvec,gvec,qplusg)
   use defs_basis
   integer,intent(in) :: iq
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   integer,intent(in) :: gvec(3,npwvec)
   real(dp),intent(in) :: q(3,nq)
   real(dp),intent(out) :: qplusg(npwvec)
  end subroutine cvc
 end interface

 interface
  subroutine cvxclda(dtset,ixc,mpi_enreg,ngfft1,ngfft2,ngfft3,nr,nsppol,rho,rprimd,vxclda)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: ixc
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nr
   integer,intent(in) :: nsppol
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   real(dp),intent(in) :: rprimd(3,3)
   real(dp),intent(in) :: rho(nr,nsppol)
   real(dp),intent(out) :: vxclda(nr,nsppol)
  end subroutine cvxclda
 end interface

 interface
  subroutine density(nbnds,nkibzm,nkibz,nkbz,nsppol,nop,ninv,nr,ngfft1,ngfft1a,&  
&  ngfft2,ngfft3,irottb,ucvol,wtk,occ,rho2,omegaplasma,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands,nonlocal,wfr)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nbnds
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nkibz
   integer,intent(in) :: nkibzm
   integer,intent(in) :: nop
   integer,intent(in) :: nr
   integer,intent(in) :: nsppol
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: nonlocal
   real(dp),intent(out) :: omegaplasma
   logical,intent(in) :: parallelism_is_on_bands
   real(dp),intent(in) :: ucvol
   integer,intent(in) :: irottb(nr,nop)
   real(dp),intent(in) :: occ(nkibzm,min_band_proc:max_band_proc,nsppol)
   real(dp),intent(out) :: rho2(nr,nsppol)
   complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
   real(dp),intent(in) :: wtk(nkibz)
  end subroutine density
 end interface

 interface
  function diffvc(rho)
   use defs_basis
   real(dp) :: diffvc
   real(dp),intent(in) :: rho
  end function diffvc
 end interface

 interface
  function diffvx(rho)
   use defs_basis
   real(dp) :: diffvx
   real(dp),intent(in) :: rho
  end function diffvx
 end interface

 interface
  function difrel(rho)
   use defs_basis
   real(dp) :: difrel
   real(dp),intent(in) :: rho
  end function difrel
 end interface

 interface
  function difvxc(rho)
   use defs_basis
   real(dp) :: difvxc
   real(dp),intent(in) :: rho
  end function difvxc
 end interface

 interface
  subroutine dosym(op,iinv,k1,k2)
   use defs_basis
   integer,intent(in) :: iinv
   real(dp),intent(in) :: k1(3)
   real(dp),intent(out) :: k2(3)
   real(dp),intent(in) :: op(3,3)
  end subroutine dosym
 end interface

 interface
  subroutine dosymr(op,iinv,r1,ngfft,r2)
   use defs_basis
   integer,intent(in) :: iinv
   integer,intent(in) :: ngfft(3)
   real(dp),intent(in) :: op(3,3)
   real(dp),intent(in) :: r1(3)
   real(dp),intent(out) :: r2(3)
  end subroutine dosymr
 end interface

 interface
  complex function dotproductqrc(r,c,b1,b2,b3)
   use defs_basis
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   complex,intent(in) :: c(3)
   real(dp),intent(in) :: r(3)
  end function dotproductqrc
 end interface

 interface
  subroutine fermi(hdr,nb,nk,fixmom,ns,wtk,en,occ,nel,nbv,&  
&  fermie,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nb
   integer,intent(inout) :: nel
   integer,intent(in) :: nk
   integer,intent(in) :: ns
   real(dp),intent(out) :: fermie
   real(dp),intent(in) :: fixmom
   type(hdr_type),intent(in) :: hdr
   type(MPI_type),intent(in) :: mpi_enreg
   logical,intent(in) :: parallelism_is_on_bands
   real(dp),intent(in) :: en(nk,min_band_proc:max_band_proc,ns)
   integer,intent(out) :: nbv(ns)
   real(dp),intent(inout) :: occ(nk,min_band_proc:max_band_proc,ns)
   real(dp),intent(in) :: wtk(nk)
  end subroutine fermi
 end interface

 interface
  subroutine fftwfn(npwwfn,nb,nk,nr,ns,wfg,wfr,igfft,ngfft1,ngfft1a,ngfft2,ngfft3,&  
&  tim_fourdp,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nb
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nk
   integer,intent(in) :: npwwfn
   integer,intent(in) :: nr
   integer,intent(in) :: ns
   integer,intent(in) :: tim_fourdp
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: parallelism_is_on_bands
   integer,intent(in) :: igfft(npwwfn)
   complex,intent(in) :: wfg(npwwfn,min_band_proc:max_band_proc,nk,ns)
   complex,intent(out) :: wfr(nr,min_band_proc:max_band_proc,nk,ns)
  end subroutine fftwfn
 end interface

 interface
  subroutine findk(nkcalc,nkbz,xkcalc,kbz,kcalc,option,verbose)
   use defs_basis
   integer,intent(in) :: nkbz
   integer,intent(in) :: nkcalc
   integer,intent(in) :: option
   integer,intent(in) :: verbose
   real(dp),intent(in) :: kbz(3,nkbz)
   integer,intent(out) :: kcalc(nkcalc)
   real(dp),intent(in) :: xkcalc(3,nkcalc)
  end subroutine findk
 end interface

 interface
  logical function findkp(nkbz,kbz,ik,k,g0)
   use defs_basis
   integer,intent(out) :: ik
   integer,intent(in) :: nkbz
   integer,intent(out) :: g0(3)
   real(dp),intent(in) :: k(3)
   real(dp),intent(in) :: kbz(3,nkbz)
  end function findkp
 end interface

 interface
  subroutine findnq(nkbz,kbz,nop,op,nq,ninv)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nop
   integer,intent(out) :: nq
   real(dp),intent(in) :: kbz(3,nkbz)
   real(dp),intent(in) :: op(3,3,nop)
  end subroutine findnq
 end interface

 interface
  subroutine findq(nkbz,kbz,nop,op,nq,q,ninv,b1,b2,b3)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nop
   integer,intent(in) :: nq
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   real(dp),intent(in) :: kbz(3,nkbz)
   real(dp),intent(in) :: op(3,3,nop)
   real(dp),intent(out) :: q(3,nq)
  end subroutine findq
 end interface

 interface
  subroutine findqg0(iq,g0,kmkp,nqbz,qbz)
   use defs_basis
   integer,intent(out) :: iq
   integer,intent(in) :: nqbz
   integer,intent(out) :: g0(3)
   real(dp),intent(in) :: kmkp(3)
   real(dp),intent(in) :: qbz(3,nqbz)
  end subroutine findqg0
 end interface

 interface
  subroutine findshells(b1,b2,b3,ng,ngs,gvec)
   use defs_basis
   integer :: ng
   integer :: ngs
   real(dp) :: b1(3)
   real(dp) :: b2(3)
   real(dp) :: b3(3)
   integer :: gvec(3,ng)
  end subroutine findshells
 end interface

 interface
  subroutine fkin(ff,kincontrib,omegame0,otw1,otw2,zcut)
   use defs_basis
   integer,intent(in) :: ff
   real(dp),intent(out) :: kincontrib
   real(dp),intent(in) :: omegame0
   real(dp),intent(in) :: otw1
   real(dp),intent(in) :: otw2
   real(dp),intent(in) :: zcut
  end subroutine fkin
 end interface

 interface
  subroutine hermitianize(m,n)
   integer,intent(in) :: n
   complex,intent(inout) :: m(n,n)
  end subroutine hermitianize
 end interface

 interface
  integer function icmpk2(k1,k2)
   use defs_basis
   real(dp),intent(in) :: k1(3)
   real(dp),intent(in) :: k2(3)
  end function icmpk2
 end interface

 interface
  subroutine identk(kibz,nkibz,nkbzmx,nr,nop,ninv,irottb,op,kbz,ktab,ktabr,&  
&  ktabi,ktabo,nkbz,wtk)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(out) :: nkbz
   integer,intent(in) :: nkbzmx
   integer,intent(in) :: nkibz
   integer,intent(in) :: nop
   integer,intent(in) :: nr
   integer,intent(in) :: irottb(nr,nop)
   real(dp),intent(out) :: kbz(3,nkbzmx)
   real(dp),intent(in) :: kibz(3,nkibz)
   integer,intent(out) :: ktab(nkbzmx)
   integer,intent(out) :: ktabi(nkbzmx)
   integer,intent(out) :: ktabo(nkbzmx)
   integer,intent(out) :: ktabr(nr,nkbzmx)
   real(dp),intent(in) :: op(3,3,nop)
   real(dp),intent(out) :: wtk(nkibz)
  end subroutine identk
 end interface

 interface
  subroutine identq(q,nq,nqbzmx,op,nop,ninv,qbz,qtab,qtabi,qtabo,nqbz)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(in) :: nop
   integer,intent(in) :: nq
   integer,intent(out) :: nqbz
   integer,intent(in) :: nqbzmx
   real(dp),intent(in) :: op(3,3,nop)
   real(dp),intent(in) :: q(3,nq)
   real(dp),intent(out) :: qbz(3,nqbzmx)
   integer,intent(out) :: qtab(nqbzmx)
   integer,intent(out) :: qtabi(nqbzmx)
   integer,intent(out) :: qtabo(nqbzmx)
  end subroutine identq
 end interface

 interface
  subroutine write_sigma_results_header(sp,ep)
   use defs_datatypes
   type(epsilonm1_parameters),intent(in) :: ep
   type(sigma_parameters),intent(in) :: sp
  end subroutine write_sigma_results_header
 end interface

 interface
  subroutine write_sigma_results(sp,sr,ikcalc,ikibz,en_lda)
   use defs_basis
   use defs_datatypes
   integer, intent(in) :: ikcalc
   integer, intent(in) :: ikibz
   type(sigma_parameters), intent(in) :: sp
   type(sigma_results), intent(in) :: sr
   real(dp),intent(in) :: en_lda(sp%nk,sp%nb,sp%nsppol)
  end subroutine write_sigma_results
 end interface

 interface
  subroutine rdgw(nk,nb,nbv,ns,kibz,gwenergy)
   use defs_basis
   integer, intent(in) :: nb
   integer, intent(in) :: nk
   integer, intent(in) :: ns
   real(dp), intent(out) :: gwenergy(nk,nb,ns)
   real(dp), intent(in) :: kibz(3,nk)
   integer, intent(in) :: nbv(ns)
  end subroutine rdgw
 end interface

 interface
  subroutine calc_wf_qp(nk,nb,nsize,ns,m_lda_to_qp,wf,min_band_proc,max_band_proc)
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nb
   integer,intent(in) :: nk
   integer,intent(in) :: ns
   integer,intent(in) :: nsize
   complex,intent(inout) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
   complex,intent(inout) :: wf(nsize,min_band_proc:max_band_proc,nk,ns)
  end subroutine calc_wf_qp
 end interface

 interface
  integer function itst0(q)
   use defs_basis
   real(dp),intent(in) :: q(3)
  end function itst0
 end interface

 interface
  subroutine lattice(a1,a2,a3,b1,b2,b3,ucvol,bzvol)
   use defs_basis
   real(dp),intent(out) :: bzvol
   real(dp),intent(out) :: ucvol
   real(dp),intent(in) :: a1(3)
   real(dp),intent(in) :: a2(3)
   real(dp),intent(in) :: a3(3)
   real(dp),intent(out) :: b1(3)
   real(dp),intent(out) :: b2(3)
   real(dp),intent(out) :: b3(3)
  end subroutine lattice
 end interface

 interface
  function linfit(n,x,y,a,b)
   use defs_basis
   integer,intent(in) :: n
   real(dp),intent(out) :: a
   real(dp),intent(out) :: b
   real(dp) :: linfit
   real(dp),intent(in) :: x(n)
   real(dp),intent(in) :: y(n)
  end function linfit
 end interface

 interface
  subroutine memerr(sub_name,array_name,size_in,kindp)
   integer,intent(in) :: size_in
   character(len=*),intent(in) :: array_name
   character(len=*),intent(in) :: kindp
   character(len=*),intent(in) :: sub_name
  end subroutine memerr
 end interface

 interface
  integer function modx(i,j)
   integer,intent(in) :: i
   integer,intent(in) :: j
  end function modx
 end interface

 interface
  subroutine pclock(itimpt)
   integer,intent(in) :: itimpt
  end subroutine pclock
 end interface

 interface
  subroutine prep_coh(nb,nr,ns,wfr_k,ktabr_k,minbnd,maxbnd,ngfft1,ngfft2,ngfft3,tim_fourdp,wfg2,mpi_enreg)
   use defs_datatypes
   integer,intent(in) :: maxbnd
   integer,intent(in) :: minbnd
   integer,intent(in) :: nb
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: nr
   integer,intent(in) :: ns
   integer,intent(in) :: tim_fourdp
   type(MPI_type),intent(inout) :: mpi_enreg
   integer,intent(in) :: ktabr_k(nr)
   complex,intent(out) :: wfg2(nr,minbnd:maxbnd,minbnd:maxbnd,ns)
   complex,intent(in) :: wfr_k(nr,nb,ns)
  end subroutine prep_coh
 end interface

 interface
  subroutine printcm(aa,nn,mm)
   integer,intent(in) :: mm
   integer,intent(in) :: nn
   complex,intent(in) :: aa(nn,mm)
  end subroutine printcm
 end interface

 interface
  subroutine printv(aa,nn)
   integer :: nn
   complex :: aa(nn)
  end subroutine printv
 end interface

 interface
  subroutine rdkss(dtfil,hdr,nopx,nbx,nkx,ngx,nsx,nwx,tit,a1,a2,a3,op,gvec,kibz,en,&  
&  oc,wf,ntypatx,natomx,mpsangx,typat,xred,vkbsign,vkb,vkbd,nel,mpi_enreg,nonlocal,min_band_proc,max_band_proc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: mpsangx
   integer,intent(in) :: natomx
   integer,intent(in) :: nbx
   integer,intent(out) :: nel
   integer,intent(in) :: ngx
   integer,intent(in) :: nkx
   integer,intent(in) :: nopx
   integer,intent(in) :: nsx
   integer,intent(in) :: ntypatx
   integer,intent(in) :: nwx
   type(datafiles_type),intent(in) :: dtfil
   type(hdr_type),intent(out) :: hdr
   type(MPI_type),intent(in) :: mpi_enreg
   logical,intent(in) :: nonlocal
   real(dp),intent(out) :: a1(3)
   real(dp),intent(out) :: a2(3)
   real(dp),intent(out) :: a3(3)
   character(len=80),intent(out) :: tit(2)
   real(dp),intent(out) :: en(nkx,min_band_proc:max_band_proc,nsx)
   integer,intent(out) :: gvec(3,ngx)
   real(dp),intent(out) :: kibz(3,nkx)
   real(dp),intent(out) :: oc(nkx,min_band_proc:max_band_proc,nsx)
   real(dp),intent(out) :: op(3,3,nopx)
   integer,intent(out) :: typat(natomx)
   real(dp),intent(out) :: vkb(nwx,ntypatx,mpsangx,nkx)
   real(dp),intent(out) :: vkbd(nwx,ntypatx,mpsangx,nkx)
   real(dp),intent(out) :: vkbsign(mpsangx,ntypatx)
   complex,intent(out) :: wf(nwx,min_band_proc:max_band_proc,nkx,nsx)
   real(dp),intent(out) :: xred(3,natomx)
  end subroutine rdkss
 end interface

 interface
  subroutine rdlda(iunit,nopx,nbx,nkx,ngx,nwx,nop,nb,nk,ng,tit,i1,i2,i3,&  
&  a1,a2,a3,op,gvec,kibz,en,occ,wf)
   use defs_basis
   integer,intent(inout) :: i1
   integer,intent(out) :: i2
   integer,intent(out) :: i3
   integer,intent(in) :: iunit
   integer,intent(out) :: nb
   integer,intent(in) :: nbx
   integer,intent(out) :: ng
   integer,intent(in) :: ngx
   integer,intent(out) :: nk
   integer,intent(in) :: nkx
   integer,intent(out) :: nop
   integer,intent(in) :: nopx
   integer,intent(in) :: nwx
   real(dp),intent(out) :: a1(3)
   real(dp),intent(out) :: a2(3)
   real(dp),intent(out) :: a3(3)
   character(len=80),intent(out) :: tit(2)
   real(dp),intent(out) :: en(nkx,nbx)
   integer,intent(out) :: gvec(3,ngx)
   real(dp),intent(out) :: kibz(3,nkx)
   real(dp),intent(out) :: occ(nkx,nbx)
   real(dp),intent(out) :: op(3,3,nopx)
   complex,intent(out) :: wf(nwx,nbx,nkx)
  end subroutine rdlda
 end interface

 interface
  subroutine rdldaabinit(iunit,nopx,nbx,nkx,ngx,nwx,tit,a1,a2,a3,op,gvec,&  
&  kibz,en,occ,wfg)
   use defs_basis
   integer,intent(in) :: iunit
   integer,intent(in) :: nbx
   integer,intent(in) :: ngx
   integer,intent(in) :: nkx
   integer,intent(in) :: nopx
   integer,intent(in) :: nwx
   real(dp),intent(out) :: a1(3)
   real(dp),intent(out) :: a2(3)
   real(dp),intent(out) :: a3(3)
   character(len=80),intent(out) :: tit(2)
   real(dp),intent(out) :: en(nkx,nbx)
   integer,intent(out) :: gvec(3,ngx)
   real(dp),intent(out) :: kibz(3,nkx)
   real(dp),intent(out) :: occ(nkx,nbx)
   real(dp),intent(out) :: op(3,3,nopx)
   complex,intent(out) :: wfg(nwx,nbx,nkx)
  end subroutine rdldaabinit
 end interface

 interface
  subroutine rdqps(dtfil,gwcalctyp,nk,nb,ns,kibz,nscf,nr,en,en_qp,m_lda_to_qp,rho_p,min_band_proc,max_band_proc,mpi_enreg)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: gwcalctyp
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nb
   integer,intent(in) :: nk
   integer,intent(in) :: nr
   integer,intent(in) :: ns
   integer,intent(out) :: nscf
   type(datafiles_type),intent(in) :: dtfil
   type(MPI_type),intent(in) :: mpi_enreg
   real(dp),intent(in) :: en(nk,min_band_proc:max_band_proc,ns)
   real(dp),intent(out) :: en_qp(nk,min_band_proc:max_band_proc,ns)
   real(dp),intent(in) :: kibz(3,nk)
   complex,intent(out) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
   real(dp),intent(inout) :: rho_p(nr,ns)
  end subroutine rdqps
 end interface

 interface
  subroutine rdscr(dtfil,npwvec,nq,nomega,q,omega,epsm1,mpi_enreg,nonlocal)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: nomega
   integer,intent(in) :: npwvec
   integer,intent(in) :: nq
   type(datafiles_type),intent(in) :: dtfil
   type(MPI_type),intent(in) :: mpi_enreg
   logical,intent(in) :: nonlocal
   complex,intent(out) :: epsm1(npwvec,npwvec,nomega,nq)
   complex,intent(out) :: omega(nomega)
   real(dp),intent(out) :: q(3,nq)
  end subroutine rdscr
 end interface

 interface
  function rel(rho)
   use defs_basis
   real(dp) :: rel
   real(dp),intent(in) :: rho
  end function rel
 end interface

 interface
  subroutine rho_tw_g(npwvec,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,igfftg0,wfn1,&  
&  i1,ktabr1,wfn2,i2,ktabr2,rhotwg,tim_fourdp)
   integer,intent(in) :: i1
   integer,intent(in) :: i2
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: npwvec
   integer,intent(in) :: nr
   integer,intent(in) :: nrb
   integer,intent(in) :: tim_fourdp
   integer,intent(in) :: igfftg0(npwvec)
   integer,intent(in) :: ktabr1(nr)
   integer,intent(in) :: ktabr2(nr)
   complex,intent(out) :: rhotwg(npwvec)
   complex,intent(in) :: wfn1(nr)
   complex,intent(in) :: wfn2(nr)
  end subroutine rho_tw_g
 end interface

 interface
  function scpdt(u,v,b1,b2,b3)
   use defs_basis
   real(dp) :: scpdt
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   real(dp),intent(in) :: u(3)
   real(dp),intent(in) :: v(3)
  end function scpdt
 end interface

 interface
  subroutine setmesh(gmet,gvec,n1,n2,n3,n1d,n2d,n3d,npwsigx,npwwfn,nr,method)
   use defs_basis
   integer,intent(in) :: method
   integer,intent(out) :: n1
   integer,intent(out) :: n1d
   integer,intent(out) :: n2
   integer,intent(out) :: n2d
   integer,intent(out) :: n3
   integer,intent(out) :: n3d
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwwfn
   integer,intent(out) :: nr
   real(dp),intent(in) :: gmet(3,3)
   integer,intent(in) :: gvec(3,max(npwwfn,npwsigx))
  end subroutine setmesh
 end interface

 interface
  subroutine setshells(ecut,npw,nsh,nsym,gmet,gprimd,symrel,tag,ucvol)
   use defs_basis
   integer,intent(inout) :: npw
   integer,intent(inout) :: nsh
   integer,intent(in) :: nsym
   real(dp),intent(inout) :: ecut
   character(len=3),intent(in) :: tag
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: gprimd(3,3)
   integer,intent(in) :: symrel(3,3,nsym)
  end subroutine setshells
 end interface

 interface
  subroutine hartrham(dtset,sp,gmet,ucvol,ngfft1,ngfft2,ngfft3,nfft,&  
&  npwvec,gvec,kibz,wtk,nsppol,wfr,wfg,rho,occ,en,hhartr,mpi_enreg,min_band_proc,max_band_proc,parallelism_is_on_bands)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nfft
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: npwvec
   integer,intent(in) :: nsppol
   type(dataset_type),intent(in) :: dtset
   type(MPI_type),intent(inout) :: mpi_enreg
   logical,intent(in) :: parallelism_is_on_bands
   type(sigma_parameters),intent(in) :: sp
   real(dp),intent(in) :: ucvol
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: en(sp%nk,min_band_proc:max_band_proc,nsppol)
   integer,intent(in) :: gvec(3,npwvec)
   complex,intent(out) :: hhartr(sp%nb,sp%nb,sp%nk,nsppol)
   real(dp),intent(in) :: kibz(3,sp%nk)
   real(dp),intent(in) :: occ(sp%nk,min_band_proc:max_band_proc,nsppol)
   real(dp),intent(inout) :: rho(nfft)
   complex,intent(in) :: wfg(sp%npwwfn,min_band_proc:max_band_proc,sp%nk,nsppol)
   complex,intent(in) :: wfr(nfft,min_band_proc:max_band_proc,sp%nk,nsppol)
   real(dp),intent(in) :: wtk(sp%nk)
  end subroutine hartrham
 end interface

 interface
  subroutine ham_changebasis(nb,nk,ns,c,h)
   integer,intent(in) :: nb
   integer,intent(in) :: nk
   integer,intent(in) :: ns
   complex,intent(in) :: c(nb,nb,nk,ns)
   complex,intent(inout) :: h(nb,nb,nk,ns)
  end subroutine ham_changebasis
 end interface

 interface
  subroutine diago_hamilt(minbnd,maxbnd,nsppol,hhartree,sigxme,sigcme,eigvec_qp,en_qp)
   use defs_basis
   integer,intent(in) :: maxbnd
   integer,intent(in) :: minbnd
   integer,intent(in) :: nsppol
   complex,intent(inout) :: eigvec_qp(minbnd:maxbnd,minbnd:maxbnd,nsppol)
   real(dp),intent(out) :: en_qp(minbnd:maxbnd,nsppol)
   complex,intent(in) :: hhartree(minbnd:maxbnd,minbnd:maxbnd,nsppol)
   complex,intent(in) :: sigcme(minbnd:maxbnd,minbnd:maxbnd,nsppol)
   complex,intent(in) :: sigxme(minbnd:maxbnd,minbnd:maxbnd,nsppol)
  end subroutine diago_hamilt
 end interface

 interface
  subroutine setup_little_group(xpt,gmet,nop,op,ninv,nkbz,kbz,ibzq,ltg,lgtab,lgtabo,lgtabi,wtksym)
   use defs_basis
   integer,intent(in) :: ninv
   integer,intent(in) :: nkbz
   integer,intent(in) :: nop
   real(dp),intent(in) :: gmet(3,3)
   real(dp),intent(in) :: xpt(3)
   integer,intent(inout) :: ibzq(nkbz)
   real(dp),intent(in) :: kbz(3,nkbz)
   integer,intent(inout) :: lgtab(nkbz)
   integer,intent(inout) :: lgtabi(nkbz)
   integer,intent(inout) :: lgtabo(nkbz)
   integer,intent(inout) :: ltg(2,nop)
   real(dp),intent(in) :: op(3,3,nop)
   integer,intent(inout) :: wtksym(2,nop,nkbz)
  end subroutine setup_little_group
 end interface

 interface
  subroutine sizefft(m,n)
   integer,intent(in) :: m
   integer,intent(out) :: n
  end subroutine sizefft
 end interface

 interface
  subroutine surot(op,nop,ninv,ngfft1,ngfft1a,ngfft2,ngfft3,nr,npwvec,gvec,grottb,&  
&  irottb,grottbm1)
   use defs_basis
   integer,intent(in) :: ngfft1
   integer,intent(in) :: ngfft1a
   integer,intent(in) :: ngfft2
   integer,intent(in) :: ngfft3
   integer,intent(in) :: ninv
   integer,intent(in) :: nop
   integer,intent(in) :: npwvec
   integer,intent(in) :: nr
   integer,intent(out) :: grottb(npwvec,2,nop)
   integer,intent(out) :: grottbm1(npwvec,2,nop)
   integer,intent(in) :: gvec(3,npwvec)
   integer,intent(out) :: irottb(nr,nop)
   real(dp),intent(in) :: op(3,3,nop)
  end subroutine surot
 end interface

 interface
  subroutine testlda(dtfil,nsym,nkpt,nbnd,npw,nsh,i1,i2,ntypat,natom,mpsang,nsppol,mpi_enreg,nonlocal)
   use defs_datatypes
   integer,intent(out) :: i1
   integer,intent(out) :: i2
   integer,intent(out) :: mpsang
   integer,intent(out) :: natom
   integer,intent(out) :: nbnd
   integer,intent(out) :: nkpt
   integer,intent(out) :: npw
   integer,intent(out) :: nsh
   integer,intent(out) :: nsppol
   integer,intent(out) :: nsym
   integer,intent(out) :: ntypat
   type(datafiles_type),intent(in) :: dtfil
   type(MPI_type),intent(in) :: mpi_enreg
   logical,intent(in) :: nonlocal
  end subroutine testlda
 end interface

 interface
  subroutine testscr(dtfil,nq,nomega,npwvece,npwwfne,nbndse,titem1,fform,mpi_enreg,nonlocal)
   use defs_datatypes
   integer,intent(out) :: fform
   integer,intent(out) :: nbndse
   integer,intent(out) :: nomega
   integer,intent(out) :: npwvece
   integer,intent(out) :: npwwfne
   integer,intent(out) :: nq
   type(datafiles_type),intent(in) :: dtfil
   type(MPI_type),intent(in) :: mpi_enreg
   logical,intent(in) :: nonlocal
   character(len=80),intent(out) :: titem1(2)
  end subroutine testscr
 end interface

 interface
  function vcjas(rho)
   use defs_basis
   real(dp),intent(in) :: rho
   real(dp) :: vcjas
  end function vcjas
 end interface

 interface
  function vlngth(v,b1,b2,b3)
   use defs_basis
   real(dp) :: vlngth
   real(dp),intent(in) :: b1(3)
   real(dp),intent(in) :: b2(3)
   real(dp),intent(in) :: b3(3)
   real(dp),intent(in) :: v(3)
  end function vlngth
 end interface

 interface
  function vxcca(rho)
   use defs_basis
   real(dp),intent(in) :: rho
   real(dp) :: vxcca
  end function vxcca
 end interface

 interface
  function vxjas(rho)
   use defs_basis
   real(dp),intent(in) :: rho
   real(dp) :: vxjas
  end function vxjas
 end interface

 interface
  function vxnr(rho)
   use defs_basis
   real(dp),intent(in) :: rho
   real(dp) :: vxnr
  end function vxnr
 end interface

 interface
  subroutine wrqps(dtfil,gwcalctyp,nk,nb,ns,kibz,nscf,nr,en_qp,eigvec_qp,m_lda_to_qp,rho_qp,min_band_proc,max_band_proc)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: gwcalctyp
   integer,intent(in) :: max_band_proc
   integer,intent(in) :: min_band_proc
   integer,intent(in) :: nb
   integer,intent(in) :: nk
   integer,intent(in) :: nr
   integer,intent(in) :: ns
   integer,intent(in) :: nscf
   type(datafiles_type),intent(in) :: dtfil
   complex,intent(in) :: eigvec_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
   real(dp),intent(in) :: en_qp(min_band_proc:max_band_proc,nk,ns)
   real(dp),intent(in) :: kibz(3,nk)
   complex,intent(in) :: m_lda_to_qp(min_band_proc:max_band_proc,min_band_proc:max_band_proc,nk,ns)
   real(dp),intent(in) :: rho_qp(nr,ns)
  end subroutine wrqps
 end interface

 interface
  subroutine wrscr(dtfil,hdr,dtset,npwsigx,npwwfn,npwmax,nbnds,nq,nomega,q,omega,&  
&  gvec,iq,epsm1,title,unitnum,nop,op)
   use defs_basis
   use defs_datatypes
   integer,intent(in) :: iq
   integer,intent(in) :: nbnds
   integer,intent(in) :: nomega
   integer,intent(in) :: nop
   integer,intent(in) :: npwmax
   integer,intent(in) :: npwsigx
   integer,intent(in) :: npwwfn
   integer,intent(in) :: nq
   integer,intent(in),optional :: unitnum
   type(datafiles_type),intent(in) :: dtfil
   type(dataset_type),intent(in) :: dtset
   type(hdr_type),intent(inout) :: hdr
   character(len=80),intent(in) :: title(2)
   complex,intent(in) :: epsm1(npwsigx,npwsigx,nomega)
   integer,intent(in) :: gvec(3,npwmax)
   complex,intent(in) :: omega(nomega)
   real(dp) :: op(3,3,nop)
   real(dp),intent(in) :: q(3,nq)
  end subroutine wrscr
 end interface

end module interfaces_15gw
!!***
