/*
 * SNMP Package
 *
 * Copyright (C) 2002, Jonathan Sevy <jsevy@mcs.drexel.edu>
 *
 * This is free software. Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that the following conditions
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, this
 *     list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation 
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO 
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


package snmp;



/**
*	Class representing a general string of bits.
*/

public class SNMPBitString extends SNMPOctetString
{
	
	protected byte tag = SNMPBERCodec.SNMPBITSTRING;
		
	
	/**
	*	Create a zero-length bit string.
	*/
	
	public SNMPBitString()
	{
		this.data = new byte[0];
	}
	
	
	/**
	*	Create a bit string from the bytes of the supplied String.
	*/
	
	public SNMPBitString(String stringData)
	{
		this.data = stringData.getBytes();
	}
	
	
	/**
	*	Create a bit string from the supplied byte array. The array may be either
	*	user-supplied, or part of a retrieved BER encoding. Note that the BER encoding
	*	of the data of a bit string is just the raw bytes.
	*/
	
	public SNMPBitString(byte[] enc)
	{
		extractFromBEREncoding(enc);
	}
	
	
}