// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudtrail

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTags for more information on using the AddTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags
func (c *CloudTrail) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddTags API operation for AWS CloudTrail.
//
// Adds one or more tags to a trail, up to a limit of 50. Tags must be unique
// per trail. Overwrites an existing tag's value when a new value is specified
// for an existing tag key. If you specify a key without a value, the tag will
// be created with the specified key and a value of null. You can tag a trail
// that applies to all regions only from the region in which the trail was created
// (that is, from its home region).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the specified resource is not found.
//
//   * ErrCodeARNInvalidException "ARNInvalidException"
//   This exception is thrown when an operation is called with an invalid trail
//   ARN. The format of a trail ARN is:
//
//   arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
//
//   * ErrCodeResourceTypeNotSupportedException "ResourceTypeNotSupportedException"
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * ErrCodeTagsLimitExceededException "TagsLimitExceededException"
//   The number of tags per trail has exceeded the permitted amount. Currently,
//   the limit is 50.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidTagParameterException "InvalidTagParameterException"
//   This exception is thrown when the key or value specified for the tag does
//   not match the regular expression ^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTags
func (c *CloudTrail) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	return out, req.Send()
}

// AddTagsWithContext is the same as AddTags with the addition of
// the ability to pass a context and additional request options.
//
// See AddTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) AddTagsWithContext(ctx aws.Context, input *AddTagsInput, opts ...request.Option) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrail = "CreateTrail"

// CreateTrailRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrail operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrail for more information on using the CreateTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTrailRequest method.
//    req, resp := client.CreateTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail
func (c *CloudTrail) CreateTrailRequest(input *CreateTrailInput) (req *request.Request, output *CreateTrailOutput) {
	op := &request.Operation{
		Name:       opCreateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrailInput{}
	}

	output = &CreateTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrail API operation for AWS CloudTrail.
//
// Creates a trail that specifies the settings for delivery of log data to an
// Amazon S3 bucket. A maximum of five trails can exist in a region, irrespective
// of the region in which they were created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation CreateTrail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMaximumNumberOfTrailsExceededException "MaximumNumberOfTrailsExceededException"
//   This exception is thrown when the maximum number of trails is reached.
//
//   * ErrCodeTrailAlreadyExistsException "TrailAlreadyExistsException"
//   This exception is thrown when the specified trail already exists.
//
//   * ErrCodeS3BucketDoesNotExistException "S3BucketDoesNotExistException"
//   This exception is thrown when the specified S3 bucket does not exist.
//
//   * ErrCodeInsufficientS3BucketPolicyException "InsufficientS3BucketPolicyException"
//   This exception is thrown when the policy on the S3 bucket is not sufficient.
//
//   * ErrCodeInsufficientSnsTopicPolicyException "InsufficientSnsTopicPolicyException"
//   This exception is thrown when the policy on the SNS topic is not sufficient.
//
//   * ErrCodeInsufficientEncryptionPolicyException "InsufficientEncryptionPolicyException"
//   This exception is thrown when the policy on the S3 bucket or KMS key is not
//   sufficient.
//
//   * ErrCodeInvalidS3BucketNameException "InvalidS3BucketNameException"
//   This exception is thrown when the provided S3 bucket name is not valid.
//
//   * ErrCodeInvalidS3PrefixException "InvalidS3PrefixException"
//   This exception is thrown when the provided S3 prefix is not valid.
//
//   * ErrCodeInvalidSnsTopicNameException "InvalidSnsTopicNameException"
//   This exception is thrown when the provided SNS topic name is not valid.
//
//   * ErrCodeInvalidKmsKeyIdException "InvalidKmsKeyIdException"
//   This exception is thrown when the KMS key ARN is invalid.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeTrailNotProvidedException "TrailNotProvidedException"
//   This exception is deprecated.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   This exception is thrown when the combination of parameters provided is not
//   valid.
//
//   * ErrCodeKmsKeyNotFoundException "KmsKeyNotFoundException"
//   This exception is thrown when the KMS key does not exist, or when the S3
//   bucket and the KMS key are not in the same region.
//
//   * ErrCodeKmsKeyDisabledException "KmsKeyDisabledException"
//   This exception is deprecated.
//
//   * ErrCodeKmsException "KmsException"
//   This exception is thrown when there is an issue with the specified KMS key
//   and the trail can’t be updated.
//
//   * ErrCodeInvalidCloudWatchLogsLogGroupArnException "InvalidCloudWatchLogsLogGroupArnException"
//   This exception is thrown when the provided CloudWatch log group is not valid.
//
//   * ErrCodeInvalidCloudWatchLogsRoleArnException "InvalidCloudWatchLogsRoleArnException"
//   This exception is thrown when the provided role is not valid.
//
//   * ErrCodeCloudWatchLogsDeliveryUnavailableException "CloudWatchLogsDeliveryUnavailableException"
//   Cannot set a CloudWatch Logs delivery for this region.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrail
func (c *CloudTrail) CreateTrail(input *CreateTrailInput) (*CreateTrailOutput, error) {
	req, out := c.CreateTrailRequest(input)
	return out, req.Send()
}

// CreateTrailWithContext is the same as CreateTrail with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) CreateTrailWithContext(ctx aws.Context, input *CreateTrailInput, opts ...request.Option) (*CreateTrailOutput, error) {
	req, out := c.CreateTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrail = "DeleteTrail"

// DeleteTrailRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrail operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrail for more information on using the DeleteTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTrailRequest method.
//    req, resp := client.DeleteTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail
func (c *CloudTrail) DeleteTrailRequest(input *DeleteTrailInput) (req *request.Request, output *DeleteTrailOutput) {
	op := &request.Operation{
		Name:       opDeleteTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrailInput{}
	}

	output = &DeleteTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTrail API operation for AWS CloudTrail.
//
// Deletes a trail. This operation must be called from the region in which the
// trail was created. DeleteTrail cannot be called on the shadow trails (replicated
// trails in other regions) of a trail that is enabled in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation DeleteTrail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidHomeRegionException "InvalidHomeRegionException"
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrail
func (c *CloudTrail) DeleteTrail(input *DeleteTrailInput) (*DeleteTrailOutput, error) {
	req, out := c.DeleteTrailRequest(input)
	return out, req.Send()
}

// DeleteTrailWithContext is the same as DeleteTrail with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) DeleteTrailWithContext(ctx aws.Context, input *DeleteTrailInput, opts ...request.Option) (*DeleteTrailOutput, error) {
	req, out := c.DeleteTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrails = "DescribeTrails"

// DescribeTrailsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrails operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrails for more information on using the DescribeTrails
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTrailsRequest method.
//    req, resp := client.DescribeTrailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails
func (c *CloudTrail) DescribeTrailsRequest(input *DescribeTrailsInput) (req *request.Request, output *DescribeTrailsOutput) {
	op := &request.Operation{
		Name:       opDescribeTrails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrailsInput{}
	}

	output = &DescribeTrailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrails API operation for AWS CloudTrail.
//
// Retrieves settings for the trail associated with the current region for your
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation DescribeTrails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrails
func (c *CloudTrail) DescribeTrails(input *DescribeTrailsInput) (*DescribeTrailsOutput, error) {
	req, out := c.DescribeTrailsRequest(input)
	return out, req.Send()
}

// DescribeTrailsWithContext is the same as DescribeTrails with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrails for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) DescribeTrailsWithContext(ctx aws.Context, input *DescribeTrailsInput, opts ...request.Option) (*DescribeTrailsOutput, error) {
	req, out := c.DescribeTrailsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventSelectors = "GetEventSelectors"

// GetEventSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the GetEventSelectors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventSelectors for more information on using the GetEventSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventSelectorsRequest method.
//    req, resp := client.GetEventSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors
func (c *CloudTrail) GetEventSelectorsRequest(input *GetEventSelectorsInput) (req *request.Request, output *GetEventSelectorsOutput) {
	op := &request.Operation{
		Name:       opGetEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEventSelectorsInput{}
	}

	output = &GetEventSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventSelectors API operation for AWS CloudTrail.
//
// Describes the settings for the event selectors that you configured for your
// trail. The information returned for your event selectors includes the following:
//
//    * The S3 objects that you are logging for data events.
//
//    * If your event selector includes management events.
//
//    * If your event selector includes read-only events, write-only events,
//    or all.
//
// For more information, see Logging Data and Management Events for Trails
// (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// in the AWS CloudTrail User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetEventSelectors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectors
func (c *CloudTrail) GetEventSelectors(input *GetEventSelectorsInput) (*GetEventSelectorsOutput, error) {
	req, out := c.GetEventSelectorsRequest(input)
	return out, req.Send()
}

// GetEventSelectorsWithContext is the same as GetEventSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetEventSelectorsWithContext(ctx aws.Context, input *GetEventSelectorsInput, opts ...request.Option) (*GetEventSelectorsOutput, error) {
	req, out := c.GetEventSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrailStatus = "GetTrailStatus"

// GetTrailStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetTrailStatus operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrailStatus for more information on using the GetTrailStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTrailStatusRequest method.
//    req, resp := client.GetTrailStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus
func (c *CloudTrail) GetTrailStatusRequest(input *GetTrailStatusInput) (req *request.Request, output *GetTrailStatusOutput) {
	op := &request.Operation{
		Name:       opGetTrailStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTrailStatusInput{}
	}

	output = &GetTrailStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrailStatus API operation for AWS CloudTrail.
//
// Returns a JSON-formatted list of information about the specified trail. Fields
// include information on delivery errors, Amazon SNS and Amazon S3 errors,
// and start and stop logging times for each trail. This operation returns trail
// status from a single region. To return trail status from all regions, you
// must call the operation on each region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation GetTrailStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatus
func (c *CloudTrail) GetTrailStatus(input *GetTrailStatusInput) (*GetTrailStatusOutput, error) {
	req, out := c.GetTrailStatusRequest(input)
	return out, req.Send()
}

// GetTrailStatusWithContext is the same as GetTrailStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrailStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) GetTrailStatusWithContext(ctx aws.Context, input *GetTrailStatusInput, opts ...request.Option) (*GetTrailStatusOutput, error) {
	req, out := c.GetTrailStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPublicKeys = "ListPublicKeys"

// ListPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListPublicKeys operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPublicKeys for more information on using the ListPublicKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPublicKeysRequest method.
//    req, resp := client.ListPublicKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys
func (c *CloudTrail) ListPublicKeysRequest(input *ListPublicKeysInput) (req *request.Request, output *ListPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPublicKeysInput{}
	}

	output = &ListPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPublicKeys API operation for AWS CloudTrail.
//
// Returns all public keys whose private keys were used to sign the digest files
// within the specified time range. The public key is needed to validate digest
// files that were signed with its corresponding private key.
//
// CloudTrail uses different private/public key pairs per region. Each digest
// file is signed with a private key unique to its region. Therefore, when you
// validate a digest file from a particular region, you must look in the same
// region for its corresponding public key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation ListPublicKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidTimeRangeException "InvalidTimeRangeException"
//   Occurs if the timestamp values are invalid. Either the start time occurs
//   after the end time or the time range is outside the range of possible values.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
//   * ErrCodeInvalidTokenException "InvalidTokenException"
//   Reserved for future use.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeys
func (c *CloudTrail) ListPublicKeys(input *ListPublicKeysInput) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	return out, req.Send()
}

// ListPublicKeysWithContext is the same as ListPublicKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListPublicKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListPublicKeysWithContext(ctx aws.Context, input *ListPublicKeysInput, opts ...request.Option) (*ListPublicKeysOutput, error) {
	req, out := c.ListPublicKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags
func (c *CloudTrail) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS CloudTrail.
//
// Lists the tags for the trail in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the specified resource is not found.
//
//   * ErrCodeARNInvalidException "ARNInvalidException"
//   This exception is thrown when an operation is called with an invalid trail
//   ARN. The format of a trail ARN is:
//
//   arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
//
//   * ErrCodeResourceTypeNotSupportedException "ResourceTypeNotSupportedException"
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
//   * ErrCodeInvalidTokenException "InvalidTokenException"
//   Reserved for future use.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTags
func (c *CloudTrail) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opLookupEvents = "LookupEvents"

// LookupEventsRequest generates a "aws/request.Request" representing the
// client's request for the LookupEvents operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See LookupEvents for more information on using the LookupEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the LookupEventsRequest method.
//    req, resp := client.LookupEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents
func (c *CloudTrail) LookupEventsRequest(input *LookupEventsInput) (req *request.Request, output *LookupEventsOutput) {
	op := &request.Operation{
		Name:       opLookupEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &LookupEventsInput{}
	}

	output = &LookupEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// LookupEvents API operation for AWS CloudTrail.
//
// Looks up API activity events captured by CloudTrail that create, update,
// or delete resources in your account. Events for a region can be looked up
// for the times in which you had CloudTrail turned on in that region during
// the last seven days. Lookup supports the following attributes:
//
//    * Event ID
//
//    * Event name
//
//    * Event source
//
//    * Resource name
//
//    * Resource type
//
//    * User name
//
// All attributes are optional. The default number of results returned is 10,
// with a maximum of 50 possible. The response includes a token that you can
// use to get the next page of results.
//
// The rate of lookup requests is limited to one per second per account. If
// this limit is exceeded, a throttling error occurs.
//
// Events that occurred during the selected time range will not be available
// for lookup if CloudTrail logging was not enabled when the events occurred.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation LookupEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidLookupAttributesException "InvalidLookupAttributesException"
//   Occurs when an invalid lookup attribute is specified.
//
//   * ErrCodeInvalidTimeRangeException "InvalidTimeRangeException"
//   Occurs if the timestamp values are invalid. Either the start time occurs
//   after the end time or the time range is outside the range of possible values.
//
//   * ErrCodeInvalidMaxResultsException "InvalidMaxResultsException"
//   This exception is thrown if the limit specified is invalid.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   Invalid token or token that was previously used in a request with different
//   parameters. This exception is thrown if the token is invalid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEvents
func (c *CloudTrail) LookupEvents(input *LookupEventsInput) (*LookupEventsOutput, error) {
	req, out := c.LookupEventsRequest(input)
	return out, req.Send()
}

// LookupEventsWithContext is the same as LookupEvents with the addition of
// the ability to pass a context and additional request options.
//
// See LookupEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) LookupEventsWithContext(ctx aws.Context, input *LookupEventsInput, opts ...request.Option) (*LookupEventsOutput, error) {
	req, out := c.LookupEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// LookupEventsPages iterates over the pages of a LookupEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See LookupEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a LookupEvents operation.
//    pageNum := 0
//    err := client.LookupEventsPages(params,
//        func(page *LookupEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *CloudTrail) LookupEventsPages(input *LookupEventsInput, fn func(*LookupEventsOutput, bool) bool) error {
	return c.LookupEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// LookupEventsPagesWithContext same as LookupEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) LookupEventsPagesWithContext(ctx aws.Context, input *LookupEventsInput, fn func(*LookupEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *LookupEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.LookupEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*LookupEventsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutEventSelectors = "PutEventSelectors"

// PutEventSelectorsRequest generates a "aws/request.Request" representing the
// client's request for the PutEventSelectors operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutEventSelectors for more information on using the PutEventSelectors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutEventSelectorsRequest method.
//    req, resp := client.PutEventSelectorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors
func (c *CloudTrail) PutEventSelectorsRequest(input *PutEventSelectorsInput) (req *request.Request, output *PutEventSelectorsOutput) {
	op := &request.Operation{
		Name:       opPutEventSelectors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutEventSelectorsInput{}
	}

	output = &PutEventSelectorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutEventSelectors API operation for AWS CloudTrail.
//
// Configures an event selector for your trail. Use event selectors to specify
// whether you want your trail to log management and/or data events. When an
// event occurs in your account, CloudTrail evaluates the event selectors in
// all trails. For each trail, if the event matches any event selector, the
// trail processes and logs the event. If the event doesn't match any event
// selector, the trail doesn't log the event.
//
// Example
//
// You create an event selector for a trail and specify that you want write-only
// events.
//
// The EC2 GetConsoleOutput and RunInstances API operations occur in your account.
//
// CloudTrail evaluates whether the events match your event selectors.
//
// The RunInstances is a write-only event and it matches your event selector.
// The trail logs the event.
//
// The GetConsoleOutput is a read-only event but it doesn't match your event
// selector. The trail doesn't log the event.
//
// The PutEventSelectors operation must be called from the region in which the
// trail was created; otherwise, an InvalidHomeRegionException is thrown.
//
// You can configure up to five event selectors for each trail. For more information,
// see Logging Data and Management Events for Trails  (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html)
// in the AWS CloudTrail User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation PutEventSelectors for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidHomeRegionException "InvalidHomeRegionException"
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * ErrCodeInvalidEventSelectorsException "InvalidEventSelectorsException"
//   This exception is thrown when the PutEventSelectors operation is called with
//   an invalid number of event selectors, data resources, or an invalid value
//   for a parameter:
//
//      * Specify a valid number of event selectors (1 to 5) for a trail.
//
//      * Specify a valid number of data resources (1 to 250) for an event selector.
//
//      * Specify a valid value for a parameter. For example, specifying the ReadWriteType
//      parameter with a value of read-only is invalid.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectors
func (c *CloudTrail) PutEventSelectors(input *PutEventSelectorsInput) (*PutEventSelectorsOutput, error) {
	req, out := c.PutEventSelectorsRequest(input)
	return out, req.Send()
}

// PutEventSelectorsWithContext is the same as PutEventSelectors with the addition of
// the ability to pass a context and additional request options.
//
// See PutEventSelectors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) PutEventSelectorsWithContext(ctx aws.Context, input *PutEventSelectorsInput, opts ...request.Option) (*PutEventSelectorsOutput, error) {
	req, out := c.PutEventSelectorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTags for more information on using the RemoveTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags
func (c *CloudTrail) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RemoveTags API operation for AWS CloudTrail.
//
// Removes the specified tags from a trail.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   This exception is thrown when the specified resource is not found.
//
//   * ErrCodeARNInvalidException "ARNInvalidException"
//   This exception is thrown when an operation is called with an invalid trail
//   ARN. The format of a trail ARN is:
//
//   arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
//
//   * ErrCodeResourceTypeNotSupportedException "ResourceTypeNotSupportedException"
//   This exception is thrown when the specified resource type is not supported
//   by CloudTrail.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidTagParameterException "InvalidTagParameterException"
//   This exception is thrown when the key or value specified for the tag does
//   not match the regular expression ^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-@]*)$.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTags
func (c *CloudTrail) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	return out, req.Send()
}

// RemoveTagsWithContext is the same as RemoveTags with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) RemoveTagsWithContext(ctx aws.Context, input *RemoveTagsInput, opts ...request.Option) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartLogging = "StartLogging"

// StartLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StartLogging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartLogging for more information on using the StartLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartLoggingRequest method.
//    req, resp := client.StartLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging
func (c *CloudTrail) StartLoggingRequest(input *StartLoggingInput) (req *request.Request, output *StartLoggingOutput) {
	op := &request.Operation{
		Name:       opStartLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartLoggingInput{}
	}

	output = &StartLoggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartLogging API operation for AWS CloudTrail.
//
// Starts the recording of AWS API calls and log file delivery for a trail.
// For a trail that is enabled in all regions, this operation must be called
// from the region in which the trail was created. This operation cannot be
// called on the shadow trails (replicated trails in other regions) of a trail
// that is enabled in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation StartLogging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidHomeRegionException "InvalidHomeRegionException"
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLogging
func (c *CloudTrail) StartLogging(input *StartLoggingInput) (*StartLoggingOutput, error) {
	req, out := c.StartLoggingRequest(input)
	return out, req.Send()
}

// StartLoggingWithContext is the same as StartLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StartLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) StartLoggingWithContext(ctx aws.Context, input *StartLoggingInput, opts ...request.Option) (*StartLoggingOutput, error) {
	req, out := c.StartLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopLogging = "StopLogging"

// StopLoggingRequest generates a "aws/request.Request" representing the
// client's request for the StopLogging operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopLogging for more information on using the StopLogging
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopLoggingRequest method.
//    req, resp := client.StopLoggingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging
func (c *CloudTrail) StopLoggingRequest(input *StopLoggingInput) (req *request.Request, output *StopLoggingOutput) {
	op := &request.Operation{
		Name:       opStopLogging,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopLoggingInput{}
	}

	output = &StopLoggingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopLogging API operation for AWS CloudTrail.
//
// Suspends the recording of AWS API calls and log file delivery for the specified
// trail. Under most circumstances, there is no need to use this action. You
// can update a trail without stopping it first. This action is the only way
// to stop recording. For a trail enabled in all regions, this operation must
// be called from the region in which the trail was created, or an InvalidHomeRegionException
// will occur. This operation cannot be called on the shadow trails (replicated
// trails in other regions) of a trail enabled in all regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation StopLogging for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeInvalidHomeRegionException "InvalidHomeRegionException"
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLogging
func (c *CloudTrail) StopLogging(input *StopLoggingInput) (*StopLoggingOutput, error) {
	req, out := c.StopLoggingRequest(input)
	return out, req.Send()
}

// StopLoggingWithContext is the same as StopLogging with the addition of
// the ability to pass a context and additional request options.
//
// See StopLogging for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) StopLoggingWithContext(ctx aws.Context, input *StopLoggingInput, opts ...request.Option) (*StopLoggingOutput, error) {
	req, out := c.StopLoggingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrail = "UpdateTrail"

// UpdateTrailRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrail operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrail for more information on using the UpdateTrail
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTrailRequest method.
//    req, resp := client.UpdateTrailRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail
func (c *CloudTrail) UpdateTrailRequest(input *UpdateTrailInput) (req *request.Request, output *UpdateTrailOutput) {
	op := &request.Operation{
		Name:       opUpdateTrail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrailInput{}
	}

	output = &UpdateTrailOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTrail API operation for AWS CloudTrail.
//
// Updates the settings that specify delivery of log files. Changes to a trail
// do not require stopping the CloudTrail service. Use this action to designate
// an existing bucket for log delivery. If the existing bucket has previously
// been a target for CloudTrail log files, an IAM policy exists for the bucket.
// UpdateTrail must be called from the region in which the trail was created;
// otherwise, an InvalidHomeRegionException is thrown.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS CloudTrail's
// API operation UpdateTrail for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeS3BucketDoesNotExistException "S3BucketDoesNotExistException"
//   This exception is thrown when the specified S3 bucket does not exist.
//
//   * ErrCodeInsufficientS3BucketPolicyException "InsufficientS3BucketPolicyException"
//   This exception is thrown when the policy on the S3 bucket is not sufficient.
//
//   * ErrCodeInsufficientSnsTopicPolicyException "InsufficientSnsTopicPolicyException"
//   This exception is thrown when the policy on the SNS topic is not sufficient.
//
//   * ErrCodeInsufficientEncryptionPolicyException "InsufficientEncryptionPolicyException"
//   This exception is thrown when the policy on the S3 bucket or KMS key is not
//   sufficient.
//
//   * ErrCodeTrailNotFoundException "TrailNotFoundException"
//   This exception is thrown when the trail with the given name is not found.
//
//   * ErrCodeInvalidS3BucketNameException "InvalidS3BucketNameException"
//   This exception is thrown when the provided S3 bucket name is not valid.
//
//   * ErrCodeInvalidS3PrefixException "InvalidS3PrefixException"
//   This exception is thrown when the provided S3 prefix is not valid.
//
//   * ErrCodeInvalidSnsTopicNameException "InvalidSnsTopicNameException"
//   This exception is thrown when the provided SNS topic name is not valid.
//
//   * ErrCodeInvalidKmsKeyIdException "InvalidKmsKeyIdException"
//   This exception is thrown when the KMS key ARN is invalid.
//
//   * ErrCodeInvalidTrailNameException "InvalidTrailNameException"
//   This exception is thrown when the provided trail name is not valid. Trail
//   names must meet the following requirements:
//
//      * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
//      (_), or dashes (-)
//
//      * Start with a letter or number, and end with a letter or number
//
//      * Be between 3 and 128 characters
//
//      * Have no adjacent periods, underscores or dashes. Names like my-_namespace
//      and my--namespace are invalid.
//
//      * Not be in IP address format (for example, 192.168.5.4)
//
//   * ErrCodeTrailNotProvidedException "TrailNotProvidedException"
//   This exception is deprecated.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   This exception is thrown when the combination of parameters provided is not
//   valid.
//
//   * ErrCodeInvalidHomeRegionException "InvalidHomeRegionException"
//   This exception is thrown when an operation is called on a trail from a region
//   other than the region in which the trail was created.
//
//   * ErrCodeKmsKeyNotFoundException "KmsKeyNotFoundException"
//   This exception is thrown when the KMS key does not exist, or when the S3
//   bucket and the KMS key are not in the same region.
//
//   * ErrCodeKmsKeyDisabledException "KmsKeyDisabledException"
//   This exception is deprecated.
//
//   * ErrCodeKmsException "KmsException"
//   This exception is thrown when there is an issue with the specified KMS key
//   and the trail can’t be updated.
//
//   * ErrCodeInvalidCloudWatchLogsLogGroupArnException "InvalidCloudWatchLogsLogGroupArnException"
//   This exception is thrown when the provided CloudWatch log group is not valid.
//
//   * ErrCodeInvalidCloudWatchLogsRoleArnException "InvalidCloudWatchLogsRoleArnException"
//   This exception is thrown when the provided role is not valid.
//
//   * ErrCodeCloudWatchLogsDeliveryUnavailableException "CloudWatchLogsDeliveryUnavailableException"
//   Cannot set a CloudWatch Logs delivery for this region.
//
//   * ErrCodeUnsupportedOperationException "UnsupportedOperationException"
//   This exception is thrown when the requested operation is not supported.
//
//   * ErrCodeOperationNotPermittedException "OperationNotPermittedException"
//   This exception is thrown when the requested operation is not permitted.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrail
func (c *CloudTrail) UpdateTrail(input *UpdateTrailInput) (*UpdateTrailOutput, error) {
	req, out := c.UpdateTrailRequest(input)
	return out, req.Send()
}

// UpdateTrailWithContext is the same as UpdateTrail with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrail for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CloudTrail) UpdateTrailWithContext(ctx aws.Context, input *UpdateTrailInput, opts ...request.Option) (*UpdateTrailOutput, error) {
	req, out := c.UpdateTrailRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Specifies the tags to add to a trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTagsRequest
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail to which one or more tags will be added. The
	// format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Contains a list of CloudTrail tags, up to a limit of 50
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagsList != nil {
		for i, v := range s.TagsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *AddTagsInput) SetResourceId(v string) *AddTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *AddTagsInput) SetTagsList(v []*Tag) *AddTagsInput {
	s.TagsList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/AddTagsResponse
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Specifies the settings for each trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrailRequest
type CreateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file integrity validation is enabled. The default is
	// false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail will not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail is created in the current region or in all regions.
	// The default is false.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be an alias name prefixed by "alias/", a fully specified ARN
	// to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// Examples:
	//
	//    * alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail. The name must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are invalid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`
}

// String returns the string representation
func (s CreateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *CreateTrailInput) SetCloudWatchLogsLogGroupArn(v string) *CreateTrailInput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateTrailInput) SetCloudWatchLogsRoleArn(v string) *CreateTrailInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetEnableLogFileValidation sets the EnableLogFileValidation field's value.
func (s *CreateTrailInput) SetEnableLogFileValidation(v bool) *CreateTrailInput {
	s.EnableLogFileValidation = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *CreateTrailInput) SetIncludeGlobalServiceEvents(v bool) *CreateTrailInput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *CreateTrailInput) SetIsMultiRegionTrail(v bool) *CreateTrailInput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateTrailInput) SetKmsKeyId(v string) *CreateTrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrailInput) SetName(v string) *CreateTrailInput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateTrailInput) SetS3BucketName(v string) *CreateTrailInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *CreateTrailInput) SetS3KeyPrefix(v string) *CreateTrailInput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *CreateTrailInput) SetSnsTopicName(v string) *CreateTrailInput {
	s.SnsTopicName = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/CreateTrailResponse
type CreateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The format of a topic ARN is:
	//
	// arn:aws:sns:us-east-1:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is deprecated. Use SnsTopicARN.
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail that was created. The format of a trail ARN
	// is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s CreateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTrailOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *CreateTrailOutput) SetCloudWatchLogsLogGroupArn(v string) *CreateTrailOutput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *CreateTrailOutput) SetCloudWatchLogsRoleArn(v string) *CreateTrailOutput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *CreateTrailOutput) SetIncludeGlobalServiceEvents(v bool) *CreateTrailOutput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *CreateTrailOutput) SetIsMultiRegionTrail(v bool) *CreateTrailOutput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateTrailOutput) SetKmsKeyId(v string) *CreateTrailOutput {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *CreateTrailOutput) SetLogFileValidationEnabled(v bool) *CreateTrailOutput {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrailOutput) SetName(v string) *CreateTrailOutput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *CreateTrailOutput) SetS3BucketName(v string) *CreateTrailOutput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *CreateTrailOutput) SetS3KeyPrefix(v string) *CreateTrailOutput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *CreateTrailOutput) SetSnsTopicARN(v string) *CreateTrailOutput {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *CreateTrailOutput) SetSnsTopicName(v string) *CreateTrailOutput {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *CreateTrailOutput) SetTrailARN(v string) *CreateTrailOutput {
	s.TrailARN = &v
	return s
}

// The Amazon S3 objects that you specify in your event selectors for your trail
// to log data events. Data events are object-level API operations that access
// S3 objects, such as GetObject, DeleteObject, and PutObject. You can specify
// up to 250 S3 buckets and object prefixes for a trail.
//
// Example
//
// You create an event selector for a trail and specify an S3 bucket and an
// empty prefix, such as arn:aws:s3:::bucket-1/.
//
// You upload an image file to bucket-1.
//
// The PutObject API operation occurs on an object in the S3 bucket that you
// specified in the event selector. The trail processes and logs the event.
//
// You upload another image file to a different S3 bucket named arn:aws:s3:::bucket-2.
//
// The event occurs on an object in an S3 bucket that you didn't specify in
// the event selector. The trail doesn’t log the event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DataResource
type DataResource struct {
	_ struct{} `type:"structure"`

	// The resource type in which you want to log data events. You can specify only
	// the following value: AWS::S3::Object.
	Type *string `type:"string"`

	// A list of ARN-like strings for the specified S3 objects.
	//
	// To log data events for all objects in an S3 bucket, specify the bucket and
	// an empty object prefix such as arn:aws:s3:::bucket-1/. The trail logs data
	// events for all objects in this S3 bucket.
	//
	// To log data events for specific objects, specify the S3 bucket and object
	// prefix such as arn:aws:s3:::bucket-1/example-images. The trail logs data
	// events for objects in this S3 bucket that match the prefix.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s DataResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataResource) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *DataResource) SetType(v string) *DataResource {
	s.Type = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DataResource) SetValues(v []*string) *DataResource {
	s.Values = v
	return s
}

// The request that specifies the name of a trail to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrailRequest
type DeleteTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail to be deleted. The
	// format of a trail ARN is: arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteTrailInput) SetName(v string) *DeleteTrailInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DeleteTrailResponse
type DeleteTrailOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTrailOutput) GoString() string {
	return s.String()
}

// Returns information about the trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrailsRequest
type DescribeTrailsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to include shadow trails in the response. A shadow trail
	// is the replication in a region of a trail that was created in a different
	// region. The default is true.
	IncludeShadowTrails *bool `locationName:"includeShadowTrails" type:"boolean"`

	// Specifies a list of trail names, trail ARNs, or both, of the trails to describe.
	// The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// If an empty list is specified, information for the trail in the current region
	// is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is false, then
	//    information for all trails in the current region is returned.
	//
	//    * If an empty list is specified and IncludeShadowTrails is null or true,
	//    then information for all trails in the current region and any associated
	//    shadow trails in other regions is returned.
	//
	// If one or more trail names are specified, information is returned only if
	// the names match the names of trails belonging only to the current region.
	// To return information about a trail in another region, you must specify its
	// trail ARN.
	TrailNameList []*string `locationName:"trailNameList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrailsInput) GoString() string {
	return s.String()
}

// SetIncludeShadowTrails sets the IncludeShadowTrails field's value.
func (s *DescribeTrailsInput) SetIncludeShadowTrails(v bool) *DescribeTrailsInput {
	s.IncludeShadowTrails = &v
	return s
}

// SetTrailNameList sets the TrailNameList field's value.
func (s *DescribeTrailsInput) SetTrailNameList(v []*string) *DescribeTrailsInput {
	s.TrailNameList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/DescribeTrailsResponse
type DescribeTrailsOutput struct {
	_ struct{} `type:"structure"`

	// The list of trail objects.
	TrailList []*Trail `locationName:"trailList" type:"list"`
}

// String returns the string representation
func (s DescribeTrailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrailsOutput) GoString() string {
	return s.String()
}

// SetTrailList sets the TrailList field's value.
func (s *DescribeTrailsOutput) SetTrailList(v []*Trail) *DescribeTrailsOutput {
	s.TrailList = v
	return s
}

// Contains information about an event that was returned by a lookup request.
// The result includes a representation of a CloudTrail event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// A JSON string that contains a representation of the event returned.
	CloudTrailEvent *string `type:"string"`

	// The CloudTrail ID of the event returned.
	EventId *string `type:"string"`

	// The name of the event returned.
	EventName *string `type:"string"`

	// The AWS service that the request was made to.
	EventSource *string `type:"string"`

	// The date and time of the event returned.
	EventTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A list of resources referenced by the event returned.
	Resources []*Resource `type:"list"`

	// A user name or role name of the requester that called the API in the event
	// returned.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetCloudTrailEvent sets the CloudTrailEvent field's value.
func (s *Event) SetCloudTrailEvent(v string) *Event {
	s.CloudTrailEvent = &v
	return s
}

// SetEventId sets the EventId field's value.
func (s *Event) SetEventId(v string) *Event {
	s.EventId = &v
	return s
}

// SetEventName sets the EventName field's value.
func (s *Event) SetEventName(v string) *Event {
	s.EventName = &v
	return s
}

// SetEventSource sets the EventSource field's value.
func (s *Event) SetEventSource(v string) *Event {
	s.EventSource = &v
	return s
}

// SetEventTime sets the EventTime field's value.
func (s *Event) SetEventTime(v time.Time) *Event {
	s.EventTime = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *Event) SetResources(v []*Resource) *Event {
	s.Resources = v
	return s
}

// SetUsername sets the Username field's value.
func (s *Event) SetUsername(v string) *Event {
	s.Username = &v
	return s
}

// Use event selectors to specify whether you want your trail to log management
// and/or data events. When an event occurs in your account, CloudTrail evaluates
// the event selector for all trails. For each trail, if the event matches any
// event selector, the trail processes and logs the event. If the event doesn't
// match any event selector, the trail doesn't log the event.
//
// You can configure up to five event selectors for a trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/EventSelector
type EventSelector struct {
	_ struct{} `type:"structure"`

	// CloudTrail supports logging only data events for S3 objects. You can specify
	// up to 250 S3 buckets and object prefixes for a trail.
	//
	// For more information, see Data Events (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-data-events)
	// in the AWS CloudTrail User Guide.
	DataResources []*DataResource `type:"list"`

	// Specify if you want your event selector to include management events for
	// your trail.
	//
	// For more information, see Management Events (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html#logging-management-events)
	// in the AWS CloudTrail User Guide.
	//
	// By default, the value is true.
	IncludeManagementEvents *bool `type:"boolean"`

	// Specify if you want your trail to log read-only events, write-only events,
	// or all. For example, the EC2 GetConsoleOutput is a read-only API operation
	// and RunInstances is a write-only API operation.
	//
	// By default, the value is All.
	ReadWriteType *string `type:"string" enum:"ReadWriteType"`
}

// String returns the string representation
func (s EventSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSelector) GoString() string {
	return s.String()
}

// SetDataResources sets the DataResources field's value.
func (s *EventSelector) SetDataResources(v []*DataResource) *EventSelector {
	s.DataResources = v
	return s
}

// SetIncludeManagementEvents sets the IncludeManagementEvents field's value.
func (s *EventSelector) SetIncludeManagementEvents(v bool) *EventSelector {
	s.IncludeManagementEvents = &v
	return s
}

// SetReadWriteType sets the ReadWriteType field's value.
func (s *EventSelector) SetReadWriteType(v string) *EventSelector {
	s.ReadWriteType = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectorsRequest
type GetEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are invalid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventSelectorsInput"}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrailName sets the TrailName field's value.
func (s *GetEventSelectorsInput) SetTrailName(v string) *GetEventSelectorsInput {
	s.TrailName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetEventSelectorsResponse
type GetEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// The event selectors that are configured for the trail.
	EventSelectors []*EventSelector `type:"list"`

	// The specified trail ARN that has the event selectors.
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s GetEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSelectorsOutput) GoString() string {
	return s.String()
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *GetEventSelectorsOutput) SetEventSelectors(v []*EventSelector) *GetEventSelectorsOutput {
	s.EventSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *GetEventSelectorsOutput) SetTrailARN(v string) *GetEventSelectorsOutput {
	s.TrailARN = &v
	return s
}

// The name of a trail about which you want the current status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatusRequest
type GetTrailStatusInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which you are requesting
	// status. To get the status of a shadow trail (a replication of the trail in
	// another region), you must specify its ARN. The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetTrailStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrailStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrailStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrailStatusInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetTrailStatusInput) SetName(v string) *GetTrailStatusInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/GetTrailStatusResponse
type GetTrailStatusOutput struct {
	_ struct{} `type:"structure"`

	// Whether the CloudTrail is currently logging AWS API calls.
	IsLogging *bool `type:"boolean"`

	// Displays any CloudWatch Logs error that CloudTrail encountered when attempting
	// to deliver logs to CloudWatch Logs.
	LatestCloudWatchLogsDeliveryError *string `type:"string"`

	// Displays the most recent date and time when CloudTrail delivered logs to
	// CloudWatch Logs.
	LatestCloudWatchLogsDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	LatestDeliveryAttemptSucceeded *string `type:"string"`

	// This field is deprecated.
	LatestDeliveryAttemptTime *string `type:"string"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver log files to the designated bucket. For more information see the
	// topic Error Responses (http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket
	// and will not occur for timeouts. To resolve the issue, create a new bucket
	// and call UpdateTrail to specify the new bucket, or fix the existing objects
	// so that CloudTrail can again write to the bucket.
	LatestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered log files to an
	// account's Amazon S3 bucket.
	LatestDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Displays any Amazon S3 error that CloudTrail encountered when attempting
	// to deliver a digest file to the designated bucket. For more information see
	// the topic Error Responses (http://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html)
	// in the Amazon S3 API Reference.
	//
	// This error occurs only when there is a problem with the destination S3 bucket
	// and will not occur for timeouts. To resolve the issue, create a new bucket
	// and call UpdateTrail to specify the new bucket, or fix the existing objects
	// so that CloudTrail can again write to the bucket.
	LatestDigestDeliveryError *string `type:"string"`

	// Specifies the date and time that CloudTrail last delivered a digest file
	// to an account's Amazon S3 bucket.
	LatestDigestDeliveryTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	LatestNotificationAttemptSucceeded *string `type:"string"`

	// This field is deprecated.
	LatestNotificationAttemptTime *string `type:"string"`

	// Displays any Amazon SNS error that CloudTrail encountered when attempting
	// to send a notification. For more information about Amazon SNS errors, see
	// the Amazon SNS Developer Guide (http://docs.aws.amazon.com/sns/latest/dg/welcome.html).
	LatestNotificationError *string `type:"string"`

	// Specifies the date and time of the most recent Amazon SNS notification that
	// CloudTrail has written a new log file to an account's Amazon S3 bucket.
	LatestNotificationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Specifies the most recent date and time when CloudTrail started recording
	// API calls for an AWS account.
	StartLoggingTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Specifies the most recent date and time when CloudTrail stopped recording
	// API calls for an AWS account.
	StopLoggingTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// This field is deprecated.
	TimeLoggingStarted *string `type:"string"`

	// This field is deprecated.
	TimeLoggingStopped *string `type:"string"`
}

// String returns the string representation
func (s GetTrailStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTrailStatusOutput) GoString() string {
	return s.String()
}

// SetIsLogging sets the IsLogging field's value.
func (s *GetTrailStatusOutput) SetIsLogging(v bool) *GetTrailStatusOutput {
	s.IsLogging = &v
	return s
}

// SetLatestCloudWatchLogsDeliveryError sets the LatestCloudWatchLogsDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestCloudWatchLogsDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestCloudWatchLogsDeliveryError = &v
	return s
}

// SetLatestCloudWatchLogsDeliveryTime sets the LatestCloudWatchLogsDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestCloudWatchLogsDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestCloudWatchLogsDeliveryTime = &v
	return s
}

// SetLatestDeliveryAttemptSucceeded sets the LatestDeliveryAttemptSucceeded field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryAttemptSucceeded(v string) *GetTrailStatusOutput {
	s.LatestDeliveryAttemptSucceeded = &v
	return s
}

// SetLatestDeliveryAttemptTime sets the LatestDeliveryAttemptTime field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryAttemptTime(v string) *GetTrailStatusOutput {
	s.LatestDeliveryAttemptTime = &v
	return s
}

// SetLatestDeliveryError sets the LatestDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestDeliveryError = &v
	return s
}

// SetLatestDeliveryTime sets the LatestDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestDeliveryTime = &v
	return s
}

// SetLatestDigestDeliveryError sets the LatestDigestDeliveryError field's value.
func (s *GetTrailStatusOutput) SetLatestDigestDeliveryError(v string) *GetTrailStatusOutput {
	s.LatestDigestDeliveryError = &v
	return s
}

// SetLatestDigestDeliveryTime sets the LatestDigestDeliveryTime field's value.
func (s *GetTrailStatusOutput) SetLatestDigestDeliveryTime(v time.Time) *GetTrailStatusOutput {
	s.LatestDigestDeliveryTime = &v
	return s
}

// SetLatestNotificationAttemptSucceeded sets the LatestNotificationAttemptSucceeded field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationAttemptSucceeded(v string) *GetTrailStatusOutput {
	s.LatestNotificationAttemptSucceeded = &v
	return s
}

// SetLatestNotificationAttemptTime sets the LatestNotificationAttemptTime field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationAttemptTime(v string) *GetTrailStatusOutput {
	s.LatestNotificationAttemptTime = &v
	return s
}

// SetLatestNotificationError sets the LatestNotificationError field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationError(v string) *GetTrailStatusOutput {
	s.LatestNotificationError = &v
	return s
}

// SetLatestNotificationTime sets the LatestNotificationTime field's value.
func (s *GetTrailStatusOutput) SetLatestNotificationTime(v time.Time) *GetTrailStatusOutput {
	s.LatestNotificationTime = &v
	return s
}

// SetStartLoggingTime sets the StartLoggingTime field's value.
func (s *GetTrailStatusOutput) SetStartLoggingTime(v time.Time) *GetTrailStatusOutput {
	s.StartLoggingTime = &v
	return s
}

// SetStopLoggingTime sets the StopLoggingTime field's value.
func (s *GetTrailStatusOutput) SetStopLoggingTime(v time.Time) *GetTrailStatusOutput {
	s.StopLoggingTime = &v
	return s
}

// SetTimeLoggingStarted sets the TimeLoggingStarted field's value.
func (s *GetTrailStatusOutput) SetTimeLoggingStarted(v string) *GetTrailStatusOutput {
	s.TimeLoggingStarted = &v
	return s
}

// SetTimeLoggingStopped sets the TimeLoggingStopped field's value.
func (s *GetTrailStatusOutput) SetTimeLoggingStopped(v string) *GetTrailStatusOutput {
	s.TimeLoggingStopped = &v
	return s
}

// Requests the public keys for a specified time range.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeysRequest
type ListPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Optionally specifies, in UTC, the end of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Optionally specifies, in UTC, the start of the time range to look up public
	// keys for CloudTrail digest files. If not specified, the current time is used,
	// and the current public key is returned.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ListPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysInput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ListPublicKeysInput) SetEndTime(v time.Time) *ListPublicKeysInput {
	s.EndTime = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysInput) SetNextToken(v string) *ListPublicKeysInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListPublicKeysInput) SetStartTime(v time.Time) *ListPublicKeysInput {
	s.StartTime = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListPublicKeysResponse
type ListPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Contains an array of PublicKey objects.
	//
	// The returned public keys may have validity time ranges that overlap.
	PublicKeyList []*PublicKey `type:"list"`
}

// String returns the string representation
func (s ListPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPublicKeysOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPublicKeysOutput) SetNextToken(v string) *ListPublicKeysOutput {
	s.NextToken = &v
	return s
}

// SetPublicKeyList sets the PublicKeyList field's value.
func (s *ListPublicKeysOutput) SetPublicKeyList(v []*PublicKey) *ListPublicKeysOutput {
	s.PublicKeyList = v
	return s
}

// Specifies a list of trail tags to return.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTagsRequest
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// Specifies a list of trail ARNs whose tags will be listed. The list has a
	// limit of 20 ARNs. The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// ResourceIdList is a required field
	ResourceIdList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceIdList == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceIdList sets the ResourceIdList field's value.
func (s *ListTagsInput) SetResourceIdList(v []*string) *ListTagsInput {
	s.ResourceIdList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ListTagsResponse
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// Reserved for future use.
	NextToken *string `type:"string"`

	// A list of resource tags.
	ResourceTagList []*ResourceTag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetResourceTagList sets the ResourceTagList field's value.
func (s *ListTagsOutput) SetResourceTagList(v []*ResourceTag) *ListTagsOutput {
	s.ResourceTagList = v
	return s
}

// Specifies an attribute and value that filter the events returned.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupAttribute
type LookupAttribute struct {
	_ struct{} `type:"structure"`

	// Specifies an attribute on which to filter the events returned.
	//
	// AttributeKey is a required field
	AttributeKey *string `type:"string" required:"true" enum:"LookupAttributeKey"`

	// Specifies a value for the specified AttributeKey.
	//
	// AttributeValue is a required field
	AttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s LookupAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupAttribute"}
	if s.AttributeKey == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeKey"))
	}
	if s.AttributeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeKey sets the AttributeKey field's value.
func (s *LookupAttribute) SetAttributeKey(v string) *LookupAttribute {
	s.AttributeKey = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *LookupAttribute) SetAttributeValue(v string) *LookupAttribute {
	s.AttributeValue = &v
	return s
}

// Contains a request for LookupEvents.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEventsRequest
type LookupEventsInput struct {
	_ struct{} `type:"structure"`

	// Specifies that only events that occur before or at the specified time are
	// returned. If the specified end time is before the specified start time, an
	// error is returned.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Contains a list of lookup attributes. Currently the list can contain only
	// one item.
	LookupAttributes []*LookupAttribute `type:"list"`

	// The number of events to return. Possible values are 1 through 50. The default
	// is 10.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	// This token must be passed in with the same parameters that were specified
	// in the the original call. For example, if the original call specified an
	// AttributeKey of 'Username' with a value of 'root', the call with NextToken
	// should include those same parameters.
	NextToken *string `type:"string"`

	// Specifies that only events that occur after or at the specified time are
	// returned. If the specified start time is after the specified end time, an
	// error is returned.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s LookupEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LookupEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LookupEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.LookupAttributes != nil {
		for i, v := range s.LookupAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LookupAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *LookupEventsInput) SetEndTime(v time.Time) *LookupEventsInput {
	s.EndTime = &v
	return s
}

// SetLookupAttributes sets the LookupAttributes field's value.
func (s *LookupEventsInput) SetLookupAttributes(v []*LookupAttribute) *LookupEventsInput {
	s.LookupAttributes = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *LookupEventsInput) SetMaxResults(v int64) *LookupEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupEventsInput) SetNextToken(v string) *LookupEventsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *LookupEventsInput) SetStartTime(v time.Time) *LookupEventsInput {
	s.StartTime = &v
	return s
}

// Contains a response to a LookupEvents action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/LookupEventsResponse
type LookupEventsOutput struct {
	_ struct{} `type:"structure"`

	// A list of events returned based on the lookup attributes specified and the
	// CloudTrail event. The events list is sorted by time. The most recent event
	// is listed first.
	Events []*Event `type:"list"`

	// The token to use to get the next page of results after a previous API call.
	// If the token does not appear, there are no more results to return. The token
	// must be passed in with the same parameters as the previous call. For example,
	// if the original call specified an AttributeKey of 'Username' with a value
	// of 'root', the call with NextToken should include those same parameters.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s LookupEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LookupEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *LookupEventsOutput) SetEvents(v []*Event) *LookupEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *LookupEventsOutput) SetNextToken(v string) *LookupEventsOutput {
	s.NextToken = &v
	return s
}

// Contains information about a returned public key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PublicKey
type PublicKey struct {
	_ struct{} `type:"structure"`

	// The fingerprint of the public key.
	Fingerprint *string `type:"string"`

	// The ending time of validity of the public key.
	ValidityEndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The starting time of validity of the public key.
	ValidityStartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The DER encoded public key value in PKCS#1 format.
	//
	// Value is automatically base64 encoded/decoded by the SDK.
	Value []byte `type:"blob"`
}

// String returns the string representation
func (s PublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublicKey) GoString() string {
	return s.String()
}

// SetFingerprint sets the Fingerprint field's value.
func (s *PublicKey) SetFingerprint(v string) *PublicKey {
	s.Fingerprint = &v
	return s
}

// SetValidityEndTime sets the ValidityEndTime field's value.
func (s *PublicKey) SetValidityEndTime(v time.Time) *PublicKey {
	s.ValidityEndTime = &v
	return s
}

// SetValidityStartTime sets the ValidityStartTime field's value.
func (s *PublicKey) SetValidityStartTime(v time.Time) *PublicKey {
	s.ValidityStartTime = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PublicKey) SetValue(v []byte) *PublicKey {
	s.Value = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectorsRequest
type PutEventSelectorsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the settings for your event selectors. You can configure up to
	// five event selectors for a trail.
	//
	// EventSelectors is a required field
	EventSelectors []*EventSelector `type:"list" required:"true"`

	// Specifies the name of the trail or trail ARN. If you specify a trail name,
	// the string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are invalid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If you specify a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// TrailName is a required field
	TrailName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutEventSelectorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventSelectorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutEventSelectorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutEventSelectorsInput"}
	if s.EventSelectors == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSelectors"))
	}
	if s.TrailName == nil {
		invalidParams.Add(request.NewErrParamRequired("TrailName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *PutEventSelectorsInput) SetEventSelectors(v []*EventSelector) *PutEventSelectorsInput {
	s.EventSelectors = v
	return s
}

// SetTrailName sets the TrailName field's value.
func (s *PutEventSelectorsInput) SetTrailName(v string) *PutEventSelectorsInput {
	s.TrailName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/PutEventSelectorsResponse
type PutEventSelectorsOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the event selectors configured for your trail.
	EventSelectors []*EventSelector `type:"list"`

	// Specifies the ARN of the trail that was updated with event selectors. The
	// format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s PutEventSelectorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutEventSelectorsOutput) GoString() string {
	return s.String()
}

// SetEventSelectors sets the EventSelectors field's value.
func (s *PutEventSelectorsOutput) SetEventSelectors(v []*EventSelector) *PutEventSelectorsOutput {
	s.EventSelectors = v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *PutEventSelectorsOutput) SetTrailARN(v string) *PutEventSelectorsOutput {
	s.TrailARN = &v
	return s
}

// Specifies the tags to remove from a trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTagsRequest
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trail from which tags should be removed. The format
	// of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// ResourceId is a required field
	ResourceId *string `type:"string" required:"true"`

	// Specifies a list of tags to be removed.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.TagsList != nil {
		for i, v := range s.TagsList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagsList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *RemoveTagsInput) SetResourceId(v string) *RemoveTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *RemoveTagsInput) SetTagsList(v []*Tag) *RemoveTagsInput {
	s.TagsList = v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/RemoveTagsResponse
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Specifies the type and name of a resource referenced by an event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// The name of the resource referenced by the event returned. These are user-created
	// names whose values will depend on the environment. For example, the resource
	// name might be "auto-scaling-test-group" for an Auto Scaling Group or "i-1234567"
	// for an EC2 Instance.
	ResourceName *string `type:"string"`

	// The type of a resource referenced by the event returned. When the resource
	// type cannot be determined, null is returned. Some examples of resource types
	// are: Instance for EC2, Trail for CloudTrail, DBInstance for RDS, and AccessKey
	// for IAM. For a list of resource types supported for event lookup, see Resource
	// Types Supported for Event Lookup (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/lookup_supported_resourcetypes.html).
	ResourceType *string `type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resource) GoString() string {
	return s.String()
}

// SetResourceName sets the ResourceName field's value.
func (s *Resource) SetResourceName(v string) *Resource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Resource) SetResourceType(v string) *Resource {
	s.ResourceType = &v
	return s
}

// A resource tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/ResourceTag
type ResourceTag struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the resource.
	ResourceId *string `type:"string"`

	// A list of tags.
	TagsList []*Tag `type:"list"`
}

// String returns the string representation
func (s ResourceTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTag) GoString() string {
	return s.String()
}

// SetResourceId sets the ResourceId field's value.
func (s *ResourceTag) SetResourceId(v string) *ResourceTag {
	s.ResourceId = &v
	return s
}

// SetTagsList sets the TagsList field's value.
func (s *ResourceTag) SetTagsList(v []*Tag) *ResourceTag {
	s.TagsList = v
	return s
}

// The request to CloudTrail to start logging AWS API calls for an account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLoggingRequest
type StartLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// logs AWS API calls. The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartLoggingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartLoggingInput) SetName(v string) *StartLoggingInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StartLoggingResponse
type StartLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartLoggingOutput) GoString() string {
	return s.String()
}

// Passes the request to CloudTrail to stop logging AWS API calls for the specified
// account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLoggingRequest
type StopLoggingInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name or the CloudTrail ARN of the trail for which CloudTrail
	// will stop logging AWS API calls. The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopLoggingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopLoggingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopLoggingInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopLoggingInput) SetName(v string) *StopLoggingInput {
	s.Name = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/StopLoggingResponse
type StopLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopLoggingOutput) GoString() string {
	return s.String()
}

// A custom key-value pair associated with a resource such as a CloudTrail trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. The key must be must be no longer than 128 Unicode
	// characters. The key must be unique for the resource to which it applies.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value in a key-value pair of a tag. The value must be no longer than
	// 256 Unicode characters.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The settings for a trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/Trail
type Trail struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Resource Name (ARN), a unique identifier that represents
	// the log group to which CloudTrail logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies if the trail has custom event selectors.
	HasCustomEventSelectors *bool `type:"boolean"`

	// The region in which the trail was created.
	HomeRegion *string `type:"string"`

	// Set to True to include AWS API calls from AWS global services such as IAM.
	// Otherwise, False.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail belongs only to one region or exists in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Name of the trail set by calling CreateTrail. The maximum length is 128 characters.
	Name *string `type:"string"`

	// Name of the Amazon S3 bucket into which CloudTrail delivers your trail files.
	// See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).The
	// maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The format of a topic ARN is:
	//
	// arn:aws:sns:us-east-1:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is deprecated. Use SnsTopicARN.
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail. The format of a trail ARN is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s Trail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trail) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *Trail) SetCloudWatchLogsLogGroupArn(v string) *Trail {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *Trail) SetCloudWatchLogsRoleArn(v string) *Trail {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetHasCustomEventSelectors sets the HasCustomEventSelectors field's value.
func (s *Trail) SetHasCustomEventSelectors(v bool) *Trail {
	s.HasCustomEventSelectors = &v
	return s
}

// SetHomeRegion sets the HomeRegion field's value.
func (s *Trail) SetHomeRegion(v string) *Trail {
	s.HomeRegion = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *Trail) SetIncludeGlobalServiceEvents(v bool) *Trail {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *Trail) SetIsMultiRegionTrail(v bool) *Trail {
	s.IsMultiRegionTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Trail) SetKmsKeyId(v string) *Trail {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *Trail) SetLogFileValidationEnabled(v bool) *Trail {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *Trail) SetName(v string) *Trail {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *Trail) SetS3BucketName(v string) *Trail {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *Trail) SetS3KeyPrefix(v string) *Trail {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *Trail) SetSnsTopicARN(v string) *Trail {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *Trail) SetSnsTopicName(v string) *Trail {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *Trail) SetTrailARN(v string) *Trail {
	s.TrailARN = &v
	return s
}

// Specifies settings to update for the trail.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrailRequest
type UpdateTrailInput struct {
	_ struct{} `type:"structure"`

	// Specifies a log group name using an Amazon Resource Name (ARN), a unique
	// identifier that represents the log group to which CloudTrail logs will be
	// delivered. Not required unless you specify CloudWatchLogsRoleArn.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether log file validation is enabled. The default is false.
	//
	// When you disable log file integrity validation, the chain of digest files
	// is broken after one hour. CloudTrail will not create digest files for log
	// files that were delivered during a period in which log file integrity validation
	// was disabled. For example, if you enable log file integrity validation at
	// noon on January 1, disable it at noon on January 2, and re-enable it at noon
	// on January 10, digest files will not be created for the log files delivered
	// from noon on January 2 to noon on January 10. The same applies whenever you
	// stop CloudTrail logging or delete a trail.
	EnableLogFileValidation *bool `type:"boolean"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail applies only to the current region or to all
	// regions. The default is false. If the trail exists only in the current region
	// and this value is set to true, shadow trails (replications of the trail)
	// will be created in the other regions. If the trail exists in all regions
	// and this value is set to false, the trail will remain in the region where
	// it was created, and its shadow trails in other regions will be deleted.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail.
	// The value can be an alias name prefixed by "alias/", a fully specified ARN
	// to an alias, a fully specified ARN to a key, or a globally unique identifier.
	//
	// Examples:
	//
	//    * alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//    * arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//    * 12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies the name of the trail or trail ARN. If Name is a trail name, the
	// string must meet the following requirements:
	//
	//    * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	//    (_), or dashes (-)
	//
	//    * Start with a letter or number, and end with a letter or number
	//
	//    * Be between 3 and 128 characters
	//
	//    * Have no adjacent periods, underscores or dashes. Names like my-_namespace
	//    and my--namespace are invalid.
	//
	//    * Not be in IP address format (for example, 192.168.5.4)
	//
	// If Name is a trail ARN, it must be in the format:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files. See Amazon S3 Bucket Naming Requirements (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/create_trail_naming_policy.html).
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	// The maximum length is 200 characters.
	S3KeyPrefix *string `type:"string"`

	// Specifies the name of the Amazon SNS topic defined for notification of log
	// file delivery. The maximum length is 256 characters.
	SnsTopicName *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrailInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrailInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrailInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *UpdateTrailInput) SetCloudWatchLogsLogGroupArn(v string) *UpdateTrailInput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *UpdateTrailInput) SetCloudWatchLogsRoleArn(v string) *UpdateTrailInput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetEnableLogFileValidation sets the EnableLogFileValidation field's value.
func (s *UpdateTrailInput) SetEnableLogFileValidation(v bool) *UpdateTrailInput {
	s.EnableLogFileValidation = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *UpdateTrailInput) SetIncludeGlobalServiceEvents(v bool) *UpdateTrailInput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *UpdateTrailInput) SetIsMultiRegionTrail(v bool) *UpdateTrailInput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateTrailInput) SetKmsKeyId(v string) *UpdateTrailInput {
	s.KmsKeyId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTrailInput) SetName(v string) *UpdateTrailInput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UpdateTrailInput) SetS3BucketName(v string) *UpdateTrailInput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *UpdateTrailInput) SetS3KeyPrefix(v string) *UpdateTrailInput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *UpdateTrailInput) SetSnsTopicName(v string) *UpdateTrailInput {
	s.SnsTopicName = &v
	return s
}

// Returns the objects or data listed below if successful. Otherwise, returns
// an error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-2013-11-01/UpdateTrailResponse
type UpdateTrailOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the log group to which CloudTrail
	// logs will be delivered.
	CloudWatchLogsLogGroupArn *string `type:"string"`

	// Specifies the role for the CloudWatch Logs endpoint to assume to write to
	// a user's log group.
	CloudWatchLogsRoleArn *string `type:"string"`

	// Specifies whether the trail is publishing events from global services such
	// as IAM to the log files.
	IncludeGlobalServiceEvents *bool `type:"boolean"`

	// Specifies whether the trail exists in one region or in all regions.
	IsMultiRegionTrail *bool `type:"boolean"`

	// Specifies the KMS key ID that encrypts the logs delivered by CloudTrail.
	// The value is a fully specified ARN to a KMS key in the format:
	//
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	KmsKeyId *string `type:"string"`

	// Specifies whether log file integrity validation is enabled.
	LogFileValidationEnabled *bool `type:"boolean"`

	// Specifies the name of the trail.
	Name *string `type:"string"`

	// Specifies the name of the Amazon S3 bucket designated for publishing log
	// files.
	S3BucketName *string `type:"string"`

	// Specifies the Amazon S3 key prefix that comes after the name of the bucket
	// you have designated for log file delivery. For more information, see Finding
	// Your CloudTrail Log Files (http://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-find-log-files.html).
	S3KeyPrefix *string `type:"string"`

	// Specifies the ARN of the Amazon SNS topic that CloudTrail uses to send notifications
	// when log files are delivered. The format of a topic ARN is:
	//
	// arn:aws:sns:us-east-1:123456789012:MyTopic
	SnsTopicARN *string `type:"string"`

	// This field is deprecated. Use SnsTopicARN.
	SnsTopicName *string `deprecated:"true" type:"string"`

	// Specifies the ARN of the trail that was updated. The format of a trail ARN
	// is:
	//
	// arn:aws:cloudtrail:us-east-1:123456789012:trail/MyTrail
	TrailARN *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTrailOutput) GoString() string {
	return s.String()
}

// SetCloudWatchLogsLogGroupArn sets the CloudWatchLogsLogGroupArn field's value.
func (s *UpdateTrailOutput) SetCloudWatchLogsLogGroupArn(v string) *UpdateTrailOutput {
	s.CloudWatchLogsLogGroupArn = &v
	return s
}

// SetCloudWatchLogsRoleArn sets the CloudWatchLogsRoleArn field's value.
func (s *UpdateTrailOutput) SetCloudWatchLogsRoleArn(v string) *UpdateTrailOutput {
	s.CloudWatchLogsRoleArn = &v
	return s
}

// SetIncludeGlobalServiceEvents sets the IncludeGlobalServiceEvents field's value.
func (s *UpdateTrailOutput) SetIncludeGlobalServiceEvents(v bool) *UpdateTrailOutput {
	s.IncludeGlobalServiceEvents = &v
	return s
}

// SetIsMultiRegionTrail sets the IsMultiRegionTrail field's value.
func (s *UpdateTrailOutput) SetIsMultiRegionTrail(v bool) *UpdateTrailOutput {
	s.IsMultiRegionTrail = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateTrailOutput) SetKmsKeyId(v string) *UpdateTrailOutput {
	s.KmsKeyId = &v
	return s
}

// SetLogFileValidationEnabled sets the LogFileValidationEnabled field's value.
func (s *UpdateTrailOutput) SetLogFileValidationEnabled(v bool) *UpdateTrailOutput {
	s.LogFileValidationEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateTrailOutput) SetName(v string) *UpdateTrailOutput {
	s.Name = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *UpdateTrailOutput) SetS3BucketName(v string) *UpdateTrailOutput {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *UpdateTrailOutput) SetS3KeyPrefix(v string) *UpdateTrailOutput {
	s.S3KeyPrefix = &v
	return s
}

// SetSnsTopicARN sets the SnsTopicARN field's value.
func (s *UpdateTrailOutput) SetSnsTopicARN(v string) *UpdateTrailOutput {
	s.SnsTopicARN = &v
	return s
}

// SetSnsTopicName sets the SnsTopicName field's value.
func (s *UpdateTrailOutput) SetSnsTopicName(v string) *UpdateTrailOutput {
	s.SnsTopicName = &v
	return s
}

// SetTrailARN sets the TrailARN field's value.
func (s *UpdateTrailOutput) SetTrailARN(v string) *UpdateTrailOutput {
	s.TrailARN = &v
	return s
}

const (
	// LookupAttributeKeyEventId is a LookupAttributeKey enum value
	LookupAttributeKeyEventId = "EventId"

	// LookupAttributeKeyEventName is a LookupAttributeKey enum value
	LookupAttributeKeyEventName = "EventName"

	// LookupAttributeKeyUsername is a LookupAttributeKey enum value
	LookupAttributeKeyUsername = "Username"

	// LookupAttributeKeyResourceType is a LookupAttributeKey enum value
	LookupAttributeKeyResourceType = "ResourceType"

	// LookupAttributeKeyResourceName is a LookupAttributeKey enum value
	LookupAttributeKeyResourceName = "ResourceName"

	// LookupAttributeKeyEventSource is a LookupAttributeKey enum value
	LookupAttributeKeyEventSource = "EventSource"
)

const (
	// ReadWriteTypeReadOnly is a ReadWriteType enum value
	ReadWriteTypeReadOnly = "ReadOnly"

	// ReadWriteTypeWriteOnly is a ReadWriteType enum value
	ReadWriteTypeWriteOnly = "WriteOnly"

	// ReadWriteTypeAll is a ReadWriteType enum value
	ReadWriteTypeAll = "All"
)
