// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dynamodb

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchGetItem = "BatchGetItem"

// BatchGetItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetItem for more information on using the BatchGetItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchGetItemRequest method.
//    req, resp := client.BatchGetItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem
func (c *DynamoDB) BatchGetItemRequest(input *BatchGetItemInput) (req *request.Request, output *BatchGetItemOutput) {
	op := &request.Operation{
		Name:       opBatchGetItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"RequestItems"},
			OutputTokens:    []string{"UnprocessedKeys"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &BatchGetItemInput{}
	}

	output = &BatchGetItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetItem API operation for Amazon DynamoDB.
//
// The BatchGetItem operation returns the attributes of one or more items from
// one or more tables. You identify requested items by primary key.
//
// A single operation can retrieve up to 16 MB of data, which can contain as
// many as 100 items. BatchGetItem will return a partial result if the response
// size limit is exceeded, the table's provisioned throughput is exceeded, or
// an internal processing failure occurs. If a partial result is returned, the
// operation returns a value for UnprocessedKeys. You can use this value to
// retry the operation starting with the next item to get.
//
// If you request more than 100 items BatchGetItem will return a ValidationException
// with the message "Too many items requested for the BatchGetItem call".
//
// For example, if you ask to retrieve 100 items, but each individual item is
// 300 KB in size, the system returns 52 items (so as not to exceed the 16 MB
// limit). It also returns an appropriate UnprocessedKeys value so you can get
// the next page of results. If desired, your application can include its own
// logic to assemble the pages of results into one data set.
//
// If none of the items can be processed due to insufficient provisioned throughput
// on all of the tables in the request, then BatchGetItem will return a ProvisionedThroughputExceededException.
// If at least one of the items is successfully processed, then BatchGetItem
// completes successfully, while returning the keys of the unread items in UnprocessedKeys.
//
// If DynamoDB returns any unprocessed items, you should retry the batch operation
// on those items. However, we strongly recommend that you use an exponential
// backoff algorithm. If you retry the batch operation immediately, the underlying
// read or write requests can still fail due to throttling on the individual
// tables. If you delay the batch operation using exponential backoff, the individual
// requests in the batch are much more likely to succeed.
//
// For more information, see Batch Operations and Error Handling (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations)
// in the Amazon DynamoDB Developer Guide.
//
// By default, BatchGetItem performs eventually consistent reads on every table
// in the request. If you want strongly consistent reads instead, you can set
// ConsistentRead to true for any or all tables.
//
// In order to minimize response latency, BatchGetItem retrieves items in parallel.
//
// When designing your application, keep in mind that DynamoDB does not return
// items in any particular order. To help parse the response by item, include
// the primary key values for the items in your request in the ProjectionExpression
// parameter.
//
// If a requested item does not exist, it is not returned in the result. Requests
// for nonexistent items consume the minimum read capacity units according to
// the type of read. For more information, see Capacity Units Calculations (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation BatchGetItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem
func (c *DynamoDB) BatchGetItem(input *BatchGetItemInput) (*BatchGetItemOutput, error) {
	req, out := c.BatchGetItemRequest(input)
	return out, req.Send()
}

// BatchGetItemWithContext is the same as BatchGetItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchGetItemWithContext(ctx aws.Context, input *BatchGetItemInput, opts ...request.Option) (*BatchGetItemOutput, error) {
	req, out := c.BatchGetItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// BatchGetItemPages iterates over the pages of a BatchGetItem operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See BatchGetItem method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a BatchGetItem operation.
//    pageNum := 0
//    err := client.BatchGetItemPages(params,
//        func(page *BatchGetItemOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) BatchGetItemPages(input *BatchGetItemInput, fn func(*BatchGetItemOutput, bool) bool) error {
	return c.BatchGetItemPagesWithContext(aws.BackgroundContext(), input, fn)
}

// BatchGetItemPagesWithContext same as BatchGetItemPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchGetItemPagesWithContext(ctx aws.Context, input *BatchGetItemInput, fn func(*BatchGetItemOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *BatchGetItemInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.BatchGetItemRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*BatchGetItemOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opBatchWriteItem = "BatchWriteItem"

// BatchWriteItemRequest generates a "aws/request.Request" representing the
// client's request for the BatchWriteItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchWriteItem for more information on using the BatchWriteItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchWriteItemRequest method.
//    req, resp := client.BatchWriteItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem
func (c *DynamoDB) BatchWriteItemRequest(input *BatchWriteItemInput) (req *request.Request, output *BatchWriteItemOutput) {
	op := &request.Operation{
		Name:       opBatchWriteItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchWriteItemInput{}
	}

	output = &BatchWriteItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchWriteItem API operation for Amazon DynamoDB.
//
// The BatchWriteItem operation puts or deletes multiple items in one or more
// tables. A single call to BatchWriteItem can write up to 16 MB of data, which
// can comprise as many as 25 put or delete requests. Individual items to be
// written can be as large as 400 KB.
//
// BatchWriteItem cannot update items. To update items, use the UpdateItem action.
//
// The individual PutItem and DeleteItem operations specified in BatchWriteItem
// are atomic; however BatchWriteItem as a whole is not. If any requested operations
// fail because the table's provisioned throughput is exceeded or an internal
// processing failure occurs, the failed operations are returned in the UnprocessedItems
// response parameter. You can investigate and optionally resend the requests.
// Typically, you would call BatchWriteItem in a loop. Each iteration would
// check for unprocessed items and submit a new BatchWriteItem request with
// those unprocessed items until all items have been processed.
//
// Note that if none of the items can be processed due to insufficient provisioned
// throughput on all of the tables in the request, then BatchWriteItem will
// return a ProvisionedThroughputExceededException.
//
// If DynamoDB returns any unprocessed items, you should retry the batch operation
// on those items. However, we strongly recommend that you use an exponential
// backoff algorithm. If you retry the batch operation immediately, the underlying
// read or write requests can still fail due to throttling on the individual
// tables. If you delay the batch operation using exponential backoff, the individual
// requests in the batch are much more likely to succeed.
//
// For more information, see Batch Operations and Error Handling (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations)
// in the Amazon DynamoDB Developer Guide.
//
// With BatchWriteItem, you can efficiently write or delete large amounts of
// data, such as from Amazon Elastic MapReduce (EMR), or copy data from another
// database into DynamoDB. In order to improve performance with these large-scale
// operations, BatchWriteItem does not behave in the same way as individual
// PutItem and DeleteItem calls would. For example, you cannot specify conditions
// on individual put and delete requests, and BatchWriteItem does not return
// deleted items in the response.
//
// If you use a programming language that supports concurrency, you can use
// threads to write items in parallel. Your application must include the necessary
// logic to manage the threads. With languages that don't support threading,
// you must update or delete the specified items one at a time. In both situations,
// BatchWriteItem performs the specified put and delete operations in parallel,
// giving you the power of the thread pool approach without having to introduce
// complexity into your application.
//
// Parallel processing reduces latency, but each specified put and delete request
// consumes the same number of write capacity units whether it is processed
// in parallel or not. Delete operations on nonexistent items consume one write
// capacity unit.
//
// If one or more of the following is true, DynamoDB rejects the entire batch
// write operation:
//
//    * One or more tables specified in the BatchWriteItem request does not
//    exist.
//
//    * Primary key attributes specified on an item in the request do not match
//    those in the corresponding table's primary key schema.
//
//    * You try to perform multiple operations on the same item in the same
//    BatchWriteItem request. For example, you cannot put and delete the same
//    item in the same BatchWriteItem request.
//
//    * There are more than 25 requests in the batch.
//
//    * Any individual item in a batch exceeds 400 KB.
//
//    * The total request size exceeds 16 MB.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation BatchWriteItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem
func (c *DynamoDB) BatchWriteItem(input *BatchWriteItemInput) (*BatchWriteItemOutput, error) {
	req, out := c.BatchWriteItemRequest(input)
	return out, req.Send()
}

// BatchWriteItemWithContext is the same as BatchWriteItem with the addition of
// the ability to pass a context and additional request options.
//
// See BatchWriteItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) BatchWriteItemWithContext(ctx aws.Context, input *BatchWriteItemInput, opts ...request.Option) (*BatchWriteItemOutput, error) {
	req, out := c.BatchWriteItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTable = "CreateTable"

// CreateTableRequest generates a "aws/request.Request" representing the
// client's request for the CreateTable operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTable for more information on using the CreateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTableRequest method.
//    req, resp := client.CreateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable
func (c *DynamoDB) CreateTableRequest(input *CreateTableInput) (req *request.Request, output *CreateTableOutput) {
	op := &request.Operation{
		Name:       opCreateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTableInput{}
	}

	output = &CreateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTable API operation for Amazon DynamoDB.
//
// The CreateTable operation adds a new table to your account. In an AWS account,
// table names must be unique within each region. That is, you can have two
// tables with same name if you create the tables in different regions.
//
// CreateTable is an asynchronous operation. Upon receiving a CreateTable request,
// DynamoDB immediately returns a response with a TableStatus of CREATING. After
// the table is created, DynamoDB sets the TableStatus to ACTIVE. You can perform
// read and write operations only on an ACTIVE table.
//
// You can optionally define secondary indexes on the new table, as part of
// the CreateTable operation. If you want to create multiple tables with secondary
// indexes on them, you must create the tables sequentially. Only one table
// with secondary indexes can be in the CREATING state at any given time.
//
// You can use the DescribeTable action to check the table status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation CreateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable
func (c *DynamoDB) CreateTable(input *CreateTableInput) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	return out, req.Send()
}

// CreateTableWithContext is the same as CreateTable with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) CreateTableWithContext(ctx aws.Context, input *CreateTableInput, opts ...request.Option) (*CreateTableOutput, error) {
	req, out := c.CreateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteItem = "DeleteItem"

// DeleteItemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteItem for more information on using the DeleteItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteItemRequest method.
//    req, resp := client.DeleteItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem
func (c *DynamoDB) DeleteItemRequest(input *DeleteItemInput) (req *request.Request, output *DeleteItemOutput) {
	op := &request.Operation{
		Name:       opDeleteItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteItemInput{}
	}

	output = &DeleteItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteItem API operation for Amazon DynamoDB.
//
// Deletes a single item in a table by primary key. You can perform a conditional
// delete operation that deletes the item if it exists, or if it has an expected
// attribute value.
//
// In addition to deleting an item, you can also return the item's attribute
// values in the same operation, using the ReturnValues parameter.
//
// Unless you specify conditions, the DeleteItem is an idempotent operation;
// running it multiple times on the same item or attribute does not result in
// an error response.
//
// Conditional deletes are useful for deleting items only if specific conditions
// are met. If those conditions are met, DynamoDB performs the delete. Otherwise,
// the item is not deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DeleteItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem
func (c *DynamoDB) DeleteItem(input *DeleteItemInput) (*DeleteItemOutput, error) {
	req, out := c.DeleteItemRequest(input)
	return out, req.Send()
}

// DeleteItemWithContext is the same as DeleteItem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DeleteItemWithContext(ctx aws.Context, input *DeleteItemInput, opts ...request.Option) (*DeleteItemOutput, error) {
	req, out := c.DeleteItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTable = "DeleteTable"

// DeleteTableRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTable operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTable for more information on using the DeleteTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTableRequest method.
//    req, resp := client.DeleteTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable
func (c *DynamoDB) DeleteTableRequest(input *DeleteTableInput) (req *request.Request, output *DeleteTableOutput) {
	op := &request.Operation{
		Name:       opDeleteTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTableInput{}
	}

	output = &DeleteTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTable API operation for Amazon DynamoDB.
//
// The DeleteTable operation deletes a table and all of its items. After a DeleteTable
// request, the specified table is in the DELETING state until DynamoDB completes
// the deletion. If the table is in the ACTIVE state, you can delete it. If
// a table is in CREATING or UPDATING states, then DynamoDB returns a ResourceInUseException.
// If the specified table does not exist, DynamoDB returns a ResourceNotFoundException.
// If table is already in the DELETING state, no error is returned.
//
// DynamoDB might continue to accept data read and write operations, such as
// GetItem and PutItem, on a table in the DELETING state until the table deletion
// is complete.
//
// When you delete a table, any indexes on that table are also deleted.
//
// If you have DynamoDB Streams enabled on the table, then the corresponding
// stream on that table goes into the DISABLED state, and the stream is automatically
// deleted after 24 hours.
//
// Use the DescribeTable action to check the status of the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DeleteTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable
func (c *DynamoDB) DeleteTable(input *DeleteTableInput) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	return out, req.Send()
}

// DeleteTableWithContext is the same as DeleteTable with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DeleteTableWithContext(ctx aws.Context, input *DeleteTableInput, opts ...request.Option) (*DeleteTableOutput, error) {
	req, out := c.DeleteTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLimits = "DescribeLimits"

// DescribeLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLimits operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLimits for more information on using the DescribeLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLimitsRequest method.
//    req, resp := client.DescribeLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits
func (c *DynamoDB) DescribeLimitsRequest(input *DescribeLimitsInput) (req *request.Request, output *DescribeLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLimitsInput{}
	}

	output = &DescribeLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLimits API operation for Amazon DynamoDB.
//
// Returns the current provisioned-capacity limits for your AWS account in a
// region, both for the region as a whole and for any one DynamoDB table that
// you create there.
//
// When you establish an AWS account, the account has initial limits on the
// maximum read capacity units and write capacity units that you can provision
// across all of your DynamoDB tables in a given region. Also, there are per-table
// limits that apply when you create a table there. For more information, see
// Limits (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// page in the Amazon DynamoDB Developer Guide.
//
// Although you can increase these limits by filing a case at AWS Support Center
// (https://console.aws.amazon.com/support/home#/), obtaining the increase is
// not instantaneous. The DescribeLimits action lets you write code to compare
// the capacity you are currently using to those limits imposed by your account
// so that you have enough time to apply for an increase before you hit a limit.
//
// For example, you could use one of the AWS SDKs to do the following:
//
// Call DescribeLimits for a particular region to obtain your current account
// limits on provisioned capacity there.
//
// Create a variable to hold the aggregate read capacity units provisioned for
// all your tables in that region, and one to hold the aggregate write capacity
// units. Zero them both.
//
// Call ListTables to obtain a list of all your DynamoDB tables.
//
// For each table name listed by ListTables, do the following:
//
// Call DescribeTable with the table name.
//
// Use the data returned by DescribeTable to add the read capacity units and
// write capacity units provisioned for the table itself to your variables.
//
// If the table has one or more global secondary indexes (GSIs), loop over these
// GSIs and add their provisioned capacity values to your variables as well.
//
// Report the account limits for that region returned by DescribeLimits, along
// with the total current provisioned capacity levels you have calculated.
//
// This will let you see whether you are getting close to your account-level
// limits.
//
// The per-table limits apply only when you are creating a new table. They restrict
// the sum of the provisioned capacity of the new table itself and all its global
// secondary indexes.
//
// For existing tables and their GSIs, DynamoDB will not let you increase provisioned
// capacity extremely rapidly, but the only upper limit that applies is that
// the aggregate provisioned capacity over all your tables and GSIs cannot exceed
// either of the per-account limits.
//
// DescribeLimits should only be called periodically. You can expect throttling
// errors if you call it more than once in a minute.
//
// The DescribeLimits Request element has no content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeLimits for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits
func (c *DynamoDB) DescribeLimits(input *DescribeLimitsInput) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	return out, req.Send()
}

// DescribeLimitsWithContext is the same as DescribeLimits with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeLimitsWithContext(ctx aws.Context, input *DescribeLimitsInput, opts ...request.Option) (*DescribeLimitsOutput, error) {
	req, out := c.DescribeLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTable = "DescribeTable"

// DescribeTableRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTable operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTable for more information on using the DescribeTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableRequest method.
//    req, resp := client.DescribeTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable
func (c *DynamoDB) DescribeTableRequest(input *DescribeTableInput) (req *request.Request, output *DescribeTableOutput) {
	op := &request.Operation{
		Name:       opDescribeTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTableInput{}
	}

	output = &DescribeTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTable API operation for Amazon DynamoDB.
//
// Returns information about the table, including the current status of the
// table, when it was created, the primary key schema, and any indexes on the
// table.
//
// If you issue a DescribeTable request immediately after a CreateTable request,
// DynamoDB might return a ResourceNotFoundException. This is because DescribeTable
// uses an eventually consistent query, and the metadata for your table might
// not be available at that moment. Wait for a few seconds, and then try the
// DescribeTable request again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable
func (c *DynamoDB) DescribeTable(input *DescribeTableInput) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	return out, req.Send()
}

// DescribeTableWithContext is the same as DescribeTable with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeTableWithContext(ctx aws.Context, input *DescribeTableInput, opts ...request.Option) (*DescribeTableOutput, error) {
	req, out := c.DescribeTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTimeToLive = "DescribeTimeToLive"

// DescribeTimeToLiveRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTimeToLive operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTimeToLive for more information on using the DescribeTimeToLive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTimeToLiveRequest method.
//    req, resp := client.DescribeTimeToLiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive
func (c *DynamoDB) DescribeTimeToLiveRequest(input *DescribeTimeToLiveInput) (req *request.Request, output *DescribeTimeToLiveOutput) {
	op := &request.Operation{
		Name:       opDescribeTimeToLive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTimeToLiveInput{}
	}

	output = &DescribeTimeToLiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTimeToLive API operation for Amazon DynamoDB.
//
// Gives a description of the Time to Live (TTL) status on the specified table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation DescribeTimeToLive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive
func (c *DynamoDB) DescribeTimeToLive(input *DescribeTimeToLiveInput) (*DescribeTimeToLiveOutput, error) {
	req, out := c.DescribeTimeToLiveRequest(input)
	return out, req.Send()
}

// DescribeTimeToLiveWithContext is the same as DescribeTimeToLive with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTimeToLive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) DescribeTimeToLiveWithContext(ctx aws.Context, input *DescribeTimeToLiveInput, opts ...request.Option) (*DescribeTimeToLiveOutput, error) {
	req, out := c.DescribeTimeToLiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetItem = "GetItem"

// GetItemRequest generates a "aws/request.Request" representing the
// client's request for the GetItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetItem for more information on using the GetItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetItemRequest method.
//    req, resp := client.GetItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem
func (c *DynamoDB) GetItemRequest(input *GetItemInput) (req *request.Request, output *GetItemOutput) {
	op := &request.Operation{
		Name:       opGetItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetItemInput{}
	}

	output = &GetItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetItem API operation for Amazon DynamoDB.
//
// The GetItem operation returns a set of attributes for the item with the given
// primary key. If there is no matching item, GetItem does not return any data
// and there will be no Item element in the response.
//
// GetItem provides an eventually consistent read by default. If your application
// requires a strongly consistent read, set ConsistentRead to true. Although
// a strongly consistent read might take more time than an eventually consistent
// read, it always returns the last updated value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation GetItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem
func (c *DynamoDB) GetItem(input *GetItemInput) (*GetItemOutput, error) {
	req, out := c.GetItemRequest(input)
	return out, req.Send()
}

// GetItemWithContext is the same as GetItem with the addition of
// the ability to pass a context and additional request options.
//
// See GetItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) GetItemWithContext(ctx aws.Context, input *GetItemInput, opts ...request.Option) (*GetItemOutput, error) {
	req, out := c.GetItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTables = "ListTables"

// ListTablesRequest generates a "aws/request.Request" representing the
// client's request for the ListTables operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTables for more information on using the ListTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTablesRequest method.
//    req, resp := client.ListTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables
func (c *DynamoDB) ListTablesRequest(input *ListTablesInput) (req *request.Request, output *ListTablesOutput) {
	op := &request.Operation{
		Name:       opListTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartTableName"},
			OutputTokens:    []string{"LastEvaluatedTableName"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTablesInput{}
	}

	output = &ListTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTables API operation for Amazon DynamoDB.
//
// Returns an array of table names associated with the current account and endpoint.
// The output from ListTables is paginated, with each page returning a maximum
// of 100 table names.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListTables for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables
func (c *DynamoDB) ListTables(input *ListTablesInput) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	return out, req.Send()
}

// ListTablesWithContext is the same as ListTables with the addition of
// the ability to pass a context and additional request options.
//
// See ListTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTablesWithContext(ctx aws.Context, input *ListTablesInput, opts ...request.Option) (*ListTablesOutput, error) {
	req, out := c.ListTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTablesPages iterates over the pages of a ListTables operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTables method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTables operation.
//    pageNum := 0
//    err := client.ListTablesPages(params,
//        func(page *ListTablesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) ListTablesPages(input *ListTablesInput, fn func(*ListTablesOutput, bool) bool) error {
	return c.ListTablesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTablesPagesWithContext same as ListTablesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTablesPagesWithContext(ctx aws.Context, input *ListTablesInput, fn func(*ListTablesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTablesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTablesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTablesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListTagsOfResource = "ListTagsOfResource"

// ListTagsOfResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsOfResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsOfResource for more information on using the ListTagsOfResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsOfResourceRequest method.
//    req, resp := client.ListTagsOfResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource
func (c *DynamoDB) ListTagsOfResourceRequest(input *ListTagsOfResourceInput) (req *request.Request, output *ListTagsOfResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsOfResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsOfResourceInput{}
	}

	output = &ListTagsOfResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsOfResource API operation for Amazon DynamoDB.
//
// List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource
// up to 10 times per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation ListTagsOfResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource
func (c *DynamoDB) ListTagsOfResource(input *ListTagsOfResourceInput) (*ListTagsOfResourceOutput, error) {
	req, out := c.ListTagsOfResourceRequest(input)
	return out, req.Send()
}

// ListTagsOfResourceWithContext is the same as ListTagsOfResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsOfResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ListTagsOfResourceWithContext(ctx aws.Context, input *ListTagsOfResourceInput, opts ...request.Option) (*ListTagsOfResourceOutput, error) {
	req, out := c.ListTagsOfResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutItem = "PutItem"

// PutItemRequest generates a "aws/request.Request" representing the
// client's request for the PutItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutItem for more information on using the PutItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutItemRequest method.
//    req, resp := client.PutItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem
func (c *DynamoDB) PutItemRequest(input *PutItemInput) (req *request.Request, output *PutItemOutput) {
	op := &request.Operation{
		Name:       opPutItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutItemInput{}
	}

	output = &PutItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutItem API operation for Amazon DynamoDB.
//
// Creates a new item, or replaces an old item with a new item. If an item that
// has the same primary key as the new item already exists in the specified
// table, the new item completely replaces the existing item. You can perform
// a conditional put operation (add a new item if one with the specified primary
// key doesn't exist), or replace an existing item if it has certain attribute
// values. You can return the item's attribute values in the same operation,
// using the ReturnValues parameter.
//
// This topic provides general information about the PutItem API.
//
// For information on how to call the PutItem API using the AWS SDK in specific
// languages, see the following:
//
//  PutItem in the AWS Command Line Interface  (http://docs.aws.amazon.com/goto/aws-cli/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for .NET  (http://docs.aws.amazon.com/goto/DotNetSDKV3/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for C++  (http://docs.aws.amazon.com/goto/SdkForCpp/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for Go  (http://docs.aws.amazon.com/goto/SdkForGoV1/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for Java  (http://docs.aws.amazon.com/goto/SdkForJava/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for JavaScript  (http://docs.aws.amazon.com/goto/AWSJavaScriptSDK/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for PHP V3  (http://docs.aws.amazon.com/goto/SdkForPHPV3/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for Python  (http://docs.aws.amazon.com/goto/boto3/dynamodb-2012-08-10/PutItem)
//
//  PutItem in the AWS SDK for Ruby V2  (http://docs.aws.amazon.com/goto/SdkForRubyV2/dynamodb-2012-08-10/PutItem)
//
// When you add an item, the primary key attribute(s) are the only required
// attributes. Attribute values cannot be null. String and Binary type attributes
// must have lengths greater than zero. Set type attributes cannot be empty.
// Requests with empty values will be rejected with a ValidationException exception.
//
// To prevent a new item from replacing an existing item, use a conditional
// expression that contains the attribute_not_exists function with the name
// of the attribute being used as the partition key for the table. Since every
// record must contain that attribute, the attribute_not_exists function will
// only succeed if no matching item exists.
//
// For more information about PutItem, see Working with Items (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation PutItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem
func (c *DynamoDB) PutItem(input *PutItemInput) (*PutItemOutput, error) {
	req, out := c.PutItemRequest(input)
	return out, req.Send()
}

// PutItemWithContext is the same as PutItem with the addition of
// the ability to pass a context and additional request options.
//
// See PutItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) PutItemWithContext(ctx aws.Context, input *PutItemInput, opts ...request.Option) (*PutItemOutput, error) {
	req, out := c.PutItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQuery = "Query"

// QueryRequest generates a "aws/request.Request" representing the
// client's request for the Query operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Query for more information on using the Query
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the QueryRequest method.
//    req, resp := client.QueryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query
func (c *DynamoDB) QueryRequest(input *QueryInput) (req *request.Request, output *QueryOutput) {
	op := &request.Operation{
		Name:       opQuery,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartKey"},
			OutputTokens:    []string{"LastEvaluatedKey"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &QueryInput{}
	}

	output = &QueryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Query API operation for Amazon DynamoDB.
//
// The Query operation finds items based on primary key values. You can query
// any table or secondary index that has a composite primary key (a partition
// key and a sort key).
//
// Use the KeyConditionExpression parameter to provide a specific value for
// the partition key. The Query operation will return all of the items from
// the table or index with that partition key value. You can optionally narrow
// the scope of the Query operation by specifying a sort key value and a comparison
// operator in KeyConditionExpression. To further refine the Query results,
// you can optionally provide a FilterExpression. A FilterExpression determines
// which items within the results should be returned to you. All of the other
// results are discarded.
//
// A Query operation always returns a result set. If no matching items are found,
// the result set will be empty. Queries that do not return results consume
// the minimum number of read capacity units for that type of read operation.
//
// DynamoDB calculates the number of read capacity units consumed based on item
// size, not on the amount of data that is returned to an application. The number
// of capacity units consumed will be the same whether you request all of the
// attributes (the default behavior) or just some of them (using a projection
// expression). The number will also be the same whether or not you use a FilterExpression.
//
// Query results are always sorted by the sort key value. If the data type of
// the sort key is Number, the results are returned in numeric order; otherwise,
// the results are returned in order of UTF-8 bytes. By default, the sort order
// is ascending. To reverse the order, set the ScanIndexForward parameter to
// false.
//
// A single Query operation will read up to the maximum number of items set
// (if using the Limit parameter) or a maximum of 1 MB of data and then apply
// any filtering to the results using FilterExpression. If LastEvaluatedKey
// is present in the response, you will need to paginate the result set. For
// more information, see Paginating the Results (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination)
// in the Amazon DynamoDB Developer Guide.
//
// FilterExpression is applied after a Query finishes, but before the results
// are returned. A FilterExpression cannot contain partition key or sort key
// attributes. You need to specify those attributes in the KeyConditionExpression.
//
// A Query operation can return an empty result set and a LastEvaluatedKey if
// all the items read for the page of results are filtered out.
//
// You can query a table, a local secondary index, or a global secondary index.
// For a query on a table or on a local secondary index, you can set the ConsistentRead
// parameter to true and obtain a strongly consistent result. Global secondary
// indexes support eventually consistent reads only, so do not specify ConsistentRead
// when querying a global secondary index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation Query for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query
func (c *DynamoDB) Query(input *QueryInput) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	return out, req.Send()
}

// QueryWithContext is the same as Query with the addition of
// the ability to pass a context and additional request options.
//
// See Query for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) QueryWithContext(ctx aws.Context, input *QueryInput, opts ...request.Option) (*QueryOutput, error) {
	req, out := c.QueryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// QueryPages iterates over the pages of a Query operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Query method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Query operation.
//    pageNum := 0
//    err := client.QueryPages(params,
//        func(page *QueryOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) QueryPages(input *QueryInput, fn func(*QueryOutput, bool) bool) error {
	return c.QueryPagesWithContext(aws.BackgroundContext(), input, fn)
}

// QueryPagesWithContext same as QueryPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) QueryPagesWithContext(ctx aws.Context, input *QueryInput, fn func(*QueryOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *QueryInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.QueryRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*QueryOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opScan = "Scan"

// ScanRequest generates a "aws/request.Request" representing the
// client's request for the Scan operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Scan for more information on using the Scan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ScanRequest method.
//    req, resp := client.ScanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan
func (c *DynamoDB) ScanRequest(input *ScanInput) (req *request.Request, output *ScanOutput) {
	op := &request.Operation{
		Name:       opScan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"ExclusiveStartKey"},
			OutputTokens:    []string{"LastEvaluatedKey"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ScanInput{}
	}

	output = &ScanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Scan API operation for Amazon DynamoDB.
//
// The Scan operation returns one or more items and item attributes by accessing
// every item in a table or a secondary index. To have DynamoDB return fewer
// items, you can provide a FilterExpression operation.
//
// If the total number of scanned items exceeds the maximum data set size limit
// of 1 MB, the scan stops and results are returned to the user as a LastEvaluatedKey
// value to continue the scan in a subsequent operation. The results also include
// the number of items exceeding the limit. A scan can result in no table data
// meeting the filter criteria.
//
// A single Scan operation will read up to the maximum number of items set (if
// using the Limit parameter) or a maximum of 1 MB of data and then apply any
// filtering to the results using FilterExpression. If LastEvaluatedKey is present
// in the response, you will need to paginate the result set. For more information,
// see Paginating the Results (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination)
// in the Amazon DynamoDB Developer Guide.
//
// Scan operations proceed sequentially; however, for faster performance on
// a large table or secondary index, applications can request a parallel Scan
// operation by providing the Segment and TotalSegments parameters. For more
// information, see Parallel Scan (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan)
// in the Amazon DynamoDB Developer Guide.
//
// Scan uses eventually consistent reads when accessing the data in a table;
// therefore, the result set might not include the changes to data in the table
// immediately before the operation began. If you need a consistent copy of
// the data, as of the time that the Scan begins, you can set the ConsistentRead
// parameter to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation Scan for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan
func (c *DynamoDB) Scan(input *ScanInput) (*ScanOutput, error) {
	req, out := c.ScanRequest(input)
	return out, req.Send()
}

// ScanWithContext is the same as Scan with the addition of
// the ability to pass a context and additional request options.
//
// See Scan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ScanWithContext(ctx aws.Context, input *ScanInput, opts ...request.Option) (*ScanOutput, error) {
	req, out := c.ScanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ScanPages iterates over the pages of a Scan operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Scan method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Scan operation.
//    pageNum := 0
//    err := client.ScanPages(params,
//        func(page *ScanOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DynamoDB) ScanPages(input *ScanInput, fn func(*ScanOutput, bool) bool) error {
	return c.ScanPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ScanPagesWithContext same as ScanPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) ScanPagesWithContext(ctx aws.Context, input *ScanInput, fn func(*ScanOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ScanInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ScanRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ScanOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource
func (c *DynamoDB) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon DynamoDB.
//
// Associate a set of tags with an Amazon DynamoDB resource. You can then activate
// these user-defined tags so that they appear on the Billing and Cost Management
// console for cost allocation tracking. You can call TagResource up to 5 times
// per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource
func (c *DynamoDB) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource
func (c *DynamoDB) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon DynamoDB.
//
// Removes the association of tags from an Amazon DynamoDB resource. You can
// call UntagResource up to 5 times per second, per account.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource
func (c *DynamoDB) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateItem = "UpdateItem"

// UpdateItemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateItem operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateItem for more information on using the UpdateItem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateItemRequest method.
//    req, resp := client.UpdateItemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem
func (c *DynamoDB) UpdateItemRequest(input *UpdateItemInput) (req *request.Request, output *UpdateItemOutput) {
	op := &request.Operation{
		Name:       opUpdateItem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateItemInput{}
	}

	output = &UpdateItemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateItem API operation for Amazon DynamoDB.
//
// Edits an existing item's attributes, or adds a new item to the table if it
// does not already exist. You can put, delete, or add attribute values. You
// can also perform a conditional update on an existing item (insert a new attribute
// name-value pair if it doesn't exist, or replace an existing name-value pair
// if it has certain expected attribute values).
//
// You can also return the item's attribute values in the same UpdateItem operation
// using the ReturnValues parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateItem for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeConditionalCheckFailedException "ConditionalCheckFailedException"
//   A condition specified in the operation could not be evaluated.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   Your request rate is too high. The AWS SDKs for DynamoDB automatically retry
//   requests that receive this exception. Your request is eventually successful,
//   unless your retry queue is too large to finish. Reduce the frequency of requests
//   and use exponential backoff. For more information, go to Error Retries and
//   Exponential Backoff (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff)
//   in the Amazon DynamoDB Developer Guide.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeItemCollectionSizeLimitExceededException "ItemCollectionSizeLimitExceededException"
//   An item collection is too large. This exception is only returned for tables
//   that have one or more local secondary indexes.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem
func (c *DynamoDB) UpdateItem(input *UpdateItemInput) (*UpdateItemOutput, error) {
	req, out := c.UpdateItemRequest(input)
	return out, req.Send()
}

// UpdateItemWithContext is the same as UpdateItem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateItem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateItemWithContext(ctx aws.Context, input *UpdateItemInput, opts ...request.Option) (*UpdateItemOutput, error) {
	req, out := c.UpdateItemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTable = "UpdateTable"

// UpdateTableRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTable operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTable for more information on using the UpdateTable
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTableRequest method.
//    req, resp := client.UpdateTableRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable
func (c *DynamoDB) UpdateTableRequest(input *UpdateTableInput) (req *request.Request, output *UpdateTableOutput) {
	op := &request.Operation{
		Name:       opUpdateTable,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTableInput{}
	}

	output = &UpdateTableOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTable API operation for Amazon DynamoDB.
//
// Modifies the provisioned throughput settings, global secondary indexes, or
// DynamoDB Streams settings for a given table.
//
// You can only perform one of the following operations at once:
//
//    * Modify the provisioned throughput settings of the table.
//
//    * Enable or disable Streams on the table.
//
//    * Remove a global secondary index from the table.
//
//    * Create a new global secondary index on the table. Once the index begins
//    backfilling, you can use UpdateTable to perform other operations.
//
// UpdateTable is an asynchronous operation; while it is executing, the table
// status changes from ACTIVE to UPDATING. While it is UPDATING, you cannot
// issue another UpdateTable request. When the table returns to the ACTIVE state,
// the UpdateTable operation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateTable for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable
func (c *DynamoDB) UpdateTable(input *UpdateTableInput) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	return out, req.Send()
}

// UpdateTableWithContext is the same as UpdateTable with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTable for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateTableWithContext(ctx aws.Context, input *UpdateTableInput, opts ...request.Option) (*UpdateTableOutput, error) {
	req, out := c.UpdateTableRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTimeToLive = "UpdateTimeToLive"

// UpdateTimeToLiveRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTimeToLive operation. The "output" return
// value will be populated with the request's response once the request complets
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTimeToLive for more information on using the UpdateTimeToLive
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateTimeToLiveRequest method.
//    req, resp := client.UpdateTimeToLiveRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive
func (c *DynamoDB) UpdateTimeToLiveRequest(input *UpdateTimeToLiveInput) (req *request.Request, output *UpdateTimeToLiveOutput) {
	op := &request.Operation{
		Name:       opUpdateTimeToLive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTimeToLiveInput{}
	}

	output = &UpdateTimeToLiveOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTimeToLive API operation for Amazon DynamoDB.
//
// The UpdateTimeToLive method will enable or disable TTL for the specified
// table. A successful UpdateTimeToLive call returns the current TimeToLiveSpecification;
// it may take up to one hour for the change to fully process. Any additional
// UpdateTimeToLive calls for the same table during this one hour duration result
// in a ValidationException.
//
// TTL compares the current time in epoch time format to the time stored in
// the TTL attribute of an item. If the epoch time value stored in the attribute
// is less than the current time, the item is marked as expired and subsequently
// deleted.
//
// The epoch time format is the number of seconds elapsed since 12:00:00 AM
// January 1st, 1970 UTC.
//
// DynamoDB deletes expired items on a best-effort basis to ensure availability
// of throughput for other data operations.
//
// DynamoDB typically deletes expired items within two days of expiration. The
// exact duration within which an item gets deleted after expiration is specific
// to the nature of the workload. Items that have expired and not been deleted
// will still show up in reads, queries, and scans.
//
// As items are deleted, they are removed from any Local Secondary Index and
// Global Secondary Index immediately in the same eventually consistent way
// as a standard delete operation.
//
// For more information, see Time To Live (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html)
// in the Amazon DynamoDB Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB's
// API operation UpdateTimeToLive for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceInUseException "ResourceInUseException"
//   The operation conflicts with the resource's availability. For example, you
//   attempted to recreate an existing table, or tried to delete a table currently
//   in the CREATING state.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The operation tried to access a nonexistent table or index. The resource
//   might not be specified correctly, or its status might not be ACTIVE.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The number of concurrent table requests (cumulative number of tables in the
//   CREATING, DELETING or UPDATING state) exceeds the maximum allowed of 10.
//
//   Also, for tables with secondary indexes, only one of those tables can be
//   in the CREATING state at any point in time. Do not attempt to create more
//   than one such table simultaneously.
//
//   The total limit of tables in the ACTIVE state is 250.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   An error occurred on the server side.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive
func (c *DynamoDB) UpdateTimeToLive(input *UpdateTimeToLiveInput) (*UpdateTimeToLiveOutput, error) {
	req, out := c.UpdateTimeToLiveRequest(input)
	return out, req.Send()
}

// UpdateTimeToLiveWithContext is the same as UpdateTimeToLive with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTimeToLive for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DynamoDB) UpdateTimeToLiveWithContext(ctx aws.Context, input *UpdateTimeToLiveInput, opts ...request.Option) (*UpdateTimeToLiveOutput, error) {
	req, out := c.UpdateTimeToLiveRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents an attribute for describing the key schema for the table and indexes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeDefinition
type AttributeDefinition struct {
	_ struct{} `type:"structure"`

	// A name for the attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The data type for the attribute, where:
	//
	//    * S - the attribute is of type String
	//
	//    * N - the attribute is of type Number
	//
	//    * B - the attribute is of type Binary
	//
	// AttributeType is a required field
	AttributeType *string `type:"string" required:"true" enum:"ScalarAttributeType"`
}

// String returns the string representation
func (s AttributeDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttributeDefinition"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.AttributeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *AttributeDefinition) SetAttributeName(v string) *AttributeDefinition {
	s.AttributeName = &v
	return s
}

// SetAttributeType sets the AttributeType field's value.
func (s *AttributeDefinition) SetAttributeType(v string) *AttributeDefinition {
	s.AttributeType = &v
	return s
}

// Represents the data for an attribute.
//
// Each attribute value is described as a name-value pair. The name is the data
// type, and the value is the data itself.
//
// For more information, see Data Types (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// An attribute of type Binary. For example:
	//
	// "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
	//
	// B is automatically base64 encoded/decoded by the SDK.
	B []byte `type:"blob"`

	// An attribute of type Boolean. For example:
	//
	// "BOOL": true
	BOOL *bool `type:"boolean"`

	// An attribute of type Binary Set. For example:
	//
	// "BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]
	BS [][]byte `type:"list"`

	// An attribute of type List. For example:
	//
	// "L": ["Cookies", "Coffee", 3.14159]
	L []*AttributeValue `type:"list"`

	// An attribute of type Map. For example:
	//
	// "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
	M map[string]*AttributeValue `type:"map"`

	// An attribute of type Number. For example:
	//
	// "N": "123.45"
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	N *string `type:"string"`

	// An attribute of type Number Set. For example:
	//
	// "NS": ["42.2", "-19", "7.5", "3.14"]
	//
	// Numbers are sent across the network to DynamoDB as strings, to maximize compatibility
	// across languages and libraries. However, DynamoDB treats them as number type
	// attributes for mathematical operations.
	NS []*string `type:"list"`

	// An attribute of type Null. For example:
	//
	// "NULL": true
	NULL *bool `type:"boolean"`

	// An attribute of type String. For example:
	//
	// "S": "Hello"
	S *string `type:"string"`

	// An attribute of type String Set. For example:
	//
	// "SS": ["Giraffe", "Hippo" ,"Zebra"]
	SS []*string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValue) GoString() string {
	return s.String()
}

// SetB sets the B field's value.
func (s *AttributeValue) SetB(v []byte) *AttributeValue {
	s.B = v
	return s
}

// SetBOOL sets the BOOL field's value.
func (s *AttributeValue) SetBOOL(v bool) *AttributeValue {
	s.BOOL = &v
	return s
}

// SetBS sets the BS field's value.
func (s *AttributeValue) SetBS(v [][]byte) *AttributeValue {
	s.BS = v
	return s
}

// SetL sets the L field's value.
func (s *AttributeValue) SetL(v []*AttributeValue) *AttributeValue {
	s.L = v
	return s
}

// SetM sets the M field's value.
func (s *AttributeValue) SetM(v map[string]*AttributeValue) *AttributeValue {
	s.M = v
	return s
}

// SetN sets the N field's value.
func (s *AttributeValue) SetN(v string) *AttributeValue {
	s.N = &v
	return s
}

// SetNS sets the NS field's value.
func (s *AttributeValue) SetNS(v []*string) *AttributeValue {
	s.NS = v
	return s
}

// SetNULL sets the NULL field's value.
func (s *AttributeValue) SetNULL(v bool) *AttributeValue {
	s.NULL = &v
	return s
}

// SetS sets the S field's value.
func (s *AttributeValue) SetS(v string) *AttributeValue {
	s.S = &v
	return s
}

// SetSS sets the SS field's value.
func (s *AttributeValue) SetSS(v []*string) *AttributeValue {
	s.SS = v
	return s
}

// For the UpdateItem operation, represents the attributes to be modified, the
// action to perform on each, and the new value for each.
//
// You cannot use UpdateItem to update any primary key attributes. Instead,
// you will need to delete the item, and then use PutItem to create a new item
// with new attributes.
//
// Attribute values cannot be null; string and binary type attributes must have
// lengths greater than zero; and set type attributes must not be empty. Requests
// with empty values will be rejected with a ValidationException exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/AttributeValueUpdate
type AttributeValueUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies how to perform the update. Valid values are PUT (default), DELETE,
	// and ADD. The behavior depends on whether the specified primary key already
	// exists in the table.
	//
	// If an item with the specified Key is found in the table:
	//
	//    * PUT - Adds the specified attribute to the item. If the attribute already
	//    exists, it is replaced by the new value.
	//
	//    * DELETE - If no value is specified, the attribute and its value are removed
	//    from the item. The data type of the specified value must match the existing
	//    value's data type.
	//
	// If a set of values is specified, then those values are subtracted from the
	//    old set. For example, if the attribute value was the set [a,b,c] and the
	//    DELETE action specified [a,c], then the final attribute value would be
	//    [b]. Specifying an empty set is an error.
	//
	//    * ADD - If the attribute does not already exist, then the attribute and
	//    its values are added to the item. If the attribute does exist, then the
	//    behavior of ADD depends on the data type of the attribute:
	//
	// If the existing attribute is a number, and if Value is also a number, then
	//    the Value is mathematically added to the existing attribute. If Value
	//    is a negative number, then it is subtracted from the existing attribute.
	//
	//  If you use ADD to increment or decrement a number value for an item that
	//    doesn't exist before the update, DynamoDB uses 0 as the initial value.
	//
	// In addition, if you use ADD to update an existing item, and intend to increment
	//    or decrement an attribute value which does not yet exist, DynamoDB uses
	//    0 as the initial value. For example, suppose that the item you want to
	//    update does not yet have an attribute named itemcount, but you decide
	//    to ADD the number 3 to this attribute anyway, even though it currently
	//    does not exist. DynamoDB will create the itemcount attribute, set its
	//    initial value to 0, and finally add 3 to it. The result will be a new
	//    itemcount attribute in the item, with a value of 3.
	//
	// If the existing data type is a set, and if the Value is also a set, then
	//    the Value is added to the existing set. (This is a set operation, not
	//    mathematical addition.) For example, if the attribute value was the set
	//    [1,2], and the ADD action specified [3], then the final attribute value
	//    would be [1,2,3]. An error occurs if an Add action is specified for a
	//    set attribute and the attribute type specified does not match the existing
	//    set type.
	//
	// Both sets must have the same primitive data type. For example, if the existing
	//    data type is a set of strings, the Value must also be a set of strings.
	//    The same holds true for number sets and binary sets.
	//
	// This action is only valid for an existing attribute whose data type is number
	//    or is a set. Do not use ADD for any other data types.
	//
	// If no item with the specified Key is found:
	//
	//    * PUT - DynamoDB creates a new item with the specified primary key, and
	//    then adds the attribute.
	//
	//    * DELETE - Nothing happens; there is no attribute to delete.
	//
	//    * ADD - DynamoDB creates an item with the supplied primary key and number
	//    (or set of numbers) for the attribute value. The only data types allowed
	//    are number and number set; no other data types can be specified.
	Action *string `type:"string" enum:"AttributeAction"`

	// Represents the data for an attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data TYpes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s AttributeValueUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributeValueUpdate) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AttributeValueUpdate) SetAction(v string) *AttributeValueUpdate {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttributeValueUpdate) SetValue(v *AttributeValue) *AttributeValueUpdate {
	s.Value = v
	return s
}

// Represents the input of a BatchGetItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItemInput
type BatchGetItemInput struct {
	_ struct{} `type:"structure"`

	// A map of one or more table names and, for each table, a map that describes
	// one or more items to retrieve from that table. Each table name can be used
	// only once per BatchGetItem request.
	//
	// Each element in the map of items to retrieve consists of the following:
	//
	//    * ConsistentRead - If true, a strongly consistent read is used; if false
	//    (the default), an eventually consistent read is used.
	//
	//    * ExpressionAttributeNames - One or more substitution tokens for attribute
	//    names in the ProjectionExpression parameter. The following are some use
	//    cases for using ExpressionAttributeNames:
	//
	// To access an attribute whose name conflicts with a DynamoDB reserved word.
	//
	// To create a placeholder for repeating occurrences of an attribute name in
	//    an expression.
	//
	// To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	//    example, consider the following attribute name:
	//
	// Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	//    used directly in an expression. (For the complete list of reserved words,
	//    see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	//    in the Amazon DynamoDB Developer Guide). To work around this, you could
	//    specify the following for ExpressionAttributeNames:
	//
	// {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	// #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	//    are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	//    (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	//    * Keys - An array of primary key attribute values that define specific
	//    items in the table. For each primary key, you must provide all of the
	//    key attributes. For example, with a simple primary key, you only need
	//    to provide the partition key value. For a composite key, you must provide
	//    both the partition key value and the sort key value.
	//
	//    * ProjectionExpression - A string that identifies one or more attributes
	//    to retrieve from the table. These attributes can include scalars, sets,
	//    or elements of a JSON document. The attributes in the expression must
	//    be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	//    If any of the requested attributes are not found, they will not appear
	//    in the result.
	//
	// For more information, see Accessing Item Attributes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	//    * AttributesToGet - This is a legacy parameter. Use ProjectionExpression
	//    instead. For more information, see AttributesToGet (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	//    in the Amazon DynamoDB Developer Guide.
	//
	// RequestItems is a required field
	RequestItems map[string]*KeysAndAttributes `min:"1" type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`
}

// String returns the string representation
func (s BatchGetItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetItemInput"}
	if s.RequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestItems"))
	}
	if s.RequestItems != nil && len(s.RequestItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestItems", 1))
	}
	if s.RequestItems != nil {
		for i, v := range s.RequestItems {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RequestItems", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestItems sets the RequestItems field's value.
func (s *BatchGetItemInput) SetRequestItems(v map[string]*KeysAndAttributes) *BatchGetItemInput {
	s.RequestItems = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *BatchGetItemInput) SetReturnConsumedCapacity(v string) *BatchGetItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// Represents the output of a BatchGetItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItemOutput
type BatchGetItemOutput struct {
	_ struct{} `type:"structure"`

	// The read capacity units consumed by the entire BatchGetItem operation.
	//
	// Each element consists of:
	//
	//    * TableName - The table that consumed the provisioned throughput.
	//
	//    * CapacityUnits - The total number of capacity units consumed.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// A map of table name to a list of items. Each object in Responses consists
	// of a table name, along with a map of attribute data consisting of the data
	// type and attribute value.
	Responses map[string][]map[string]*AttributeValue `type:"map"`

	// A map of tables and their respective keys that were not processed with the
	// current response. The UnprocessedKeys value is in the same form as RequestItems,
	// so the value can be provided directly to a subsequent BatchGetItem operation.
	// For more information, see RequestItems in the Request Parameters section.
	//
	// Each element consists of:
	//
	//    * Keys - An array of primary key attribute values that define specific
	//    items in the table.
	//
	//    * ProjectionExpression - One or more attributes to be retrieved from the
	//    table or index. By default, all attributes are returned. If a requested
	//    attribute is not found, it does not appear in the result.
	//
	//    * ConsistentRead - The consistency of a read operation. If set to true,
	//    then a strongly consistent read is used; otherwise, an eventually consistent
	//    read is used.
	//
	// If there are no unprocessed keys remaining, the response contains an empty
	// UnprocessedKeys map.
	UnprocessedKeys map[string]*KeysAndAttributes `min:"1" type:"map"`
}

// String returns the string representation
func (s BatchGetItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *BatchGetItemOutput) SetConsumedCapacity(v []*ConsumedCapacity) *BatchGetItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetResponses sets the Responses field's value.
func (s *BatchGetItemOutput) SetResponses(v map[string][]map[string]*AttributeValue) *BatchGetItemOutput {
	s.Responses = v
	return s
}

// SetUnprocessedKeys sets the UnprocessedKeys field's value.
func (s *BatchGetItemOutput) SetUnprocessedKeys(v map[string]*KeysAndAttributes) *BatchGetItemOutput {
	s.UnprocessedKeys = v
	return s
}

// Represents the input of a BatchWriteItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItemInput
type BatchWriteItemInput struct {
	_ struct{} `type:"structure"`

	// A map of one or more table names and, for each table, a list of operations
	// to be performed (DeleteRequest or PutRequest). Each element in the map consists
	// of the following:
	//
	//    * DeleteRequest - Perform a DeleteItem operation on the specified item.
	//    The item to be deleted is identified by a Key subelement:
	//
	// Key - A map of primary key attribute values that uniquely identify the item.
	//    Each entry in this map consists of an attribute name and an attribute
	//    value. For each primary key, you must provide all of the key attributes.
	//    For example, with a simple primary key, you only need to provide a value
	//    for the partition key. For a composite primary key, you must provide values
	//    for both the partition key and the sort key.
	//
	//    * PutRequest - Perform a PutItem operation on the specified item. The
	//    item to be put is identified by an Item subelement:
	//
	// Item - A map of attributes and their values. Each entry in this map consists
	//    of an attribute name and an attribute value. Attribute values must not
	//    be null; string and binary type attributes must have lengths greater than
	//    zero; and set type attributes must not be empty. Requests that contain
	//    empty values will be rejected with a ValidationException exception.
	//
	// If you specify any attributes that are part of an index key, then the data
	//    types for those attributes must match those of the schema in the table's
	//    attribute definition.
	//
	// RequestItems is a required field
	RequestItems map[string][]*WriteRequest `min:"1" type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`
}

// String returns the string representation
func (s BatchWriteItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchWriteItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchWriteItemInput"}
	if s.RequestItems == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestItems"))
	}
	if s.RequestItems != nil && len(s.RequestItems) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestItems sets the RequestItems field's value.
func (s *BatchWriteItemInput) SetRequestItems(v map[string][]*WriteRequest) *BatchWriteItemInput {
	s.RequestItems = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *BatchWriteItemInput) SetReturnConsumedCapacity(v string) *BatchWriteItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *BatchWriteItemInput) SetReturnItemCollectionMetrics(v string) *BatchWriteItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// Represents the output of a BatchWriteItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItemOutput
type BatchWriteItemOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the entire BatchWriteItem operation.
	//
	// Each element consists of:
	//
	//    * TableName - The table that consumed the provisioned throughput.
	//
	//    * CapacityUnits - The total number of capacity units consumed.
	ConsumedCapacity []*ConsumedCapacity `type:"list"`

	// A list of tables that were processed by BatchWriteItem and, for each table,
	// information about any item collections that were affected by individual DeleteItem
	// or PutItem operations.
	//
	// Each entry consists of the following subelements:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item.
	//
	//    * SizeEstimateRange - An estimate of item collection size, expressed in
	//    GB. This is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on the table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	//    precision or accuracy of the estimate.
	ItemCollectionMetrics map[string][]*ItemCollectionMetrics `type:"map"`

	// A map of tables and requests against those tables that were not processed.
	// The UnprocessedItems value is in the same form as RequestItems, so you can
	// provide this value directly to a subsequent BatchGetItem operation. For more
	// information, see RequestItems in the Request Parameters section.
	//
	// Each UnprocessedItems entry consists of a table name and, for that table,
	// a list of operations to perform (DeleteRequest or PutRequest).
	//
	//    * DeleteRequest - Perform a DeleteItem operation on the specified item.
	//    The item to be deleted is identified by a Key subelement:
	//
	// Key - A map of primary key attribute values that uniquely identify the item.
	//    Each entry in this map consists of an attribute name and an attribute
	//    value.
	//
	//    * PutRequest - Perform a PutItem operation on the specified item. The
	//    item to be put is identified by an Item subelement:
	//
	// Item - A map of attributes and their values. Each entry in this map consists
	//    of an attribute name and an attribute value. Attribute values must not
	//    be null; string and binary type attributes must have lengths greater than
	//    zero; and set type attributes must not be empty. Requests that contain
	//    empty values will be rejected with a ValidationException exception.
	//
	// If you specify any attributes that are part of an index key, then the data
	//    types for those attributes must match those of the schema in the table's
	//    attribute definition.
	//
	// If there are no unprocessed items remaining, the response contains an empty
	// UnprocessedItems map.
	UnprocessedItems map[string][]*WriteRequest `min:"1" type:"map"`
}

// String returns the string representation
func (s BatchWriteItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchWriteItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *BatchWriteItemOutput) SetConsumedCapacity(v []*ConsumedCapacity) *BatchWriteItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *BatchWriteItemOutput) SetItemCollectionMetrics(v map[string][]*ItemCollectionMetrics) *BatchWriteItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// SetUnprocessedItems sets the UnprocessedItems field's value.
func (s *BatchWriteItemOutput) SetUnprocessedItems(v map[string][]*WriteRequest) *BatchWriteItemOutput {
	s.UnprocessedItems = v
	return s
}

// Represents the amount of provisioned throughput capacity consumed on a table
// or an index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Capacity
type Capacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed on a table or an index.
	CapacityUnits *float64 `type:"double"`
}

// String returns the string representation
func (s Capacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Capacity) GoString() string {
	return s.String()
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *Capacity) SetCapacityUnits(v float64) *Capacity {
	s.CapacityUnits = &v
	return s
}

// Represents the selection criteria for a Query or Scan operation:
//
//    * For a Query operation, Condition is used for specifying the KeyConditions
//    to use when querying a table or an index. For KeyConditions, only the
//    following comparison operators are supported:
//
// EQ | LE | LT | GE | GT | BEGINS_WITH | BETWEEN
//
// Condition is also used in a QueryFilter, which evaluates the query results
//    and returns only the desired values.
//
//    * For a Scan operation, Condition is used in a ScanFilter, which evaluates
//    the scan results and returns only the desired values.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	AttributeValueList []*AttributeValue `type:"list"`

	// A comparator for evaluating attributes. For example, equals, greater than,
	// less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps.
	//
	// AttributeValueList can contain only one AttributeValue element of type String,
	//    Number, Binary, String Set, Number Set, or Binary Set. If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps.
	//
	//    * AttributeValueList can contain only one AttributeValue of type String,
	//    Number, Binary, String Set, Number Set, or Binary Set. If an item contains
	//    an AttributeValue of a different type than the one provided in the request,
	//    the value does not match. For example, {"S":"6"} does not equal {"N":"6"}.
	//    Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal.
	//
	// AttributeValueList can contain only one AttributeValue element of type String,
	// Number, or Binary (not a set type). If an item contains an AttributeValue
	// element of a different type than the one provided in the request, the value
	// does not match. For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"}
	// does not compare to {"NS":["6", "2", "1"]}.
	//
	// LT: Less than.
	//
	// AttributeValueListcan contain only one AttributeValueof type String, Number, or Binary (not a set type). If an item contains an
	// AttributeValueelement of a different type than the one provided in the request, the value
	// does not match. For example, {"S":"6"}does not equal {"N":"6"}. Also, {"N":"6"}does not compare to {"NS":["6", "2", "1"]}
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeValueList sets the AttributeValueList field's value.
func (s *Condition) SetAttributeValueList(v []*AttributeValue) *Condition {
	s.AttributeValueList = v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *Condition) SetComparisonOperator(v string) *Condition {
	s.ComparisonOperator = &v
	return s
}

// The capacity units consumed by an operation. The data returned includes the
// total provisioned throughput consumed, along with statistics for the table
// and any indexes involved in the operation. ConsumedCapacity is only returned
// if the request asked for it. For more information, see Provisioned Throughput
// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ConsumedCapacity
type ConsumedCapacity struct {
	_ struct{} `type:"structure"`

	// The total number of capacity units consumed by the operation.
	CapacityUnits *float64 `type:"double"`

	// The amount of throughput consumed on each global index affected by the operation.
	GlobalSecondaryIndexes map[string]*Capacity `type:"map"`

	// The amount of throughput consumed on each local index affected by the operation.
	LocalSecondaryIndexes map[string]*Capacity `type:"map"`

	// The amount of throughput consumed on the table affected by the operation.
	Table *Capacity `type:"structure"`

	// The name of the table that was affected by the operation.
	TableName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s ConsumedCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsumedCapacity) GoString() string {
	return s.String()
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *ConsumedCapacity) SetCapacityUnits(v float64) *ConsumedCapacity {
	s.CapacityUnits = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *ConsumedCapacity) SetGlobalSecondaryIndexes(v map[string]*Capacity) *ConsumedCapacity {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *ConsumedCapacity) SetLocalSecondaryIndexes(v map[string]*Capacity) *ConsumedCapacity {
	s.LocalSecondaryIndexes = v
	return s
}

// SetTable sets the Table field's value.
func (s *ConsumedCapacity) SetTable(v *Capacity) *ConsumedCapacity {
	s.Table = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ConsumedCapacity) SetTableName(v string) *ConsumedCapacity {
	s.TableName = &v
	return s
}

// Represents a new global secondary index to be added to an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalSecondaryIndexAction
type CreateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be created.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The key schema for the global secondary index.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into an
	// index. These are in addition to the primary key attributes and index key
	// attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.ProvisionedThroughput == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *CreateGlobalSecondaryIndexAction) SetIndexName(v string) *CreateGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *CreateGlobalSecondaryIndexAction) SetKeySchema(v []*KeySchemaElement) *CreateGlobalSecondaryIndexAction {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *CreateGlobalSecondaryIndexAction) SetProjection(v *Projection) *CreateGlobalSecondaryIndexAction {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *CreateGlobalSecondaryIndexAction) SetProvisionedThroughput(v *ProvisionedThroughput) *CreateGlobalSecondaryIndexAction {
	s.ProvisionedThroughput = v
	return s
}

// Represents the input of a CreateTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTableInput
type CreateTableInput struct {
	_ struct{} `type:"structure"`

	// An array of attributes that describe the key schema for the table and indexes.
	//
	// AttributeDefinitions is a required field
	AttributeDefinitions []*AttributeDefinition `type:"list" required:"true"`

	// One or more global secondary indexes (the maximum is five) to be created
	// on the table. Each global secondary index in the array includes the following:
	//
	//    * IndexName - The name of the global secondary index. Must be unique only
	//    for this table.
	//
	//    * KeySchema - Specifies the key schema for the global secondary index.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of:
	//
	//    * ProjectionType - One of the following:
	//
	// KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	// INCLUDE - Only the specified table attributes are projected into the index.
	//    The list of projected attributes are in NonKeyAttributes.
	//
	// ALL - All of the table attributes are projected into the index.
	//
	// NonKeyAttributes - A list of one or more non-key attribute names that are
	//    projected into the secondary index. The total count of attributes provided
	//    in NonKeyAttributes, summed across all of the secondary indexes, must
	//    not exceed 20. If you project the same attribute into two different indexes,
	//    this counts as two distinct attributes when determining the total.
	//
	//    * ProvisionedThroughput - The provisioned throughput settings for the
	//    global secondary index, consisting of read and write capacity units.
	GlobalSecondaryIndexes []*GlobalSecondaryIndex `type:"list"`

	// Specifies the attributes that make up the primary key for a table or an index.
	// The attributes in KeySchema must also be defined in the AttributeDefinitions
	// array. For more information, see Data Model (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// Each KeySchemaElement in the array is composed of:
	//
	//    * AttributeName - The name of this key attribute.
	//
	//    * KeyType - The role that the key attribute will assume:
	//
	// HASH - partition key
	//
	// RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// For a simple primary key (partition key), you must provide exactly one element
	// with a KeyType of HASH.
	//
	// For a composite primary key (partition key and sort key), you must provide
	// exactly two elements, in this order: The first element must have a KeyType
	// of HASH, and the second element must have a KeyType of RANGE.
	//
	// For more information, see Specifying the Primary Key (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key)
	// in the Amazon DynamoDB Developer Guide.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// One or more local secondary indexes (the maximum is five) to be created on
	// the table. Each index is scoped to a given partition key value. There is
	// a 10 GB size limit per partition key value; otherwise, the size of a local
	// secondary index is unconstrained.
	//
	// Each local secondary index in the array includes the following:
	//
	//    * IndexName - The name of the local secondary index. Must be unique only
	//    for this table.
	//
	//    * KeySchema - Specifies the key schema for the local secondary index.
	//    The key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of:
	//
	//    * ProjectionType - One of the following:
	//
	// KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	// INCLUDE - Only the specified table attributes are projected into the index.
	//    The list of projected attributes are in NonKeyAttributes.
	//
	// ALL - All of the table attributes are projected into the index.
	//
	// NonKeyAttributes - A list of one or more non-key attribute names that are
	//    projected into the secondary index. The total count of attributes provided
	//    in NonKeyAttributes, summed across all of the secondary indexes, must
	//    not exceed 20. If you project the same attribute into two different indexes,
	//    this counts as two distinct attributes when determining the total.
	LocalSecondaryIndexes []*LocalSecondaryIndex `type:"list"`

	// Represents the provisioned throughput settings for a specified table or index.
	// The settings can be modified using the UpdateTable operation.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`

	// The settings for DynamoDB Streams on the table. These settings consist of:
	//
	//    * StreamEnabled - Indicates whether Streams is to be enabled (true) or
	//    disabled (false).
	//
	//    * StreamViewType - When an item in the table is modified, StreamViewType
	//    determines what information is written to the table's stream. Valid values
	//    for StreamViewType are:
	//
	// KEYS_ONLY - Only the key attributes of the modified item are written to the
	//    stream.
	//
	// NEW_IMAGE - The entire item, as it appears after it was modified, is written
	//    to the stream.
	//
	// OLD_IMAGE - The entire item, as it appeared before it was modified, is written
	//    to the stream.
	//
	// NEW_AND_OLD_IMAGES - Both the new and the old item images of the item are
	//    written to the stream.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The name of the table to create.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTableInput"}
	if s.AttributeDefinitions == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeDefinitions"))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.ProvisionedThroughput == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.AttributeDefinitions != nil {
		for i, v := range s.AttributeDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalSecondaryIndexes != nil {
		for i, v := range s.GlobalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LocalSecondaryIndexes != nil {
		for i, v := range s.LocalSecondaryIndexes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LocalSecondaryIndexes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *CreateTableInput) SetAttributeDefinitions(v []*AttributeDefinition) *CreateTableInput {
	s.AttributeDefinitions = v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *CreateTableInput) SetGlobalSecondaryIndexes(v []*GlobalSecondaryIndex) *CreateTableInput {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *CreateTableInput) SetKeySchema(v []*KeySchemaElement) *CreateTableInput {
	s.KeySchema = v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *CreateTableInput) SetLocalSecondaryIndexes(v []*LocalSecondaryIndex) *CreateTableInput {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *CreateTableInput) SetProvisionedThroughput(v *ProvisionedThroughput) *CreateTableInput {
	s.ProvisionedThroughput = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *CreateTableInput) SetStreamSpecification(v *StreamSpecification) *CreateTableInput {
	s.StreamSpecification = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *CreateTableInput) SetTableName(v string) *CreateTableInput {
	s.TableName = &v
	return s
}

// Represents the output of a CreateTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTableOutput
type CreateTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of the table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s CreateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *CreateTableOutput) SetTableDescription(v *TableDescription) *CreateTableOutput {
	s.TableDescription = v
	return s
}

// Represents a global secondary index to be deleted from an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteGlobalSecondaryIndexAction
type DeleteGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be deleted.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *DeleteGlobalSecondaryIndexAction) SetIndexName(v string) *DeleteGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// Represents the input of a DeleteItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItemInput
type DeleteItemInput struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional DeleteItem
	// to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size
	//
	// These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    *  Logical operators: AND | OR | NOT
	//
	// For more information on condition expressions, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A map of attribute names to AttributeValue objects, representing the primary
	// key of the item to delete.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appeared
	// before they were deleted. For DeleteItem, the valid values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - The content of the old item is returned.
	//
	// The ReturnValues parameter is used by several DynamoDB operations; however,
	// DeleteItem does not recognize any values other than NONE or ALL_OLD.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table from which to delete the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteItemInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *DeleteItemInput) SetConditionExpression(v string) *DeleteItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *DeleteItemInput) SetConditionalOperator(v string) *DeleteItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *DeleteItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *DeleteItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *DeleteItemInput) SetExpressionAttributeNames(v map[string]*string) *DeleteItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *DeleteItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *DeleteItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *DeleteItemInput) SetKey(v map[string]*AttributeValue) *DeleteItemInput {
	s.Key = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *DeleteItemInput) SetReturnConsumedCapacity(v string) *DeleteItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *DeleteItemInput) SetReturnItemCollectionMetrics(v string) *DeleteItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *DeleteItemInput) SetReturnValues(v string) *DeleteItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *DeleteItemInput) SetTableName(v string) *DeleteItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a DeleteItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItemOutput
type DeleteItemOutput struct {
	_ struct{} `type:"structure"`

	// A map of attribute names to AttributeValue objects, representing the item
	// as it appeared before the DeleteItem operation. This map appears in the response
	// only if ReturnValues was specified as ALL_OLD in the request.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the DeleteItem operation. The data returned
	// includes the total provisioned throughput consumed, along with statistics
	// for the table and any indexes involved in the operation. ConsumedCapacity
	// is only returned if the ReturnConsumedCapacity parameter was specified. For
	// more information, see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the DeleteItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRange - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	//    precision or accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s DeleteItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DeleteItemOutput) SetAttributes(v map[string]*AttributeValue) *DeleteItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *DeleteItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *DeleteItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *DeleteItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *DeleteItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents a request to perform a DeleteItem operation on an item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteRequest
type DeleteRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of the item to delete. All of the table's primary key attributes must be
	// specified, and their data types must match those of the table's key schema.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s DeleteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRequest) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *DeleteRequest) SetKey(v map[string]*AttributeValue) *DeleteRequest {
	s.Key = v
	return s
}

// Represents the input of a DeleteTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTableInput
type DeleteTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to delete.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DeleteTableInput) SetTableName(v string) *DeleteTableInput {
	s.TableName = &v
	return s
}

// Represents the output of a DeleteTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTableOutput
type DeleteTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of a table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s DeleteTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *DeleteTableOutput) SetTableDescription(v *TableDescription) *DeleteTableOutput {
	s.TableDescription = v
	return s
}

// Represents the input of a DescribeLimits operation. Has no content.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimitsInput
type DescribeLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeLimits operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimitsOutput
type DescribeLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum total read capacity units that your account allows you to provision
	// across all of your tables in this region.
	AccountMaxReadCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum total write capacity units that your account allows you to provision
	// across all of your tables in this region.
	AccountMaxWriteCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum read capacity units that your account allows you to provision
	// for a new table that you are creating in this region, including the read
	// capacity units provisioned for its global secondary indexes (GSIs).
	TableMaxReadCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum write capacity units that your account allows you to provision
	// for a new table that you are creating in this region, including the write
	// capacity units provisioned for its global secondary indexes (GSIs).
	TableMaxWriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s DescribeLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLimitsOutput) GoString() string {
	return s.String()
}

// SetAccountMaxReadCapacityUnits sets the AccountMaxReadCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetAccountMaxReadCapacityUnits(v int64) *DescribeLimitsOutput {
	s.AccountMaxReadCapacityUnits = &v
	return s
}

// SetAccountMaxWriteCapacityUnits sets the AccountMaxWriteCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetAccountMaxWriteCapacityUnits(v int64) *DescribeLimitsOutput {
	s.AccountMaxWriteCapacityUnits = &v
	return s
}

// SetTableMaxReadCapacityUnits sets the TableMaxReadCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetTableMaxReadCapacityUnits(v int64) *DescribeLimitsOutput {
	s.TableMaxReadCapacityUnits = &v
	return s
}

// SetTableMaxWriteCapacityUnits sets the TableMaxWriteCapacityUnits field's value.
func (s *DescribeLimitsOutput) SetTableMaxWriteCapacityUnits(v int64) *DescribeLimitsOutput {
	s.TableMaxWriteCapacityUnits = &v
	return s
}

// Represents the input of a DescribeTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableInput
type DescribeTableInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to describe.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeTableInput) SetTableName(v string) *DescribeTableInput {
	s.TableName = &v
	return s
}

// Represents the output of a DescribeTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableOutput
type DescribeTableOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the table.
	Table *TableDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableOutput) GoString() string {
	return s.String()
}

// SetTable sets the Table field's value.
func (s *DescribeTableOutput) SetTable(v *TableDescription) *DescribeTableOutput {
	s.Table = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLiveInput
type DescribeTimeToLiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to be described.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTimeToLiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeToLiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTimeToLiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTimeToLiveInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *DescribeTimeToLiveInput) SetTableName(v string) *DescribeTimeToLiveInput {
	s.TableName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLiveOutput
type DescribeTimeToLiveOutput struct {
	_ struct{} `type:"structure"`

	// The description of the Time to Live (TTL) status on the specified table.
	TimeToLiveDescription *TimeToLiveDescription `type:"structure"`
}

// String returns the string representation
func (s DescribeTimeToLiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeToLiveOutput) GoString() string {
	return s.String()
}

// SetTimeToLiveDescription sets the TimeToLiveDescription field's value.
func (s *DescribeTimeToLiveOutput) SetTimeToLiveDescription(v *TimeToLiveDescription) *DescribeTimeToLiveOutput {
	s.TimeToLiveDescription = v
	return s
}

// Represents a condition to be compared with an attribute value. This condition
// can be used with DeleteItem, PutItem or UpdateItem operations; if the comparison
// evaluates to true, the operation succeeds; if not, the operation fails. You
// can use ExpectedAttributeValue in one of two different ways:
//
//    * Use AttributeValueList to specify one or more values to compare against
//    an attribute. Use ComparisonOperator to specify how you want to perform
//    the comparison. If the comparison evaluates to true, then the conditional
//    operation succeeds.
//
//    * Use Value to specify a value that DynamoDB will compare against an attribute.
//    If the values match, then ExpectedAttributeValue evaluates to true and
//    the conditional operation succeeds. Optionally, you can also set Exists
//    to false, indicating that you do not expect to find the attribute value
//    in the table. In this case, the conditional operation succeeds only if
//    the comparison evaluates to false.
//
// Value and Exists are incompatible with AttributeValueList and ComparisonOperator.
// Note that if you use both sets of parameters at once, DynamoDB will return
// a ValidationException exception.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExpectedAttributeValue
type ExpectedAttributeValue struct {
	_ struct{} `type:"structure"`

	// One or more values to evaluate against the supplied attribute. The number
	// of values in the list depends on the ComparisonOperator being used.
	//
	// For type Number, value comparisons are numeric.
	//
	// String value comparisons for greater than, equals, or less than are based
	// on ASCII character code values. For example, a is greater than A, and a is
	// greater than B. For a list of code values, see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters
	// (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	//
	// For Binary, DynamoDB treats each byte of the binary data as unsigned when
	// it compares binary values.
	//
	// For information on specifying data types in JSON, see JSON Data Format (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataFormat.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeValueList []*AttributeValue `type:"list"`

	// A comparator for evaluating attributes in the AttributeValueList. For example,
	// equals, greater than, less than, etc.
	//
	// The following comparison operators are available:
	//
	// EQ | NE | LE | LT | GE | GT | NOT_NULL | NULL | CONTAINS | NOT_CONTAINS |
	// BEGINS_WITH | IN | BETWEEN
	//
	// The following are descriptions of each comparison operator.
	//
	//    * EQ : Equal. EQ is supported for all data types, including lists and
	//    maps.
	//
	// AttributeValueList can contain only one AttributeValue element of type String,
	//    Number, Binary, String Set, Number Set, or Binary Set. If an item contains
	//    an AttributeValue element of a different type than the one provided in
	//    the request, the value does not match. For example, {"S":"6"} does not
	//    equal {"N":"6"}. Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * NE : Not equal. NE is supported for all data types, including lists
	//    and maps.
	//
	//    * AttributeValueList can contain only one AttributeValue of type String,
	//    Number, Binary, String Set, Number Set, or Binary Set. If an item contains
	//    an AttributeValue of a different type than the one provided in the request,
	//    the value does not match. For example, {"S":"6"} does not equal {"N":"6"}.
	//    Also, {"N":"6"} does not equal {"NS":["6", "2", "1"]}.
	//
	//    * LE : Less than or equal.
	//
	// AttributeValueList can contain only one AttributeValue element of type String,
	// Number, or Binary (not a set type). If an item contains an AttributeValue
	// element of a different type than the one provided in the request, the value
	// does not match. For example, {"S":"6"} does not equal {"N":"6"}. Also, {"N":"6"}
	// does not compare to {"NS":["6", "2", "1"]}.
	//
	// LT: Less than.
	//
	// AttributeValueListcan contain only one AttributeValueof type String, Number, or Binary (not a set type). If an item contains an
	// AttributeValueelement of a different type than the one provided in the request, the value
	// does not match. For example, {"S":"6"}does not equal {"N":"6"}. Also, {"N":"6"}does not compare to {"NS":["6", "2", "1"]}
	ComparisonOperator *string `type:"string" enum:"ComparisonOperator"`

	// Causes DynamoDB to evaluate the value before attempting a conditional operation:
	//
	//    * If Exists is true, DynamoDB will check to see if that attribute value
	//    already exists in the table. If it is found, then the operation succeeds.
	//    If it is not found, the operation fails with a ConditionalCheckFailedException.
	//
	//    * If Exists is false, DynamoDB assumes that the attribute value does not
	//    exist in the table. If in fact the value does not exist, then the assumption
	//    is valid and the operation succeeds. If the value is found, despite the
	//    assumption that it does not exist, the operation fails with a ConditionalCheckFailedException.
	//
	// The default setting for Exists is true. If you supply a Value all by itself,
	// DynamoDB assumes the attribute exists: You don't have to set Exists to true,
	// because it is implied.
	//
	// DynamoDB returns a ValidationException if:
	//
	//    * Exists is true but there is no Value to check. (You expect a value to
	//    exist, but don't specify what that value is.)
	//
	//    * Exists is false but you also provide a Value. (You cannot expect an
	//    attribute to have a value, while also expecting it not to exist.)
	Exists *bool `type:"boolean"`

	// Represents the data for the expected attribute.
	//
	// Each attribute value is described as a name-value pair. The name is the data
	// type, and the value is the data itself.
	//
	// For more information, see Data Types (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes)
	// in the Amazon DynamoDB Developer Guide.
	Value *AttributeValue `type:"structure"`
}

// String returns the string representation
func (s ExpectedAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpectedAttributeValue) GoString() string {
	return s.String()
}

// SetAttributeValueList sets the AttributeValueList field's value.
func (s *ExpectedAttributeValue) SetAttributeValueList(v []*AttributeValue) *ExpectedAttributeValue {
	s.AttributeValueList = v
	return s
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ExpectedAttributeValue) SetComparisonOperator(v string) *ExpectedAttributeValue {
	s.ComparisonOperator = &v
	return s
}

// SetExists sets the Exists field's value.
func (s *ExpectedAttributeValue) SetExists(v bool) *ExpectedAttributeValue {
	s.Exists = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ExpectedAttributeValue) SetValue(v *AttributeValue) *ExpectedAttributeValue {
	s.Value = v
	return s
}

// Represents the input of a GetItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItemInput
type GetItemInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// Determines the read consistency model: If set to true, then the operation
	// uses strongly consistent reads; otherwise, the operation uses eventually
	// consistent reads.
	ConsistentRead *bool `type:"boolean"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// A map of attribute names to AttributeValue objects, representing the primary
	// key of the item to retrieve.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// The name of the table containing the requested item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetItemInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *GetItemInput) SetAttributesToGet(v []*string) *GetItemInput {
	s.AttributesToGet = v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *GetItemInput) SetConsistentRead(v bool) *GetItemInput {
	s.ConsistentRead = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *GetItemInput) SetExpressionAttributeNames(v map[string]*string) *GetItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetKey sets the Key field's value.
func (s *GetItemInput) SetKey(v map[string]*AttributeValue) *GetItemInput {
	s.Key = v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *GetItemInput) SetProjectionExpression(v string) *GetItemInput {
	s.ProjectionExpression = &v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *GetItemInput) SetReturnConsumedCapacity(v string) *GetItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GetItemInput) SetTableName(v string) *GetItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a GetItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItemOutput
type GetItemOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the GetItem operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// A map of attribute names to AttributeValue objects, as specified by ProjectionExpression.
	Item map[string]*AttributeValue `type:"map"`
}

// String returns the string representation
func (s GetItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetItemOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *GetItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *GetItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItem sets the Item field's value.
func (s *GetItemOutput) SetItem(v map[string]*AttributeValue) *GetItemOutput {
	s.Item = v
	return s
}

// Represents the properties of a global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndex
type GlobalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`
}

// String returns the string representation
func (s GlobalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSecondaryIndex"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.ProvisionedThroughput == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndex) SetIndexName(v string) *GlobalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *GlobalSecondaryIndex) SetKeySchema(v []*KeySchemaElement) *GlobalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *GlobalSecondaryIndex) SetProjection(v *Projection) *GlobalSecondaryIndex {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *GlobalSecondaryIndex) SetProvisionedThroughput(v *ProvisionedThroughput) *GlobalSecondaryIndex {
	s.ProvisionedThroughput = v
	return s
}

// Represents the properties of a global secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndexDescription
type GlobalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// Indicates whether the index is currently backfilling. Backfilling is the
	// process of reading items from the table and determining whether they can
	// be added to the index. (Not all items will qualify: For example, a partition
	// key cannot have any duplicate values.) If an item can be added to the index,
	// DynamoDB will do so. After all items have been processed, the backfilling
	// operation is complete and Backfilling is false.
	//
	// For indexes that were created during a CreateTable operation, the Backfilling
	// attribute does not appear in the DescribeTable output.
	Backfilling *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// The name of the global secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The current state of the global secondary index:
	//
	//    * CREATING - The index is being created.
	//
	//    * UPDATING - The index is being updated.
	//
	//    * DELETING - The index is being deleted.
	//
	//    * ACTIVE - The index is ready for use.
	IndexStatus *string `type:"string" enum:"IndexStatus"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for a global secondary index, which consists of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexDescription) GoString() string {
	return s.String()
}

// SetBackfilling sets the Backfilling field's value.
func (s *GlobalSecondaryIndexDescription) SetBackfilling(v bool) *GlobalSecondaryIndexDescription {
	s.Backfilling = &v
	return s
}

// SetIndexArn sets the IndexArn field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexArn(v string) *GlobalSecondaryIndexDescription {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexName(v string) *GlobalSecondaryIndexDescription {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexSizeBytes(v int64) *GlobalSecondaryIndexDescription {
	s.IndexSizeBytes = &v
	return s
}

// SetIndexStatus sets the IndexStatus field's value.
func (s *GlobalSecondaryIndexDescription) SetIndexStatus(v string) *GlobalSecondaryIndexDescription {
	s.IndexStatus = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *GlobalSecondaryIndexDescription) SetItemCount(v int64) *GlobalSecondaryIndexDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *GlobalSecondaryIndexDescription) SetKeySchema(v []*KeySchemaElement) *GlobalSecondaryIndexDescription {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *GlobalSecondaryIndexDescription) SetProjection(v *Projection) *GlobalSecondaryIndexDescription {
	s.Projection = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *GlobalSecondaryIndexDescription) SetProvisionedThroughput(v *ProvisionedThroughputDescription) *GlobalSecondaryIndexDescription {
	s.ProvisionedThroughput = v
	return s
}

// Represents one of the following:
//
//    * A new global secondary index to be added to an existing table.
//
//    * New provisioned throughput parameters for an existing global secondary
//    index.
//
//    * An existing global secondary index to be removed from an existing table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GlobalSecondaryIndexUpdate
type GlobalSecondaryIndexUpdate struct {
	_ struct{} `type:"structure"`

	// The parameters required for creating a global secondary index on an existing
	// table:
	//
	//    * IndexName
	//
	//    * KeySchema
	//
	//    * AttributeDefinitions
	//
	//    * Projection
	//
	//    * ProvisionedThroughput
	Create *CreateGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index to be removed.
	Delete *DeleteGlobalSecondaryIndexAction `type:"structure"`

	// The name of an existing global secondary index, along with new provisioned
	// throughput settings to be applied to that index.
	Update *UpdateGlobalSecondaryIndexAction `type:"structure"`
}

// String returns the string representation
func (s GlobalSecondaryIndexUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GlobalSecondaryIndexUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlobalSecondaryIndexUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlobalSecondaryIndexUpdate"}
	if s.Create != nil {
		if err := s.Create.Validate(); err != nil {
			invalidParams.AddNested("Create", err.(request.ErrInvalidParams))
		}
	}
	if s.Delete != nil {
		if err := s.Delete.Validate(); err != nil {
			invalidParams.AddNested("Delete", err.(request.ErrInvalidParams))
		}
	}
	if s.Update != nil {
		if err := s.Update.Validate(); err != nil {
			invalidParams.AddNested("Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreate sets the Create field's value.
func (s *GlobalSecondaryIndexUpdate) SetCreate(v *CreateGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Create = v
	return s
}

// SetDelete sets the Delete field's value.
func (s *GlobalSecondaryIndexUpdate) SetDelete(v *DeleteGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Delete = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *GlobalSecondaryIndexUpdate) SetUpdate(v *UpdateGlobalSecondaryIndexAction) *GlobalSecondaryIndexUpdate {
	s.Update = v
	return s
}

// Information about item collections, if any, that were affected by the operation.
// ItemCollectionMetrics is only returned if the request asked for it. If the
// table does not have any local secondary indexes, this information is not
// returned in the response.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ItemCollectionMetrics
type ItemCollectionMetrics struct {
	_ struct{} `type:"structure"`

	// The partition key value of the item collection. This value is the same as
	// the partition key value of the item.
	ItemCollectionKey map[string]*AttributeValue `type:"map"`

	// An estimate of item collection size, in gigabytes. This value is a two-element
	// array containing a lower bound and an upper bound for the estimate. The estimate
	// includes the size of all the items in the table, plus the size of all attributes
	// projected into all of the local secondary indexes on that table. Use this
	// estimate to measure whether a local secondary index is approaching its size
	// limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	// precision or accuracy of the estimate.
	SizeEstimateRangeGB []*float64 `type:"list"`
}

// String returns the string representation
func (s ItemCollectionMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemCollectionMetrics) GoString() string {
	return s.String()
}

// SetItemCollectionKey sets the ItemCollectionKey field's value.
func (s *ItemCollectionMetrics) SetItemCollectionKey(v map[string]*AttributeValue) *ItemCollectionMetrics {
	s.ItemCollectionKey = v
	return s
}

// SetSizeEstimateRangeGB sets the SizeEstimateRangeGB field's value.
func (s *ItemCollectionMetrics) SetSizeEstimateRangeGB(v []*float64) *ItemCollectionMetrics {
	s.SizeEstimateRangeGB = v
	return s
}

// Represents a single element of a key schema. A key schema specifies the attributes
// that make up the primary key of a table, or the key attributes of an index.
//
// A KeySchemaElement represents exactly one attribute of the primary key. For
// example, a simple primary key would be represented by one KeySchemaElement
// (for the partition key). A composite primary key would require one KeySchemaElement
// for the partition key, and another KeySchemaElement for the sort key.
//
// A KeySchemaElement must be a scalar, top-level attribute (not a nested attribute).
// The data type must be one of String, Number, or Binary. The attribute cannot
// be nested within a List or a Map.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/KeySchemaElement
type KeySchemaElement struct {
	_ struct{} `type:"structure"`

	// The name of a key attribute.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The role that this key attribute will assume:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeyType is a required field
	KeyType *string `type:"string" required:"true" enum:"KeyType"`
}

// String returns the string representation
func (s KeySchemaElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeySchemaElement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeySchemaElement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeySchemaElement"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.KeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *KeySchemaElement) SetAttributeName(v string) *KeySchemaElement {
	s.AttributeName = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *KeySchemaElement) SetKeyType(v string) *KeySchemaElement {
	s.KeyType = &v
	return s
}

// Represents a set of primary keys and, for each key, the attributes to retrieve
// from the table.
//
// For each primary key, you must provide all of the key attributes. For example,
// with a simple primary key, you only need to provide the partition key. For
// a composite primary key, you must provide both the partition key and the
// sort key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/KeysAndAttributes
type KeysAndAttributes struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see Legacy Conditional Parameters (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// The consistency of a read operation. If set to true, then a strongly consistent
	// read is used; otherwise, an eventually consistent read is used.
	ConsistentRead *bool `type:"boolean"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// The primary key attribute values that define the items and the attributes
	// associated with the items.
	//
	// Keys is a required field
	Keys []map[string]*AttributeValue `min:"1" type:"list" required:"true"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the ProjectionExpression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`
}

// String returns the string representation
func (s KeysAndAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeysAndAttributes) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeysAndAttributes) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeysAndAttributes"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("Keys"))
	}
	if s.Keys != nil && len(s.Keys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Keys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *KeysAndAttributes) SetAttributesToGet(v []*string) *KeysAndAttributes {
	s.AttributesToGet = v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *KeysAndAttributes) SetConsistentRead(v bool) *KeysAndAttributes {
	s.ConsistentRead = &v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *KeysAndAttributes) SetExpressionAttributeNames(v map[string]*string) *KeysAndAttributes {
	s.ExpressionAttributeNames = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *KeysAndAttributes) SetKeys(v []map[string]*AttributeValue) *KeysAndAttributes {
	s.Keys = v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *KeysAndAttributes) SetProjectionExpression(v string) *KeysAndAttributes {
	s.ProjectionExpression = &v
	return s
}

// Represents the input of a ListTables operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTablesInput
type ListTablesInput struct {
	_ struct{} `type:"structure"`

	// The first table name that this operation will evaluate. Use the value that
	// was returned for LastEvaluatedTableName in a previous operation, so that
	// you can obtain the next page of results.
	ExclusiveStartTableName *string `min:"3" type:"string"`

	// A maximum number of table names to return. If this parameter is not specified,
	// the limit is 100.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTablesInput"}
	if s.ExclusiveStartTableName != nil && len(*s.ExclusiveStartTableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartTableName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExclusiveStartTableName sets the ExclusiveStartTableName field's value.
func (s *ListTablesInput) SetExclusiveStartTableName(v string) *ListTablesInput {
	s.ExclusiveStartTableName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTablesInput) SetLimit(v int64) *ListTablesInput {
	s.Limit = &v
	return s
}

// Represents the output of a ListTables operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTablesOutput
type ListTablesOutput struct {
	_ struct{} `type:"structure"`

	// The name of the last table in the current page of results. Use this value
	// as the ExclusiveStartTableName in a new request to obtain the next page of
	// results, until all the table names are returned.
	//
	// If you do not receive a LastEvaluatedTableName value in the response, this
	// means that there are no more table names to be retrieved.
	LastEvaluatedTableName *string `min:"3" type:"string"`

	// The names of the tables associated with the current account at the current
	// endpoint. The maximum size of this array is 100.
	//
	// If LastEvaluatedTableName also appears in the output, you can use this value
	// as the ExclusiveStartTableName parameter in a subsequent ListTables request
	// and obtain the next page of results.
	TableNames []*string `type:"list"`
}

// String returns the string representation
func (s ListTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTablesOutput) GoString() string {
	return s.String()
}

// SetLastEvaluatedTableName sets the LastEvaluatedTableName field's value.
func (s *ListTablesOutput) SetLastEvaluatedTableName(v string) *ListTablesOutput {
	s.LastEvaluatedTableName = &v
	return s
}

// SetTableNames sets the TableNames field's value.
func (s *ListTablesOutput) SetTableNames(v []*string) *ListTablesOutput {
	s.TableNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResourceInput
type ListTagsOfResourceInput struct {
	_ struct{} `type:"structure"`

	// An optional string that, if supplied, must be copied from the output of a
	// previous call to ListTagOfResource. When provided in this manner, this API
	// fetches the next page of results.
	NextToken *string `type:"string"`

	// The Amazon DynamoDB resource with tags to be listed. This value is an Amazon
	// Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsOfResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOfResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsOfResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsOfResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOfResourceInput) SetNextToken(v string) *ListTagsOfResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsOfResourceInput) SetResourceArn(v string) *ListTagsOfResourceInput {
	s.ResourceArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResourceOutput
type ListTagsOfResourceOutput struct {
	_ struct{} `type:"structure"`

	// If this value is returned, there are additional results to be displayed.
	// To retrieve them, call ListTagsOfResource again, with NextToken set to this
	// value.
	NextToken *string `type:"string"`

	// The tags currently associated with the Amazon DynamoDB resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOfResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOfResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOfResourceOutput) SetNextToken(v string) *ListTagsOfResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOfResourceOutput) SetTags(v []*Tag) *ListTagsOfResourceOutput {
	s.Tags = v
	return s
}

// Represents the properties of a local secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/LocalSecondaryIndex
type LocalSecondaryIndex struct {
	_ struct{} `type:"structure"`

	// The name of the local secondary index. The name must be unique among all
	// other indexes on this table.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	//
	// KeySchema is a required field
	KeySchema []*KeySchemaElement `min:"1" type:"list" required:"true"`

	// Represents attributes that are copied (projected) from the table into the
	// local secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	//
	// Projection is a required field
	Projection *Projection `type:"structure" required:"true"`
}

// String returns the string representation
func (s LocalSecondaryIndex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalSecondaryIndex) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LocalSecondaryIndex) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LocalSecondaryIndex"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.KeySchema == nil {
		invalidParams.Add(request.NewErrParamRequired("KeySchema"))
	}
	if s.KeySchema != nil && len(s.KeySchema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeySchema", 1))
	}
	if s.Projection == nil {
		invalidParams.Add(request.NewErrParamRequired("Projection"))
	}
	if s.KeySchema != nil {
		for i, v := range s.KeySchema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeySchema", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Projection != nil {
		if err := s.Projection.Validate(); err != nil {
			invalidParams.AddNested("Projection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *LocalSecondaryIndex) SetIndexName(v string) *LocalSecondaryIndex {
	s.IndexName = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *LocalSecondaryIndex) SetKeySchema(v []*KeySchemaElement) *LocalSecondaryIndex {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *LocalSecondaryIndex) SetProjection(v *Projection) *LocalSecondaryIndex {
	s.Projection = v
	return s
}

// Represents the properties of a local secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/LocalSecondaryIndexDescription
type LocalSecondaryIndexDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the index.
	IndexArn *string `type:"string"`

	// Represents the name of the local secondary index.
	IndexName *string `min:"3" type:"string"`

	// The total size of the specified index, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	IndexSizeBytes *int64 `type:"long"`

	// The number of items in the specified index. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The complete key schema for the local secondary index, consisting of one
	// or more pairs of attribute names and key types:
	//
	//    * HASH - partition key
	//
	//    * RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	// "hash attribute" derives from DynamoDB' usage of an internal hash function
	// to evenly distribute data items across partitions, based on their partition
	// key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	// attribute" derives from the way DynamoDB stores items with the same partition
	// key physically close together, in sorted order by the sort key value.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// Represents attributes that are copied (projected) from the table into the
	// global secondary index. These are in addition to the primary key attributes
	// and index key attributes, which are automatically projected.
	Projection *Projection `type:"structure"`
}

// String returns the string representation
func (s LocalSecondaryIndexDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalSecondaryIndexDescription) GoString() string {
	return s.String()
}

// SetIndexArn sets the IndexArn field's value.
func (s *LocalSecondaryIndexDescription) SetIndexArn(v string) *LocalSecondaryIndexDescription {
	s.IndexArn = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *LocalSecondaryIndexDescription) SetIndexName(v string) *LocalSecondaryIndexDescription {
	s.IndexName = &v
	return s
}

// SetIndexSizeBytes sets the IndexSizeBytes field's value.
func (s *LocalSecondaryIndexDescription) SetIndexSizeBytes(v int64) *LocalSecondaryIndexDescription {
	s.IndexSizeBytes = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *LocalSecondaryIndexDescription) SetItemCount(v int64) *LocalSecondaryIndexDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *LocalSecondaryIndexDescription) SetKeySchema(v []*KeySchemaElement) *LocalSecondaryIndexDescription {
	s.KeySchema = v
	return s
}

// SetProjection sets the Projection field's value.
func (s *LocalSecondaryIndexDescription) SetProjection(v *Projection) *LocalSecondaryIndexDescription {
	s.Projection = v
	return s
}

// Represents attributes that are copied (projected) from the table into an
// index. These are in addition to the primary key attributes and index key
// attributes, which are automatically projected.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Projection
type Projection struct {
	_ struct{} `type:"structure"`

	// Represents the non-key attribute names which will be projected into the index.
	//
	// For local secondary indexes, the total count of NonKeyAttributes summed across
	// all of the local secondary indexes, must not exceed 20. If you project the
	// same attribute into two different indexes, this counts as two distinct attributes
	// when determining the total.
	NonKeyAttributes []*string `min:"1" type:"list"`

	// The set of attributes that are projected into the index:
	//
	//    * KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	//    * INCLUDE - Only the specified table attributes are projected into the
	//    index. The list of projected attributes are in NonKeyAttributes.
	//
	//    * ALL - All of the table attributes are projected into the index.
	ProjectionType *string `type:"string" enum:"ProjectionType"`
}

// String returns the string representation
func (s Projection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Projection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Projection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Projection"}
	if s.NonKeyAttributes != nil && len(s.NonKeyAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NonKeyAttributes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNonKeyAttributes sets the NonKeyAttributes field's value.
func (s *Projection) SetNonKeyAttributes(v []*string) *Projection {
	s.NonKeyAttributes = v
	return s
}

// SetProjectionType sets the ProjectionType field's value.
func (s *Projection) SetProjectionType(v string) *Projection {
	s.ProjectionType = &v
	return s
}

// Represents the provisioned throughput settings for a specified table or index.
// The settings can be modified using the UpdateTable operation.
//
// For current minimum and maximum provisioned throughput values, see Limits
// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ProvisionedThroughput
type ProvisionedThroughput struct {
	_ struct{} `type:"structure"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. For more information, see Specifying
	// Read and Write Requirements (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ReadCapacityUnits is a required field
	ReadCapacityUnits *int64 `min:"1" type:"long" required:"true"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException. For more information, see Specifying Read and Write
	// Requirements (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#ProvisionedThroughput)
	// in the Amazon DynamoDB Developer Guide.
	//
	// WriteCapacityUnits is a required field
	WriteCapacityUnits *int64 `min:"1" type:"long" required:"true"`
}

// String returns the string representation
func (s ProvisionedThroughput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedThroughput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionedThroughput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionedThroughput"}
	if s.ReadCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("ReadCapacityUnits"))
	}
	if s.ReadCapacityUnits != nil && *s.ReadCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ReadCapacityUnits", 1))
	}
	if s.WriteCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("WriteCapacityUnits"))
	}
	if s.WriteCapacityUnits != nil && *s.WriteCapacityUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("WriteCapacityUnits", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ProvisionedThroughput) SetReadCapacityUnits(v int64) *ProvisionedThroughput {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *ProvisionedThroughput) SetWriteCapacityUnits(v int64) *ProvisionedThroughput {
	s.WriteCapacityUnits = &v
	return s
}

// Represents the provisioned throughput settings for the table, consisting
// of read and write capacity units, along with data about increases and decreases.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ProvisionedThroughputDescription
type ProvisionedThroughputDescription struct {
	_ struct{} `type:"structure"`

	// The date and time of the last provisioned throughput decrease for this table.
	LastDecreaseDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time of the last provisioned throughput increase for this table.
	LastIncreaseDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The number of provisioned throughput decreases for this table during this
	// UTC calendar day. For current maximums on provisioned throughput decreases,
	// see Limits (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	NumberOfDecreasesToday *int64 `min:"1" type:"long"`

	// The maximum number of strongly consistent reads consumed per second before
	// DynamoDB returns a ThrottlingException. Eventually consistent reads require
	// less effort than strongly consistent reads, so a setting of 50 ReadCapacityUnits
	// per second provides 100 eventually consistent ReadCapacityUnits per second.
	ReadCapacityUnits *int64 `min:"1" type:"long"`

	// The maximum number of writes consumed per second before DynamoDB returns
	// a ThrottlingException.
	WriteCapacityUnits *int64 `min:"1" type:"long"`
}

// String returns the string representation
func (s ProvisionedThroughputDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProvisionedThroughputDescription) GoString() string {
	return s.String()
}

// SetLastDecreaseDateTime sets the LastDecreaseDateTime field's value.
func (s *ProvisionedThroughputDescription) SetLastDecreaseDateTime(v time.Time) *ProvisionedThroughputDescription {
	s.LastDecreaseDateTime = &v
	return s
}

// SetLastIncreaseDateTime sets the LastIncreaseDateTime field's value.
func (s *ProvisionedThroughputDescription) SetLastIncreaseDateTime(v time.Time) *ProvisionedThroughputDescription {
	s.LastIncreaseDateTime = &v
	return s
}

// SetNumberOfDecreasesToday sets the NumberOfDecreasesToday field's value.
func (s *ProvisionedThroughputDescription) SetNumberOfDecreasesToday(v int64) *ProvisionedThroughputDescription {
	s.NumberOfDecreasesToday = &v
	return s
}

// SetReadCapacityUnits sets the ReadCapacityUnits field's value.
func (s *ProvisionedThroughputDescription) SetReadCapacityUnits(v int64) *ProvisionedThroughputDescription {
	s.ReadCapacityUnits = &v
	return s
}

// SetWriteCapacityUnits sets the WriteCapacityUnits field's value.
func (s *ProvisionedThroughputDescription) SetWriteCapacityUnits(v int64) *ProvisionedThroughputDescription {
	s.WriteCapacityUnits = &v
	return s
}

// Represents the input of a PutItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItemInput
type PutItemInput struct {
	_ struct{} `type:"structure"`

	// A condition that must be satisfied in order for a conditional PutItem operation
	// to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size
	//
	// These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    *  Logical operators: AND | OR | NOT
	//
	// For more information on condition expressions, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A map of attribute name/value pairs, one for each attribute. Only the primary
	// key attributes are required; you can optionally provide other attribute name-value
	// pairs for the item.
	//
	// You must provide all of the attributes for the primary key. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide both values for both the
	// partition key and the sort key.
	//
	// If you specify any attributes that are part of an index key, then the data
	// types for those attributes must match those of the schema in the table's
	// attribute definition.
	//
	// For more information about primary keys, see Primary Key (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	//
	// Each element in the Item map is an AttributeValue object.
	//
	// Item is a required field
	Item map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appeared
	// before they were updated with the PutItem request. For PutItem, the valid
	// values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - If PutItem overwrote an attribute name-value pair, then the
	//    content of the old item is returned.
	//
	// The ReturnValues parameter is used by several DynamoDB operations; however,
	// PutItem does not recognize any values other than NONE or ALL_OLD.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table to contain the item.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s PutItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutItemInput"}
	if s.Item == nil {
		invalidParams.Add(request.NewErrParamRequired("Item"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *PutItemInput) SetConditionExpression(v string) *PutItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *PutItemInput) SetConditionalOperator(v string) *PutItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *PutItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *PutItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *PutItemInput) SetExpressionAttributeNames(v map[string]*string) *PutItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *PutItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *PutItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetItem sets the Item field's value.
func (s *PutItemInput) SetItem(v map[string]*AttributeValue) *PutItemInput {
	s.Item = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *PutItemInput) SetReturnConsumedCapacity(v string) *PutItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *PutItemInput) SetReturnItemCollectionMetrics(v string) *PutItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *PutItemInput) SetReturnValues(v string) *PutItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *PutItemInput) SetTableName(v string) *PutItemInput {
	s.TableName = &v
	return s
}

// Represents the output of a PutItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItemOutput
type PutItemOutput struct {
	_ struct{} `type:"structure"`

	// The attribute values as they appeared before the PutItem operation, but only
	// if ReturnValues is specified as ALL_OLD in the request. Each element consists
	// of an attribute name and an attribute value.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the PutItem operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the PutItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRange - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	//    precision or accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s PutItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *PutItemOutput) SetAttributes(v map[string]*AttributeValue) *PutItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *PutItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *PutItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *PutItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *PutItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents a request to perform a PutItem operation on an item.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutRequest
type PutRequest struct {
	_ struct{} `type:"structure"`

	// A map of attribute name to attribute values, representing the primary key
	// of an item to be processed by PutItem. All of the table's primary key attributes
	// must be specified, and their data types must match those of the table's key
	// schema. If any attributes are present in the item which are part of an index
	// key schema for the table, their types must match the index key schema.
	//
	// Item is a required field
	Item map[string]*AttributeValue `type:"map" required:"true"`
}

// String returns the string representation
func (s PutRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRequest) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *PutRequest) SetItem(v map[string]*AttributeValue) *PutRequest {
	s.Item = v
	return s
}

// Represents the input of a Query operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/QueryInput
type QueryInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ConditionalOperator (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// Determines the read consistency model: If set to true, then the operation
	// uses strongly consistent reads; otherwise, the operation uses eventually
	// consistent reads.
	//
	// Strongly consistent reads are not supported on global secondary indexes.
	// If you query a global secondary index with ConsistentRead set to true, you
	// will receive a ValidationException.
	ConsistentRead *bool `type:"boolean"`

	// The primary key of the first item that this operation will evaluate. Use
	// the value that was returned for LastEvaluatedKey in the previous operation.
	//
	// The data type for ExclusiveStartKey must be String, Number or Binary. No
	// set data types are allowed.
	ExclusiveStartKey map[string]*AttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A string that contains conditions that DynamoDB applies after the Query operation,
	// but before the data is returned to you. Items that do not satisfy the FilterExpression
	// criteria are not returned.
	//
	// A FilterExpression does not allow key attributes. You cannot define a filter
	// expression based on a partition key or a sort key.
	//
	// A FilterExpression is applied after the items have already been read; the
	// process of filtering does not consume any additional read capacity units.
	//
	// For more information, see Filter Expressions (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
	// in the Amazon DynamoDB Developer Guide.
	FilterExpression *string `type:"string"`

	// The name of an index to query. This index can be any local secondary index
	// or global secondary index on the table. Note that if you use the IndexName
	// parameter, you must also provide TableName.
	IndexName *string `min:"3" type:"string"`

	// The condition that specifies the key value(s) for items to be retrieved by
	// the Query action.
	//
	// The condition must perform an equality test on a single partition key value.
	// The condition can also perform one of several comparison tests on a single
	// sort key value. Query can use KeyConditionExpression to retrieve one item
	// with a given partition key value and sort key value, or several items that
	// have the same partition key value but different sort key values.
	//
	// The partition key equality test is required, and must be specified in the
	// following format:
	//
	// partitionKeyName=:partitionkeyval
	//
	// If you also want to provide a condition for the sort key, it must be combined
	// using AND with the condition for the sort key. Following is an example, using
	// the = comparison operator for the sort key:
	//
	// partitionKeyName=:partitionkeyvalANDsortKeyName=:sortkeyval
	//
	// Valid comparisons for the sort key condition are as follows:
	//
	//    * sortKeyName=:sortkeyval - true if the sort key value is equal to :sortkeyval.
	//
	//    * sortKeyName<:sortkeyval - true if the sort key value is less than :sortkeyval.
	//
	//    * sortKeyName<=:sortkeyval - true if the sort key value is less than or
	//    equal to :sortkeyval.
	//
	//    * sortKeyName>:sortkeyval - true if the sort key value is greater than
	//    :sortkeyval.
	//
	//    * sortKeyName>= :sortkeyval - true if the sort key value is greater than
	//    or equal to :sortkeyval.
	//
	//    * sortKeyNameBETWEEN:sortkeyval1AND:sortkeyval2 - true if the sort key
	//    value is greater than or equal to :sortkeyval1, and less than or equal
	//    to :sortkeyval2.
	//
	//    * begins_with (sortKeyName, :sortkeyval) - true if the sort key value
	//    begins with a particular operand. (You cannot use this function with a
	//    sort key that is of type Number.) Note that the function name begins_with
	//    is case-sensitive.
	//
	// Use the ExpressionAttributeValues parameter to replace tokens such as :partitionval
	// and :sortval with actual values at runtime.
	//
	// You can optionally use the ExpressionAttributeNames parameter to replace
	// the names of the partition key and sort key with placeholder tokens. This
	// option might be necessary if an attribute name conflicts with a DynamoDB
	// reserved word. For example, the following KeyConditionExpression parameter
	// causes an error because Size is a reserved word:
	//
	//    * Size = :myval
	//
	// To work around this, define a placeholder (such a #S) to represent the attribute
	// name Size. KeyConditionExpression then is as follows:
	//
	//    * #S = :myval
	//
	// For a list of reserved words, see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// For more information on ExpressionAttributeNames and ExpressionAttributeValues,
	// see Using Placeholders for Attribute Names and Values (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html)
	// in the Amazon DynamoDB Developer Guide.
	KeyConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use KeyConditionExpression instead. For more
	// information, see KeyConditions (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	KeyConditions map[string]*Condition `type:"map"`

	// The maximum number of items to evaluate (not necessarily the number of matching
	// items). If DynamoDB processes the number of items up to the limit while processing
	// the results, it stops the operation and returns the matching values up to
	// that point, and a key in LastEvaluatedKey to apply in a subsequent operation,
	// so that you can pick up where you left off. Also, if the processed data set
	// size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation
	// and returns the matching values up to the limit, and a key in LastEvaluatedKey
	// to apply in a subsequent operation to continue the operation. For more information,
	// see Query and Scan (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
	// in the Amazon DynamoDB Developer Guide.
	Limit *int64 `min:"1" type:"integer"`

	// A string that identifies one or more attributes to retrieve from the table.
	// These attributes can include scalars, sets, or elements of a JSON document.
	// The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see QueryFilter (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html)
	// in the Amazon DynamoDB Developer Guide.
	QueryFilter map[string]*Condition `type:"map"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Specifies the order for index traversal: If true (default), the traversal
	// is performed in ascending order; if false, the traversal is performed in
	// descending order.
	//
	// Items with the same partition key value are stored in sorted order by sort
	// key. If the sort key data type is Number, the results are stored in numeric
	// order. For type String, the results are stored in order of ASCII character
	// code values. For type Binary, DynamoDB treats each byte of the binary data
	// as unsigned.
	//
	// If ScanIndexForward is true, DynamoDB returns the results in the order in
	// which they are stored (by sort key value). This is the default behavior.
	// If ScanIndexForward is false, DynamoDB reads the results in reverse order
	// by sort key value, and then returns the results to the client.
	ScanIndexForward *bool `type:"boolean"`

	// The attributes to be returned in the result. You can retrieve all item attributes,
	// specific item attributes, the count of matching items, or in the case of
	// an index, some or all of the attributes projected into the index.
	//
	//    * ALL_ATTRIBUTES - Returns all of the item attributes from the specified
	//    table or index. If you query a local secondary index, then for each matching
	//    item in the index DynamoDB will fetch the entire item from the parent
	//    table. If the index is configured to project all item attributes, then
	//    all of the data can be obtained from the local secondary index, and no
	//    fetching is required.
	//
	//    * ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves
	//    all attributes that have been projected into the index. If the index is
	//    configured to project all attributes, this return value is equivalent
	//    to specifying ALL_ATTRIBUTES.
	//
	//    * COUNT - Returns the number of matching items, rather than the matching
	//    items themselves.
	//
	//    * SPECIFIC_ATTRIBUTES - Returns only the attributes listed in AttributesToGet.
	//    This return value is equivalent to specifying AttributesToGet without
	//    specifying any value for Select.
	//
	// If you query or scan a local secondary index and request only attributes
	//    that are projected into that index, the operation will read only the index
	//    and not the table. If any of the requested attributes are not projected
	//    into the local secondary index, DynamoDB will fetch each of these attributes
	//    from the parent table. This extra fetching incurs additional throughput
	//    cost and latency.
	//
	// If you query or scan a global secondary index, you can only request attributes
	//    that are projected into the index. Global secondary index queries cannot
	//    fetch attributes from the parent table.
	//
	// If neither Select nor AttributesToGet are specified, DynamoDB defaults to
	// ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when
	// accessing an index. You cannot use both Select and AttributesToGet together
	// in a single request, unless the value for Select is SPECIFIC_ATTRIBUTES.
	// (This usage is equivalent to specifying AttributesToGet without any value
	// for Select.)
	//
	// If you use the ProjectionExpression parameter, then the value for Select
	// can only be SPECIFIC_ATTRIBUTES. Any other value for Select will return an
	// error.
	Select *string `type:"string" enum:"Select"`

	// The name of the table containing the requested items.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s QueryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.KeyConditions != nil {
		for i, v := range s.KeyConditions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "KeyConditions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QueryFilter != nil {
		for i, v := range s.QueryFilter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueryFilter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *QueryInput) SetAttributesToGet(v []*string) *QueryInput {
	s.AttributesToGet = v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *QueryInput) SetConditionalOperator(v string) *QueryInput {
	s.ConditionalOperator = &v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *QueryInput) SetConsistentRead(v bool) *QueryInput {
	s.ConsistentRead = &v
	return s
}

// SetExclusiveStartKey sets the ExclusiveStartKey field's value.
func (s *QueryInput) SetExclusiveStartKey(v map[string]*AttributeValue) *QueryInput {
	s.ExclusiveStartKey = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *QueryInput) SetExpressionAttributeNames(v map[string]*string) *QueryInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *QueryInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *QueryInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *QueryInput) SetFilterExpression(v string) *QueryInput {
	s.FilterExpression = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *QueryInput) SetIndexName(v string) *QueryInput {
	s.IndexName = &v
	return s
}

// SetKeyConditionExpression sets the KeyConditionExpression field's value.
func (s *QueryInput) SetKeyConditionExpression(v string) *QueryInput {
	s.KeyConditionExpression = &v
	return s
}

// SetKeyConditions sets the KeyConditions field's value.
func (s *QueryInput) SetKeyConditions(v map[string]*Condition) *QueryInput {
	s.KeyConditions = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *QueryInput) SetLimit(v int64) *QueryInput {
	s.Limit = &v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *QueryInput) SetProjectionExpression(v string) *QueryInput {
	s.ProjectionExpression = &v
	return s
}

// SetQueryFilter sets the QueryFilter field's value.
func (s *QueryInput) SetQueryFilter(v map[string]*Condition) *QueryInput {
	s.QueryFilter = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *QueryInput) SetReturnConsumedCapacity(v string) *QueryInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetScanIndexForward sets the ScanIndexForward field's value.
func (s *QueryInput) SetScanIndexForward(v bool) *QueryInput {
	s.ScanIndexForward = &v
	return s
}

// SetSelect sets the Select field's value.
func (s *QueryInput) SetSelect(v string) *QueryInput {
	s.Select = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *QueryInput) SetTableName(v string) *QueryInput {
	s.TableName = &v
	return s
}

// Represents the output of a Query operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/QueryOutput
type QueryOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the Query operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified For more information,
	// see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// The number of items in the response.
	//
	// If you used a QueryFilter in the request, then Count is the number of items
	// returned after the filter was applied, and ScannedCount is the number of
	// matching items before the filter was applied.
	//
	// If you did not use a filter in the request, then Count and ScannedCount are
	// the same.
	Count *int64 `type:"integer"`

	// An array of item attributes that match the query criteria. Each element in
	// this array consists of an attribute name and the value for that attribute.
	Items []map[string]*AttributeValue `type:"list"`

	// The primary key of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedKey is empty, then the "last page" of results has been processed
	// and there is no more data to be retrieved.
	//
	// If LastEvaluatedKey is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedKey is empty.
	LastEvaluatedKey map[string]*AttributeValue `type:"map"`

	// The number of items evaluated, before any QueryFilter is applied. A high
	// ScannedCount value with few, or no, Count results indicates an inefficient
	// Query operation. For more information, see Count and ScannedCount (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If you did not use a filter in the request, then ScannedCount is the same
	// as Count.
	ScannedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s QueryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *QueryOutput) SetConsumedCapacity(v *ConsumedCapacity) *QueryOutput {
	s.ConsumedCapacity = v
	return s
}

// SetCount sets the Count field's value.
func (s *QueryOutput) SetCount(v int64) *QueryOutput {
	s.Count = &v
	return s
}

// SetItems sets the Items field's value.
func (s *QueryOutput) SetItems(v []map[string]*AttributeValue) *QueryOutput {
	s.Items = v
	return s
}

// SetLastEvaluatedKey sets the LastEvaluatedKey field's value.
func (s *QueryOutput) SetLastEvaluatedKey(v map[string]*AttributeValue) *QueryOutput {
	s.LastEvaluatedKey = v
	return s
}

// SetScannedCount sets the ScannedCount field's value.
func (s *QueryOutput) SetScannedCount(v int64) *QueryOutput {
	s.ScannedCount = &v
	return s
}

// Represents the input of a Scan operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ScanInput
type ScanInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use ProjectionExpression instead. For more information,
	// see AttributesToGet (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributesToGet []*string `min:"1" type:"list"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ConditionalOperator (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// A Boolean value that determines the read consistency model during the scan:
	//
	//    * If ConsistentRead is false, then the data returned from Scan might not
	//    contain the results from other recently completed write operations (PutItem,
	//    UpdateItem or DeleteItem).
	//
	//    * If ConsistentRead is true, then all of the write operations that completed
	//    before the Scan began are guaranteed to be contained in the Scan response.
	//
	// The default setting for ConsistentRead is false.
	//
	// The ConsistentRead parameter is not supported on global secondary indexes.
	// If you scan a global secondary index with ConsistentRead set to true, you
	// will receive a ValidationException.
	ConsistentRead *bool `type:"boolean"`

	// The primary key of the first item that this operation will evaluate. Use
	// the value that was returned for LastEvaluatedKey in the previous operation.
	//
	// The data type for ExclusiveStartKey must be String, Number or Binary. No
	// set data types are allowed.
	//
	// In a parallel scan, a Scan request that includes ExclusiveStartKey must specify
	// the same segment whose previous Scan returned the corresponding value of
	// LastEvaluatedKey.
	ExclusiveStartKey map[string]*AttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// A string that contains conditions that DynamoDB applies after the Scan operation,
	// but before the data is returned to you. Items that do not satisfy the FilterExpression
	// criteria are not returned.
	//
	// A FilterExpression is applied after the items have already been read; the
	// process of filtering does not consume any additional read capacity units.
	//
	// For more information, see Filter Expressions (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#FilteringResults)
	// in the Amazon DynamoDB Developer Guide.
	FilterExpression *string `type:"string"`

	// The name of a secondary index to scan. This index can be any local secondary
	// index or global secondary index. Note that if you use the IndexName parameter,
	// you must also provide TableName.
	IndexName *string `min:"3" type:"string"`

	// The maximum number of items to evaluate (not necessarily the number of matching
	// items). If DynamoDB processes the number of items up to the limit while processing
	// the results, it stops the operation and returns the matching values up to
	// that point, and a key in LastEvaluatedKey to apply in a subsequent operation,
	// so that you can pick up where you left off. Also, if the processed data set
	// size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation
	// and returns the matching values up to the limit, and a key in LastEvaluatedKey
	// to apply in a subsequent operation to continue the operation. For more information,
	// see Query and Scan (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html)
	// in the Amazon DynamoDB Developer Guide.
	Limit *int64 `min:"1" type:"integer"`

	// A string that identifies one or more attributes to retrieve from the specified
	// table or index. These attributes can include scalars, sets, or elements of
	// a JSON document. The attributes in the expression must be separated by commas.
	//
	// If no attribute names are specified, then all attributes will be returned.
	// If any of the requested attributes are not found, they will not appear in
	// the result.
	//
	// For more information, see Accessing Item Attributes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ProjectionExpression *string `type:"string"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// This is a legacy parameter. Use FilterExpression instead. For more information,
	// see ScanFilter (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ScanFilter.html)
	// in the Amazon DynamoDB Developer Guide.
	ScanFilter map[string]*Condition `type:"map"`

	// For a parallel Scan request, Segment identifies an individual segment to
	// be scanned by an application worker.
	//
	// Segment IDs are zero-based, so the first segment is always 0. For example,
	// if you want to use four application threads to scan a table or an index,
	// then the first thread specifies a Segment value of 0, the second thread specifies
	// 1, and so on.
	//
	// The value of LastEvaluatedKey returned from a parallel Scan request must
	// be used as ExclusiveStartKey with the same segment ID in a subsequent Scan
	// operation.
	//
	// The value for Segment must be greater than or equal to 0, and less than the
	// value provided for TotalSegments.
	//
	// If you provide Segment, you must also provide TotalSegments.
	Segment *int64 `type:"integer"`

	// The attributes to be returned in the result. You can retrieve all item attributes,
	// specific item attributes, the count of matching items, or in the case of
	// an index, some or all of the attributes projected into the index.
	//
	//    * ALL_ATTRIBUTES - Returns all of the item attributes from the specified
	//    table or index. If you query a local secondary index, then for each matching
	//    item in the index DynamoDB will fetch the entire item from the parent
	//    table. If the index is configured to project all item attributes, then
	//    all of the data can be obtained from the local secondary index, and no
	//    fetching is required.
	//
	//    * ALL_PROJECTED_ATTRIBUTES - Allowed only when querying an index. Retrieves
	//    all attributes that have been projected into the index. If the index is
	//    configured to project all attributes, this return value is equivalent
	//    to specifying ALL_ATTRIBUTES.
	//
	//    * COUNT - Returns the number of matching items, rather than the matching
	//    items themselves.
	//
	//    * SPECIFIC_ATTRIBUTES - Returns only the attributes listed in AttributesToGet.
	//    This return value is equivalent to specifying AttributesToGet without
	//    specifying any value for Select.
	//
	// If you query or scan a local secondary index and request only attributes
	//    that are projected into that index, the operation will read only the index
	//    and not the table. If any of the requested attributes are not projected
	//    into the local secondary index, DynamoDB will fetch each of these attributes
	//    from the parent table. This extra fetching incurs additional throughput
	//    cost and latency.
	//
	// If you query or scan a global secondary index, you can only request attributes
	//    that are projected into the index. Global secondary index queries cannot
	//    fetch attributes from the parent table.
	//
	// If neither Select nor AttributesToGet are specified, DynamoDB defaults to
	// ALL_ATTRIBUTES when accessing a table, and ALL_PROJECTED_ATTRIBUTES when
	// accessing an index. You cannot use both Select and AttributesToGet together
	// in a single request, unless the value for Select is SPECIFIC_ATTRIBUTES.
	// (This usage is equivalent to specifying AttributesToGet without any value
	// for Select.)
	//
	// If you use the ProjectionExpression parameter, then the value for Select
	// can only be SPECIFIC_ATTRIBUTES. Any other value for Select will return an
	// error.
	Select *string `type:"string" enum:"Select"`

	// The name of the table containing the requested items; or, if you provide
	// IndexName, the name of the table to which that index belongs.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// For a parallel Scan request, TotalSegments represents the total number of
	// segments into which the Scan operation will be divided. The value of TotalSegments
	// corresponds to the number of application workers that will perform the parallel
	// scan. For example, if you want to use four application threads to scan a
	// table or an index, specify a TotalSegments value of 4.
	//
	// The value for TotalSegments must be greater than or equal to 1, and less
	// than or equal to 1000000. If you specify a TotalSegments value of 1, the
	// Scan operation will be sequential rather than parallel.
	//
	// If you specify TotalSegments, you must also specify Segment.
	TotalSegments *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ScanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScanInput"}
	if s.AttributesToGet != nil && len(s.AttributesToGet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributesToGet", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.TotalSegments != nil && *s.TotalSegments < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TotalSegments", 1))
	}
	if s.ScanFilter != nil {
		for i, v := range s.ScanFilter {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ScanFilter", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributesToGet sets the AttributesToGet field's value.
func (s *ScanInput) SetAttributesToGet(v []*string) *ScanInput {
	s.AttributesToGet = v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *ScanInput) SetConditionalOperator(v string) *ScanInput {
	s.ConditionalOperator = &v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *ScanInput) SetConsistentRead(v bool) *ScanInput {
	s.ConsistentRead = &v
	return s
}

// SetExclusiveStartKey sets the ExclusiveStartKey field's value.
func (s *ScanInput) SetExclusiveStartKey(v map[string]*AttributeValue) *ScanInput {
	s.ExclusiveStartKey = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *ScanInput) SetExpressionAttributeNames(v map[string]*string) *ScanInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *ScanInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *ScanInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetFilterExpression sets the FilterExpression field's value.
func (s *ScanInput) SetFilterExpression(v string) *ScanInput {
	s.FilterExpression = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ScanInput) SetIndexName(v string) *ScanInput {
	s.IndexName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ScanInput) SetLimit(v int64) *ScanInput {
	s.Limit = &v
	return s
}

// SetProjectionExpression sets the ProjectionExpression field's value.
func (s *ScanInput) SetProjectionExpression(v string) *ScanInput {
	s.ProjectionExpression = &v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *ScanInput) SetReturnConsumedCapacity(v string) *ScanInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetScanFilter sets the ScanFilter field's value.
func (s *ScanInput) SetScanFilter(v map[string]*Condition) *ScanInput {
	s.ScanFilter = v
	return s
}

// SetSegment sets the Segment field's value.
func (s *ScanInput) SetSegment(v int64) *ScanInput {
	s.Segment = &v
	return s
}

// SetSelect sets the Select field's value.
func (s *ScanInput) SetSelect(v string) *ScanInput {
	s.Select = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *ScanInput) SetTableName(v string) *ScanInput {
	s.TableName = &v
	return s
}

// SetTotalSegments sets the TotalSegments field's value.
func (s *ScanInput) SetTotalSegments(v int64) *ScanInput {
	s.TotalSegments = &v
	return s
}

// Represents the output of a Scan operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ScanOutput
type ScanOutput struct {
	_ struct{} `type:"structure"`

	// The capacity units consumed by the Scan operation. The data returned includes
	// the total provisioned throughput consumed, along with statistics for the
	// table and any indexes involved in the operation. ConsumedCapacity is only
	// returned if the ReturnConsumedCapacity parameter was specified. For more
	// information, see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// The number of items in the response.
	//
	// If you set ScanFilter in the request, then Count is the number of items returned
	// after the filter was applied, and ScannedCount is the number of matching
	// items before the filter was applied.
	//
	// If you did not use a filter in the request, then Count is the same as ScannedCount.
	Count *int64 `type:"integer"`

	// An array of item attributes that match the scan criteria. Each element in
	// this array consists of an attribute name and the value for that attribute.
	Items []map[string]*AttributeValue `type:"list"`

	// The primary key of the item where the operation stopped, inclusive of the
	// previous result set. Use this value to start a new operation, excluding this
	// value in the new request.
	//
	// If LastEvaluatedKey is empty, then the "last page" of results has been processed
	// and there is no more data to be retrieved.
	//
	// If LastEvaluatedKey is not empty, it does not necessarily mean that there
	// is more data in the result set. The only way to know when you have reached
	// the end of the result set is when LastEvaluatedKey is empty.
	LastEvaluatedKey map[string]*AttributeValue `type:"map"`

	// The number of items evaluated, before any ScanFilter is applied. A high ScannedCount
	// value with few, or no, Count results indicates an inefficient Scan operation.
	// For more information, see Count and ScannedCount (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count)
	// in the Amazon DynamoDB Developer Guide.
	//
	// If you did not use a filter in the request, then ScannedCount is the same
	// as Count.
	ScannedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ScanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScanOutput) GoString() string {
	return s.String()
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *ScanOutput) SetConsumedCapacity(v *ConsumedCapacity) *ScanOutput {
	s.ConsumedCapacity = v
	return s
}

// SetCount sets the Count field's value.
func (s *ScanOutput) SetCount(v int64) *ScanOutput {
	s.Count = &v
	return s
}

// SetItems sets the Items field's value.
func (s *ScanOutput) SetItems(v []map[string]*AttributeValue) *ScanOutput {
	s.Items = v
	return s
}

// SetLastEvaluatedKey sets the LastEvaluatedKey field's value.
func (s *ScanOutput) SetLastEvaluatedKey(v map[string]*AttributeValue) *ScanOutput {
	s.LastEvaluatedKey = v
	return s
}

// SetScannedCount sets the ScannedCount field's value.
func (s *ScanOutput) SetScannedCount(v int64) *ScanOutput {
	s.ScannedCount = &v
	return s
}

// Represents the DynamoDB Streams configuration for a table in DynamoDB.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/StreamSpecification
type StreamSpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether DynamoDB Streams is enabled (true) or disabled (false)
	// on the table.
	StreamEnabled *bool `type:"boolean"`

	// When an item in the table is modified, StreamViewType determines what information
	// is written to the stream for this table. Valid values for StreamViewType
	// are:
	//
	//    * KEYS_ONLY - Only the key attributes of the modified item are written
	//    to the stream.
	//
	//    * NEW_IMAGE - The entire item, as it appears after it was modified, is
	//    written to the stream.
	//
	//    * OLD_IMAGE - The entire item, as it appeared before it was modified,
	//    is written to the stream.
	//
	//    * NEW_AND_OLD_IMAGES - Both the new and the old item images of the item
	//    are written to the stream.
	StreamViewType *string `type:"string" enum:"StreamViewType"`
}

// String returns the string representation
func (s StreamSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StreamSpecification) GoString() string {
	return s.String()
}

// SetStreamEnabled sets the StreamEnabled field's value.
func (s *StreamSpecification) SetStreamEnabled(v bool) *StreamSpecification {
	s.StreamEnabled = &v
	return s
}

// SetStreamViewType sets the StreamViewType field's value.
func (s *StreamSpecification) SetStreamViewType(v string) *StreamSpecification {
	s.StreamViewType = &v
	return s
}

// Represents the properties of a table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TableDescription
type TableDescription struct {
	_ struct{} `type:"structure"`

	// An array of AttributeDefinition objects. Each of these objects describes
	// one attribute in the table and index key schema.
	//
	// Each AttributeDefinition object in this array is composed of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * AttributeType - The data type for the attribute.
	AttributeDefinitions []*AttributeDefinition `type:"list"`

	// The date and time when the table was created, in UNIX epoch time (http://www.epochconverter.com/)
	// format.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The global secondary indexes, if any, on the table. Each index is scoped
	// to a given partition key value. Each element is composed of:
	//
	//    * Backfilling - If true, then the index is currently in the backfilling
	//    phase. Backfilling occurs only when a new global secondary index is added
	//    to the table; it is the process by which DynamoDB populates the new index
	//    with data from the table. (This attribute does not appear for indexes
	//    that were created during a CreateTable operation.)
	//
	//    * IndexName - The name of the global secondary index.
	//
	//    * IndexSizeBytes - The total size of the global secondary index, in bytes.
	//    DynamoDB updates this value approximately every six hours. Recent changes
	//    might not be reflected in this value.
	//
	//    * IndexStatus - The current status of the global secondary index:
	//
	// CREATING - The index is being created.
	//
	// UPDATING - The index is being updated.
	//
	// DELETING - The index is being deleted.
	//
	// ACTIVE - The index is ready for use.
	//
	//    * ItemCount - The number of items in the global secondary index. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of:
	//
	// ProjectionType - One of the following:
	//
	// KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	// INCLUDE - Only the specified table attributes are projected into the index.
	//    The list of projected attributes are in NonKeyAttributes.
	//
	// ALL - All of the table attributes are projected into the index.
	//
	// NonKeyAttributes - A list of one or more non-key attribute names that are
	//    projected into the secondary index. The total count of attributes provided
	//    in NonKeyAttributes, summed across all of the secondary indexes, must
	//    not exceed 20. If you project the same attribute into two different indexes,
	//    this counts as two distinct attributes when determining the total.
	//
	//    * ProvisionedThroughput - The provisioned throughput settings for the
	//    global secondary index, consisting of read and write capacity units, along
	//    with data about increases and decreases.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	GlobalSecondaryIndexes []*GlobalSecondaryIndexDescription `type:"list"`

	// The number of items in the specified table. DynamoDB updates this value approximately
	// every six hours. Recent changes might not be reflected in this value.
	ItemCount *int64 `type:"long"`

	// The primary key structure for the table. Each KeySchemaElement consists of:
	//
	//    * AttributeName - The name of the attribute.
	//
	//    * KeyType - The role of the attribute:
	//
	// HASH - partition key
	//
	// RANGE - sort key
	//
	// The partition key of an item is also known as its hash attribute. The term
	//    "hash attribute" derives from DynamoDB' usage of an internal hash function
	//    to evenly distribute data items across partitions, based on their partition
	//    key values.
	//
	// The sort key of an item is also known as its range attribute. The term "range
	//    attribute" derives from the way DynamoDB stores items with the same partition
	//    key physically close together, in sorted order by the sort key value.
	//
	// For more information about primary keys, see Primary Key (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey)
	// in the Amazon DynamoDB Developer Guide.
	KeySchema []*KeySchemaElement `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) that uniquely identifies the latest stream
	// for this table.
	LatestStreamArn *string `min:"37" type:"string"`

	// A timestamp, in ISO 8601 format, for this stream.
	//
	// Note that LatestStreamLabel is not a unique identifier for the stream, because
	// it is possible that a stream from another table might have the same timestamp.
	// However, the combination of the following three elements is guaranteed to
	// be unique:
	//
	//    * the AWS customer ID.
	//
	//    * the table name.
	//
	//    * the StreamLabel.
	LatestStreamLabel *string `type:"string"`

	// Represents one or more local secondary indexes on the table. Each index is
	// scoped to a given partition key value. Tables with one or more local secondary
	// indexes are subject to an item collection size limit, where the amount of
	// data within a given item collection cannot exceed 10 GB. Each element is
	// composed of:
	//
	//    * IndexName - The name of the local secondary index.
	//
	//    * KeySchema - Specifies the complete index key schema. The attribute names
	//    in the key schema must be between 1 and 255 characters (inclusive). The
	//    key schema must begin with the same partition key as the table.
	//
	//    * Projection - Specifies attributes that are copied (projected) from the
	//    table into the index. These are in addition to the primary key attributes
	//    and index key attributes, which are automatically projected. Each attribute
	//    specification is composed of:
	//
	// ProjectionType - One of the following:
	//
	// KEYS_ONLY - Only the index and primary keys are projected into the index.
	//
	// INCLUDE - Only the specified table attributes are projected into the index.
	//    The list of projected attributes are in NonKeyAttributes.
	//
	// ALL - All of the table attributes are projected into the index.
	//
	// NonKeyAttributes - A list of one or more non-key attribute names that are
	//    projected into the secondary index. The total count of attributes provided
	//    in NonKeyAttributes, summed across all of the secondary indexes, must
	//    not exceed 20. If you project the same attribute into two different indexes,
	//    this counts as two distinct attributes when determining the total.
	//
	//    * IndexSizeBytes - Represents the total size of the index, in bytes. DynamoDB
	//    updates this value approximately every six hours. Recent changes might
	//    not be reflected in this value.
	//
	//    * ItemCount - Represents the number of items in the index. DynamoDB updates
	//    this value approximately every six hours. Recent changes might not be
	//    reflected in this value.
	//
	// If the table is in the DELETING state, no information about indexes will
	// be returned.
	LocalSecondaryIndexes []*LocalSecondaryIndexDescription `type:"list"`

	// The provisioned throughput settings for the table, consisting of read and
	// write capacity units, along with data about increases and decreases.
	ProvisionedThroughput *ProvisionedThroughputDescription `type:"structure"`

	// The current DynamoDB Streams configuration for the table.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the table.
	TableArn *string `type:"string"`

	// The name of the table.
	TableName *string `min:"3" type:"string"`

	// The total size of the specified table, in bytes. DynamoDB updates this value
	// approximately every six hours. Recent changes might not be reflected in this
	// value.
	TableSizeBytes *int64 `type:"long"`

	// The current state of the table:
	//
	//    * CREATING - The table is being created.
	//
	//    * UPDATING - The table is being updated.
	//
	//    * DELETING - The table is being deleted.
	//
	//    * ACTIVE - The table is ready for use.
	TableStatus *string `type:"string" enum:"TableStatus"`
}

// String returns the string representation
func (s TableDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableDescription) GoString() string {
	return s.String()
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *TableDescription) SetAttributeDefinitions(v []*AttributeDefinition) *TableDescription {
	s.AttributeDefinitions = v
	return s
}

// SetCreationDateTime sets the CreationDateTime field's value.
func (s *TableDescription) SetCreationDateTime(v time.Time) *TableDescription {
	s.CreationDateTime = &v
	return s
}

// SetGlobalSecondaryIndexes sets the GlobalSecondaryIndexes field's value.
func (s *TableDescription) SetGlobalSecondaryIndexes(v []*GlobalSecondaryIndexDescription) *TableDescription {
	s.GlobalSecondaryIndexes = v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *TableDescription) SetItemCount(v int64) *TableDescription {
	s.ItemCount = &v
	return s
}

// SetKeySchema sets the KeySchema field's value.
func (s *TableDescription) SetKeySchema(v []*KeySchemaElement) *TableDescription {
	s.KeySchema = v
	return s
}

// SetLatestStreamArn sets the LatestStreamArn field's value.
func (s *TableDescription) SetLatestStreamArn(v string) *TableDescription {
	s.LatestStreamArn = &v
	return s
}

// SetLatestStreamLabel sets the LatestStreamLabel field's value.
func (s *TableDescription) SetLatestStreamLabel(v string) *TableDescription {
	s.LatestStreamLabel = &v
	return s
}

// SetLocalSecondaryIndexes sets the LocalSecondaryIndexes field's value.
func (s *TableDescription) SetLocalSecondaryIndexes(v []*LocalSecondaryIndexDescription) *TableDescription {
	s.LocalSecondaryIndexes = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *TableDescription) SetProvisionedThroughput(v *ProvisionedThroughputDescription) *TableDescription {
	s.ProvisionedThroughput = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *TableDescription) SetStreamSpecification(v *StreamSpecification) *TableDescription {
	s.StreamSpecification = v
	return s
}

// SetTableArn sets the TableArn field's value.
func (s *TableDescription) SetTableArn(v string) *TableDescription {
	s.TableArn = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableDescription) SetTableName(v string) *TableDescription {
	s.TableName = &v
	return s
}

// SetTableSizeBytes sets the TableSizeBytes field's value.
func (s *TableDescription) SetTableSizeBytes(v int64) *TableDescription {
	s.TableSizeBytes = &v
	return s
}

// SetTableStatus sets the TableStatus field's value.
func (s *TableDescription) SetTableStatus(v string) *TableDescription {
	s.TableStatus = &v
	return s
}

// Describes a tag. A tag is a key-value pair. You can add up to 50 tags to
// a single DynamoDB table.
//
// AWS-assigned tag names and values are automatically assigned the aws: prefix,
// which the user cannot assign. AWS-assigned tag names do not count towards
// the tag limit of 50. User-assigned tag names have the prefix user: in the
// Cost Allocation Report. You cannot backdate the application of a tag.
//
// For an overview on tagging DynamoDB resources, see Tagging for DynamoDB (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html)
// in the Amazon DynamoDB Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.Tag keys are case sensitive. Each DynamoDB table can only
	// have up to one tag with the same key. If you try to add an existing tag (same
	// key), the existing tag value will be updated to the new value.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResourceInput
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the Amazon DynamoDB resource to which tags should be added. This
	// value is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Amazon DynamoDB resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResourceOutput
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The description of the Time to Live (TTL) status on the specified table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TimeToLiveDescription
type TimeToLiveDescription struct {
	_ struct{} `type:"structure"`

	// The name of the Time to Live attribute for items in the table.
	AttributeName *string `min:"1" type:"string"`

	// The Time to Live status for the table.
	TimeToLiveStatus *string `type:"string" enum:"TimeToLiveStatus"`
}

// String returns the string representation
func (s TimeToLiveDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeToLiveDescription) GoString() string {
	return s.String()
}

// SetAttributeName sets the AttributeName field's value.
func (s *TimeToLiveDescription) SetAttributeName(v string) *TimeToLiveDescription {
	s.AttributeName = &v
	return s
}

// SetTimeToLiveStatus sets the TimeToLiveStatus field's value.
func (s *TimeToLiveDescription) SetTimeToLiveStatus(v string) *TimeToLiveDescription {
	s.TimeToLiveStatus = &v
	return s
}

// Represents the settings used to enable or disable Time to Live for the specified
// table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TimeToLiveSpecification
type TimeToLiveSpecification struct {
	_ struct{} `type:"structure"`

	// The name of the Time to Live attribute used to store the expiration time
	// for items in the table.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// Indicates whether Time To Live is to be enabled (true) or disabled (false)
	// on the table.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TimeToLiveSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeToLiveSpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeToLiveSpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeToLiveSpecification"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *TimeToLiveSpecification) SetAttributeName(v string) *TimeToLiveSpecification {
	s.AttributeName = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *TimeToLiveSpecification) SetEnabled(v bool) *TimeToLiveSpecification {
	s.Enabled = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResourceInput
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon DyanamoDB resource the tags will be removed from. This value is
	// an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// A list of tag keys. Existing tags of the resource whose keys are members
	// of this list will be removed from the Amazon DynamoDB resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResourceOutput
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Represents the new provisioned throughput settings to be applied to a global
// secondary index.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalSecondaryIndexAction
type UpdateGlobalSecondaryIndexAction struct {
	_ struct{} `type:"structure"`

	// The name of the global secondary index to be updated.
	//
	// IndexName is a required field
	IndexName *string `min:"3" type:"string" required:"true"`

	// Represents the provisioned throughput settings for the specified global secondary
	// index.
	//
	// For current minimum and maximum provisioned throughput values, see Limits
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html)
	// in the Amazon DynamoDB Developer Guide.
	//
	// ProvisionedThroughput is a required field
	ProvisionedThroughput *ProvisionedThroughput `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateGlobalSecondaryIndexAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGlobalSecondaryIndexAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGlobalSecondaryIndexAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGlobalSecondaryIndexAction"}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 3))
	}
	if s.ProvisionedThroughput == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionedThroughput"))
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIndexName sets the IndexName field's value.
func (s *UpdateGlobalSecondaryIndexAction) SetIndexName(v string) *UpdateGlobalSecondaryIndexAction {
	s.IndexName = &v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *UpdateGlobalSecondaryIndexAction) SetProvisionedThroughput(v *ProvisionedThroughput) *UpdateGlobalSecondaryIndexAction {
	s.ProvisionedThroughput = v
	return s
}

// Represents the input of an UpdateItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItemInput
type UpdateItemInput struct {
	_ struct{} `type:"structure"`

	// This is a legacy parameter. Use UpdateExpression instead. For more information,
	// see AttributeUpdates (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributeUpdates.html)
	// in the Amazon DynamoDB Developer Guide.
	AttributeUpdates map[string]*AttributeValueUpdate `type:"map"`

	// A condition that must be satisfied in order for a conditional update to succeed.
	//
	// An expression can contain any of the following:
	//
	//    * Functions: attribute_exists | attribute_not_exists | attribute_type
	//    | contains | begins_with | size
	//
	// These function names are case-sensitive.
	//
	//    * Comparison operators: = | <> | < | > | <= | >= | BETWEEN | IN
	//
	//    *  Logical operators: AND | OR | NOT
	//
	// For more information on condition expressions, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionExpression *string `type:"string"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see ConditionalOperator (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html)
	// in the Amazon DynamoDB Developer Guide.
	ConditionalOperator *string `type:"string" enum:"ConditionalOperator"`

	// This is a legacy parameter. Use ConditionExpression instead. For more information,
	// see Expected (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.Expected.html)
	// in the Amazon DynamoDB Developer Guide.
	Expected map[string]*ExpectedAttributeValue `type:"map"`

	// One or more substitution tokens for attribute names in an expression. The
	// following are some use cases for using ExpressionAttributeNames:
	//
	//    * To access an attribute whose name conflicts with a DynamoDB reserved
	//    word.
	//
	//    * To create a placeholder for repeating occurrences of an attribute name
	//    in an expression.
	//
	//    * To prevent special characters in an attribute name from being misinterpreted
	//    in an expression.
	//
	// Use the # character in an expression to dereference an attribute name. For
	// example, consider the following attribute name:
	//
	//    * Percentile
	//
	// The name of this attribute conflicts with a reserved word, so it cannot be
	// used directly in an expression. (For the complete list of reserved words,
	// see Reserved Words (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html)
	// in the Amazon DynamoDB Developer Guide). To work around this, you could specify
	// the following for ExpressionAttributeNames:
	//
	//    * {"#P":"Percentile"}
	//
	// You could then use this substitution in an expression, as in this example:
	//
	//    * #P = :val
	//
	// Tokens that begin with the : character are expression attribute values, which
	// are placeholders for the actual value at runtime.
	//
	// For more information on expression attribute names, see Accessing Item Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeNames map[string]*string `type:"map"`

	// One or more values that can be substituted in an expression.
	//
	// Use the : (colon) character in an expression to dereference an attribute
	// value. For example, suppose that you wanted to check whether the value of
	// the ProductStatus attribute was one of the following:
	//
	// Available | Backordered | Discontinued
	//
	// You would first need to specify ExpressionAttributeValues as follows:
	//
	// { ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"}
	// }
	//
	// You could then use these values in an expression, such as this:
	//
	// ProductStatus IN (:avail, :back, :disc)
	//
	// For more information on expression attribute values, see Specifying Conditions
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html)
	// in the Amazon DynamoDB Developer Guide.
	ExpressionAttributeValues map[string]*AttributeValue `type:"map"`

	// The primary key of the item to be updated. Each element consists of an attribute
	// name and a value for that attribute.
	//
	// For the primary key, you must provide all of the attributes. For example,
	// with a simple primary key, you only need to provide a value for the partition
	// key. For a composite primary key, you must provide values for both the partition
	// key and the sort key.
	//
	// Key is a required field
	Key map[string]*AttributeValue `type:"map" required:"true"`

	// Determines the level of detail about provisioned throughput consumption that
	// is returned in the response:
	//
	//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
	//    operation, together with ConsumedCapacity for each table and secondary
	//    index that was accessed.
	//
	// Note that some operations, such as GetItem and BatchGetItem, do not access
	//    any indexes at all. In these cases, specifying INDEXES will only return
	//    ConsumedCapacity information for table(s).
	//
	//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
	//    the operation.
	//
	//    * NONE - No ConsumedCapacity details are included in the response.
	ReturnConsumedCapacity *string `type:"string" enum:"ReturnConsumedCapacity"`

	// Determines whether item collection metrics are returned. If set to SIZE,
	// the response includes statistics about item collections, if any, that were
	// modified during the operation are returned in the response. If set to NONE
	// (the default), no statistics are returned.
	ReturnItemCollectionMetrics *string `type:"string" enum:"ReturnItemCollectionMetrics"`

	// Use ReturnValues if you want to get the item attributes as they appear before
	// or after they are updated. For UpdateItem, the valid values are:
	//
	//    * NONE - If ReturnValues is not specified, or if its value is NONE, then
	//    nothing is returned. (This setting is the default for ReturnValues.)
	//
	//    * ALL_OLD - Returns all of the attributes of the item, as they appeared
	//    before the UpdateItem operation.
	//
	//    * UPDATED_OLD - Returns only the updated attributes, as they appeared
	//    before the UpdateItem operation.
	//
	//    * ALL_NEW - Returns all of the attributes of the item, as they appear
	//    after the UpdateItem operation.
	//
	//    * UPDATED_NEW - Returns only the updated attributes, as they appear after
	//    the UpdateItem operation.
	//
	// There is no additional cost associated with requesting a return value aside
	// from the small network and processing overhead of receiving a larger response.
	// No read capacity units are consumed.
	//
	// The values returned are strongly consistent.
	ReturnValues *string `type:"string" enum:"ReturnValue"`

	// The name of the table containing the item to update.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// An expression that defines one or more attributes to be updated, the action
	// to be performed on them, and new value(s) for them.
	//
	// The following action values are available for UpdateExpression.
	//
	//    * SET - Adds one or more attributes and values to an item. If any of these
	//    attribute already exist, they are replaced by the new values. You can
	//    also use SET to add or subtract from an attribute that is of type Number.
	//    For example: SET myNum = myNum + :val
	//
	// SET supports the following functions:
	//
	// if_not_exists (path, operand) - if the item does not contain an attribute
	//    at the specified path, then if_not_exists evaluates to operand; otherwise,
	//    it evaluates to path. You can use this function to avoid overwriting an
	//    attribute that may already be present in the item.
	//
	// list_append (operand, operand) - evaluates to a list with a new element added
	//    to it. You can append the new element to the start or the end of the list
	//    by reversing the order of the operands.
	//
	// These function names are case-sensitive.
	//
	//    * REMOVE - Removes one or more attributes from an item.
	//
	//    * ADD - Adds the specified value to the item, if the attribute does not
	//    already exist. If the attribute does exist, then the behavior of ADD depends
	//    on the data type of the attribute:
	//
	// If the existing attribute is a number, and if Value is also a number, then
	//    Value is mathematically added to the existing attribute. If Value is a
	//    negative number, then it is subtracted from the existing attribute.
	//
	// If you use ADD to increment or decrement a number value for an item that
	//    doesn't exist before the update, DynamoDB uses 0 as the initial value.
	//
	// Similarly, if you use ADD for an existing item to increment or decrement
	//    an attribute value that doesn't exist before the update, DynamoDB uses
	//    0 as the initial value. For example, suppose that the item you want to
	//    update doesn't have an attribute named itemcount, but you decide to ADD
	//    the number 3 to this attribute anyway. DynamoDB will create the itemcount
	//    attribute, set its initial value to 0, and finally add 3 to it. The result
	//    will be a new itemcount attribute in the item, with a value of 3.
	//
	// If the existing data type is a set and if Value is also a set, then Value
	//    is added to the existing set. For example, if the attribute value is the
	//    set [1,2], and the ADD action specified [3], then the final attribute
	//    value is [1,2,3]. An error occurs if an ADD action is specified for a
	//    set attribute and the attribute type specified does not match the existing
	//    set type.
	//
	// Both sets must have the same primitive data type. For example, if the existing
	//    data type is a set of strings, the Value must also be a set of strings.
	//
	// The ADD action only supports Number and set data types. In addition, ADD
	//    can only be used on top-level attributes, not nested attributes.
	//
	//    * DELETE - Deletes an element from a set.
	//
	// If a set of values is specified, then those values are subtracted from the
	//    old set. For example, if the attribute value was the set [a,b,c] and the
	//    DELETE action specifies [a,c], then the final attribute value is [b].
	//    Specifying an empty set is an error.
	//
	// The DELETE action only supports set data types. In addition, DELETE can only
	//    be used on top-level attributes, not nested attributes.
	//
	// You can have many actions in a single expression, such as the following:
	// SET a=:value1, b=:value2 DELETE :value3, :value4, :value5
	//
	// For more information on update expressions, see Modifying Items and Attributes
	// (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.Modifying.html)
	// in the Amazon DynamoDB Developer Guide.
	UpdateExpression *string `type:"string"`
}

// String returns the string representation
func (s UpdateItemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateItemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateItemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateItemInput"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeUpdates sets the AttributeUpdates field's value.
func (s *UpdateItemInput) SetAttributeUpdates(v map[string]*AttributeValueUpdate) *UpdateItemInput {
	s.AttributeUpdates = v
	return s
}

// SetConditionExpression sets the ConditionExpression field's value.
func (s *UpdateItemInput) SetConditionExpression(v string) *UpdateItemInput {
	s.ConditionExpression = &v
	return s
}

// SetConditionalOperator sets the ConditionalOperator field's value.
func (s *UpdateItemInput) SetConditionalOperator(v string) *UpdateItemInput {
	s.ConditionalOperator = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *UpdateItemInput) SetExpected(v map[string]*ExpectedAttributeValue) *UpdateItemInput {
	s.Expected = v
	return s
}

// SetExpressionAttributeNames sets the ExpressionAttributeNames field's value.
func (s *UpdateItemInput) SetExpressionAttributeNames(v map[string]*string) *UpdateItemInput {
	s.ExpressionAttributeNames = v
	return s
}

// SetExpressionAttributeValues sets the ExpressionAttributeValues field's value.
func (s *UpdateItemInput) SetExpressionAttributeValues(v map[string]*AttributeValue) *UpdateItemInput {
	s.ExpressionAttributeValues = v
	return s
}

// SetKey sets the Key field's value.
func (s *UpdateItemInput) SetKey(v map[string]*AttributeValue) *UpdateItemInput {
	s.Key = v
	return s
}

// SetReturnConsumedCapacity sets the ReturnConsumedCapacity field's value.
func (s *UpdateItemInput) SetReturnConsumedCapacity(v string) *UpdateItemInput {
	s.ReturnConsumedCapacity = &v
	return s
}

// SetReturnItemCollectionMetrics sets the ReturnItemCollectionMetrics field's value.
func (s *UpdateItemInput) SetReturnItemCollectionMetrics(v string) *UpdateItemInput {
	s.ReturnItemCollectionMetrics = &v
	return s
}

// SetReturnValues sets the ReturnValues field's value.
func (s *UpdateItemInput) SetReturnValues(v string) *UpdateItemInput {
	s.ReturnValues = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateItemInput) SetTableName(v string) *UpdateItemInput {
	s.TableName = &v
	return s
}

// SetUpdateExpression sets the UpdateExpression field's value.
func (s *UpdateItemInput) SetUpdateExpression(v string) *UpdateItemInput {
	s.UpdateExpression = &v
	return s
}

// Represents the output of an UpdateItem operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItemOutput
type UpdateItemOutput struct {
	_ struct{} `type:"structure"`

	// A map of attribute values as they appear before or after the UpdateItem operation,
	// as determined by the ReturnValues parameter.
	//
	// The Attributes map is only present if ReturnValues was specified as something
	// other than NONE in the request. Each element represents one attribute.
	Attributes map[string]*AttributeValue `type:"map"`

	// The capacity units consumed by the UpdateItem operation. The data returned
	// includes the total provisioned throughput consumed, along with statistics
	// for the table and any indexes involved in the operation. ConsumedCapacity
	// is only returned if the ReturnConsumedCapacity parameter was specified. For
	// more information, see Provisioned Throughput (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html)
	// in the Amazon DynamoDB Developer Guide.
	ConsumedCapacity *ConsumedCapacity `type:"structure"`

	// Information about item collections, if any, that were affected by the UpdateItem
	// operation. ItemCollectionMetrics is only returned if the ReturnItemCollectionMetrics
	// parameter was specified. If the table does not have any local secondary indexes,
	// this information is not returned in the response.
	//
	// Each ItemCollectionMetrics element consists of:
	//
	//    * ItemCollectionKey - The partition key value of the item collection.
	//    This is the same as the partition key value of the item itself.
	//
	//    * SizeEstimateRange - An estimate of item collection size, in gigabytes.
	//    This value is a two-element array containing a lower bound and an upper
	//    bound for the estimate. The estimate includes the size of all the items
	//    in the table, plus the size of all attributes projected into all of the
	//    local secondary indexes on that table. Use this estimate to measure whether
	//    a local secondary index is approaching its size limit.
	//
	// The estimate is subject to change over time; therefore, do not rely on the
	//    precision or accuracy of the estimate.
	ItemCollectionMetrics *ItemCollectionMetrics `type:"structure"`
}

// String returns the string representation
func (s UpdateItemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateItemOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateItemOutput) SetAttributes(v map[string]*AttributeValue) *UpdateItemOutput {
	s.Attributes = v
	return s
}

// SetConsumedCapacity sets the ConsumedCapacity field's value.
func (s *UpdateItemOutput) SetConsumedCapacity(v *ConsumedCapacity) *UpdateItemOutput {
	s.ConsumedCapacity = v
	return s
}

// SetItemCollectionMetrics sets the ItemCollectionMetrics field's value.
func (s *UpdateItemOutput) SetItemCollectionMetrics(v *ItemCollectionMetrics) *UpdateItemOutput {
	s.ItemCollectionMetrics = v
	return s
}

// Represents the input of an UpdateTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableInput
type UpdateTableInput struct {
	_ struct{} `type:"structure"`

	// An array of attributes that describe the key schema for the table and indexes.
	// If you are adding a new global secondary index to the table, AttributeDefinitions
	// must include the key element(s) of the new index.
	AttributeDefinitions []*AttributeDefinition `type:"list"`

	// An array of one or more global secondary indexes for the table. For each
	// index in the array, you can request one action:
	//
	//    * Create - add a new global secondary index to the table.
	//
	//    * Update - modify the provisioned throughput settings of an existing global
	//    secondary index.
	//
	//    * Delete - remove a global secondary index from the table.
	//
	// For more information, see Managing Global Secondary Indexes (http://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GSI.OnlineOps.html)
	// in the Amazon DynamoDB Developer Guide.
	GlobalSecondaryIndexUpdates []*GlobalSecondaryIndexUpdate `type:"list"`

	// The new provisioned throughput settings for the specified table or index.
	ProvisionedThroughput *ProvisionedThroughput `type:"structure"`

	// Represents the DynamoDB Streams configuration for the table.
	//
	// You will receive a ResourceInUseException if you attempt to enable a stream
	// on a table that already has a stream, or if you attempt to disable a stream
	// on a table which does not have a stream.
	StreamSpecification *StreamSpecification `type:"structure"`

	// The name of the table to be updated.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTableInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTableInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTableInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.AttributeDefinitions != nil {
		for i, v := range s.AttributeDefinitions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AttributeDefinitions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.GlobalSecondaryIndexUpdates != nil {
		for i, v := range s.GlobalSecondaryIndexUpdates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GlobalSecondaryIndexUpdates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ProvisionedThroughput != nil {
		if err := s.ProvisionedThroughput.Validate(); err != nil {
			invalidParams.AddNested("ProvisionedThroughput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeDefinitions sets the AttributeDefinitions field's value.
func (s *UpdateTableInput) SetAttributeDefinitions(v []*AttributeDefinition) *UpdateTableInput {
	s.AttributeDefinitions = v
	return s
}

// SetGlobalSecondaryIndexUpdates sets the GlobalSecondaryIndexUpdates field's value.
func (s *UpdateTableInput) SetGlobalSecondaryIndexUpdates(v []*GlobalSecondaryIndexUpdate) *UpdateTableInput {
	s.GlobalSecondaryIndexUpdates = v
	return s
}

// SetProvisionedThroughput sets the ProvisionedThroughput field's value.
func (s *UpdateTableInput) SetProvisionedThroughput(v *ProvisionedThroughput) *UpdateTableInput {
	s.ProvisionedThroughput = v
	return s
}

// SetStreamSpecification sets the StreamSpecification field's value.
func (s *UpdateTableInput) SetStreamSpecification(v *StreamSpecification) *UpdateTableInput {
	s.StreamSpecification = v
	return s
}

// SetTableName sets the TableName field's value.
func (s *UpdateTableInput) SetTableName(v string) *UpdateTableInput {
	s.TableName = &v
	return s
}

// Represents the output of an UpdateTable operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableOutput
type UpdateTableOutput struct {
	_ struct{} `type:"structure"`

	// Represents the properties of the table.
	TableDescription *TableDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateTableOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTableOutput) GoString() string {
	return s.String()
}

// SetTableDescription sets the TableDescription field's value.
func (s *UpdateTableOutput) SetTableDescription(v *TableDescription) *UpdateTableOutput {
	s.TableDescription = v
	return s
}

// Represents the input of an UpdateTimeToLive operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLiveInput
type UpdateTimeToLiveInput struct {
	_ struct{} `type:"structure"`

	// The name of the table to be configured.
	//
	// TableName is a required field
	TableName *string `min:"3" type:"string" required:"true"`

	// Represents the settings used to enable or disable Time to Live for the specified
	// table.
	//
	// TimeToLiveSpecification is a required field
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateTimeToLiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTimeToLiveInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTimeToLiveInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTimeToLiveInput"}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 3))
	}
	if s.TimeToLiveSpecification == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeToLiveSpecification"))
	}
	if s.TimeToLiveSpecification != nil {
		if err := s.TimeToLiveSpecification.Validate(); err != nil {
			invalidParams.AddNested("TimeToLiveSpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableName sets the TableName field's value.
func (s *UpdateTimeToLiveInput) SetTableName(v string) *UpdateTimeToLiveInput {
	s.TableName = &v
	return s
}

// SetTimeToLiveSpecification sets the TimeToLiveSpecification field's value.
func (s *UpdateTimeToLiveInput) SetTimeToLiveSpecification(v *TimeToLiveSpecification) *UpdateTimeToLiveInput {
	s.TimeToLiveSpecification = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLiveOutput
type UpdateTimeToLiveOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of an UpdateTimeToLive operation.
	TimeToLiveSpecification *TimeToLiveSpecification `type:"structure"`
}

// String returns the string representation
func (s UpdateTimeToLiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateTimeToLiveOutput) GoString() string {
	return s.String()
}

// SetTimeToLiveSpecification sets the TimeToLiveSpecification field's value.
func (s *UpdateTimeToLiveOutput) SetTimeToLiveSpecification(v *TimeToLiveSpecification) *UpdateTimeToLiveOutput {
	s.TimeToLiveSpecification = v
	return s
}

// Represents an operation to perform - either DeleteItem or PutItem. You can
// only request one of these operations, not both, in a single WriteRequest.
// If you do need to perform both of these operations, you will need to provide
// two separate WriteRequest objects.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/WriteRequest
type WriteRequest struct {
	_ struct{} `type:"structure"`

	// A request to perform a DeleteItem operation.
	DeleteRequest *DeleteRequest `type:"structure"`

	// A request to perform a PutItem operation.
	PutRequest *PutRequest `type:"structure"`
}

// String returns the string representation
func (s WriteRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WriteRequest) GoString() string {
	return s.String()
}

// SetDeleteRequest sets the DeleteRequest field's value.
func (s *WriteRequest) SetDeleteRequest(v *DeleteRequest) *WriteRequest {
	s.DeleteRequest = v
	return s
}

// SetPutRequest sets the PutRequest field's value.
func (s *WriteRequest) SetPutRequest(v *PutRequest) *WriteRequest {
	s.PutRequest = v
	return s
}

const (
	// AttributeActionAdd is a AttributeAction enum value
	AttributeActionAdd = "ADD"

	// AttributeActionPut is a AttributeAction enum value
	AttributeActionPut = "PUT"

	// AttributeActionDelete is a AttributeAction enum value
	AttributeActionDelete = "DELETE"
)

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorIn is a ComparisonOperator enum value
	ComparisonOperatorIn = "IN"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"

	// ComparisonOperatorBetween is a ComparisonOperator enum value
	ComparisonOperatorBetween = "BETWEEN"

	// ComparisonOperatorNotNull is a ComparisonOperator enum value
	ComparisonOperatorNotNull = "NOT_NULL"

	// ComparisonOperatorNull is a ComparisonOperator enum value
	ComparisonOperatorNull = "NULL"

	// ComparisonOperatorContains is a ComparisonOperator enum value
	ComparisonOperatorContains = "CONTAINS"

	// ComparisonOperatorNotContains is a ComparisonOperator enum value
	ComparisonOperatorNotContains = "NOT_CONTAINS"

	// ComparisonOperatorBeginsWith is a ComparisonOperator enum value
	ComparisonOperatorBeginsWith = "BEGINS_WITH"
)

const (
	// ConditionalOperatorAnd is a ConditionalOperator enum value
	ConditionalOperatorAnd = "AND"

	// ConditionalOperatorOr is a ConditionalOperator enum value
	ConditionalOperatorOr = "OR"
)

const (
	// IndexStatusCreating is a IndexStatus enum value
	IndexStatusCreating = "CREATING"

	// IndexStatusUpdating is a IndexStatus enum value
	IndexStatusUpdating = "UPDATING"

	// IndexStatusDeleting is a IndexStatus enum value
	IndexStatusDeleting = "DELETING"

	// IndexStatusActive is a IndexStatus enum value
	IndexStatusActive = "ACTIVE"
)

const (
	// KeyTypeHash is a KeyType enum value
	KeyTypeHash = "HASH"

	// KeyTypeRange is a KeyType enum value
	KeyTypeRange = "RANGE"
)

const (
	// ProjectionTypeAll is a ProjectionType enum value
	ProjectionTypeAll = "ALL"

	// ProjectionTypeKeysOnly is a ProjectionType enum value
	ProjectionTypeKeysOnly = "KEYS_ONLY"

	// ProjectionTypeInclude is a ProjectionType enum value
	ProjectionTypeInclude = "INCLUDE"
)

// Determines the level of detail about provisioned throughput consumption that
// is returned in the response:
//
//    * INDEXES - The response includes the aggregate ConsumedCapacity for the
//    operation, together with ConsumedCapacity for each table and secondary
//    index that was accessed.
//
// Note that some operations, such as GetItem and BatchGetItem, do not access
//    any indexes at all. In these cases, specifying INDEXES will only return
//    ConsumedCapacity information for table(s).
//
//    * TOTAL - The response includes only the aggregate ConsumedCapacity for
//    the operation.
//
//    * NONE - No ConsumedCapacity details are included in the response.
const (
	// ReturnConsumedCapacityIndexes is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityIndexes = "INDEXES"

	// ReturnConsumedCapacityTotal is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityTotal = "TOTAL"

	// ReturnConsumedCapacityNone is a ReturnConsumedCapacity enum value
	ReturnConsumedCapacityNone = "NONE"
)

const (
	// ReturnItemCollectionMetricsSize is a ReturnItemCollectionMetrics enum value
	ReturnItemCollectionMetricsSize = "SIZE"

	// ReturnItemCollectionMetricsNone is a ReturnItemCollectionMetrics enum value
	ReturnItemCollectionMetricsNone = "NONE"
)

const (
	// ReturnValueNone is a ReturnValue enum value
	ReturnValueNone = "NONE"

	// ReturnValueAllOld is a ReturnValue enum value
	ReturnValueAllOld = "ALL_OLD"

	// ReturnValueUpdatedOld is a ReturnValue enum value
	ReturnValueUpdatedOld = "UPDATED_OLD"

	// ReturnValueAllNew is a ReturnValue enum value
	ReturnValueAllNew = "ALL_NEW"

	// ReturnValueUpdatedNew is a ReturnValue enum value
	ReturnValueUpdatedNew = "UPDATED_NEW"
)

const (
	// ScalarAttributeTypeS is a ScalarAttributeType enum value
	ScalarAttributeTypeS = "S"

	// ScalarAttributeTypeN is a ScalarAttributeType enum value
	ScalarAttributeTypeN = "N"

	// ScalarAttributeTypeB is a ScalarAttributeType enum value
	ScalarAttributeTypeB = "B"
)

const (
	// SelectAllAttributes is a Select enum value
	SelectAllAttributes = "ALL_ATTRIBUTES"

	// SelectAllProjectedAttributes is a Select enum value
	SelectAllProjectedAttributes = "ALL_PROJECTED_ATTRIBUTES"

	// SelectSpecificAttributes is a Select enum value
	SelectSpecificAttributes = "SPECIFIC_ATTRIBUTES"

	// SelectCount is a Select enum value
	SelectCount = "COUNT"
)

const (
	// StreamViewTypeNewImage is a StreamViewType enum value
	StreamViewTypeNewImage = "NEW_IMAGE"

	// StreamViewTypeOldImage is a StreamViewType enum value
	StreamViewTypeOldImage = "OLD_IMAGE"

	// StreamViewTypeNewAndOldImages is a StreamViewType enum value
	StreamViewTypeNewAndOldImages = "NEW_AND_OLD_IMAGES"

	// StreamViewTypeKeysOnly is a StreamViewType enum value
	StreamViewTypeKeysOnly = "KEYS_ONLY"
)

const (
	// TableStatusCreating is a TableStatus enum value
	TableStatusCreating = "CREATING"

	// TableStatusUpdating is a TableStatus enum value
	TableStatusUpdating = "UPDATING"

	// TableStatusDeleting is a TableStatus enum value
	TableStatusDeleting = "DELETING"

	// TableStatusActive is a TableStatus enum value
	TableStatusActive = "ACTIVE"
)

const (
	// TimeToLiveStatusEnabling is a TimeToLiveStatus enum value
	TimeToLiveStatusEnabling = "ENABLING"

	// TimeToLiveStatusDisabling is a TimeToLiveStatus enum value
	TimeToLiveStatusDisabling = "DISABLING"

	// TimeToLiveStatusEnabled is a TimeToLiveStatus enum value
	TimeToLiveStatusEnabled = "ENABLED"

	// TimeToLiveStatusDisabled is a TimeToLiveStatus enum value
	TimeToLiveStatusDisabled = "DISABLED"
)
