/*
 * Copyright (c) 2000-2004 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef ArgusEsp
#define ArgusEsp
#endif


#include <stdio.h>
#include <ArgusModeler.h>

#include <errno.h>
#include <string.h>


struct esphdr {
   unsigned int spi, seq;
};


int
ArgusCreateESPFlow (struct ip *ip)
{
   int retn = 0;
   struct ArgusESPFlow *espFlow = &ArgusThisFlow->esp_flow;
   struct esphdr *esp = (struct esphdr *) ArgusThisUpHdr;

   ArgusThisDir = 0;

   if (STRUCTCAPTURED(*esp)) {
      espFlow->ip_src = ip->ip_src.s_addr;
      espFlow->ip_dst = ip->ip_dst.s_addr;
      espFlow->ip_p   = ip->ip_p;
      espFlow->spi    = esp->spi;

#ifdef _LITTLE_ENDIAN
      espFlow->spi    = ntohl(espFlow->spi);
#endif

      if (espFlow->ip_src < espFlow->ip_dst) {
         espFlow->ip_src = ip->ip_dst.s_addr;
         espFlow->ip_dst = ip->ip_src.s_addr;
         ArgusThisDir = 1;
      }

      retn = 1;
   }

#ifdef ARGUSDEBUG
   ArgusDebug (4, "ArgusCreateESPFlow(0x%x) returning %d\n", ip, retn);
#endif 

   return (retn);
}


void
ArgusUpdateESPState (struct ArgusFlowStruct *flowstr, unsigned char *state)
{
   struct esphdr *esp = (struct esphdr *) ArgusThisUpHdr;
   struct ArgusESPStruct *espObject = NULL;
   struct ArgusESPObject *ArgusThisEsp;

   ArgusTallyTime (flowstr, *state);

   if (STRUCTCAPTURED(*esp)) {

#ifdef _LITTLE_ENDIAN
      esp->spi = ntohl(esp->spi);
      esp->seq = ntohl(esp->seq);
#endif 

      if (*state == ARGUS_START) {
         if (flowstr->TransportDSRBuffer) 
            ArgusFree(flowstr->TransportDSRBuffer);
   
         if ((flowstr->TransportDSRBuffer = (struct ArgusESPStruct *) ArgusCalloc (1,
                                                 sizeof (struct ArgusESPStruct))) == NULL) {
            ArgusLog (LOG_ERR, "%s: ArgusUpdateEspState: ArgusCalloc failed %s\n", ArgusProgramName, strerror(errno));
   
         } else {
            espObject = flowstr->TransportDSRBuffer;
            espObject->type = ARGUS_ESP_DSR;
            espObject->length = sizeof(*espObject);
            espObject->status = ARGUS_START;
         }
         
         espObject->src.spi = esp->spi;
         espObject->dst.spi = esp->spi;

         if (flowstr->state.rev == ArgusThisDir)
            ArgusThisEsp = &espObject->src;
         else
            ArgusThisEsp = &espObject->dst;
   
         ArgusThisEsp->lastseq = esp->seq;
         
      } else {
         flowstr->ArgusTimeout = ARGUS_IPTIMEOUT;

         if ((espObject = flowstr->TransportDSRBuffer) != NULL) {
            if (flowstr->state.rev == ArgusThisDir)
               ArgusThisEsp = &espObject->src;
            else
               ArgusThisEsp = &espObject->dst;
   
            if (esp->spi == ArgusThisEsp->spi) {
               if (ArgusThisEsp->lastseq && (esp->seq != (ArgusThisEsp->lastseq + 1))) {
                  ArgusThisEsp->lostseq++;
                  espObject->status |= ARGUS_SRC_PKTS_RETRANS;
               }
   
               ArgusThisEsp->lastseq = esp->seq;
            }
         }
      }
   }
   
#ifdef ARGUSDEBUG
   ArgusDebug (8, "ArgusUpdateESPState(0x%x, %d) returning\n", flowstr, *state);
#endif 
}


#include <argus_out.h>

void
ArgusESPFlowRecord (struct ArgusFlowStruct *flow, struct ArgusRecord *argus, unsigned char state)
{
   int length = 0;
   struct ArgusESPStruct *esp = (struct ArgusESPStruct *) flow->TransportDSRBuffer;

   if (esp && ((length = argus->ahdr.length) > 0)) {
      bcopy ((char *)esp, &((char *)argus)[argus->ahdr.length], sizeof(*esp));
      argus->ahdr.length += sizeof(*esp);

      esp->src.lostseq = 0;
      esp->dst.lostseq = 0;
   }


#ifdef ARGUSDEBUG
   ArgusDebug (4, "ArgusESPFlowRecord(0x%x, 0x%x, %d) returning\n", flow, argus, state);
#endif 
}
