/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.attribute.Annotation;

public abstract class ParameterAnnotationsAttr
extends Attribute {
    private Vector<Vector<Annotation>> mParameterAnnotations;

    public ParameterAnnotationsAttr(ConstantPool cp, String name) {
        super(cp, name);
        this.mParameterAnnotations = new Vector(2);
    }

    public ParameterAnnotationsAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedByte();
        this.mParameterAnnotations = new Vector(size);
        for (int i = 0; i < size; ++i) {
            int subSize = din.readUnsignedShort();
            Vector<Annotation> annotations = new Vector<Annotation>(subSize);
            for (int j = 0; j < subSize; ++j) {
                annotations.add(new Annotation(cp, din));
            }
            this.mParameterAnnotations.add(annotations);
        }
    }

    public Annotation[][] getAnnotations() {
        Annotation[][] copy = new Annotation[this.mParameterAnnotations.size()][];
        int i = copy.length;
        while (--i >= 0) {
            Vector<Annotation> annotations = this.mParameterAnnotations.get(i);
            if (annotations == null) {
                copy[i] = new Annotation[0];
                continue;
            }
            copy[i] = annotations.toArray(new Annotation[annotations.size()]);
        }
        return copy;
    }

    public int getParameterCount() {
        return this.mParameterAnnotations.size();
    }

    public Annotation[] getAnnotations(int parameter) {
        Vector<Annotation> annotations = this.mParameterAnnotations.get(parameter);
        if (annotations == null) {
            return new Annotation[0];
        }
        return annotations.toArray(new Annotation[annotations.size()]);
    }

    public void addAnnotation(int parameter, Annotation annotation) {
        Vector<Annotation> annotations;
        if (parameter >= this.mParameterAnnotations.size()) {
            this.mParameterAnnotations.setSize(parameter);
        }
        if ((annotations = this.mParameterAnnotations.get(parameter)) == null) {
            annotations = new Vector(2);
            this.mParameterAnnotations.set(parameter, annotations);
        }
        annotations.add(annotation);
    }

    public int getLength() {
        int length = 1;
        int i = this.mParameterAnnotations.size();
        while (--i >= 0) {
            Vector<Annotation> annotations = this.mParameterAnnotations.get(i);
            int j = annotations.size();
            while (--j >= 0) {
                length += 2 + annotations.get(j).getLength();
            }
        }
        return length;
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mParameterAnnotations.size();
        dout.writeByte(size);
        for (int i = 0; i < size; ++i) {
            Vector<Annotation> annotations = this.mParameterAnnotations.get(i);
            int subSize = annotations.size();
            dout.writeShort(subSize);
            for (int j = 0; j < subSize; ++j) {
                annotations.get(j).writeTo(dout);
            }
        }
    }
}

