/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef COMPONENTGENERATOR_H
#define COMPONENTGENERATOR_H

#if defined(_WIN32) && !defined(__MINGW32__) // MSVC only
#pragma warning( disable : 4290 )
#endif // MSVC only

#include <set>

// includes from Qt
#include <QMap>
#include <QDir>
#include <QPair>
#include <QString>
#include <QFileInfo>
#include <QTextStream>

#include <Component.hxx>

class ComponentGenerator  {

public :
    enum RepresentationType {
        IMAGE,
        MESH,
        NONE
    };
    static bool generateComponentFiles(QString xmlFileName, QString devDirectoryName, QString * elementClassName = NULL);

protected:
    ComponentGenerator(QString xmlFilename, QString devDirectoryName);

    virtual void setXmlFileName(QString xmlFileName) throw (QString);
    virtual void setDevDirectoryName(QString devDirectoryName) throw (QString);

    virtual void createElement() throw (QString);
    virtual void generateComponentFiles() throw (QString);

    virtual void writeHFile() throw (QString);
    virtual void writeCFile() throw (QString);


    /** XML DOM Element create by CodeSynthesis
     * This component contains all of the informations of the xml file
     */
    std::auto_ptr<coreschema::Component> theComponent;

    /// Where to find the XML description of the Action
    QFileInfo xmlFileName;

    /// Where to store the produced files
    QDir devDirectoryName;

    /// Name of the created Component class
    ///  redundant information already contained in theAction, for practicle purpose.
    QString className;

    /// Does the component have properties ?
    bool hasParameters;

    /** List containing all properties of the component
     *  For practical reasons, this map contains for each parameter:
     *  - key: the name of the parameter
     *  - value: a QPair of element:
     *       - first: the type of the parameter
     *       - second: the default value of the parameter
     *                 (if non exists in the XML file, a default one is given)
     */
    QMap<QString, QPair<QString, QString> > parameters;

    /// Set of additional files to include
    std::set<QString> additionalIncludes;

    RepresentationType representation;
};
#endif
