/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


// -- Core image component stuff
#include "MedicalDataOriginDialog.h"
#include "ImageComponent.h"

// -- Core stuff
#include "Core.h"
#include "SliderTextWidget.h"

// -- QT stuff
#include <QLineEdit>
#include <QFileDialog>
#include <QFileInfo>
#include <QMessageBox>

// -- stl stuff
#include <sstream>


namespace camitk
{
// ---------------------- Constructor and destructor ----------------------------
MedicalDataOriginDialog::MedicalDataOriginDialog(ImageComponent *mdc, QWidget* parent) : QDialog(parent)
{
	// get the Component
	myComponent = mdc;
	// Setup UI
	ui.setupUi(this);
	// Initialize UI
	init();
}

MedicalDataOriginDialog::~MedicalDataOriginDialog() {}

// ----------------------   init   --------------------------------------------
void MedicalDataOriginDialog::init()
{
	ui.comboBoxConvension->setCurrentIndex( 2 );
}


//*****************************************************************************
//                            SLOT IMPLEMENTATION
//*****************************************************************************

// ---------------------- slotDisplayOrigin  ----------------------------------
void MedicalDataOriginDialog::displayOrigin( int i)
{
	// Select the desired origin
	ui.comboBoxConvension->setCurrentIndex( i );

	// Load the corresponding PNG image
	switch( (ImageComponent::MedicalDataOrigin) (i) )
	{
	case ImageComponent::RAI_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/IRA.png") );
		break;

	case ImageComponent::RAI_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/AIR.png") );
		break;

	case ImageComponent::RAI_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/RAI.png") );
		break;

	case ImageComponent::LAI_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/IAL.png") );
		break;

	case ImageComponent::LAI_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/LIA.png") );
		break;

	case ImageComponent::LAI_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/ALI.png") );
		break;

	case ImageComponent::RPI_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/IPR.png") );
		break;

	case ImageComponent::RPI_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/RIP.png") );
		break;

	case ImageComponent::RPI_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/PRI.png") );
		break;

	case ImageComponent::LPI_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/ILP.png") );
		break;

	case ImageComponent::LPI_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/PIL.png") );
		break;

	case ImageComponent::LPI_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/LPI.png") );
		break;

	case ImageComponent::RAS_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/SAR.png") );
		break;

	case ImageComponent::RAS_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/RSA.png") );
		break;

	case ImageComponent::RAS_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/ARS.png") );
		break;

	case ImageComponent::LAS_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/SLA.png") );
		break;

	case ImageComponent::LAS_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/ASL.png") );
		break;

	case ImageComponent::LAS_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/LAS.png") );
		break;

	case ImageComponent::RPS_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/SRP.png") );
		break;

	case ImageComponent::RPS_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/PSR.png") );
		break;

	case ImageComponent::RPS_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/RPS.png") );
		break;

	case ImageComponent::LPS_X :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/SPL.png") );
		break;

	case ImageComponent::LPS_Y :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/LSP.png") );
		break;

	case ImageComponent::LPS_Z :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/PLS.png") );
		break;

	default :
		ui.labelDataOrigin->setPixmap( QPixmap(":/icons/RAI.png") );
		break;
	}
}

// ---------------------- slotApplyOrigin  ----------------------------
void MedicalDataOriginDialog::applyOrigin( )
{
	// Once chosen, apply the new origin on the image data.
	//	myComponent->setMedicalDataOrigin( (ImageComponent::MedicalDataOrigin)(ui.comboBoxConvension->currentIndex()) );
}

}

//**************************************************************************
