(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13920,        436]*)
(*NotebookOutlinePosition[     14959,        472]*)
(*  CellTagsIndexPosition[     14871,        466]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Diet Problem",
    FontColor->RGBColor[0.0557107, 0.137819, 0.517113]],
  "\nAn Application of Vertex Enumeration\nwith ",
  StyleBox["MathLink",
    FontSize->24,
    FontSlant->"Italic",
    FontColor->RGBColor[0.0146487, 0.461387, 0.0967727]],
  " to ",
  StyleBox["cddlib",
    FontColor->RGBColor[0.517113, 0.0273594, 0.0273594]]
}], "Title",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->27],

Cell[TextData[StyleBox["Komei Fukuda, fukuda@ifor.math.ethz.ch\nSwiss Federal \
Institute of Technology, Lausanne and Zurich\nMarch 14, 1999",
  FontSize->17,
  FontSlant->"Italic"]], "Subtitle",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Connecting  cddmathlink", "Section",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell[TextData[{
  "You just put the compiled cddmathlink for your computer in some directory. \
 In this example, the name of the directory is ",
  StyleBox["\"~/Math\".",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "Text",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["Off[General::spell1]; Off[General::spell];", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["cddml=Install[\"~/Math/cddmathlink\"]", "Input",
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(LinkObject["/Users/fukuda/Math/cddmathlink", 7, 7]\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["What is Diet Problem?", "Section",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->20],

Cell["\<\
The following diet problem is taken from V. Chvatal's  great book \
on Linear Programming (\"Linear Programming\", W.H.Freeman and Company,1983). \
  It is to design a cheapest meal with six possible items below to satisfy \
prescribed nutritional needs.  Please see Page 3 of the book.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
var={\"\",\"Oatmeal\",\"Chicken\",\"Eggs\",\"Milk\",\"Cherry Pie\", \

\t\"Pork Beans\"};

price={\"Price/Ser\", \"3c\", \"24c\", \"13c\", \"9c\", \"20c\", \
\"19c\"}\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \({"Price/Ser", "3c", "24c", "13c", "9c", "20c", "19c"}\)], "Output"]
}, Open  ]],

Cell["\<\
MatrixForm[dietproblem1=
{{0, 1, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 0, 0},
 {0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0}, 
 {0, 0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 1}, 
 {4, -1, 0, 0, 0, 0, 0}, {3, 0, -1, 0, 0, 0, 0},
 {2, 0, 0, -1, 0, 0, 0}, {8, 0, 0, 0, -1, 0, 0}, 
 {2, 0, 0, 0, 0, -1, 0}, {2, 0, 0, 0, 0, 0, -1},
 {-2000, 110, 205, 160, 160, 420, 260}, 
 {-55, 4, 32, 13, 8, 4, 14}, 
 {-800, 2, 12, 54, 285, 22, 80}}];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[CellGroupData[{

Cell["\<\
TableForm[table1=Prepend[Prepend[dietproblem1,var],price]]
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"Price/Ser\"\>", "\<\"3c\"\>", "\<\"24c\"\>", "\<\"13c\"\>", "\
\<\"9c\"\>", "\<\"20c\"\>", "\<\"19c\"\>"},
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"0", "1", "0", "0", "0", "0", "0"},
          {"0", "0", "1", "0", "0", "0", "0"},
          {"0", "0", "0", "1", "0", "0", "0"},
          {"0", "0", "0", "0", "1", "0", "0"},
          {"0", "0", "0", "0", "0", "1", "0"},
          {"0", "0", "0", "0", "0", "0", "1"},
          {"4", \(-1\), "0", "0", "0", "0", "0"},
          {"3", "0", \(-1\), "0", "0", "0", "0"},
          {"2", "0", "0", \(-1\), "0", "0", "0"},
          {"8", "0", "0", "0", \(-1\), "0", "0"},
          {"2", "0", "0", "0", "0", \(-1\), "0"},
          {"2", "0", "0", "0", "0", "0", \(-1\)},
          {\(-2000\), "110", "205", "160", "160", "420", "260"},
          {\(-55\), "4", "32", "13", "8", "4", "14"},
          {\(-800\), "2", "12", "54", "285", "22", "80"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]],

Cell["\<\
m=Transpose[Drop[Transpose[dietproblem1],1]];
b=-First[Transpose[dietproblem1]];
c={3, 24, 13, 9, 20, 19};\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[TextData[{
  "By using the build-in LP optimizer of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", one can easily compute the optimal solution."
}], "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["lps=LinearProgramming[c, m,b]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \({4, 0, 0, 9\/2, 2, 0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["optvalue= N[c.lps]", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    \(92.5`\)], "Output"]
}, Open  ]],

Cell["\<\
We can see the optimal solution better in the following table.   It \
is certainly not an exciting menu.   In fact, an optimal solution to any \
optimization problem tends to be extreme, and thus it must be modified for \
practical purposes.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
TableForm[Join[{var},{Prepend[N[lps],optvalue]}]]
\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}},
  FontSize->14],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"92.5`", "4.`", "0.`", "0.`", "4.5`", "2.`", "0.`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Why is the Vertex Enumeration Useful?", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Now we try to do something more reasonable.  We use cddmathlink \
fuction AllVertices:\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["?AllVertices", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("AllVertices[m,d+1,A] generates all extreme points (vertices) and \
extreme rays of the convex polyhedron in R^(d+1) given as the solution set to \
an inequality system  A x >= 0 where  A is an m*(d+1) matrix  and  \
x=(1,x1,...,xd).  The output is {{extlist, linearity}, ecdlist} where extlist \
is  the extreme point list and ecdlist is the incidence list.  Each vertex \
(ray) has the first component 1 (0).  If the convex polyhedron is nonempty \
and has no vertices, extlist is a (nonunique) set of generators of the \
polyhedron where those generators in the linearity list are considered as \
linearity space (of points satisfying A (0, x1, x2, ...., xd) = 0)  \
generators."\)], "Print",
  CellTags->"Info3249106745-1451094"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
We can then compute ALL possibilities for cost at most, say One \
Dollar.\
\>", "Subsection",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["BudgetLimit=100;", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["\<\
MatrixForm[dietproblem2=Append[dietproblem1, 
  {BudgetLimit, -3, -24, -13, -9, -20, -19}]]\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"0", "1", "0", "0", "0", "0", "0"},
            {"0", "0", "1", "0", "0", "0", "0"},
            {"0", "0", "0", "1", "0", "0", "0"},
            {"0", "0", "0", "0", "1", "0", "0"},
            {"0", "0", "0", "0", "0", "1", "0"},
            {"0", "0", "0", "0", "0", "0", "1"},
            {"4", \(-1\), "0", "0", "0", "0", "0"},
            {"3", "0", \(-1\), "0", "0", "0", "0"},
            {"2", "0", "0", \(-1\), "0", "0", "0"},
            {"8", "0", "0", "0", \(-1\), "0", "0"},
            {"2", "0", "0", "0", "0", \(-1\), "0"},
            {"2", "0", "0", "0", "0", "0", \(-1\)},
            {\(-2000\), "110", "205", "160", "160", "420", "260"},
            {\(-55\), "4", "32", "13", "8", "4", "14"},
            {\(-800\), "2", "12", "54", "285", "22", "80"},
            {"100", \(-3\), \(-24\), \(-13\), \(-9\), \(-20\), \(-19\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"],

Cell[CellGroupData[{

Cell["{m2,d2}=Dimensions[dietproblem2]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \({16, 7}\)], "Output"]
}, Open  ]],

Cell["\<\
{{extlist,linearity},inclist}=AllVertices[m2,d2,Flatten[\
dietproblem2]];\
\>", "Input",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Length[extlist]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \(17\)], "Output"]
}, Open  ]],

Cell["vlist=Map[Drop[#,1]&, extlist];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["allsolutions=Union[Map[Prepend[#, N[c.#,3]]&, N[vlist,5]]];", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["TableForm[table2=Prepend[allsolutions,var]]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"\"\>", "\<\"Oatmeal\"\>", "\<\"Chicken\"\>", "\<\"Eggs\"\>", \
"\<\"Milk\"\>", "\<\"Cherry Pie\"\>", "\<\"Pork Beans\"\>"},
          {"92.5`", "4.`", "0.`", "0.`", "4.5`", "2.`", "0.`"},
          {"97.33333333333336`", "4.`", "0.`", "0.`", "8.`", 
            "0.6666666666666675`", "0.`"},
          {"98.6035889070147`", "4.`", "0.`", "0.`", "2.232952691680261`", 
            "2.`", "1.3951060358890708`"},
          {"100.`", "1.6470588235294117`", "0.`", "0.`", "6.117647058823529`",
             "2.`", "0.`"},
          {"100.`", "2.8085106382978777`", "0.`", "0.`", "8.`", 
            "0.9787234042553182`", "0.`"},
          {"100.`", "3.7415068699984926`", "0.`", "0.`", 
            "2.1980371432885404`", "2.`", "1.5259550052846136`"},
          {"100.`", "4.`", "0.`", "0.`", "2.2091586794462197`", "2.`", 
            "1.4798722044728432`"},
          {"100.`", "4.`", "0.`", "0.`", "5.333333333333333`", "2.`", "0.`"},
          {"100.`", "4.`", "0.`", "0.`", "8.`", "0.8000000000000002`", 
            "0.`"},
          {"100.`", "4.`", "0.`", "0.49557522123893516`", "8.`", 
            "0.4778761061946923`", "0.`"},
          {"100.`", "4.`", "0.`", "1.8750000000000029`", "2.624999999999996`",
             "2.`", "0.`"},
          {"100.`", "4.`", "0.1655305777133171`", "0.`", "2.268813149625332`",
             "2.`", "1.2425235678027577`"},
          {"100.`", "4.`", "0.1872909698996644`", "0.`", "8.`", 
            "0.5752508361204028`", "0.`"},
          {"100.`", "4.`", "0.601503759398496`", "0.`", "3.729323308270678`", 
            "2.`", "0.`"},
          {"100.00000000000001`", "4.`", "0.`", "0.`", "2.179657768651609`", 
            "1.8828199863107473`", "1.6171937029431882`"},
          {"100.00000000000001`", "4.`", "0.`", "0.`", "8.`", 
            "0.4172661870503621`", "0.4028776978417242`"},
          {"100.00000000000001`", "4.`", "0.`", "1.025149700598805`", 
            "2.2122155688622755`", "2.`", "0.7770059880239508`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output"]
}, Open  ]]
}, Open  ]],

Cell["\<\
The list is complete in the sense that any feasible menu of cost at \
most One Dollar is a combination of these seventeen (extreme) solutions.  One \
can find menus with Chicken, Eggs or Pork that might be much more desireble \
than the optimal menu.   Also it shows you cannot avoid Oatmeal nor Cherry \
pie within this budget to satisfy the nutritional needs.\
\>", "Text",
  ImageRegion->{{0, 1}, {0, 1}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Disconnecting  cddmathlink", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Uninstall[cddml]", "Input",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[
    \("/Users/fukuda/Math/cddmathlink"\)], "Output"]
}, Open  ]]
}, Closed]]
},
FrontEndVersion->"4.1 for Macintosh",
ScreenRectangle->{{0, 1152}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{639, 621},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3249106745-1451094"->{
    Cell[7959, 273, 753, 11, 167, "Print",
      CellTags->"Info3249106745-1451094"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3249106745-1451094", 14759, 459}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 424, 13, 179, "Title"],
Cell[2132, 65, 228, 4, 92, "Subtitle"],

Cell[CellGroupData[{
Cell[2385, 73, 103, 2, 56, "Section",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2513, 79, 295, 8, 49, "Text",
  InitializationCell->True],
Cell[2811, 89, 120, 2, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2956, 95, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[3074, 99, 84, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3219, 107, 89, 2, 40, "Section"],
Cell[3311, 111, 343, 6, 68, "Text"],

Cell[CellGroupData[{
Cell[3679, 121, 240, 9, 76, "Input"],
Cell[3922, 132, 87, 1, 27, "Output"]
}, Open  ]],
Cell[4024, 136, 495, 13, 172, "Input"],

Cell[CellGroupData[{
Cell[4544, 153, 117, 4, 42, "Input"],
Cell[4664, 159, 1261, 27, 293, "Output"]
}, Open  ]],
Cell[5940, 189, 180, 6, 60, "Input"],
Cell[6123, 197, 207, 6, 32, "Text"],

Cell[CellGroupData[{
Cell[6355, 207, 95, 2, 28, "Input"],
Cell[6453, 211, 55, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6545, 217, 84, 2, 28, "Input"],
Cell[6632, 221, 39, 1, 27, "Output"]
}, Open  ]],
Cell[6686, 225, 298, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[7009, 235, 124, 5, 44, "Input"],
Cell[7136, 242, 443, 11, 53, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[7628, 259, 89, 1, 36, "Section"],
Cell[7720, 262, 149, 4, 46, "Subsection"],

Cell[CellGroupData[{
Cell[7894, 270, 62, 1, 27, "Input"],
Cell[7959, 273, 753, 11, 167, "Print",
  CellTags->"Info3249106745-1451094"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8749, 289, 136, 4, 46, "Subsection"],
Cell[8888, 295, 66, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[8979, 300, 149, 4, 42, "Input"],
Cell[9131, 306, 1041, 21, 277, "Output"],

Cell[CellGroupData[{
Cell[10197, 331, 82, 1, 27, "Input"],
Cell[10282, 334, 41, 1, 27, "Output"]
}, Open  ]],
Cell[10338, 338, 131, 4, 42, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10506, 347, 65, 1, 27, "Input"],
Cell[10574, 350, 36, 1, 27, "Output"]
}, Open  ]],
Cell[10625, 354, 81, 1, 27, "Input"],
Cell[10709, 357, 109, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[10843, 362, 93, 1, 27, "Input"],
Cell[10939, 365, 2233, 42, 309, "Output"]
}, Open  ]]
}, Open  ]],
Cell[13199, 411, 418, 7, 68, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[13654, 423, 78, 1, 36, "Section"],

Cell[CellGroupData[{
Cell[13757, 428, 66, 1, 27, "Input"],
Cell[13826, 431, 66, 1, 27, "Output"]
}, Open  ]]
}, Closed]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

